/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

class ParameterFinder {
    private List<String> tokens;

    public ParameterFinder(String parametersString) {
        StringTokenizer parser = new StringTokenizer(parametersString, "?&=;", true);
        ArrayList<String> parsedTokens = new ArrayList<String>();
        while (parser.hasMoreTokens()) {
            parsedTokens.add(parser.nextToken());
        }
        this.tokens = parsedTokens;
    }

    public String findParameterAt(int dot) {
        int tokenIndex = this.getTokenIndexForChar(dot == 0 ? 1 : dot);
        if (tokenIndex == -1) {
            return "";
        }
        String token = this.tokens.get(tokenIndex);
        if (this.isSeparator(token)) {
            return tokenIndex < this.tokens.size() - 1 ? this.tokens.get(tokenIndex + 1) : "";
        }
        if (token.equals("=")) {
            return tokenIndex > 1 ? this.tokens.get(tokenIndex - 1) : "";
        }
        if (tokenIndex > 1 && this.tokens.get(tokenIndex - 1).equals("=")) {
            return this.tokens.get(tokenIndex - 2);
        }
        return token;
    }

    private boolean isSeparator(String token) {
        return token.equals("&") || token.equals(";");
    }

    private int getTokenIndexForChar(int index) {
        int currentIndex = 0;
        int tokenIndex = 0;
        for (String token : this.tokens) {
            if (index >= currentIndex && index < currentIndex + token.length()) {
                return tokenIndex;
            }
            currentIndex += token.length();
            ++tokenIndex;
        }
        return this.tokens.size() - 1;
    }
}

