/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest;

import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRepresentation;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.rest.panels.request.inspectors.schema.InferredSchemaManager;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.dev.wadl.x2009.x02.ApplicationDocument;
import net.java.dev.wadl.x2009.x02.DocDocument;
import net.java.dev.wadl.x2009.x02.GrammarsDocument;
import net.java.dev.wadl.x2009.x02.MethodDocument;
import net.java.dev.wadl.x2009.x02.ParamDocument;
import net.java.dev.wadl.x2009.x02.ParamStyle;
import net.java.dev.wadl.x2009.x02.RepresentationDocument;
import net.java.dev.wadl.x2009.x02.RequestDocument;
import net.java.dev.wadl.x2009.x02.ResourceDocument;
import net.java.dev.wadl.x2009.x02.ResourcesDocument;
import net.java.dev.wadl.x2009.x02.ResponseDocument;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class WadlGenerator {
    private RestService restService;
    private boolean isWADL11 = true;

    public WadlGenerator(RestService restService) {
        this.restService = restService;
    }

    public XmlObject generateWadl() {
        ApplicationDocument applicationDocument = ApplicationDocument.Factory.newInstance();
        ApplicationDocument.Application application = applicationDocument.addNewApplication();
        this.createDoc(application.addNewDoc(), this.restService);
        ResourcesDocument.Resources resources = application.addNewResources();
        String basePath = this.restService.getBasePath();
        String[] endpoints = this.restService.getEndpoints();
        if (endpoints.length > 0) {
            basePath = endpoints[0] + basePath;
        }
        resources.setBase(basePath);
        for (int c = 0; c < this.restService.getOperationCount(); ++c) {
            resources.addNewResource().set(this.generateWadlResource(this.restService.getOperationAt(c)));
        }
        String[] namespaces = InferredSchemaManager.getInferredSchema(this.restService).getNamespaces();
        if (namespaces.length > 0) {
            GrammarsDocument.Grammars grammars = application.addNewGrammars();
            for (String namespace : namespaces) {
                grammars.addNewInclude().setHref(InferredSchemaManager.filenameForNamespace(namespace));
            }
        }
        if (!this.isWADL11) {
            XmlOptions options = new XmlOptions();
            StringToStringMap subst = new StringToStringMap();
            subst.put("http://wadl.dev.java.net/2009/02", "http://research.sun.com/wadl/2006/10");
            options.setLoadSubstituteNamespaces((Map)subst);
            try {
                return XmlUtils.createXmlObject(applicationDocument.xmlText(), options);
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
        }
        return applicationDocument;
    }

    private XmlObject generateWadlResource(RestResource resource) {
        int c;
        ResourceDocument.Resource resourceConfig = ResourceDocument.Resource.Factory.newInstance();
        this.createDoc(resourceConfig.addNewDoc(), resource);
        String path = resource.getPath();
        if (path.startsWith("/")) {
            path = path.length() > 1 ? path.substring(1) : "";
        }
        resourceConfig.setPath(path);
        resourceConfig.setId(resource.getName());
        RestParamsPropertyHolder params = resource.getParams();
        for (c = 0; c < params.size(); ++c) {
            this.generateParam(resourceConfig.addNewParam(), params.getPropertyAt(c));
        }
        for (c = 0; c < resource.getChildResourceCount(); ++c) {
            resourceConfig.addNewResource().set(this.generateWadlResource(resource.getChildResourceAt(c)));
        }
        for (c = 0; c < resource.getRestMethodCount(); ++c) {
            RestMethod restMethod = resource.getRestMethodAt(c);
            this.generateWadlMethod(resourceConfig, restMethod);
        }
        return resourceConfig;
    }

    private void generateParam(ParamDocument.Param paramConfig, RestParamProperty param) {
        String[] options;
        paramConfig.setName(param.getName());
        if (StringUtils.hasContent(param.getDefaultValue())) {
            paramConfig.setDefault(param.getDefaultValue());
        }
        paramConfig.setType(param.getType());
        paramConfig.setRequired(param.getRequired());
        paramConfig.setDefault(param.getDefaultValue());
        if (StringUtils.hasContent(param.getDescription())) {
            this.createDoc(paramConfig.addNewDoc(), param.getName() + " Parameter", param.getDescription());
        }
        for (String option : options = param.getOptions()) {
            paramConfig.addNewOption().setValue(option);
        }
        ParamStyle.Enum style = ParamStyle.QUERY;
        switch (param.getStyle()) {
            case HEADER: {
                style = ParamStyle.HEADER;
                break;
            }
            case MATRIX: {
                style = ParamStyle.MATRIX;
                break;
            }
            case PLAIN: {
                style = ParamStyle.PLAIN;
                break;
            }
            case TEMPLATE: {
                style = ParamStyle.TEMPLATE;
            }
        }
        paramConfig.setStyle(style);
    }

    private void createDoc(DocDocument.Doc docConfig, ModelItem modelItem) {
        this.createDoc(docConfig, modelItem.getName(), modelItem.getDescription());
    }

    private void createDoc(DocDocument.Doc docConfig, String name, String description) {
        docConfig.setLang("en");
        docConfig.setTitle(name);
        docConfig.getDomNode().appendChild(docConfig.getDomNode().getOwnerDocument().createTextNode(description));
    }

    private void generateWadlMethod(ResourceDocument.Resource resourceConfig, RestMethod restMethod) {
        MethodDocument.Method methodConfig = resourceConfig.addNewMethod();
        this.createDoc(methodConfig.addNewDoc(), restMethod);
        methodConfig.setName(restMethod.getMethod().toString());
        methodConfig.setId(restMethod.getName());
        RequestDocument.Request requestConfig = methodConfig.addNewRequest();
        HashMap<String, RestParamProperty> defaultParams = new HashMap<String, RestParamProperty>();
        for (RestParamProperty defaultParam : restMethod.getResource().getDefaultParams()) {
            defaultParams.put(defaultParam.getName(), defaultParam);
        }
        RestParamsPropertyHolder params = restMethod.getParams();
        for (int c = 0; c < params.size(); ++c) {
            RestParamProperty param = params.getPropertyAt(c);
            if (defaultParams.containsKey(param.getName()) && param.equals(defaultParams.get(param.getName()))) continue;
            this.generateParam(requestConfig.addNewParam(), param);
        }
        if (restMethod.hasRequestBody()) {
            for (RestRepresentation representation : restMethod.getRepresentations(RestRepresentation.Type.REQUEST, null)) {
                this.generateRepresentation(requestConfig.addNewRepresentation(), representation);
            }
        }
        HashMap<String, ResponseDocument.Response> responses = new HashMap<String, ResponseDocument.Response>();
        if (!this.isWADL11) {
            responses.put(null, methodConfig.addNewResponse());
        }
        for (RestRepresentation representation : restMethod.getRepresentations()) {
            ResponseDocument.Response response;
            if (this.isWADL11) {
                ArrayList status = new ArrayList(representation.getStatus());
                Collections.sort(status);
                StringBuilder statusStrBuilder = new StringBuilder();
                for (Object o : status) {
                    statusStrBuilder.append(o).append(" ");
                }
                String statusStr = statusStrBuilder.toString();
                if (!responses.containsKey(statusStr)) {
                    response = methodConfig.addNewResponse();
                    response.setStatus(status);
                    responses.put(statusStr, response);
                } else {
                    response = (ResponseDocument.Response)responses.get(statusStr);
                }
            } else {
                response = (ResponseDocument.Response)responses.get(null);
            }
            RepresentationDocument.Representation representationConfig = response.addNewRepresentation();
            this.generateRepresentation(representationConfig, representation);
            if (this.isWADL11 || representation.getType() != RestRepresentation.Type.FAULT) continue;
            Element resp = (Element)response.getDomNode();
            Element rep = (Element)representationConfig.getDomNode();
            Element fault = resp.getOwnerDocument().createElementNS("http://wadl.dev.java.net/2009/02", "fault");
            NamedNodeMap attributes = rep.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                fault.setAttribute(attributes.item(i).getNodeName(), attributes.item(i).getNodeValue());
            }
            NodeList children = rep.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                fault.appendChild(children.item(i));
            }
            resp.appendChild(fault);
            rep.getParentNode().removeChild(rep);
        }
    }

    private void generateRepresentation(RepresentationDocument.Representation representationConfig, RestRepresentation representation) {
        List<?> status;
        representationConfig.setMediaType(representation.getMediaType());
        if (StringUtils.hasContent(representation.getId())) {
            representationConfig.setId(representation.getId());
        }
        if (!this.isWADL11 && (status = representation.getStatus()) != null && status.size() > 0) {
            StringBuilder statusStr = new StringBuilder();
            for (Object s : status) {
                statusStr.append(s).append(" ");
            }
            ((Element)representationConfig.getDomNode()).setAttribute("status", statusStr.toString().trim());
        }
        if (representation.getElement() != null) {
            representationConfig.setElement(representation.getElement());
        }
    }
}

