/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.analytics;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.Version;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.AnalyticsManager;
import com.eviware.soapui.analytics.AnalyticsProviderFactory;
import com.eviware.soapui.analytics.providers.GoogleAnalyticsProviderFactory;
import com.eviware.soapui.analytics.providers.LogTabAnalyticsProvider;
import com.eviware.soapui.analytics.providers.OSUserProviderFactory;
import com.eviware.soapui.analytics.providers.StatisticsCollectionConfirmationDialog;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.UISettings;
import java.util.concurrent.Executor;

public class AnalyticsHelper {
    private static boolean initialized = false;

    private static boolean isAnalyticsDisabled() {
        Settings settings = SoapUI.getSettings();
        boolean analyticsDisabled = settings.getBoolean(UISettings.DISABLE_ANALYTICS, false);
        if (analyticsDisabled) {
            return true;
        }
        Version optOutVersion = new Version(settings.getString(UISettings.ANALYTICS_OPT_OUT_VERSION, "0.0"));
        Version currentSoapUIVersion = new Version(SoapUI.SOAPUI_VERSION);
        if (!optOutVersion.getMajorVersion().equals(currentSoapUIVersion.getMajorVersion()) && SoapUI.usingGraphicalEnvironment()) {
            analyticsDisabled = StatisticsCollectionConfirmationDialog.showDialog() == 1;
            settings.setBoolean(UISettings.DISABLE_ANALYTICS, analyticsDisabled);
            settings.setString(UISettings.ANALYTICS_OPT_OUT_VERSION, currentSoapUIVersion.getMajorVersion());
        }
        return analyticsDisabled;
    }

    public static void initializeAnalytics() {
        if (initialized) {
            return;
        }
        initialized = true;
        AnalyticsManager manager = Analytics.getAnalyticsManager();
        manager.setExecutorService((Executor)SoapUI.getThreadPool());
        manager.registerAnalyticsProviderFactory((AnalyticsProviderFactory)new OSUserProviderFactory());
        if (AnalyticsHelper.isAnalyticsDisabled()) {
            return;
        }
        manager.registerAnalyticsProviderFactory((AnalyticsProviderFactory)new GoogleAnalyticsProviderFactory());
        if (System.getProperty("soapui.analytics.logtab", "false").equals("true")) {
            manager.registerAnalyticsProviderFactory((AnalyticsProviderFactory)new LogTabAnalyticsProvider.LogTabAnalyticsProviderFactory());
        }
    }
}

