/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ChartUtils {
    public static void writeGifToFile(Component component, File file) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ChartUtils.a(component, "gif", fileOutputStream);
    }

    public static void writeJpegToFile(Component component, File file) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ChartUtils.a(component, "jpg", fileOutputStream);
    }

    public static void writePngToFile(Component component, File file) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ChartUtils.a(component, "png", fileOutputStream);
    }

    public static void writeToStream(Component component, OutputStream outputStream) {
        ChartUtils.a(component, "png", outputStream);
    }

    private static void a(Component component, String string, OutputStream outputStream) {
        BufferedImage bufferedImage = ChartUtils.createImage(component);
        try {
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
        }
        catch (IOException iOException) {
            Logger.getAnonymousLogger().severe(iOException.getMessage());
            return;
        }
    }

    public static BufferedImage createImage(Component component) {
        return ChartUtils.createImage(component, 1);
    }

    public static BufferedImage createImage(Component component, int n) {
        Dimension dimension = component.getPreferredSize();
        component.setSize(dimension);
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        component.paint(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }
}

