/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.annotation.AutoPositionedLabel;
import com.jidesoft.chart.axis.AxisPlacement;
import com.jidesoft.chart.axis.DefaultNumericTickCalculator;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.chart.axis.TickCalculator;
import com.jidesoft.chart.model.IdentityTransform;
import com.jidesoft.chart.model.InvertibleTransform;
import com.jidesoft.chart.render.AxisRenderer;
import com.jidesoft.chart.render.NoAxisRenderer;
import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import com.jidesoft.range.TimeRange;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis
implements PropertyChangeListener {
    private static final AxisPlacement a = AxisPlacement.LEADING;
    public static final String PROPERTY_TICKS = "ticks";
    public static final String PROPERTY_RANGE = "range";
    public static final String PROPERTY_UPDATE_OTHER_AXES = "updateOtherAxes";
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_TICK_CALCULATOR = "tickCalculator";
    private static final Logger b = Logger.getLogger(Axis.class.getName());
    private Range<?> c;
    private TickCalculator d;
    private AutoPositionedLabel e;
    private PropertyChangeSupport f;
    private AxisPlacement g;
    private boolean h;
    private AxisRenderer i;
    private Tick[] j;
    private Range<Double> k;
    private boolean l;
    private double m;
    private InvertibleTransform<Double> n;
    public static boolean p;

    public Axis() {
        this.c = null;
        this.d = new DefaultNumericTickCalculator();
        this.e = null;
        this.f = new PropertyChangeSupport(this);
        this.h = true;
        this.i = new NoAxisRenderer();
        this.k = null;
        this.l = false;
        this.n = new IdentityTransform<Double>();
        this.setRange(new NumericRange(0.0, 1.0));
        this.setPlacement(a);
    }

    public Axis(String string) {
        this(new AutoPositionedLabel(string));
    }

    public Axis(AutoPositionedLabel autoPositionedLabel) {
        this();
        this.setLabel(autoPositionedLabel);
    }

    public Axis(double d2, double d3) {
        this(new NumericRange(d2, d3));
    }

    public Axis(Range<?> range) {
        this.c = null;
        this.d = new DefaultNumericTickCalculator();
        this.e = null;
        this.f = new PropertyChangeSupport(this);
        this.h = true;
        this.i = new NoAxisRenderer();
        this.k = null;
        this.l = false;
        this.n = new IdentityTransform<Double>();
        if (!p) {
            if (range == null) {
                throw new IllegalArgumentException("Cannot set a range of null!");
            }
            this.setRange(range);
            this.setPlacement(a);
        }
    }

    public Axis(Range<?> range, String string) {
        boolean bl = p;
        this.c = null;
        this.d = new DefaultNumericTickCalculator();
        this.e = null;
        this.f = new PropertyChangeSupport(this);
        this.h = true;
        this.i = new NoAxisRenderer();
        this.k = null;
        this.l = false;
        this.n = new IdentityTransform<Double>();
        if (!bl) {
            if (range == null) {
                throw new IllegalArgumentException("Cannot set a range of null!");
            }
            this.setRange(range);
            this.setLabel(new AutoPositionedLabel(string));
            this.setPlacement(a);
        }
        if (Chart.W != 0) {
            p = !bl;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.f.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.f.addPropertyChangeListener(propertyChangeListener);
    }

    public TickCalculator getTickCalculator() {
        return this.d;
    }

    public void setTickCalculator(TickCalculator tickCalculator) {
        block6: {
            TickCalculator tickCalculator2;
            TickCalculator tickCalculator3;
            block5: {
                boolean bl = p;
                tickCalculator2 = tickCalculator3 = this.d;
                if (bl) break block5;
                if (tickCalculator2 != null) {
                    tickCalculator3.removePropertyChangeListener(this);
                }
                this.d = tickCalculator;
                if (bl) break block6;
                tickCalculator2 = tickCalculator;
            }
            if (tickCalculator2 != null) {
                tickCalculator.addPropertyChangeListener(this);
            }
            this.j = null;
            this.f.firePropertyChange(PROPERTY_TICK_CALCULATOR, tickCalculator3, tickCalculator);
        }
    }

    public AxisRenderer getAxisRenderer() {
        return this.i;
    }

    public int labelWidth(Graphics graphics, Font font, Orientation orientation) {
        boolean bl = p;
        Tick[] tickArray = this.getTicks();
        Graphics graphics2 = graphics;
        if (!bl) {
            if (graphics2 == null) {
                throw new IllegalArgumentException("Graphics instance cannot be null");
            }
            graphics2 = graphics;
        }
        FontMetrics fontMetrics = graphics2.getFontMetrics(font);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(graphics.getFont());
        Orientation orientation2 = orientation;
        Orientation orientation3 = Orientation.vertical;
        if (!bl) {
            if (orientation2 == orientation3) {
                int n;
                int n2;
                block9: {
                    int n3 = 0;
                    Tick[] tickArray2 = tickArray;
                    int n4 = tickArray2.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        Tick tick = tickArray2[n5];
                        int n6 = fontMetrics.stringWidth(tick.getLabel());
                        if (!bl) {
                            n2 = n6;
                            n = n3;
                            if (bl) break block9;
                            if (n2 > n) {
                                n3 = n6;
                            }
                            ++n5;
                        }
                        if (!bl) continue;
                    }
                    n2 = n3;
                    n = fontMetrics2.getHeight();
                }
                return n2 + n;
            }
            orientation2 = orientation;
            orientation3 = Orientation.horizontal;
        }
        if (orientation2 == orientation3) {
            return fontMetrics.getHeight() + fontMetrics2.getHeight();
        }
        throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)orientation));
    }

    public void setAxisRenderer(AxisRenderer axisRenderer) {
        AxisRenderer axisRenderer2 = this.i;
        this.i = axisRenderer;
        this.f.firePropertyChange("axisRenderer", axisRenderer2, axisRenderer);
    }

    public void setRange(double d2, double d3) {
        this.setRange(new NumericRange(d2, d3));
    }

    public void setRange(Range<?> range) {
        this.setRange(range, true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void setRange(Range<?> var1_1, boolean var2_2) {
        block16: {
            block15: {
                block13: {
                    block14: {
                        var7_3 = Axis.p;
                        v0 /* !! */  = var1_1;
                        if (!var7_3) {
                            if (v0 /* !! */  == null) {
                                throw new IllegalArgumentException("Cannot set a range of null!");
                            }
                            v0 /* !! */  = var1_1;
                        }
                        if (!var7_3) {
                            if (v0 /* !! */ .equals(this.c)) {
                                return;
                            }
                            v0 /* !! */  = this.c;
                        }
                        if (!var7_3) {
                            if (v0 /* !! */  != null) {
                                this.c.removePropertyChangeListener(this);
                            }
                            v0 /* !! */  = this.k;
                        }
                        if (var7_3) break block13;
                        if (v0 /* !! */  == null) break block14;
                        v1 = var1_1;
                        if (var7_3) ** GOTO lbl23
                        if (v1.minimum() < this.k.minimum()) {
                            v2 = this.k.minimum();
                        } else {
                            v1 = var1_1;
lbl23:
                            // 2 sources

                            v2 = v1.minimum();
                        }
                        var3_4 = v2;
                        v3 = var1_1;
                        if (var7_3) ** GOTO lbl31
                        if (v3.maximum() > this.k.maximum()) {
                            v4 = this.k.maximum();
                        } else {
                            v3 = var1_1;
lbl31:
                            // 2 sources

                            v4 = v3.maximum();
                        }
                        var5_6 = v4;
                        var1_1 = new NumericRange(var3_4, var5_6);
                    }
                    v0 /* !! */  = this.c;
                }
                var3_5 /* !! */  = v0 /* !! */ ;
                this.c = var1_1;
                this.j = null;
                this.c.addPropertyChangeListener(this);
                Axis.b.fine("Firing property change: old= " + var3_5 /* !! */  + ", new=" + var1_1);
                v5 = this.f;
                v6 = "range";
                v7 /* !! */  = var3_5 /* !! */ ;
                v8 = var1_1;
                if (var7_3) break block15;
                v5.firePropertyChange(v6, v7 /* !! */ , v8);
                if (!var2_2) break block16;
                v5 = this.f;
                v6 = "updateOtherAxes";
                v7 /* !! */  = var3_5 /* !! */ ;
                v8 = var1_1;
            }
            v5.firePropertyChange(v6, v7 /* !! */ , v8);
        }
    }

    public Range<Double> getDomain() {
        return this.k;
    }

    public void setDomain(Range<Double> range) {
        this.k = range;
    }

    public Range<?> getOutputRange() {
        Object object;
        block4: {
            block5: {
                Axis axis;
                block2: {
                    block3: {
                        boolean bl = p;
                        axis = this;
                        if (bl) break block2;
                        if (axis.n == null) break block3;
                        object = this.n;
                        if (bl) break block4;
                        if (!(object instanceof IdentityTransform)) break block5;
                    }
                    axis = this;
                }
                return axis.c;
            }
            object = this.n.transform(this.minimum());
        }
        double d2 = (Double)object;
        double d3 = this.n.transform(this.maximum());
        double d4 = Math.min(d2, d3);
        double d5 = Math.max(d2, d3);
        return new NumericRange(d4, d5);
    }

    public Range<?> getRange() {
        return this.c;
    }

    public InvertibleTransform<Double> getAxisTransform() {
        return this.n;
    }

    public void setAxisTransform(InvertibleTransform<Double> invertibleTransform) {
        this.n = invertibleTransform;
    }

    public AutoPositionedLabel getLabel() {
        return this.e;
    }

    public void setLabel(String string) {
        assert (string != null);
        AutoPositionedLabel autoPositionedLabel = new AutoPositionedLabel(string);
        this.setLabel(autoPositionedLabel);
    }

    public void setLabel(AutoPositionedLabel autoPositionedLabel) {
        AutoPositionedLabel autoPositionedLabel2 = this.e;
        this.e = autoPositionedLabel;
        this.f.firePropertyChange(PROPERTY_LABEL, autoPositionedLabel2, autoPositionedLabel);
    }

    public double maximum() {
        return this.c.maximum();
    }

    public double minimum() {
        return this.c.minimum();
    }

    public double midPoint() {
        return (this.c.maximum() + this.c.minimum()) / 2.0;
    }

    public AxisPlacement getPlacement() {
        return this.g;
    }

    public void setPlacement(AxisPlacement axisPlacement) {
        this.g = axisPlacement;
    }

    public double getFloatingPosition() {
        return this.m;
    }

    public void setFloatingPosition(double d2) {
        this.m = d2;
    }

    public Tick[] getTicks() {
        Tick[] tickArray = this.j;
        if (!p) {
            if (tickArray == null) {
                this.updateTicks();
            }
            tickArray = this.j;
        }
        return tickArray;
    }

    protected void updateTicks() {
        Tick[] tickArray = this.j;
        this.j = this.d.calculateTicks(this.c);
        this.f.firePropertyChange(PROPERTY_TICKS, tickArray, this.j);
    }

    public boolean isTicksVisible() {
        return this.h;
    }

    public void setTicksVisible(boolean bl) {
        this.h = bl;
    }

    public boolean isFlipped() {
        return this.l;
    }

    public void setFlipped(boolean bl) {
        this.l = bl;
    }

    public static Range<?> zoom(Axis axis, double d2) {
        AbstractRange abstractRange;
        block3: {
            double d3;
            double d4;
            block2: {
                Range<?> range = axis.getOutputRange();
                d4 = axis.midPoint();
                double d5 = range.size();
                d3 = d5 * d2;
                if (!(range instanceof TimeRange)) break block2;
                abstractRange = new TimeRange((long)(d4 - d3 / 2.0), (long)(d4 + d3 / 2.0));
                if (!p) break block3;
            }
            abstractRange = new NumericRange(d4 - d3 / 2.0, d4 + d3 / 2.0);
        }
        return abstractRange;
    }

    public static Range<?> zoomFromPosition(Axis axis, double d2, double d3) {
        AbstractRange abstractRange;
        block3: {
            double d4;
            double d5;
            block2: {
                Range<?> range = axis.getOutputRange();
                d5 = axis.minimum();
                d4 = axis.maximum();
                if (!(range instanceof TimeRange)) break block2;
                abstractRange = new TimeRange((long)(d3 - d2 * (d3 - d5)), (long)(d3 + d2 * (d4 - d3)));
                if (!p) break block3;
            }
            abstractRange = new NumericRange(d3 - d2 * (d3 - d5), d3 + d2 * (d4 - d3));
        }
        return abstractRange;
    }

    public String toString() {
        return String.format("#<Axis label='%s'> range=%s", this.getLabel(), this.getRange());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.j = null;
        this.f.firePropertyChange(propertyChangeEvent);
    }
}

