/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.ChartType;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.UserToPixelTransform;
import com.jidesoft.chart.annotation.AbstractAnnotation;
import com.jidesoft.chart.annotation.AbstractLabel;
import com.jidesoft.chart.annotation.AutoPositionedLabel;
import com.jidesoft.chart.annotation.ChartImage;
import com.jidesoft.chart.annotation.ChartLabel;
import com.jidesoft.chart.annotation.Rotation;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.AxisPlacement;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.chart.b;
import com.jidesoft.chart.c;
import com.jidesoft.chart.d;
import com.jidesoft.chart.e;
import com.jidesoft.chart.event.MouseDragPanner;
import com.jidesoft.chart.event.MouseWheelZoomer;
import com.jidesoft.chart.event.PointSelection;
import com.jidesoft.chart.f;
import com.jidesoft.chart.g;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartModelListener;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.render.AxisRenderer;
import com.jidesoft.chart.render.BarRenderer;
import com.jidesoft.chart.render.DefaultBarRenderer;
import com.jidesoft.chart.render.DefaultLineRenderer;
import com.jidesoft.chart.render.DefaultPieSegmentRenderer;
import com.jidesoft.chart.render.DefaultPointRenderer;
import com.jidesoft.chart.render.LineRenderer;
import com.jidesoft.chart.render.PieSegmentRenderer;
import com.jidesoft.chart.render.PointRenderer;
import com.jidesoft.chart.render.ShadowFactory;
import com.jidesoft.chart.style.AbstractStyle;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.style.LabelStyle;
import com.jidesoft.chart.style.PointStyle;
import com.jidesoft.chart.util.Pair;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.W;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart
extends JComponent
implements ChartModelListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1843397021865383301L;
    public static final String PROPERTY_ANTI_ALIASING = "AntiAliasing";
    public static final String PROPERTY_AXIS_COLOR = "AxisColor";
    public static final String PROPERTY_BAR_RENDERER = "BarRenderer";
    public static final String PROPERTY_BAR_GAP = "BarGap";
    public static final String PROPERTY_BAR_GROUP_GAP = "BarGroupGap";
    public static final String PROPERTY_BARS_GROUPED = "BarsGrouped";
    public static final String PROPERTY_CHART_BACKGROUND = "ChartBackground";
    public static final String PROPERTY_CHART_TYPE = "ChartType";
    public static final String PROPERTY_GRID_COLOR = "GridColor";
    public static final String PROPERTY_HIGHLIGHT_STYLE = "HighlightStyle";
    public static final String PROPERTY_HIGH_QUALITY = "HighQuality";
    public static final String PROPERTY_HORIZONTAL_GRIDLINES_VISIBLE = "HorizontalGridLinesVisible";
    public static final String PROPERTY_LABEL_COLOR = "LabelColor";
    public static final String PROPERTY_LABELLING_TRACES = "LabellingTraces";
    public static final String PROPERTY_LAZY_RENDERING_THRESHOLD = "LazyRenderingThreshold";
    public static final String PROPERTY_LINE_RENDERER = "LineRenderer";
    public static final String PROPERTY_MODEL = "Model";
    public static final String PROPERTY_PANEL_BACKGROUND = "PanelBackground";
    public static final String PROPERTY_PIE_SEGMENT_RENDERER = "PieSegmentRenderer";
    public static final String PROPERTY_POINT_RENDERER = "PointRenderer";
    public static final String PROPERTY_SHADOW_VISIBLE = "ShadowVisible";
    public static final String PROPERTY_CHART_STYLE = "ChartStyle";
    public static final String PROPERTY_TICK_COLOR = "TickColor";
    public static final String PROPERTY_TICK_FONT = "TickFont";
    public static final String PROPERTY_TICK_LENGTH = "TickLength";
    public static final String PROPERTY_TITLE = "Title";
    public static final String PROPERTY_TITLE_VISIBLE = "TitleVisible";
    public static final String PROPERTY_VERTICAL_GRIDLINES_VISIBLE = "VerticalGridLinesVisible";
    public static final String PROPERTY_X_AXIS = "XAxis";
    public static final String PROPERTY_Y_AXIS = "YAxis";
    private static final Logger a;
    public static int MIN_LEFT_MARGIN;
    public static int MIN_RIGHT_MARGIN;
    public static int MIN_TOP_MARGIN;
    public static int MIN_BOTTOM_MARGIN;
    private static double b;
    private int c;
    private ShadowFactory d;
    private Axis e;
    private List<Axis> f;
    private Map<ChartModel, Axis> g;
    private AbstractLabel h;
    private List<Drawable> i;
    private d j;
    private boolean k;
    private boolean l;
    private boolean m;
    private boolean n;
    private boolean o;
    private boolean p;
    private List<UserToPixelTransform> q;
    private int r;
    private int s;
    private int t;
    private int u;
    private int v;
    private Paint w;
    private Paint x;
    private Color y;
    private Color z;
    private Color A;
    private Color B;
    private Font C;
    private boolean D;
    private BufferedImage E;
    private boolean F;
    private Map<String, ChartStyle> G;
    private Map<Chartable, AbstractStyle> H;
    private Map<Highlight, PointStyle> I;
    private MouseWheelZoomer J;
    private MouseDragPanner K;
    private List<ChartModel> L;
    private c M;
    private b N;
    private c O;
    private c P;
    private ChartType Q;
    private PointRenderer R;
    private BarRenderer S;
    private LineRenderer T;
    private PieSegmentRenderer U;
    static final /* synthetic */ boolean V;
    public static int W;

    public Chart() {
        int n = Orientation.b;
        this.c = Integer.MAX_VALUE;
        this.d = new ShadowFactory();
        this.f = new ArrayList<Axis>();
        this.g = new HashMap<ChartModel, Axis>();
        this.h = null;
        this.i = new ArrayList<Drawable>();
        this.j = new d(this);
        this.k = true;
        this.l = false;
        this.m = true;
        this.n = true;
        this.o = true;
        this.p = false;
        this.q = Collections.synchronizedList(new ArrayList());
        this.v = 2;
        this.w = (Color)UIManager.get("Panel.background");
        this.x = Color.WHITE;
        this.y = Color.DARK_GRAY;
        this.z = Color.DARK_GRAY;
        this.A = Color.LIGHT_GRAY;
        this.B = Color.black;
        this.C = UIManager.getFont("Label.font");
        this.D = false;
        this.E = null;
        this.G = new HashMap<String, ChartStyle>();
        this.H = new HashMap<Chartable, AbstractStyle>();
        this.I = new HashMap<Highlight, PointStyle>();
        this.L = Collections.synchronizedList(new ArrayList());
        this.M = new f();
        this.N = new b();
        this.O = new e();
        this.P = new g();
        this.Q = ChartType.XY;
        this.R = new DefaultPointRenderer();
        this.S = new DefaultBarRenderer();
        this.T = new DefaultLineRenderer(this);
        this.U = new DefaultPieSegmentRenderer();
        this.init();
        if (W != 0) {
            Orientation.b = ++n;
        }
    }

    public Chart(String string) {
        this();
        this.setName(string);
    }

    public Chart(Dimension dimension) {
        int n = Orientation.b;
        this.c = Integer.MAX_VALUE;
        this.d = new ShadowFactory();
        this.f = new ArrayList<Axis>();
        this.g = new HashMap<ChartModel, Axis>();
        this.h = null;
        this.i = new ArrayList<Drawable>();
        this.j = new d(this);
        this.k = true;
        this.l = false;
        this.m = true;
        this.n = true;
        this.o = true;
        this.p = false;
        this.q = Collections.synchronizedList(new ArrayList());
        this.v = 2;
        this.w = (Color)UIManager.get("Panel.background");
        this.x = Color.WHITE;
        this.y = Color.DARK_GRAY;
        this.z = Color.DARK_GRAY;
        this.A = Color.LIGHT_GRAY;
        this.B = Color.black;
        this.C = UIManager.getFont("Label.font");
        this.D = false;
        this.E = null;
        this.G = new HashMap<String, ChartStyle>();
        this.H = new HashMap<Chartable, AbstractStyle>();
        this.I = new HashMap<Highlight, PointStyle>();
        this.L = Collections.synchronizedList(new ArrayList());
        this.M = new f();
        this.N = new b();
        this.O = new e();
        this.P = new g();
        this.Q = ChartType.XY;
        this.R = new DefaultPointRenderer();
        this.S = new DefaultBarRenderer();
        this.T = new DefaultLineRenderer(this);
        this.U = new DefaultPieSegmentRenderer();
        this.init();
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.update();
        if (n != 0) {
            int n2 = W;
            W = ++n2;
        }
    }

    protected void init() {
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.a(new Axis("x"), false);
        this.b(new Axis("y"), false);
        this.setMinimumSize(new Dimension(100, 100));
        this.setFont(UIManager.getFont("Label.font"));
        this.addDrawable(this.j);
        this.j.setModels(this.L);
        this.j.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Chart.this.repaint();
                Chart.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Chart.this.update();
            }
        });
    }

    public ChartType getChartType() {
        return this.Q;
    }

    public void setChartType(ChartType chartType) {
        ChartType chartType2 = this.Q;
        this.Q = chartType;
        this.a(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_CHART_TYPE, (Object)chartType2, (Object)chartType);
    }

    public PointRenderer getPointRenderer() {
        return this.R;
    }

    public void setPointRenderer(PointRenderer pointRenderer) {
        PointRenderer pointRenderer2 = this.R;
        if (Orientation.b == 0) {
            if (pointRenderer == null) {
                throw new IllegalArgumentException("PointRenderer cannot be null");
            }
            this.R = pointRenderer;
            this.a(true);
            this.repaint();
            this.firePropertyChange(PROPERTY_POINT_RENDERER, pointRenderer2, pointRenderer);
        }
    }

    public BarRenderer getBarRenderer() {
        return this.S;
    }

    public void setBarRenderer(BarRenderer barRenderer) {
        BarRenderer barRenderer2 = this.S;
        this.S = barRenderer;
        this.a(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_BAR_RENDERER, barRenderer2, barRenderer);
    }

    public PieSegmentRenderer getPieSegmentRenderer() {
        return this.U;
    }

    public void setPieSegmentRenderer(PieSegmentRenderer pieSegmentRenderer) {
        PieSegmentRenderer pieSegmentRenderer2 = this.U;
        this.U = pieSegmentRenderer;
        this.a(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_PIE_SEGMENT_RENDERER, pieSegmentRenderer2, pieSegmentRenderer);
    }

    public LineRenderer getLineRenderer() {
        return this.T;
    }

    public void setLineRenderer(LineRenderer lineRenderer) {
        LineRenderer lineRenderer2 = this.T;
        this.T = lineRenderer;
        this.a(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_LINE_RENDERER, lineRenderer2, lineRenderer);
    }

    public void setBarGap(int n) {
        int n2 = this.N.getBarGap();
        this.N.setBarGap(n);
        this.a(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_BAR_GAP, n2, n);
    }

    public int getBarGap() {
        return this.N.getBarGap();
    }

    public void setBarGroupGap(int n) {
        int n2 = this.N.getGroupGap();
        this.N.setGroupGap(n);
        this.a(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_BAR_GROUP_GAP, n2, n);
    }

    public void setBarsGrouped(boolean bl) {
        boolean bl2 = this.N.isGrouped();
        this.N.setGrouped(bl);
        this.a(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_BARS_GROUPED, bl2, bl);
    }

    public boolean isBarsGrouped() {
        return this.N.isGrouped();
    }

    private boolean a() {
        return this.F;
    }

    private void a(boolean bl) {
        this.F = bl;
    }

    public void updateLazyCharts() {
        this.j.updateCharts();
    }

    public long lazyImageLastModified() {
        return this.j.lastModified();
    }

    public void setLazyUpdateDelay(int n) {
        this.j.setTimerDuration(n);
    }

    public int getLazyUpdateDelay() {
        return this.j.getTimerDuration();
    }

    public boolean isHighQuality() {
        return this.p;
    }

    public void setHighQuality(boolean bl) {
        boolean bl2 = this.p;
        this.p = bl;
        this.a(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_HIGH_QUALITY, bl2, bl);
    }

    public boolean isVerticalGridLinesVisible() {
        return this.n;
    }

    public void setVerticalGridLinesVisible(boolean bl) {
        this.n = bl;
    }

    public boolean isHorizontalGridLinesVisible() {
        return this.o;
    }

    public void setHorizontalGridLinesVisible(boolean bl) {
        boolean bl2 = this.o;
        this.o = bl;
        this.firePropertyChange(PROPERTY_HORIZONTAL_GRIDLINES_VISIBLE, bl2, bl);
    }

    public boolean isTitleVisible() {
        return this.m;
    }

    public void setTitleVisible(boolean bl) {
        boolean bl2 = this.m;
        this.m = bl;
        this.a(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_TITLE_VISIBLE, bl2, bl);
    }

    public Font getTickFont() {
        return this.C;
    }

    public void setTickFont(Font font) {
        Font font2 = this.C;
        this.C = font;
        this.a(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_TICK_FONT, font2, font);
    }

    public Color getAxisColor() {
        return this.y;
    }

    public void setAxisColor(Color color) {
        Color color2 = this.y;
        this.y = color;
        this.a(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_AXIS_COLOR, color2, color);
    }

    public Color getGridColor() {
        return this.A;
    }

    public void setGridColor(Color color) {
        Color color2 = this.A;
        this.A = color;
        this.a(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_GRID_COLOR, color2, color);
    }

    public Paint getPanelBackground() {
        return this.w;
    }

    public void setPanelBackground(Paint paint) {
        Paint paint2 = this.w;
        if (Orientation.b == 0) {
            if (paint instanceof Color) {
                Color color = (Color)paint;
                this.setBackground(color);
            }
            this.w = paint;
            this.repaint();
            this.firePropertyChange(PROPERTY_PANEL_BACKGROUND, paint2, paint);
        }
    }

    public Paint getChartBackground() {
        return this.x;
    }

    public void setChartBackground(Paint paint) {
        Paint paint2 = this.x;
        this.x = paint;
        this.repaint();
        this.firePropertyChange(PROPERTY_CHART_BACKGROUND, paint2, paint);
    }

    /*
     * Unable to fully structure code
     */
    public UserToPixelTransform getUserToPixelTransform() {
        block6: {
            var1_1 = Orientation.b;
            v0 = Chart.V;
            if (var1_1 != 0) break block6;
            if (v0 == 0) {
                v1 = this.q;
                if (var1_1 == 0) {
                    if (v1 == null) {
                        throw new AssertionError();
                    } else {
                        ** GOTO lbl-1000
                    }
                }
            } else lbl-1000:
            // 3 sources

            {
                v1 = this.q;
            }
            if (var1_1 != 0) ** GOTO lbl16
            v0 = v1.size();
        }
        if (v0 > 0) {
            v1 = this.q.get(0);
lbl16:
            // 2 sources

            v2 = (UserToPixelTransform)v1;
        } else {
            v2 = null;
        }
        return v2;
    }

    public boolean isAntiAliasing() {
        return this.k;
    }

    public void setAntiAliasing(boolean bl) {
        boolean bl2 = this.k;
        this.k = bl;
        this.a(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_ANTI_ALIASING, bl2, bl);
    }

    public boolean isLabellingTraces() {
        return this.l;
    }

    public void setLabellingTraces(boolean bl) {
        boolean bl2 = this.l;
        this.l = bl;
        this.a(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_LABELLING_TRACES, bl2, bl);
    }

    public Chart addMouseZoomer() {
        return this.addMouseZoomer(true, true);
    }

    public Chart addMouseZoomer(boolean bl, boolean bl2) {
        Chart chart = this;
        if (Orientation.b == 0) {
            if (chart.J != null) {
                this.removeMouseZoomer();
            }
            this.J = new MouseWheelZoomer(this, bl, bl2);
            this.addMouseWheelListener(this.J);
            this.addMouseMotionListener(this.J);
            chart = this;
        }
        return chart;
    }

    public Chart removeMouseZoomer() {
        Chart chart = this;
        if (Orientation.b == 0) {
            if (chart.J != null) {
                this.removeMouseWheelListener(this.J);
                this.removeMouseMotionListener(this.J);
            }
            chart = this;
        }
        return chart;
    }

    public Chart addMousePanner() {
        Chart chart = this;
        if (Orientation.b == 0) {
            if (chart.K != null) {
                this.removeMousePanner();
            }
            this.K = new MouseDragPanner(this);
            this.addMouseListener(this.K);
            this.addMouseMotionListener(this.K);
            chart = this;
        }
        return chart;
    }

    public Chart removeMousePanner() {
        Chart chart = this;
        if (Orientation.b == 0) {
            if (chart.K != null) {
                this.removeMouseListener(this.K);
                this.removeMouseMotionListener(this.K);
            }
            chart = this;
        }
        return chart;
    }

    @Override
    public void chartModelChanged() {
        this.update();
    }

    public boolean isShadowVisible() {
        return this.D;
    }

    public void setShadowVisible(boolean bl) {
        boolean bl2 = this.D;
        this.D = bl;
        this.a(true);
        this.update();
        this.firePropertyChange(PROPERTY_SHADOW_VISIBLE, bl2, bl);
    }

    public void update() {
        Chart chart;
        int n;
        block6: {
            Container container;
            block7: {
                int n2;
                Dimension dimension;
                block8: {
                    n = Orientation.b;
                    this.f();
                    this.h();
                    AxisRenderer axisRenderer = this.e.getAxisRenderer();
                    int n3 = this.N.computeAxisBreadth(this);
                    axisRenderer.setBreadth(n3);
                    this.f();
                    this.h();
                    dimension = this.getSize();
                    container = this;
                    if (n != 0) break block6;
                    if (!container.D) break block7;
                    n2 = dimension.width;
                    if (n != 0) break block8;
                    if (n2 <= 0) break block7;
                    n2 = dimension.height;
                }
                if (n2 > 0) {
                    this.E = new BufferedImage(dimension.width, dimension.height, 2);
                }
            }
            this.a(true);
            container = chart = this.getParent();
        }
        if (n == 0) {
            if (chart != null) {
                chart.repaint();
            }
            this.revalidate();
            this.repaint();
        }
    }

    public void drawInBackground() {
        Chart chart;
        block4: {
            block5: {
                int n = Orientation.b;
                chart = this;
                if (n != 0) break block4;
                if (!chart.isLazyRendering()) break block5;
                chart = this;
                if (n != 0) break block4;
                if (chart.a()) {
                    this.j.updateCharts();
                }
            }
            this.a(false);
            chart = this;
        }
        super.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block11: {
            boolean bl;
            block12: {
                String string;
                block13: {
                    int n;
                    block8: {
                        block14: {
                            block9: {
                                block10: {
                                    n = Orientation.b;
                                    string = propertyChangeEvent.getPropertyName();
                                    bl = "range".equals(string);
                                    if (n != 0) break block9;
                                    if (!bl) break block10;
                                    this.update();
                                    if (n == 0) break block11;
                                }
                                bl = "updateOtherAxes".equals(string);
                            }
                            if (n != 0) break block12;
                            if (!bl) break block13;
                            Object object = propertyChangeEvent.getSource();
                            Object object2 = propertyChangeEvent.getOldValue();
                            Object object3 = propertyChangeEvent.getNewValue();
                            Axis axis = this.getYAxis();
                            if (n != 0) break block8;
                            if (object != this.getYAxis()) break block14;
                            Range range = (Range)object2;
                            Range range2 = (Range)object3;
                            double d2 = (range2.minimum() - range.minimum()) / range.size();
                            double d3 = (range2.maximum() - range.minimum()) / range.size();
                            for (Axis axis2 : this.f) {
                                block16: {
                                    Axis axis3;
                                    block15: {
                                        if (n != 0) break block8;
                                        axis3 = axis2;
                                        if (n != 0) break block15;
                                        if (axis3 == axis) break block16;
                                        axis3 = axis2;
                                    }
                                    Range<?> range3 = axis3.getOutputRange();
                                    NumericRange numericRange = new NumericRange(d2 * range3.size() + range3.minimum(), d3 * range3.size() + range3.minimum());
                                    axis2.setRange(numericRange, false);
                                }
                                if (n == 0) continue;
                            }
                        }
                        this.update();
                    }
                    if (n == 0) break block11;
                }
                bl = "label".equals(string);
            }
            if (bl) {
                this.repaint();
            }
        }
    }

    public Chart addDrawable(Drawable drawable) {
        Chart chart = this;
        if (Orientation.b == 0) {
            chart.i.add(drawable);
            if (drawable != this.j) {
                this.invalidate();
                this.repaint();
            }
            chart = this;
        }
        return chart;
    }

    public Chart removeDrawable(Drawable drawable) {
        this.i.remove(drawable);
        this.repaint();
        return this;
    }

    public Chart removeDrawables() {
        this.i.clear();
        this.repaint();
        return this;
    }

    public boolean containsDrawable(Drawable drawable) {
        return this.i.contains(drawable);
    }

    public Collection<Drawable> getDrawables() {
        return this.i;
    }

    public void clearDrawables() {
        this.i.clear();
        this.repaint();
    }

    public int axisWidth(Axis axis) {
        int n = this.getTickLength();
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return 35;
        }
        if (axis == this.e) {
            return n + axis.labelWidth(graphics, this.getTickFont(), Orientation.horizontal);
        }
        return n + axis.labelWidth(graphics, this.getTickFont(), Orientation.vertical);
    }

    /*
     * Unable to fully structure code
     */
    int b() {
        var4_1 = Orientation.b;
        var1_2 = 0;
        var2_3 = this.f.iterator();
        while (var2_3.hasNext()) {
            var3_4 = var2_3.next();
            if (var3_4.getPlacement() == AxisPlacement.LEADING) {
                var1_2 += this.axisWidth(var3_4);
            }
            if (var4_1 == 0) continue;
        }
        v0 = var2_3 = this.getInsets();
        if (var4_1 != 0) ** GOTO lbl15
        if (v0 == null) {
            v1 = Chart.MIN_LEFT_MARGIN;
        } else {
            v0 = var2_3;
lbl15:
            // 2 sources

            v1 = v0.left;
        }
        var3_5 = v1;
        v2 = var1_2;
        if (var4_1 == 0) {
            v2 = v2 < var3_5 ? var3_5 : var1_2;
        }
        return v2;
    }

    /*
     * Unable to fully structure code
     */
    int c() {
        var4_1 = Orientation.b;
        var1_2 = 0;
        var2_3 = this.f.iterator();
        while (var2_3.hasNext()) {
            var3_4 = var2_3.next();
            if (var3_4.getPlacement() == AxisPlacement.TRAILING) {
                var1_2 += this.axisWidth(var3_4);
            }
            if (var4_1 == 0) continue;
        }
        v0 = var2_3 = this.getInsets();
        if (var4_1 != 0) ** GOTO lbl15
        if (v0 == null) {
            v1 = Chart.MIN_RIGHT_MARGIN;
        } else {
            v0 = var2_3;
lbl15:
            // 2 sources

            v1 = v0.right;
        }
        var3_5 = v1;
        v2 = var1_2;
        if (var4_1 == 0) {
            v2 = v2 < var3_5 ? var3_5 : var1_2;
        }
        return v2;
    }

    /*
     * Unable to fully structure code
     */
    int d() {
        v0 = var1_1 = this.getInsets();
        if (Orientation.b != 0) ** GOTO lbl7
        if (v0 == null) {
            v1 = Chart.MIN_TOP_MARGIN;
        } else {
            v0 = var1_1;
lbl7:
            // 2 sources

            v1 = var2_2 = v0.top;
        }
        if (this.e.getPlacement() == AxisPlacement.TRAILING) {
            return var2_2 + this.axisWidth(this.getXAxis());
        }
        return var2_2;
    }

    /*
     * Unable to fully structure code
     */
    int e() {
        var3_1 = Orientation.b;
        v0 = var1_2 = this.getInsets();
        if (var3_1 != 0) ** GOTO lbl8
        if (v0 == null) {
            v1 = Chart.MIN_BOTTOM_MARGIN;
        } else {
            v0 = var1_2;
lbl8:
            // 2 sources

            v1 = v0.bottom;
        }
        var2_3 = v1;
        v2 = this.e.getPlacement();
        v3 = AxisPlacement.FLOATING;
        if (var3_1 == 0) {
            if (v2 == v3) {
                return var2_3;
            }
            v2 = this.e.getPlacement();
            v3 = AxisPlacement.TRAILING;
        }
        if (var3_1 == 0) {
            if (v2 == v3) {
                return var2_3;
            }
            v2 = this.e.getPlacement();
            v3 = AxisPlacement.CENTER;
        }
        if (v2 == v3) {
            return var2_3;
        }
        return var2_3 + this.axisWidth(this.e);
    }

    public int getXStart() {
        return this.r;
    }

    public int getXEnd() {
        return this.s;
    }

    public int getChartWidth() {
        return this.s - this.r;
    }

    public int getYStart() {
        return this.t;
    }

    public int getYEnd() {
        return this.u;
    }

    public int getChartHeight() {
        return this.t - this.u;
    }

    public double getYSum(ChartModel chartModel) {
        double d2;
        int n = Orientation.b;
        double d3 = 0.0;
        if (chartModel != null) {
            for (int i = 0; i < chartModel.getPointCount(); ++i) {
                Chartable chartable = chartModel.getPoint(i);
                d2 = d3 + chartable.getY().position();
                if (n == 0) {
                    d3 = d2;
                    if (n == 0) continue;
                }
                break;
            }
        } else {
            d2 = d3;
        }
        return d2;
    }

    /*
     * Unable to fully structure code
     */
    private void f() {
        var2_1 = Orientation.b;
        var1_2 = this.getSize();
        v0 = var1_2.width;
        if (var2_1 != 0) ** GOTO lbl9
        if (v0 == 0) {
            v1 = 0;
        } else {
            v0 = this.b();
lbl9:
            // 2 sources

            v1 = v0 + this.getYAxis().getAxisRenderer().getBreadth();
        }
        this.r = v1;
        v2 = var1_2.width;
        if (var2_1 != 0) ** GOTO lbl17
        if (v2 == 0) {
            v3 = 0;
        } else {
            v2 = var1_2.width;
lbl17:
            // 2 sources

            v3 = v2 - this.c();
        }
        this.s = v3;
        v4 = var1_2.height;
        if (var2_1 != 0) ** GOTO lbl25
        if (v4 == 0) {
            v5 = 0;
        } else {
            v4 = var1_2.height - this.e();
lbl25:
            // 2 sources

            v5 = v4 - this.getXAxis().getAxisRenderer().getBreadth();
        }
        this.t = v5;
        v6 = var1_2.height;
        if (var2_1 == 0) {
            v6 = v6 == 0 ? 0 : this.d();
        }
        this.u = v6;
    }

    public int getTickLength() {
        return this.v;
    }

    public void setTickLength(int n) {
        int n2 = this.v;
        this.v = n;
        this.repaint();
        this.firePropertyChange(PROPERTY_TICK_LENGTH, n2, n);
    }

    public Color getTickColor() {
        return this.z;
    }

    public void setTickColor(Color color) {
        Color color2 = this.z;
        this.z = color;
        this.firePropertyChange(PROPERTY_TICK_COLOR, color2, color);
    }

    public Color getLabelColor() {
        return this.B;
    }

    public void setLabelColor(Color color) {
        Color color2 = this.B;
        this.B = color;
        this.a(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_LABEL_COLOR, color2, color);
    }

    private void a(Axis axis, boolean bl) {
        int n = Orientation.b;
        Axis axis2 = this.e;
        Chart chart = this;
        if (n == 0) {
            if (chart.e != null) {
                this.e.removePropertyChangeListener(this);
            }
            chart = this;
        }
        chart.e = axis;
        if (n == 0) {
            if (bl) {
                this.update();
            }
            this.e.addPropertyChangeListener(this);
            this.firePropertyChange(PROPERTY_X_AXIS, axis2, axis);
        }
    }

    public void setXAxis(Axis axis) {
        this.a(axis, true);
    }

    public Axis getXAxis() {
        return this.e;
    }

    private void b(Axis axis, boolean bl) {
        Object object;
        int n;
        block9: {
            Object object2;
            n = Orientation.b;
            boolean bl2 = V;
            if (n == 0) {
                if (!bl2 && this.f == null) {
                    throw new AssertionError();
                }
                bl2 = V;
            }
            if (!bl2 && axis == null) {
                throw new AssertionError();
            }
            object = this.f.iterator();
            while (object.hasNext()) {
                Axis axis2;
                object2 = axis2 = object.next();
                if (n == 0) {
                    ((Axis)object2).removePropertyChangeListener(this);
                    if (n == 0) continue;
                }
                break block9;
            }
            object2 = object = axis;
        }
        if (n == 0) {
            if (((Axis)object).getPlacement() == null) {
                ((Axis)object).setPlacement(AxisPlacement.LEADING);
            }
            this.f.clear();
            this.f.add((Axis)object);
        }
        if (n == 0) {
            if (bl) {
                this.update();
            }
            ((Axis)object).addPropertyChangeListener(this);
            this.firePropertyChange(PROPERTY_Y_AXIS, null, axis);
        }
    }

    public void setYAxis(Axis axis) {
        this.b(axis, true);
    }

    /*
     * Unable to fully structure code
     */
    public Chart addYAxis(Axis var1_1) {
        var2_2 = Orientation.b;
        v0 = Chart.V;
        if (var2_2 == 0) {
            if (!v0 && this.f == null) {
                throw new AssertionError();
            }
            v0 = Chart.V;
        }
        if (var2_2 != 0) ** GOTO lbl15
        if (!v0) {
            v1 = var1_1;
            if (var2_2 == 0) {
                if (v1 == null) {
                    throw new AssertionError();
                } else {
                    ** GOTO lbl-1000
                }
            }
        } else lbl-1000:
        // 3 sources

        {
            v0 = this.f.add(var1_1);
lbl15:
            // 2 sources

            this.update();
            v1 = var1_1;
        }
        v1.addPropertyChangeListener(this);
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public Axis getYAxis() {
        block10: {
            block9: {
                var1_1 = Orientation.b;
                v0 = Chart.V;
                if (var1_1 != 0) break block9;
                if (v0 == 0) {
                    v1 = this.f;
                    if (var1_1 == 0) {
                        if (v1 == null) {
                            throw new AssertionError();
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    v1 = this.f;
                }
                if (var1_1 != 0) break block10;
                v0 = v1.size();
            }
            if (v0 == 0) {
                return null;
            }
            v1 = this.f.get(0);
        }
        return (Axis)v1;
    }

    public void setTitle(String string) {
        AutoPositionedLabel autoPositionedLabel = new AutoPositionedLabel(string);
        this.setTitle(autoPositionedLabel);
    }

    public AbstractAnnotation getTitle() {
        return this.h;
    }

    public void setTitle(AbstractLabel abstractLabel) {
        AbstractLabel abstractLabel2 = this.h;
        this.h = abstractLabel;
        this.repaint();
        this.firePropertyChange(PROPERTY_TITLE, abstractLabel2, abstractLabel);
    }

    public int getLazyRenderingThreshold() {
        return this.c;
    }

    public void setLazyRenderingThreshold(int n) {
        int n2 = this.c;
        if (Orientation.b == 0) {
            if (n < 0) {
                throw new IllegalArgumentException("Threshold must be >= 0");
            }
            this.c = n;
            this.firePropertyChange(PROPERTY_LAZY_RENDERING_THRESHOLD, n2, n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isLazyRendering() {
        int n = Orientation.b;
        int n2 = this.getLazyRenderingThreshold();
        if (n != 0) return n2 != 0;
        if (n2 <= 0) return 1 != 0;
        n2 = this.pointCount();
        if (n != 0) return n2 != 0;
        if (n2 < this.getLazyRenderingThreshold()) return 0 != 0;
        return 1 != 0;
    }

    private void a(ChartModel chartModel) {
        ArrayList<ChartModel> arrayList;
        block10: {
            boolean bl;
            List<ChartModel> list;
            int n;
            block13: {
                block12: {
                    boolean bl2;
                    block11: {
                        n = Orientation.b;
                        boolean bl3 = V;
                        if (n == 0) {
                            if (!bl3 && chartModel == null) {
                                throw new AssertionError();
                            }
                            bl3 = V;
                        }
                        if (!bl3 && chartModel.getName() == null) {
                            throw new AssertionError();
                        }
                        arrayList = new ArrayList<ChartModel>(this.L);
                        bl2 = V;
                        if (n != 0) break block11;
                        if (bl2) break block12;
                        list = this.L;
                        if (n != 0) break block13;
                        bl2 = list.contains(chartModel);
                    }
                    if (bl2) {
                        throw new AssertionError((Object)String.format("Chart '%s' already contains a model equal to %s", this.getName(), chartModel.getName()));
                    }
                }
                list = this.L;
            }
            for (ChartModel chartModel2 : list) {
                bl = chartModel2.getName().equals(chartModel.getName());
                if (n == 0) {
                    if (bl) {
                        throw new IllegalArgumentException("ChartModel " + chartModel2.getName() + " already exists!");
                    }
                    if (n == 0) continue;
                }
                break block10;
            }
            bl = this.L.add(chartModel);
        }
        chartModel.addChartModelListener(this);
        this.firePropertyChange("models", arrayList, this.L);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void setModel(ChartModel var1_1) {
        v0 /* !! */  = this.L;
        if (Orientation.b != 0) ** GOTO lbl5
        if (v0 /* !! */ .size() > 0) {
            v0 /* !! */  = this.L.get(0);
lbl5:
            // 2 sources

            v1 = (ChartModel)v0 /* !! */ ;
        } else {
            v1 = null;
        }
        var2_2 = v1;
        this.removeModels();
        this.addModel(var1_1);
        this.firePropertyChange("Model", var2_2, var1_1);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void setModel(ChartModel var1_1, ChartStyle var2_2) {
        v0 /* !! */  = this.L;
        if (Orientation.b != 0) ** GOTO lbl5
        if (v0 /* !! */ .size() > 0) {
            v0 /* !! */  = this.L.get(0);
lbl5:
            // 2 sources

            v1 = (ChartModel)v0 /* !! */ ;
        } else {
            v1 = null;
        }
        var3_3 = v1;
        this.removeModels();
        this.addModel(var1_1, var2_2);
        this.firePropertyChange("Model", var3_3, var1_1);
    }

    public Chart addModel(ChartModel chartModel) {
        this.addModel(chartModel, true);
        return this;
    }

    public Chart addModel(ChartModel chartModel, boolean bl) {
        this.a(chartModel);
        Chart chart = this;
        if (Orientation.b == 0) {
            chart.a(bl);
            if (bl) {
                this.a(true);
                this.repaint();
            }
            chart = this;
        }
        return chart;
    }

    public Chart addModel(ChartModel chartModel, ChartStyle chartStyle) {
        this.G.put(chartModel.getName(), chartStyle);
        this.a(chartModel);
        this.a(true);
        this.repaint();
        return this;
    }

    public Chart addModel(ChartModel chartModel, Axis axis) {
        this.a(chartModel);
        this.setModelAxis(chartModel, axis);
        this.a(true);
        this.repaint();
        return this;
    }

    public ChartModel getModel() {
        Iterable<ChartModel> iterable;
        block4: {
            block5: {
                block3: {
                    int n;
                    block2: {
                        n = Orientation.b;
                        iterable = this.L;
                        if (n != 0) break block2;
                        if (iterable == null) break block3;
                        iterable = this.L;
                    }
                    if (n != 0) break block4;
                    if (iterable.size() != 0) break block5;
                }
                return null;
            }
            iterable = this.L.get(0);
        }
        return (ChartModel)iterable;
    }

    public ChartModel getModel(int n) {
        Iterable<ChartModel> iterable;
        block4: {
            block5: {
                block3: {
                    int n2;
                    block2: {
                        n2 = Orientation.b;
                        iterable = this.L;
                        if (n2 != 0) break block2;
                        if (iterable == null) break block3;
                        iterable = this.L;
                    }
                    if (n2 != 0) break block4;
                    if (iterable.size() != 0) break block5;
                }
                return null;
            }
            iterable = this.L.get(n);
        }
        return (ChartModel)iterable;
    }

    public ChartModel getModel(String string) {
        for (ChartModel chartModel : this.L) {
            if (string.equals(chartModel.getName())) {
                return chartModel;
            }
            if (Orientation.b == 0) continue;
        }
        return null;
    }

    public List<ChartModel> getModels() {
        return this.L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int modelCount() {
        List<ChartModel> list = this.L;
        if (Orientation.b == 0) {
            if (list == null) {
                return 0;
            }
            list = this.L;
        }
        int n = list.size();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pointCount() {
        int n = Orientation.b;
        int n2 = 0;
        List<ChartModel> list = this.L;
        synchronized (list) {
            for (ChartModel chartModel : this.L) {
                n2 += chartModel.getPointCount();
                if (n == 0) {
                    if (n == 0) continue;
                }
                break;
            }
            return n2;
        }
    }

    public void setModelAxis(ChartModel chartModel, Axis axis) {
        this.g.put(chartModel, axis);
        this.a(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_Y_AXIS, null, axis);
    }

    public Axis getModelAxis(ChartModel chartModel) {
        return this.getAxisForModel(chartModel);
    }

    public Axis getAxisForModel(ChartModel chartModel) {
        Axis axis;
        Axis axis2 = axis = this.g.get(chartModel);
        if (Orientation.b == 0) {
            axis2 = axis2 == null ? this.getYAxis() : axis;
        }
        return axis2;
    }

    public UserToPixelTransform getTransformForModel(ChartModel chartModel) {
        Axis axis = this.getAxisForModel(chartModel);
        if (!V && axis == null) {
            throw new AssertionError();
        }
        return this.getTransformForAxis(axis);
    }

    public void setStyle(ChartModel chartModel, ChartStyle chartStyle) {
        this.setStyle(chartModel, chartStyle, true);
    }

    public void setStyle(ChartModel chartModel, ChartStyle chartStyle, boolean bl) {
        this.G.put(chartModel.getName(), chartStyle);
        if (Orientation.b == 0) {
            if (bl) {
                this.a(true);
                this.repaint();
            }
            this.firePropertyChange(PROPERTY_CHART_STYLE, null, chartStyle);
        }
    }

    /*
     * Unable to fully structure code
     */
    public ChartStyle getStyle(ChartModel var1_1) {
        var3_2 = Orientation.b;
        if (!Chart.V) {
            v0 = var1_1;
            if (var3_2 == 0) {
                if (v0 == null) {
                    throw new AssertionError();
                } else {
                    ** GOTO lbl-1000
                }
            }
        } else lbl-1000:
        // 3 sources

        {
            v0 = var1_1;
        }
        var2_3 = v0.getName();
        v1 = var2_3;
        if (var3_2 == 0) {
            if (v1 == null) {
                throw new NullPointerException("Unnamed Model " + var1_1);
            }
            v1 = this.G.get(var2_3);
        }
        return (ChartStyle)v1;
    }

    public void setHighlightStyle(Highlight highlight, PointStyle pointStyle) {
        block2: {
            PointStyle pointStyle2;
            block3: {
                int n = Orientation.b;
                pointStyle2 = pointStyle;
                if (n != 0) break block2;
                if (pointStyle2 != null) break block3;
                this.I.remove(highlight);
                if (n == 0) break block2;
            }
            pointStyle2 = this.I.put(highlight, pointStyle);
        }
        this.a(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_HIGHLIGHT_STYLE, null, pointStyle);
    }

    public PointStyle getHighlightStyle(Highlight highlight) {
        return this.I.get(highlight);
    }

    public Chart clearHighlights() {
        this.H.clear();
        this.repaint();
        return this;
    }

    public AbstractStyle getStyle(ChartModel chartModel, Chartable chartable) {
        return this.H.get(chartable);
    }

    public boolean containsModel(ChartModel chartModel) {
        return this.L.contains(chartModel);
    }

    /*
     * Unable to fully structure code
     */
    public Chart removeModel(ChartModel var1_1) {
        var3_2 = Orientation.b;
        v0 = Chart.V;
        if (var3_2 == 0) {
            if (v0 == 0) {
                v1 = var1_1;
                if (var3_2 == 0) {
                    if (v1 == null) {
                        throw new AssertionError((Object)"Supplied ChartModel cannot be null");
                    } else {
                        ** GOTO lbl-1000
                    }
                }
            } else lbl-1000:
            // 3 sources

            {
                v1 = var1_1;
            }
            v1.removeChartModelListener(this);
            v0 = this.L.size();
        }
        var2_3 = v0;
        this.L.remove(var1_1);
        if (var3_2 == 0) {
            if (!Chart.V) {
                v2 = this.L;
                if (var3_2 == 0) {
                    if (v2.size() != var2_3 - 1) {
                        throw new AssertionError((Object)"Unable to remove model. Was it named?");
                    } else {
                        ** GOTO lbl-1000
                    }
                }
            } else lbl-1000:
            // 3 sources

            {
                this.g.remove(var1_1);
                v2 = this.G.remove(var1_1.getName());
            }
            this.a(true);
            this.repaint();
        }
        return this;
    }

    public Chart removeModels() {
        Chart chart;
        block8: {
            block6: {
                int n;
                block7: {
                    int n2 = Orientation.b;
                    ArrayList<ChartModel> arrayList = new ArrayList<ChartModel>(this.getModels());
                    for (ChartModel chartModel : arrayList) {
                        this.removeModel(chartModel);
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                        }
                        break block6;
                    }
                    n = V;
                    if (n2 != 0) break block7;
                    if (n != 0) break block6;
                    chart = this;
                    if (n2 != 0) break block8;
                    n = chart.L.size();
                }
                if (n != 0) {
                    throw new AssertionError((Object)String.format("Chart " + this.getName() + " still has %d models", this.L.size()));
                }
            }
            chart = this;
        }
        return chart;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    protected void paintComponent(Graphics var1_1) {
        block39: {
            block50: {
                block51: {
                    block49: {
                        block47: {
                            block48: {
                                block45: {
                                    block46: {
                                        block44: {
                                            block42: {
                                                block43: {
                                                    block40: {
                                                        block41: {
                                                            var15_2 = Orientation.b;
                                                            var2_3 = this.getVisibleRect();
                                                            var3_4 = var2_3.width;
                                                            var4_5 = var2_3.height;
                                                            v0 = this.isLazyRendering();
                                                            if (var15_2 != 0) break block40;
                                                            if (v0 == 0) break block41;
                                                            v0 = this.a();
                                                            if (var15_2 != 0) break block40;
                                                            if (v0 == 0) break block41;
                                                            v0 = var3_4;
                                                            if (var15_2 != 0) break block40;
                                                            if (v0 <= 0) break block41;
                                                            v0 = var4_5;
                                                            if (var15_2 != 0) break block40;
                                                            if (v0 > 0) {
                                                                this.F = false;
                                                                this.j.updateCharts();
                                                            }
                                                        }
                                                        this.F = false;
                                                        v0 = this.r;
                                                    }
                                                    if (v0 == this.s) {
                                                        return;
                                                    }
                                                    var5_6 = (Graphics2D)var1_1;
                                                    Chart.a(this.E);
                                                    v1 = this.E;
                                                    if (var15_2 != 0) ** GOTO lbl33
                                                    if (v1 == null) {
                                                        v2 = (Graphics2D)var1_1;
                                                    } else {
                                                        v1 = this.E;
lbl33:
                                                        // 2 sources

                                                        v2 = (Graphics2D)v1.getGraphics();
                                                    }
                                                    var6_7 = v2;
                                                    var6_7.setFont(this.getFont());
                                                    var5_6.setFont(this.getFont());
                                                    if (var15_2 != 0) break block42;
                                                    if (!this.k) break block43;
                                                    var5_6.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                                                    var5_6.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                                    if (var15_2 == 0) break block44;
                                                }
                                                var5_6.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                                            }
                                            var5_6.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                                        }
                                        var7_8 = var5_6.getPaint();
                                        var5_6.setPaint(this.w);
                                        var8_9 = var5_6.getClip();
                                        if (!Chart.V) {
                                            v3 = var8_9;
                                            if (var15_2 == 0) {
                                                if (v3 == null) {
                                                    throw new AssertionError();
                                                } else {
                                                    ** GOTO lbl-1000
                                                }
                                            }
                                        } else lbl-1000:
                                        // 3 sources

                                        {
                                            v3 = var8_9;
                                        }
                                        var9_10 = v3.getBounds();
                                        if (this.isOpaque()) {
                                            var5_6.fillRect(var9_10.x, var9_10.y, var9_10.width, var9_10.height);
                                        }
                                        var10_11 /* !! */  = var5_6.getClipBounds();
                                        var11_12 = 0;
                                        var12_13 = 0;
                                        v4 = this;
                                        if (var15_2 == 0) {
                                            if (v4.Q != ChartType.PIE) {
                                                var5_6.setPaint(this.x);
                                                var5_6.fillRect(this.r, this.u, this.getXEnd() - this.r, this.t - this.u);
                                                var11_12 = this.e.getAxisRenderer().getBreadth();
                                                var12_13 = this.getYAxis().getAxisRenderer().getBreadth();
                                                var13_14 = new Rectangle(this.r - var12_13 / 2, this.u, this.getXEnd() - this.r + var12_13 / 2, this.t - this.u + var11_12 / 2);
                                                var10_11 /* !! */  = var9_10.createIntersection((Rectangle2D)var13_14);
                                                var5_6.setClip(var10_11 /* !! */ );
                                            }
                                            this.paintAnnotations(var5_6);
                                            v4 = this;
                                        }
                                        if (var15_2 != 0) break block45;
                                        if (v4.e.getPlacement() == AxisPlacement.FLOATING) break block46;
                                        v4 = this;
                                        if (var15_2 != 0) break block45;
                                        if (v4.getYAxis().getPlacement() != AxisPlacement.FLOATING) {
                                            var5_6.setClip(var8_9);
                                        }
                                    }
                                    v4 = this;
                                }
                                if (var15_2 != 0) break block47;
                                if (v4.Q != ChartType.PIE) break block48;
                                this.M.drawChart(var6_7, this, this.getModel(), 0, null, false);
                                if (var15_2 == 0) break block49;
                            }
                            v4 = this;
                        }
                        v4.paintAxes(var5_6);
                    }
                    var5_6.setClip(var10_11 /* !! */ );
                    v5 = this;
                    if (var15_2 != 0) break block50;
                    if (v5.isLazyRendering()) break block51;
                    v5 = this;
                    if (var15_2 != 0) break block50;
                    if (v5.Q == ChartType.XY) {
                        this.paintModels(var6_7, var9_10, var10_11 /* !! */ );
                    }
                }
                v5 = this;
            }
            for (Object var14_15 : v5.i) {
                var14_15.draw(var5_6);
                if (var15_2 == 0) {
                    if (var15_2 == 0) continue;
                }
                break block39;
            }
            if (this.E != null) {
                var13_14 = new Rectangle(this.r + var12_13 / 2, this.u, (int)((double)(this.getXEnd() - this.r) - (double)var12_13 / 2.0), (int)((double)(this.t - this.u) - (double)var11_12 / 2.0));
                var5_6.setClip((Shape)var13_14);
                v6 = this.isShadowVisible();
                if (var15_2 == 0) {
                    if (v6) {
                        var14_15 = this.d.createShadow(this.E);
                        if (this.Q == ChartType.PIE) {
                            var1_1.setClip(this.getBounds());
                        }
                        var1_1.drawImage((Image)var14_15, 0, 0, null);
                    }
                    var5_6.setClip(var10_11 /* !! */ );
                    v6 = var1_1.drawImage(this.E, 0, 0, null);
                }
            }
            var5_6.setPaint(var7_8);
            var6_7.dispose();
            var5_6.setClip(this.getBounds());
        }
    }

    private static void a(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = bufferedImage;
        if (Orientation.b == 0) {
            if (bufferedImage2 == null) {
                return;
            }
            bufferedImage2 = bufferedImage;
        }
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.fill(double_);
    }

    /*
     * Unable to fully structure code
     */
    protected void paintYAxisTicks(Graphics var1_1, Axis var2_2, UserToPixelTransform var3_3, Point var4_4, int var5_5) {
        block20: {
            block23: {
                block21: {
                    block22: {
                        block19: {
                            block12: {
                                block13: {
                                    var17_6 = Orientation.b;
                                    var6_7 = var1_1.getFontMetrics();
                                    var7_8 = var6_7.getHeight();
                                    var8_9 = var2_2.getPlacement();
                                    v0 = var2_2;
                                    if (var17_6 != 0) break block12;
                                    if (!v0.isTicksVisible()) break block13;
                                    var9_10 = var2_2.getTicks();
                                    var10_11 = 0;
                                    while (var10_11 < var9_10.length) {
                                        block14: {
                                            block15: {
                                                block18: {
                                                    block16: {
                                                        block17: {
                                                            var11_13 = new Point2D.Double(0.0, var9_10[var10_11].getPosition());
                                                            var12_15 = this.calculatePixelPoint(var11_13, var3_3);
                                                            if (var17_6 != 0) break block14;
                                                            if (var12_15 == null) break block15;
                                                            var13_17 = var12_15.y;
                                                            if (var17_6 == 0) {
                                                                if (var2_2 == this.getYAxis() && this.o) {
                                                                    var1_1.setColor(this.A);
                                                                    var1_1.drawLine(this.r, var13_17, this.s, var13_17);
                                                                }
                                                                var1_1.setColor(this.z);
                                                            }
                                                            var14_18 = var9_10[var10_11].getLabel();
                                                            var1_1.setFont(this.C);
                                                            var15_20 = var6_7.stringWidth(var14_18);
                                                            var16_21 = var8_9 == AxisPlacement.LEADING ? -1 : 1;
                                                            var1_1.drawLine(var5_5, var13_17, var5_5 + this.v * var16_21, var13_17);
                                                            var1_1.setColor(this.B);
                                                            v1 = var8_9;
                                                            v2 = AxisPlacement.TRAILING;
                                                            if (var17_6 != 0) break block16;
                                                            if (v1 != v2) break block17;
                                                            this.drawStringIfWithinClip(var1_1, var14_18.toString(), var5_5 + this.v + 1, var13_17 + var6_7.getDescent());
                                                            if (var17_6 == 0) break block15;
                                                        }
                                                        v1 = var8_9;
                                                        v2 = AxisPlacement.LEADING;
                                                    }
                                                    if (v1 != v2) break block18;
                                                    this.drawStringIfWithinClip(var1_1, var14_18.toString(), var5_5 - var15_20 - this.v - 1, var13_17 + var6_7.getDescent());
                                                    if (var17_6 == 0) break block15;
                                                }
                                                this.drawStringIfWithinClip(var1_1, var14_18.toString(), var5_5 + this.v + 1, var13_17 + var6_7.getDescent());
                                            }
                                            ++var10_11;
                                        }
                                        if (var17_6 == 0) continue;
                                    }
                                }
                                v0 = var2_2;
                            }
                            v3 = var9_10 = v0.getLabel();
                            if (var17_6 != 0) break block19;
                            if (v3 == null) break block20;
                            v3 = var9_10;
                        }
                        var10_12 = v3.getRotation();
                        var11_14 = (int)Math.ceil((double)var7_8 / 2.0);
                        var12_16 = this.axisWidth(var2_2);
                        v4 = var8_9;
                        v5 = AxisPlacement.TRAILING;
                        if (var17_6 != 0) break block21;
                        if (v4 != v5) break block22;
                        v6 = var4_4.y;
                        v7 = var10_12;
                        if (var17_6 != 0) ** GOTO lbl68
                        if (v7 == null) {
                            v8 = Rotation.QUARTER_CLOCKWISE.doubleValue();
                        } else {
                            v7 = var10_12;
lbl68:
                            // 2 sources

                            v8 = v7;
                        }
                        var9_10.paint(var1_1, var5_5 + var12_16 - var11_14 - 2, v6, v8);
                        if (var17_6 == 0) break block20;
                    }
                    v4 = var8_9;
                    v5 = AxisPlacement.LEADING;
                }
                if (v4 != v5) break block23;
                v9 = var4_4.y;
                v10 = var10_12;
                if (var17_6 != 0) ** GOTO lbl83
                if (v10 == null) {
                    v11 = Rotation.QUARTER_ANTICLOCKWISE.doubleValue();
                } else {
                    v10 = var10_12;
lbl83:
                    // 2 sources

                    v11 = v10;
                }
                var9_10.paint(var1_1, var5_5 - var12_16 + var11_14 + 2, v9, v11);
                if (var17_6 == 0) break block20;
            }
            var13_17 = var6_7.stringWidth(var9_10.getLabel());
            var14_19 = 10;
            v12 = var5_5 - var7_8 / 2;
            v13 = this.u + var14_19 + var13_17 / 2;
            v14 = var10_12;
            if (var17_6 != 0) ** GOTO lbl97
            if (v14 == null) {
                v15 = Rotation.QUARTER_ANTICLOCKWISE.doubleValue();
            } else {
                v14 = var10_12;
lbl97:
                // 2 sources

                v15 = v14;
            }
            var9_10.paint(var1_1, v12, v13, v15);
        }
    }

    protected void drawStringIfWithinClip(Graphics graphics, String string, int n, int n2) {
        block4: {
            block2: {
                int n3;
                int n4;
                block6: {
                    int n5;
                    Rectangle rectangle;
                    int n6;
                    block5: {
                        int n7;
                        block3: {
                            n6 = Orientation.b;
                            rectangle = graphics.getClipBounds();
                            FontMetrics fontMetrics = graphics.getFontMetrics();
                            int n8 = fontMetrics.stringWidth(string);
                            n7 = fontMetrics.getAscent();
                            n5 = fontMetrics.getDescent();
                            if (rectangle == null) break block2;
                            n4 = n;
                            n3 = rectangle.x;
                            if (n6 != 0) break block3;
                            if (n4 < n3) break block4;
                            n4 = n + n8;
                            n3 = rectangle.x + rectangle.width;
                        }
                        if (n6 != 0) break block5;
                        if (n4 >= n3) break block4;
                        n4 = n2 - n7;
                        n3 = rectangle.y;
                    }
                    if (n6 != 0) break block6;
                    if (n4 < n3) break block4;
                    n4 = n2 + n5;
                    n3 = rectangle.y + rectangle.height;
                }
                if (n4 >= n3) break block4;
            }
            graphics.drawString(string, n, n2);
        }
    }

    protected void paintYAxis(Graphics2D graphics2D, Axis axis, int n) {
        graphics2D.setColor(this.y);
        graphics2D.drawLine(n, this.t, n, this.u);
    }

    protected void paintXAxis(Graphics2D graphics2D) {
        Axis axis = this.getYAxis();
        AxisRenderer axisRenderer = this.e.getAxisRenderer();
        Point2D.Double double_ = new Point2D.Double(this.e.midPoint(), axis.midPoint());
        Point point = this.calculatePixelPoint(double_);
        if (point != null) {
            int n = this.g();
            AutoPositionedLabel autoPositionedLabel = this.e.getLabel();
            if (Orientation.b == 0) {
                if (autoPositionedLabel != null) {
                    Point point2 = this.a(graphics2D);
                    autoPositionedLabel.paint((Graphics)graphics2D, point2.x, point2.y, Rotation.NONE);
                }
                graphics2D.setColor(this.y);
                graphics2D.drawLine(this.r, n, this.s, n);
            }
            int n2 = this.s - this.r;
            axisRenderer.renderAxis(graphics2D, this.r, n, n2, Orientation.horizontal);
        }
    }

    int g() {
        int n;
        block6: {
            block9: {
                AxisPlacement axisPlacement;
                AxisPlacement axisPlacement2;
                int n2;
                block7: {
                    AxisPlacement axisPlacement3;
                    block8: {
                        block4: {
                            block5: {
                                block3: {
                                    block2: {
                                        n2 = Orientation.b;
                                        axisPlacement2 = axisPlacement3 = this.e.getPlacement();
                                        if (n2 != 0) break block2;
                                        if (axisPlacement2 == null) break block3;
                                        axisPlacement2 = axisPlacement3;
                                    }
                                    axisPlacement = AxisPlacement.LEADING;
                                    if (n2 != 0) break block4;
                                    if (axisPlacement2 != axisPlacement) break block5;
                                }
                                n = this.t;
                                if (n2 == 0) break block6;
                            }
                            axisPlacement2 = axisPlacement3;
                            axisPlacement = AxisPlacement.CENTER;
                        }
                        if (n2 != 0) break block7;
                        if (axisPlacement2 != axisPlacement) break block8;
                        n = (this.t + this.u) / 2;
                        if (n2 == 0) break block6;
                    }
                    axisPlacement2 = axisPlacement3;
                    axisPlacement = AxisPlacement.FLOATING;
                }
                if (axisPlacement2 != axisPlacement) break block9;
                double d2 = this.e.getFloatingPosition();
                Point2D.Double double_ = new Point2D.Double(this.e.minimum(), d2);
                Point point = this.calculatePixelPoint(double_);
                n = point.y;
                if (n2 == 0) break block6;
            }
            n = this.u;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    Point a(Graphics var1_1) {
        block10: {
            block13: {
                block11: {
                    block12: {
                        block8: {
                            block9: {
                                var12_2 = Orientation.b;
                                var2_3 = var1_1.getFontMetrics();
                                var3_4 = this.getSize();
                                var4_5 = this.g();
                                var5_6 = var2_3.getHeight();
                                var7_7 = this.e.getLabel();
                                var8_8 = this.e.getPlacement();
                                var9_9 = new Point2D.Double(this.e.midPoint(), this.getYAxis().midPoint());
                                var10_10 = this.calculatePixelPoint(var9_9);
                                if (!Chart.V) {
                                    v0 = var7_7;
                                    if (var12_2 == 0) {
                                        if (v0 == null) {
                                            throw new AssertionError();
                                        } else {
                                            ** GOTO lbl-1000
                                        }
                                    }
                                } else lbl-1000:
                                // 3 sources

                                {
                                    v0 = var7_7;
                                }
                                var11_11 = v0.size(var1_1, var7_7.getFont());
                                v1 = var8_8;
                                v2 = AxisPlacement.LEADING;
                                if (var12_2 != 0) break block8;
                                if (v1 != v2) break block9;
                                var6_12 = new Point(var10_10.x, this.u - 2 * var5_6);
                                if (var12_2 == 0) break block10;
                            }
                            v1 = var8_8;
                            v2 = AxisPlacement.CENTER;
                        }
                        if (var12_2 != 0) break block11;
                        if (v1 != v2) break block12;
                        var6_12 = new Point(this.s - this.c() - var11_11.width / 2, var4_5 - var5_6 / 2);
                        if (var12_2 == 0) break block10;
                    }
                    v1 = var8_8;
                    v2 = AxisPlacement.FLOATING;
                }
                if (v1 != v2) break block13;
                var6_12 = new Point(this.s - this.c() - var11_11.width / 2, var4_5 - var5_6 / 2);
                if (var12_2 == 0) break block10;
            }
            var6_12 = new Point(var10_10.x, var3_4.height - 2);
        }
        return var6_12;
    }

    protected void paintXAxisTicks(Graphics2D graphics2D) {
        block12: {
            Axis axis;
            AxisPlacement axisPlacement;
            int n;
            FontMetrics fontMetrics;
            int n2;
            block11: {
                n2 = Orientation.b;
                graphics2D.setFont(this.C);
                fontMetrics = graphics2D.getFontMetrics();
                n = fontMetrics.getHeight();
                axisPlacement = this.e.getPlacement();
                axis = this.e;
                if (n2 != 0) break block11;
                if (!axis.isTicksVisible()) break block12;
                axis = this.e;
            }
            Tick[] tickArray = axis.getTicks();
            for (int i = 0; i < tickArray.length; ++i) {
                AxisPlacement axisPlacement2;
                AxisPlacement axisPlacement3;
                int n3;
                int n4;
                String string;
                int n5;
                Point2D.Double double_;
                block15: {
                    block16: {
                        block13: {
                            block14: {
                                Point point;
                                double_ = new Point2D.Double(tickArray[i].getPosition(), 0.0);
                                Point point2 = point = this.calculatePixelPoint(double_);
                                if (n2 == 0) {
                                    if (point2 == null) {
                                        throw new RuntimeException("Point should not be null");
                                    }
                                    point2 = point;
                                }
                                n5 = point2.x;
                                string = tickArray[i].getLabel();
                                n4 = fontMetrics.stringWidth(string);
                                int n6 = this.n;
                                if (n2 == 0) {
                                    if (n6 != 0) {
                                        graphics2D.setColor(this.A);
                                        graphics2D.drawLine(n5, this.t, n5, this.u);
                                    }
                                    graphics2D.setColor(this.z);
                                    n6 = n3 = this.e.getAxisRenderer().getBreadth();
                                }
                                if (n2 != 0) break block13;
                                if (axisPlacement == null) break block14;
                                axisPlacement3 = axisPlacement;
                                axisPlacement2 = AxisPlacement.LEADING;
                                if (n2 != 0) break block15;
                                if (axisPlacement3 != axisPlacement2) break block16;
                            }
                            graphics2D.drawLine(n5, this.t, n5, this.t + this.v);
                            graphics2D.setColor(this.B);
                            this.drawStringIfWithinClip(graphics2D, string, n5 - n4 / 2, this.t + n + n3);
                        }
                        if (n2 == 0) continue;
                    }
                    axisPlacement3 = axisPlacement;
                    axisPlacement2 = AxisPlacement.CENTER;
                }
                if (n2 == 0) {
                    if (axisPlacement3 == axisPlacement2) {
                        int n7 = (this.t + this.u) / 2;
                        graphics2D.drawLine(n5, n7, n5, n7 + this.v);
                        graphics2D.setColor(this.B);
                        this.drawStringIfWithinClip(graphics2D, string, n5 - n4 / 2, n7 + n + n3);
                        if (n2 == 0) continue;
                    }
                    axisPlacement3 = axisPlacement;
                    axisPlacement2 = AxisPlacement.FLOATING;
                }
                if (axisPlacement3 == axisPlacement2) {
                    double d2 = this.e.getFloatingPosition();
                    double_ = new Point2D.Double(this.e.minimum(), d2);
                    Point point = this.calculatePixelPoint(double_);
                    int n8 = point.y;
                    graphics2D.drawLine(n5, n8, n5, n8 + this.v);
                    graphics2D.setColor(this.B);
                    this.drawStringIfWithinClip(graphics2D, string, n5 - n4 / 2, n8 + n + n3);
                    if (n2 == 0) continue;
                }
                graphics2D.drawLine(n5, this.u, n5, this.u - this.v);
                graphics2D.setColor(this.B);
                this.drawStringIfWithinClip(graphics2D, string, n5 - n4 / 2, this.u - n / 2);
                if (n2 == 0) continue;
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void paintAxes(Graphics2D var1_1) {
        block20: {
            block29: {
                block30: {
                    var16_2 = Orientation.b;
                    var2_3 = this.getYAxis().getAxisRenderer();
                    var3_4 = 0;
                    var1_1.setColor(this.y);
                    this.paintXAxisTicks(var1_1);
                    var4_5 = (this.r + this.s) / 2;
                    var5_6 = this.r;
                    var6_7 = this.s;
                    for (Object var8_10 : this.f) {
                        block25: {
                            block28: {
                                block26: {
                                    block27: {
                                        block23: {
                                            block24: {
                                                block22: {
                                                    block21: {
                                                        var9_11 = this.axisWidth((Axis)var8_10);
                                                        var10_13 = var8_10.getPlacement();
                                                        if (var16_2 != 0) break block20;
                                                        v0 = var10_13;
                                                        if (var16_2 != 0) break block21;
                                                        if (v0 == null) break block22;
                                                        v0 = var10_13;
                                                    }
                                                    v1 = AxisPlacement.LEADING;
                                                    if (var16_2 != 0) break block23;
                                                    if (v0 != v1) break block24;
                                                }
                                                var11_15 = var5_6;
                                                var5_6 -= var9_11;
                                                if (var16_2 == 0) break block25;
                                            }
                                            v0 = var10_13;
                                            v1 = AxisPlacement.TRAILING;
                                        }
                                        if (var16_2 != 0) break block26;
                                        if (v0 != v1) break block27;
                                        var11_15 = var6_7;
                                        var6_7 += var9_11;
                                        if (var16_2 == 0) break block25;
                                    }
                                    v0 = var10_13;
                                    v1 = AxisPlacement.FLOATING;
                                }
                                if (v0 != v1) break block28;
                                var12_17 = var8_10.getFloatingPosition();
                                var14_21 /* !! */  = new Point2D.Double(var12_17, var8_10.midPoint());
                                var15_22 = this.calculatePixelPoint(var14_21 /* !! */ );
                                var11_15 = var15_22.x;
                                if (var16_2 == 0) break block25;
                            }
                            var11_15 = var4_5;
                        }
                        if (var8_10 == this.getYAxis()) {
                            var12_18 = this.t - this.getYEnd();
                            v2 = Chart.V;
                            if (var16_2 == 0) {
                                if (v2 == 0) {
                                    v2 = var12_18;
                                    if (var16_2 == 0) {
                                        if (v2 < 0) {
                                            throw new AssertionError();
                                        } else {
                                            ** GOTO lbl-1000
                                        }
                                    }
                                } else lbl-1000:
                                // 3 sources

                                {
                                    v2 = (int)((double)var12_18 * Chart.b);
                                }
                            }
                            var13_19 = v2;
                            var2_3.setBreadth(var13_19);
                            var11_15 -= var2_3.getBreadth();
                        }
                        this.paintYAxis(var1_1, (Axis)var8_10, var11_15);
                        var12_16 = new Point2D.Double(this.e.midPoint(), var8_10.midPoint());
                        if (var3_4 < this.q.size()) {
                            var13_20 = this.q.get(var3_4);
                            if (!Chart.V && var13_20 == null) {
                                throw new AssertionError();
                            }
                            var14_21 /* !! */  = this.calculatePixelPoint(var12_16, var13_20);
                            this.paintYAxisTicks(var1_1, (Axis)var8_10, var13_20, (Point)var14_21 /* !! */ , var11_15);
                        }
                        if (var8_10 == this.getYAxis()) {
                            var13_19 = this.t - this.getYEnd();
                            var2_3.renderAxis(var1_1, var11_15 + var2_3.getBreadth(), this.t, var13_19, Orientation.vertical);
                        }
                        ++var3_4;
                        if (var16_2 == 0) continue;
                    }
                    v3 = this;
                    if (var16_2 != 0) break block29;
                    if (v3.h == null) break block30;
                    v3 = this;
                    if (var16_2 != 0) break block29;
                    if (v3.m) {
                        var7_9 = this.getXStart() + this.getChartWidth() / 2;
                        var8_10 = this.h.getFont();
                        if (!Chart.V && var8_10 == null) {
                            throw new AssertionError();
                        }
                        var9_12 = var1_1.getFontMetrics((Font)var8_10);
                        var10_14 = var9_12.getHeight();
                        this.h.paint((Graphics)var1_1, var7_9, var10_14, Rotation.NONE);
                    }
                }
                v3 = this;
            }
            v3.paintXAxis(var1_1);
        }
    }

    public PointSelection nearestPoint(Point point, ChartModel chartModel) {
        int n = Orientation.b;
        UserToPixelTransform userToPixelTransform = this.getTransformForModel(chartModel);
        double d2 = Double.MAX_VALUE;
        Chartable chartable = null;
        int n2 = -1;
        int n3 = 0;
        for (Chartable chartable2 : chartModel) {
            Point2D.Double double_ = new Point2D.Double(chartable2.getX().position(), chartable2.getY().position());
            Point point2 = this.calculatePixelPoint(double_, userToPixelTransform);
            double d3 = point2.distanceSq(point.x, point.y);
            if (n == 0) {
                if (d3 < d2) {
                    d2 = d3;
                    chartable = chartable2;
                    n2 = n3;
                }
                ++n3;
            }
            if (n == 0) continue;
        }
        return new PointSelection(chartable, d2, n2);
    }

    public boolean isUserPointViewable(Point2D point2D, ChartModel chartModel) {
        UserToPixelTransform userToPixelTransform = this.getTransformForModel(chartModel);
        Point2D point2D2 = userToPixelTransform.transform(point2D);
        return this.isPixelPointViewable((int)point2D2.getX(), (int)point2D2.getY());
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPixelPointViewable(int var1_1, int var2_2) {
        block12: {
            block11: {
                block10: {
                    block9: {
                        var5_3 = Orientation.b;
                        v0 = var1_1;
                        v1 = this.getXEnd();
                        if (var5_3 != 0) break block9;
                        if (v0 > v1) ** GOTO lbl-1000
                        v0 = var1_1;
                        if (var5_3 != 0) break block10;
                        v1 = this.getXStart();
                    }
                    ** if (v0 < v1) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        v0 = true;
                        ** GOTO lbl15
                    }
lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                }
                var3_4 = v0;
                v2 = var2_2;
                v3 = this.getYStart();
                if (var5_3 != 0) break block11;
                if (v2 > v3) ** GOTO lbl-1000
                v2 = var2_2;
                if (var5_3 != 0) break block12;
                v3 = this.getYEnd();
            }
            ** if (v2 < v3) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                v2 = true;
                ** GOTO lbl30
            }
lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
        }
        var4_5 = v2;
        v4 = var3_4;
        if (var5_3 == 0) {
            if (v4 == false) return false;
            v4 = var4_5;
        }
        if (var5_3 != 0) return v4;
        if (v4 == false) return false;
        return true;
    }

    public Pair<Chartable, Double> nearestPoint(Point2D point2D, ChartModel chartModel) {
        int n = Orientation.b;
        Chartable chartable = null;
        Double d2 = null;
        for (Chartable chartable2 : chartModel) {
            block6: {
                Double d3;
                block3: {
                    double d4;
                    block5: {
                        double d5;
                        block4: {
                            d5 = Chart.distanceSq(point2D, chartable2);
                            d3 = d2;
                            if (n != 0) break block3;
                            if (d3 == null) break block4;
                            d4 = d5;
                            if (n != 0) break block5;
                            if (!(d4 < d2)) break block6;
                        }
                        d4 = d5;
                    }
                    d3 = d4;
                }
                d2 = d3;
                chartable = chartable2;
            }
            if (n == 0) continue;
        }
        return new Pair<Object, Object>(chartable, d2);
    }

    public static double distanceSq(Point2D point2D, Chartable chartable) {
        double d2 = chartable.getX().position();
        double d3 = chartable.getY().position();
        return point2D.distanceSq(d2, d3);
    }

    public static double distance(Point2D point2D, Chartable chartable) {
        double d2 = chartable.getX().position();
        double d3 = chartable.getY().position();
        return point2D.distance(d2, d3);
    }

    void a(Rectangle2D rectangle2D, Rectangle rectangle) {
        UserToPixelTransform userToPixelTransform = this.b(rectangle2D, rectangle);
        this.q.add(userToPixelTransform);
    }

    /*
     * Unable to fully structure code
     */
    private UserToPixelTransform b(Rectangle2D var1_1, Rectangle var2_2) {
        var9_3 = Orientation.b;
        var3_4 = this.getXAxis().isFlipped();
        v0 = this.e.isFlipped();
        if (var9_3 == 0) {
            v0 = v0 != 0 ? -1 : 1;
        }
        var4_5 = v0;
        v1 = var5_6 = this.getYAxis().isFlipped();
        if (var9_3 == 0) {
            v1 = v1 != 0 ? -1 : 1;
        }
        var6_7 = v1;
        var7_8 = new AffineTransform();
        v2 = var3_4;
        if (var9_3 != 0) ** GOTO lbl18
        if (v2 != 0) {
            v3 = var2_2.x + var2_2.width;
        } else {
            v2 = var2_2.x;
lbl18:
            // 2 sources

            v3 = v2;
        }
        v4 = var2_2.y;
        v5 = var5_6;
        if (var9_3 == 0) {
            v5 = v5 != 0 ? 0 : var2_2.height;
        }
        var7_8.translate(v3, v4 + v5);
        var7_8.scale((double)(var4_5 * var2_2.width) / var1_1.getWidth(), (double)(-1 * var6_7 * var2_2.height) / var1_1.getHeight());
        var7_8.translate(-var1_1.getX(), -var1_1.getY());
        var8_9 = new UserToPixelTransform(var7_8);
        var8_9.setXTransform(this.e.getAxisTransform());
        var8_9.setYTransform(this.getYAxis().getAxisTransform());
        return var8_9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point calculatePixelPoint(Point2D point2D) {
        Chart chart = this;
        synchronized (chart) {
            block8: {
                Point2D point2D2;
                UserToPixelTransform userToPixelTransform;
                block7: {
                    UserToPixelTransform userToPixelTransform2;
                    userToPixelTransform = userToPixelTransform2 = this.getUserToPixelTransform();
                    if (Orientation.b != 0) break block7;
                    if (userToPixelTransform == null) break block8;
                    userToPixelTransform = userToPixelTransform2;
                }
                if ((point2D2 = userToPixelTransform.transform(point2D)) == null) {
                    return null;
                }
                return new Point((int)point2D2.getX(), (int)point2D2.getY());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point calculatePixelPoint(Point2D point2D, UserToPixelTransform userToPixelTransform) {
        Chart chart = this;
        synchronized (chart) {
            block8: {
                Point2D point2D2;
                UserToPixelTransform userToPixelTransform2;
                block7: {
                    userToPixelTransform2 = userToPixelTransform;
                    if (Orientation.b != 0) break block7;
                    if (userToPixelTransform2 == null) break block8;
                    userToPixelTransform2 = userToPixelTransform;
                }
                if ((point2D2 = userToPixelTransform2.transform(point2D)) == null) {
                    return null;
                }
                return new Point((int)point2D2.getX(), (int)point2D2.getY());
            }
            return null;
        }
    }

    public Point2D calculateUserPoint(Point point) {
        if (!V && point == null) {
            throw new AssertionError();
        }
        Point2D point2D = new Point2D.Double();
        try {
            UserToPixelTransform userToPixelTransform = this.getUserToPixelTransform();
            point2D = userToPixelTransform.inverseTransform(point);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
        return point2D;
    }

    private void h() {
        Rectangle rectangle = new Rectangle(this.getXStart(), this.getYEnd(), Math.abs(this.getXEnd() - this.getXStart()), Math.abs(this.getYStart() - this.getYEnd()));
        this.q.clear();
        for (Axis axis : this.f) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(this.e.getOutputRange().minimum(), axis.getOutputRange().minimum(), this.e.getOutputRange().size(), axis.getOutputRange().size());
            this.a(double_, rectangle);
            if (Orientation.b == 0) continue;
        }
    }

    Map<String, UserToPixelTransform> i() {
        int n = Orientation.b;
        HashMap<String, UserToPixelTransform> hashMap = new HashMap<String, UserToPixelTransform>();
        for (ChartModel chartModel : this.L) {
            Axis axis = this.getModelAxis(chartModel);
            if (axis != null) {
                UserToPixelTransform userToPixelTransform;
                UserToPixelTransform userToPixelTransform2 = userToPixelTransform = this.getTransformForAxis(axis);
                if (n == 0 && userToPixelTransform2 != null) {
                    userToPixelTransform2 = hashMap.put(chartModel.getName(), userToPixelTransform);
                }
            }
            if (n == 0) continue;
        }
        return hashMap;
    }

    public Point2D calculateRealPoint(Point point) {
        this.h();
        return this.calculateUserPoint(point);
    }

    void a(Graphics2D graphics2D, ChartModel chartModel, int n, UserToPixelTransform userToPixelTransform) {
        int n2 = this.getXStart();
        int n3 = 0;
        graphics2D.translate(-n2, n3);
        this.N.drawChart(graphics2D, this, chartModel, n, userToPixelTransform, true);
        graphics2D.translate(n2, -n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintModels(Graphics2D graphics2D, Shape shape, Shape shape2) {
        int n = Orientation.b;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        List<ChartModel> list = this.L;
        synchronized (list) {
            for (int i = 0; i < this.L.size(); ++i) {
                ChartModel chartModel = this.L.get(i);
                Axis axis = this.getAxisForModel(chartModel);
                UserToPixelTransform userToPixelTransform = this.getTransformForAxis(axis);
                graphics2D.setClip(shape2);
                this.N.drawChart(graphics2D, this, chartModel, i, userToPixelTransform, false);
                Stroke stroke = graphics2D.getStroke();
                this.O.drawChart(graphics2D, this, chartModel, i, userToPixelTransform, false);
                graphics2D.setStroke(stroke);
                this.P.drawChart(graphics2D, this, chartModel, i, userToPixelTransform, false);
                graphics2D.setClip(shape2);
                if (n == 0) {
                    if (n == 0) continue;
                }
                break;
            }
            return;
        }
    }

    void b(Graphics2D graphics2D, ChartModel chartModel, int n, UserToPixelTransform userToPixelTransform) {
        int n2 = this.getXStart();
        int n3 = 0;
        graphics2D.translate(-n2, n3);
        this.P.drawChart(graphics2D, this, chartModel, n, userToPixelTransform, true);
        graphics2D.translate(n2, -n3);
    }

    protected UserToPixelTransform getTransformForAxis(Axis axis) {
        int n;
        int n2;
        block7: {
            Axis axis2;
            block6: {
                n2 = Orientation.b;
                axis2 = axis;
                if (n2 != 0) break block6;
                if (axis2 != null) break block7;
                axis2 = this.getYAxis();
            }
            axis = axis2;
        }
        int n3 = n = this.f.indexOf(axis);
        if (n2 == 0) {
            if (n3 < 0) {
                n = 0;
            }
            n3 = n;
        }
        if (n3 < this.q.size()) {
            return this.q.get(n);
        }
        return null;
    }

    protected void paintAnnotation(Graphics graphics, ChartLabel chartLabel) {
        block4: {
            Double d2;
            Point point;
            block6: {
                Double d3;
                block5: {
                    LabelStyle labelStyle;
                    int n;
                    block2: {
                        LabelStyle labelStyle2;
                        block3: {
                            n = Orientation.b;
                            Color color = chartLabel.getColor();
                            Font font = chartLabel.getFont();
                            graphics.setColor(color);
                            graphics.setFont(font);
                            point = this.calculatePixelPoint(new Point2D.Double(chartLabel.getX().position(), chartLabel.getY().position()));
                            labelStyle = labelStyle2 = chartLabel.getLabelStyle();
                            if (n != 0) break block2;
                            if (labelStyle != null) break block3;
                            graphics.drawString(chartLabel.getLabel(), point.x, point.y);
                            if (n == 0) break block4;
                        }
                        labelStyle = labelStyle2;
                    }
                    d3 = d2 = labelStyle.getRotation();
                    if (n != 0) break block5;
                    if (d3 != null) break block6;
                    d3 = 0.0;
                }
                d2 = d3;
            }
            chartLabel.paint(graphics, point.x, point.y, d2);
        }
    }

    protected void paintAnnotation(Graphics2D graphics2D, ChartImage chartImage) {
        Point point = this.calculatePixelPoint(new Point2D.Double(chartImage.getXMin().position(), chartImage.getYMax().position()));
        Point point2 = this.calculatePixelPoint(new Point2D.Double(chartImage.getXMax().position(), chartImage.getYMin().position()));
        graphics2D.drawImage(chartImage.getImage(), point.x, point.y, point2.x - point.x, point2.y - point.y, this);
    }

    /*
     * Unable to fully structure code
     */
    protected void paintAnnotations(Graphics2D var1_1) {
        var7_2 = Orientation.b;
        var2_3 = this.L.iterator();
        block0: while (true) {
            v0 = var2_3.hasNext();
            block1: while (v0) {
                block13: {
                    v1 = var3_4 = var2_3.next();
                    if (var7_2 != 0) break block13;
                    v2 = v1 instanceof AnnotatedChartModel;
                    if (var7_2 != 0) ** GOTO lbl31
                    if (!v2) continue block0;
                    v1 = var3_4;
                }
                var4_5 = (AnnotatedChartModel)v1;
                v3 = var4_5.isAnnotationsVisible();
                if (var7_2 == 0) {
                    if (v3 == 0) continue block0;
                    v3 = var5_6 = 0;
                }
                while (var5_6 < var4_5.getAnnotationCount()) {
                    var6_7 = var4_5.getAnnotation(var5_6);
                    if (var7_2 == 0) {
                        v0 = var6_7 instanceof ChartImage;
                        if (var7_2 != 0) continue block1;
                        if (v0) {
                            this.paintAnnotation(var1_1, (ChartImage)var6_7);
                        }
                        ++var5_6;
                    }
                    if (var7_2 == 0) continue;
                }
                if (var7_2 == 0) continue block0;
            }
            break;
        }
        var2_3 = this.L.iterator();
        block3: while (true) {
            v2 = var2_3.hasNext();
            block4: while (v2) {
                v4 = var3_4 = var2_3.next();
                if (var7_2 == 0) {
                    if (!(v4 instanceof AnnotatedChartModel)) continue block3;
                    v4 = var3_4;
                }
                var4_5 = (AnnotatedChartModel)v4;
                v5 = var4_5.isAnnotationsVisible();
                if (var7_2 == 0) {
                    if (!v5) continue block3;
                    v5 = false;
                }
                var5_6 = (int)v5;
                while (var5_6 < var4_5.getAnnotationCount()) {
                    var6_7 = var4_5.getAnnotation(var5_6);
                    if (var7_2 == 0) {
                        v2 = var6_7 instanceof ChartLabel;
                        if (var7_2 != 0) continue block4;
                        if (v2) {
                            this.paintAnnotation((Graphics)var1_1, (ChartLabel)var6_7);
                        }
                        ++var5_6;
                    }
                    if (var7_2 == 0) continue;
                }
                if (var7_2 == 0) continue block3;
            }
            break;
        }
    }

    void c(Graphics2D graphics2D, ChartModel chartModel, int n, UserToPixelTransform userToPixelTransform) {
        int n2 = this.getXStart();
        int n3 = 0;
        graphics2D.translate(-n2, n3);
        this.O.drawChart(graphics2D, this, chartModel, n, userToPixelTransform, true);
        graphics2D.translate(n2, -n3);
    }

    /*
     * Unable to fully structure code
     */
    public int hashCode() {
        var2_1 = 1;
        v0 = this.h;
        if (Orientation.b != 0) ** GOTO lbl8
        if (v0 == null) {
            v1 = 0;
        } else {
            v0 = this.h;
lbl8:
            // 2 sources

            v1 = v0.hashCode();
        }
        var2_1 = 31 * var2_1 + v1;
        return var2_1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        int n = Orientation.b;
        Object object2 = this;
        if (n == 0) {
            if (object2 == object) {
                return true;
            }
            object2 = object;
        }
        if (object2 == null) {
            return false;
        }
        Object object3 = this.getClass();
        if (n == 0) {
            if (object3 != object.getClass()) {
                return false;
            }
            object3 = object;
        }
        Chart chart = (Chart)object3;
        AbstractLabel abstractLabel = this.h;
        if (n == 0) {
            if (abstractLabel == null) {
                if (chart.h == null) return true;
                return false;
            }
            abstractLabel = this.h;
        }
        boolean bl = abstractLabel.equals(chart.h);
        if (n != 0) return bl;
        if (bl) return true;
        return false;
    }

    static {
        boolean bl = V = !Chart.class.desiredAssertionStatus();
        if (!com.jidesoft.utils.W.a(4096)) {
            Lm.showInvalidProductMessage(Chart.class.getName(), 4096);
        }
        a = Logger.getLogger(Chart.class.getName());
        MIN_LEFT_MARGIN = 0;
        MIN_RIGHT_MARGIN = 0;
        MIN_TOP_MARGIN = 0;
        MIN_BOTTOM_MARGIN = 0;
        b = 0.05;
    }
}

