/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.jasper.runtime.TagHandlerPool;

public class PerThreadTagHandlerPool
extends TagHandlerPool {
    public static int MAX_SIZE = 100;
    private int maxSize = MAX_SIZE;
    private int initialSize = 5;
    private ThreadLocal perThread = new ThreadLocal();
    private Hashtable threadData = new Hashtable();

    public PerThreadTagHandlerPool() {
    }

    protected void init(Servlet servlet) {
        String maxSizeS = TagHandlerPool.getOption(servlet.getServletConfig(), TagHandlerPool.OPTION_MAXSIZE, null);
        this.maxSize = Integer.parseInt(maxSizeS);
        if (this.maxSize < 0) {
            this.maxSize = MAX_SIZE;
        }
    }

    public PerThreadTagHandlerPool(int capacity) {
        this.maxSize = capacity;
    }

    public Tag get(Class handlerClass) throws JspException {
        PerThreadData ptd = (PerThreadData)this.perThread.get();
        if (ptd != null && ptd.current >= 0) {
            return ptd.handlers[ptd.current--];
        }
        try {
            return (Tag)handlerClass.newInstance();
        }
        catch (Exception e) {
            throw new JspException(e.getMessage(), (Throwable)e);
        }
    }

    public void reuse(Tag handler) {
        PerThreadData ptd = (PerThreadData)this.perThread.get();
        if (ptd == null) {
            ptd = new PerThreadData();
            ptd.handlers = new Tag[this.initialSize];
            ptd.current = 0;
            this.threadData.put(ptd, ptd);
        }
        if (ptd.current < ptd.handlers.length - 1) {
            ptd.handlers[++ptd.current] = handler;
            return;
        }
        if (ptd.handlers.length < this.maxSize) {
            Tag[] newH = new Tag[ptd.handlers.length + this.initialSize];
            System.arraycopy(ptd.handlers, 0, newH, 0, ptd.handlers.length);
            ptd.handlers = newH;
            ptd.handlers[++ptd.current] = handler;
            return;
        }
        handler.release();
    }

    public synchronized void release() {
        Enumeration ptdE = this.threadData.keys();
        while (ptdE.hasMoreElements()) {
            PerThreadData ptd = (PerThreadData)ptdE.nextElement();
            int i = ptd.current;
            while (i >= 0) {
                if (ptd.handlers != null && ptd.handlers[i] != null) {
                    ptd.handlers[i].release();
                }
                --i;
            }
        }
    }

    private static class PerThreadData {
        Tag[] handlers;
        int current;

        private PerThreadData() {
        }
    }
}

