/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.jasper.runtime.JspWriterImpl;

public class BodyContentImpl
extends BodyContent {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private char[] cb;
    private int nextChar;
    private boolean closed;
    private Writer writer;
    private int bufferSizeSave;

    public BodyContentImpl(JspWriter enclosingWriter) {
        super(enclosingWriter);
        this.bufferSize = 512;
        this.cb = new char[this.bufferSize];
        this.nextChar = 0;
        this.closed = false;
    }

    public void write(int c) throws IOException {
        if (this.writer != null) {
            this.writer.write(c);
        } else {
            this.ensureOpen();
            if (this.nextChar >= this.bufferSize) {
                this.reAllocBuff(0);
            }
            this.cb[this.nextChar++] = (char)c;
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.writer != null) {
            this.writer.write(cbuf, off, len);
        } else {
            this.ensureOpen();
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (len >= this.bufferSize - this.nextChar) {
                this.reAllocBuff(len);
            }
            System.arraycopy(cbuf, off, this.cb, this.nextChar, len);
            this.nextChar += len;
        }
    }

    public void write(char[] buf) throws IOException {
        if (this.writer != null) {
            this.writer.write(buf);
        } else {
            this.write(buf, 0, buf.length);
        }
    }

    public void write(String s, int off, int len) throws IOException {
        if (this.writer != null) {
            this.writer.write(s, off, len);
        } else {
            this.ensureOpen();
            if (len >= this.bufferSize - this.nextChar) {
                this.reAllocBuff(len);
            }
            s.getChars(off, off + len, this.cb, this.nextChar);
            this.nextChar += len;
        }
    }

    public void write(String s) throws IOException {
        if (this.writer != null) {
            this.writer.write(s);
        } else {
            this.write(s, 0, s.length());
        }
    }

    public void newLine() throws IOException {
        if (this.writer != null) {
            this.writer.write(LINE_SEPARATOR);
        } else {
            this.write(LINE_SEPARATOR);
        }
    }

    public void print(boolean b) throws IOException {
        if (this.writer != null) {
            this.writer.write(b ? "true" : "false");
        } else {
            this.write(b ? "true" : "false");
        }
    }

    public void print(char c) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(c));
        } else {
            this.write(String.valueOf(c));
        }
    }

    public void print(int i) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(i));
        } else {
            this.write(String.valueOf(i));
        }
    }

    public void print(long l) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(l));
        } else {
            this.write(String.valueOf(l));
        }
    }

    public void print(float f) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(f));
        } else {
            this.write(String.valueOf(f));
        }
    }

    public void print(double d) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(d));
        } else {
            this.write(String.valueOf(d));
        }
    }

    public void print(char[] s) throws IOException {
        if (this.writer != null) {
            this.writer.write(s);
        } else {
            this.write(s);
        }
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        if (this.writer != null) {
            this.writer.write(s);
        } else {
            this.write(s);
        }
    }

    public void print(Object obj) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(obj));
        } else {
            this.write(String.valueOf(obj));
        }
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(char x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(int x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(long x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(float x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(double x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(char[] x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(String x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(Object x) throws IOException {
        this.print(x);
        this.println();
    }

    public void clear() throws IOException {
        if (this.writer != null) {
            throw new IOException();
        }
        this.nextChar = 0;
    }

    public void clearBuffer() throws IOException {
        if (this.writer == null) {
            this.clear();
        }
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else {
            this.cb = null;
            this.closed = true;
        }
    }

    public int getRemaining() {
        return this.writer == null ? this.bufferSize - this.nextChar : 0;
    }

    public Reader getReader() {
        return this.writer == null ? new CharArrayReader(this.cb, 0, this.nextChar) : null;
    }

    public String getString() {
        return this.writer == null ? new String(this.cb, 0, this.nextChar) : null;
    }

    public void writeOut(Writer out) throws IOException {
        if (this.writer == null) {
            out.write(this.cb, 0, this.nextChar);
        }
    }

    public static void main(String[] args) throws Exception {
        char[] buff = new char[]{'f', 'o', 'o', 'b', 'a', 'r', 'b', 'a', 'z', 'y'};
        BodyContentImpl bodyContent = new BodyContentImpl(new JspWriterImpl(null, 100, false));
        bodyContent.println(buff);
        System.out.println(bodyContent.getString());
        bodyContent.writeOut(new PrintWriter(System.out));
    }

    void setWriter(Writer writer) {
        this.writer = writer;
        if (writer != null) {
            if (this.bufferSize != 0) {
                this.bufferSizeSave = this.bufferSize;
                this.bufferSize = 0;
            }
        } else {
            this.bufferSize = this.bufferSizeSave;
            this.clearBody();
        }
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    private void reAllocBuff(int len) {
        if (this.bufferSize + len <= this.cb.length) {
            this.bufferSize = this.cb.length;
            return;
        }
        if (len < 512) {
            len = 512;
        }
        this.bufferSize = this.cb.length + len;
        char[] tmp = new char[this.bufferSize];
        System.arraycopy(this.cb, 0, tmp, 0, this.cb.length);
        this.cb = tmp;
        Object var2_2 = null;
    }
}

