/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.oracle.aq;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.config.DestinationConfig;
import hermes.ext.HermesAdminSupport;
import hermes.ext.oracle.aq.AQTopicBrowser;
import hermes.ext.oracle.aq.HermesShutdownHook;
import hermes.impl.ConfigDAOImpl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.QueueBrowser;
import oracle.AQ.AQAgent;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleSession;
import oracle.AQ.AQQueue;
import oracle.jms.AQjmsSession;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AQAdmin
extends HermesAdminSupport
implements HermesAdmin {
    public static final String VERSION_STR = "$Header: /cvs/Integration/dev-tools/rib-aq-hermes-impl/src/hermes/ext/oracle/aq/AQAdmin.java,v 1.1 2009/02/06 03:00:17 polavap Exp $";
    private AQjmsSession session;
    private Hermes hermes;
    HermesShutdownHook shutdownHook;
    private static final Logger LOG = Logger.getLogger(AQAdmin.class);

    protected AQAdmin(Hermes hermes, AQjmsSession session) {
        super(hermes);
        this.session = session;
        this.shutdownHook = new HermesShutdownHook(hermes);
        LOG.debug((Object)("Creating a new Shutdown hook " + this.shutdownHook));
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public int getDepth(DestinationConfig destConfig) {
        return 0;
    }

    public void close() {
    }

    public Collection<DestinationConfig> discoverDestinationConfigs() throws JMSException {
        ArrayList<DestinationConfig> rval = new ArrayList<DestinationConfig>();
        Connection conn = null;
        try {
            conn = this.session.getDBConnection();
            String query = "SELECT T1.NAME FROM ALL_QUEUES T1,  ALL_QUEUE_TABLES T2 WHERE  T1.QUEUE_TABLE = T2.QUEUE_TABLE  AND T1.OWNER = T2.OWNER AND T1.OWNER = '" + conn.getMetaData().getUserName() + "' AND T1.NAME NOT LIKE 'AQ$%'";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                String tableName = rs.getString(1);
                LOG.debug((Object)("Fetching Topic information " + tableName));
                ConfigDAOImpl configDao = new ConfigDAOImpl();
                DestinationConfig dc = configDao.createDestinationConfig(tableName, Domain.TOPIC);
                dc.setDurable(Boolean.valueOf(false));
                dc.setName(tableName);
                dc.setShortName(tableName);
                String hostname = InetAddress.getLocalHost().getHostName();
                hostname = hostname.replace('-', '_');
                String subName = System.getProperty("user.name") + "_" + hostname + "_Hermes";
                if (subName.length() > 30) {
                    subName = subName.substring(0, 30);
                }
                dc.setClientID(subName);
                rval.add(dc);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            String msg = "SQL Exception encountered , check log (hermes.log) for more details ";
            LOG.error((Object)"SQL Exception encountered , check log (hermes.log) for more details ", (Throwable)e);
            throw new JMSException("SQL Exception encountered , check log (hermes.log) for more details " + e.getMessage());
        }
        catch (UnknownHostException e) {
            String msg = "UnknownHostException encountered , check log (hermes.log) for more details ";
            LOG.error((Object)"UnknownHostException encountered , check log (hermes.log) for more details ", (Throwable)e);
            throw new JMSException("UnknownHostException encountered , check log (hermes.log) for more details " + e.getMessage());
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                String msg = "Could not close database connection ";
                LOG.error((Object)("Could not close database connection " + conn), (Throwable)e);
                throw new JMSException("Could not close database connection  " + e.getMessage());
            }
        }
        return rval;
    }

    public Map<String, String> getStatistics(DestinationConfig destination) {
        HashMap<String, String> map = new HashMap<String, String>();
        Connection conn = null;
        try {
            conn = this.session.getDBConnection();
            LOG.debug((Object)("Getting all the subscribers for topic " + destination.getName()));
            List<String> list = this.getSubscribers(destination);
            for (String subscriberName : list) {
                map.put(subscriberName, String.valueOf(this.getSubscriberMessagesCount(destination.getName(), subscriberName)));
            }
        }
        catch (AQException e) {
            String msg = "AQ Exception encountered";
            LOG.error((Object)"AQ Exception encountered", (Throwable)e);
            map.put("AQ Exception encountered, check logs ", e.getMessage());
            throw new RuntimeException("AQ Exception encountered");
        }
        catch (SQLException e) {
            String msg = "SQL Exception encountered , check log (hermes.log) for more details ";
            LOG.error((Object)"SQL Exception encountered , check log (hermes.log) for more details ", (Throwable)e);
            throw new RuntimeException("SQL Exception encountered , check log (hermes.log) for more details ");
        }
        catch (JMSException e) {
            String msg = "JMS Exception encountered ";
            LOG.error((Object)"JMS Exception encountered ", (Throwable)e);
            map.put("JMS Exception encountered, check logs ", e.getMessage());
            throw new RuntimeException("JMS Exception encountered ");
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ignore) {}
        }
        return map;
    }

    private long getSubscriberMessagesCount(String topicName, String subscriberName) throws SQLException, JMSException {
        Connection conn = this.session.getDBConnection();
        String query = "SELECT T1.QUEUE_TABLE FROM ALL_QUEUES T1,  ALL_QUEUE_TABLES T2  WHERE T1.QUEUE_TABLE = T2.QUEUE_TABLE  AND T1.OWNER = T2.OWNER AND T1.OWNER = '" + conn.getMetaData().getUserName() + "' AND T1.NAME='" + topicName.toUpperCase() + "'";
        LOG.debug((Object)("Executing query " + query));
        long count = 0L;
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        if (rs.next()) {
            String tableName = rs.getString(1);
            String query1 = "SELECT COUNT(*) FROM AQ$" + tableName + " WHERE CONSUMER_NAME='" + subscriberName + "'";
            LOG.debug((Object)("Executing query " + query1));
            Statement stmt1 = conn.createStatement();
            ResultSet rs1 = stmt1.executeQuery(query1);
            if (rs1.next()) {
                count = rs1.getLong(1);
            }
            rs1.close();
            stmt1.close();
        }
        rs.close();
        stmt.close();
        return count;
    }

    private List<String> getSubscribers(DestinationConfig destination) throws AQException, SQLException, JMSException {
        AQAgent[] subscribers;
        Connection conn = this.session.getDBConnection();
        ArrayList<String> list = new ArrayList<String>();
        AQOracleSession aqSession = new AQOracleSession(conn);
        AQQueue queue = aqSession.getQueue(conn.getMetaData().getUserName(), destination.getName());
        if (queue != null && (subscribers = queue.getSubscribers()) != null) {
            for (int index = 0; index < subscribers.length; ++index) {
                list.add(subscribers[index].getName());
            }
        }
        queue.close();
        aqSession.close();
        return list;
    }

    public QueueBrowser createDurableSubscriptionBrowser(DestinationConfig dConfig) throws JMSException {
        LOG.debug((Object)("Creating a new AQ topic browser for " + dConfig.getName()));
        this.shutdownHook.addSubscriber(dConfig);
        return new AQTopicBrowser(this.getHermes().getSession(), this.getHermes().getDestinationManager(), dConfig, this.shutdownHook);
    }
}

