/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.swingx.EnumerationValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanInfoSupport
extends SimpleBeanInfo {
    private static Logger LOG = Logger.getLogger(BeanInfoSupport.class.getName());
    private static Map<Class<?>, Boolean> introspectingState = new HashMap();
    private Class<?> beanClass;
    private int defaultPropertyIndex = -1;
    private int defaultEventIndex = -1;
    private Image iconColor16 = null;
    private Image iconColor32 = null;
    private Image iconMono16 = null;
    private Image iconMono32 = null;
    private String iconNameC16 = null;
    private String iconNameC32 = null;
    private String iconNameM16 = null;
    private String iconNameM32 = null;
    private BeanDescriptor beanDescriptor;
    private Map<String, PropertyDescriptor> properties = new TreeMap<String, PropertyDescriptor>();
    private Map<String, EventSetDescriptor> events = new TreeMap<String, EventSetDescriptor>();
    private Map<String, MethodDescriptor> methods = new TreeMap<String, MethodDescriptor>();

    public BeanInfoSupport(Class<?> clazz) {
        this.beanClass = clazz;
        Boolean bl = introspectingState.get(clazz);
        if (!this.isIntrospecting()) {
            introspectingState.put(clazz, Boolean.TRUE);
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                this.beanDescriptor = beanInfo.getBeanDescriptor();
                if (this.beanDescriptor != null) {
                    FeatureDescriptor[] featureDescriptorArray = this.getCustomizerClass();
                    this.beanDescriptor = new BeanDescriptor(this.beanDescriptor.getBeanClass(), (Class<?>)(featureDescriptorArray == null ? this.beanDescriptor.getCustomizerClass() : featureDescriptorArray));
                } else {
                    this.beanDescriptor = new BeanDescriptor(clazz, this.getCustomizerClass());
                }
                for (PropertyDescriptor featureDescriptor : beanInfo.getPropertyDescriptors()) {
                    this.properties.put(featureDescriptor.getName(), featureDescriptor);
                }
                for (FeatureDescriptor featureDescriptor : beanInfo.getEventSetDescriptors()) {
                    this.events.put(featureDescriptor.getName(), (EventSetDescriptor)featureDescriptor);
                }
                for (FeatureDescriptor featureDescriptor : beanInfo.getMethodDescriptors()) {
                    this.methods.put(featureDescriptor.getName(), (MethodDescriptor)featureDescriptor);
                }
                this.defaultPropertyIndex = beanInfo.getDefaultPropertyIndex();
                this.defaultEventIndex = beanInfo.getDefaultEventIndex();
                this.iconColor16 = this.loadStandardImage(beanInfo, 1);
                this.iconColor32 = this.loadStandardImage(beanInfo, 2);
                this.iconMono16 = this.loadStandardImage(beanInfo, 3);
                this.iconMono32 = this.loadStandardImage(beanInfo, 4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            introspectingState.put(clazz, Boolean.FALSE);
            this.initialize();
        }
    }

    private boolean isIntrospecting() {
        Boolean bl = introspectingState.get(this.beanClass);
        return bl == null ? false : bl;
    }

    private Image loadStandardImage(BeanInfo beanInfo, int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "16";
                break;
            }
            case 2: {
                string = "32";
                break;
            }
            case 3: {
                string = "16-mono";
                break;
            }
            case 4: {
                string = "32-mono";
            }
        }
        String string2 = this.beanClass.getSimpleName() + string + ".png";
        Image image = null;
        try {
            image = this.loadImage("resources/" + string2);
        }
        catch (Exception exception) {
            LOG.info("No icon named " + string2 + " was found");
        }
        return image;
    }

    protected abstract void initialize();

    protected Class<?> getCustomizerClass() {
        return null;
    }

    protected void setSmallColorIconName(String string) {
        this.iconNameC16 = string;
    }

    protected void setColorIconName(String string) {
        this.iconNameC32 = string;
    }

    protected void setSmallMonoIconName(String string) {
        this.iconNameM16 = string;
    }

    protected void setMonoIconName(String string) {
        this.iconNameM32 = string;
    }

    protected void setDisplayName(String string, String string2) {
        PropertyDescriptor propertyDescriptor = this.properties.get(string2);
        if (propertyDescriptor != null) {
            propertyDescriptor.setDisplayName(string);
        } else {
            LOG.log(Level.WARNING, "Failed to set display name for property '" + string2 + "'. No such property was found");
        }
    }

    protected void setHidden(boolean bl, String ... stringArray) {
        for (String string : stringArray) {
            PropertyDescriptor propertyDescriptor = this.properties.get(string);
            if (propertyDescriptor != null) {
                propertyDescriptor.setHidden(bl);
                continue;
            }
            LOG.log(Level.WARNING, "Failed to set hidden attribute for property '" + string + "'. No such property was found");
        }
    }

    protected void setExpert(boolean bl, String ... stringArray) {
        for (String string : stringArray) {
            PropertyDescriptor propertyDescriptor = this.properties.get(string);
            if (propertyDescriptor != null) {
                propertyDescriptor.setExpert(bl);
                continue;
            }
            LOG.log(Level.WARNING, "Failed to set expert attribute for property '" + string + "'. No such property was found");
        }
    }

    protected void setPreferred(boolean bl, String ... stringArray) {
        for (String string : stringArray) {
            PropertyDescriptor propertyDescriptor = this.properties.get(string);
            if (propertyDescriptor != null) {
                propertyDescriptor.setPreferred(bl);
                continue;
            }
            LOG.log(Level.WARNING, "Failed to set preferred attribute for property '" + string + "'. No such property was found");
        }
    }

    protected void setBound(boolean bl, String ... stringArray) {
        for (String string : stringArray) {
            PropertyDescriptor propertyDescriptor = this.properties.get(string);
            if (propertyDescriptor != null) {
                propertyDescriptor.setBound(bl);
                continue;
            }
            LOG.log(Level.WARNING, "Failed to set bound attribute for property '" + string + "'. No such property was found");
        }
    }

    protected void setConstrained(boolean bl, String ... stringArray) {
        for (String string : stringArray) {
            PropertyDescriptor propertyDescriptor = this.properties.get(string);
            if (propertyDescriptor != null) {
                propertyDescriptor.setConstrained(bl);
                continue;
            }
            LOG.log(Level.WARNING, "Failed to set constrained attribute for property '" + string + "'. No such property was found");
        }
    }

    protected void setCategory(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            PropertyDescriptor propertyDescriptor = this.properties.get(string2);
            if (propertyDescriptor != null) {
                propertyDescriptor.setValue("category", string);
                continue;
            }
            LOG.log(Level.WARNING, "Failed to set category for property '" + string2 + "'. No such property was found");
        }
    }

    protected void setPropertyEditor(Class<?> clazz, String ... stringArray) {
        for (String string : stringArray) {
            PropertyDescriptor propertyDescriptor = this.properties.get(string);
            if (propertyDescriptor != null) {
                propertyDescriptor.setPropertyEditorClass(clazz);
                continue;
            }
            LOG.log(Level.WARNING, "Failed to set property editor for property '" + string + "'. No such property was found");
        }
    }

    protected void setEnumerationValues(EnumerationValue[] enumerationValueArray, String ... stringArray) {
        if (enumerationValueArray == null) {
            return;
        }
        Object[] objectArray = new Object[enumerationValueArray.length * 3];
        int n = 0;
        for (EnumerationValue object : enumerationValueArray) {
            objectArray[n++] = object.getName();
            objectArray[n++] = object.getValue();
            objectArray[n++] = object.getJavaInitializationString();
        }
        for (String string : stringArray) {
            PropertyDescriptor propertyDescriptor = this.properties.get(string);
            if (propertyDescriptor != null) {
                propertyDescriptor.setValue("enumerationValues", objectArray);
                continue;
            }
            LOG.log(Level.WARNING, "Failed to set enumeration values for property '" + (String)string + "'. No such property was found");
        }
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.isIntrospecting() ? null : this.beanDescriptor;
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.isIntrospecting() ? null : this.properties.values().toArray(new PropertyDescriptor[0]);
    }

    @Override
    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.isIntrospecting() ? null : this.events.values().toArray(new EventSetDescriptor[0]);
    }

    @Override
    public MethodDescriptor[] getMethodDescriptors() {
        return this.isIntrospecting() ? null : this.methods.values().toArray(new MethodDescriptor[0]);
    }

    @Override
    public int getDefaultPropertyIndex() {
        return this.isIntrospecting() ? -1 : this.defaultPropertyIndex;
    }

    @Override
    public int getDefaultEventIndex() {
        return this.isIntrospecting() ? -1 : this.defaultEventIndex;
    }

    @Override
    public Image getIcon(int n) {
        switch (n) {
            case 1: {
                return this.getImage(this.iconNameC16, this.iconColor16);
            }
            case 2: {
                return this.getImage(this.iconNameC32, this.iconColor32);
            }
            case 3: {
                return this.getImage(this.iconNameM16, this.iconMono16);
            }
            case 4: {
                return this.getImage(this.iconNameM32, this.iconMono32);
            }
        }
        return null;
    }

    private Image getImage(String string, Image image) {
        if (image == null && string != null) {
            image = this.loadImage(string);
        }
        return image;
    }
}

