/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.analytics;

import com.eviware.soapui.analytics.ActionDescription;
import com.eviware.soapui.analytics.AnalyticsProvider;
import com.eviware.soapui.analytics.AnalyticsProviderFactory;
import com.eviware.soapui.analytics.OSUserDescription;
import com.eviware.soapui.analytics.UserInfoProvider;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticsManager {
    private static final Logger log = Logger.getLogger(AnalyticsManager.class);
    private static AnalyticsManager instance = null;
    private List<AnalyticsProvider> providers = new ArrayList<AnalyticsProvider>();
    private String sessionId;
    private List<AnalyticsProviderFactory> factories = new ArrayList<AnalyticsProviderFactory>();
    private Executor executorService;

    private AnalyticsManager() {
        String startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        this.sessionId = AnalyticsManager.makeUserId() + ":" + startTime;
    }

    static AnalyticsManager getInstance() {
        if (instance == null) {
            instance = new AnalyticsManager();
        }
        return instance;
    }

    public void setExecutorService(Executor executorService) {
        this.executorService = executorService;
    }

    boolean trackAction(String actionName) {
        return this.trackAction(Category.ACTION, actionName, null);
    }

    void trackAction(String action, Map<String, String> params) {
        this.trackAction(Category.ACTION, action, params);
    }

    boolean trackOSUser(String name, String email) {
        if (this.providers.isEmpty()) {
            return false;
        }
        final OSUserDescription description = new OSUserDescription(name, email);
        this.runInBackground(new Runnable(){

            public void run() {
                for (AnalyticsProvider provider : AnalyticsManager.this.providers) {
                    if (!(provider instanceof UserInfoProvider)) continue;
                    UserInfoProvider userProvider = (UserInfoProvider)((Object)provider);
                    userProvider.trackUserInfo(description);
                }
            }
        });
        return true;
    }

    void trackError(final Throwable error) {
        if (this.providers.isEmpty()) {
            return;
        }
        this.runInBackground(new Runnable(){

            public void run() {
                for (AnalyticsProvider provider : AnalyticsManager.this.providers) {
                    provider.trackError(error);
                }
            }
        });
    }

    void trackLicenseData(String actionName, Map<String, String> parameterMap) {
        this.trackAction(Category.LICENSE_UPDATE, actionName, parameterMap);
    }

    boolean trackCustomPlugInAction(String actionName, Map<String, String> parameterMap) {
        return this.trackAction(Category.CUSTOM_PLUGIN_ACTION, actionName, parameterMap);
    }

    public boolean trackSessionStart() {
        return this.trackAction(Category.SESSION_START, "", null);
    }

    public boolean trackSessionStop() {
        return this.trackAction(Category.SESSION_STOP, "", null);
    }

    public void registerAnalyticsProviderFactory(AnalyticsProviderFactory factory) {
        this.factories.add(factory);
        this.registerActiveProvider(factory.allocateProvider(), false);
    }

    public boolean selectAnalyticsProvider(String name, boolean keepTheOnlyOne) {
        for (AnalyticsProviderFactory factory : this.factories) {
            if (factory.getName().compareToIgnoreCase(name) != 0) continue;
            this.registerActiveProvider(factory.allocateProvider(), keepTheOnlyOne);
            return true;
        }
        if (keepTheOnlyOne) {
            this.providers.clear();
        }
        return false;
    }

    public void clearProviders() {
        this.providers.clear();
    }

    protected void registerActiveProvider(AnalyticsProvider provider, boolean keepTheOnlyOne) {
        if (keepTheOnlyOne) {
            this.providers.clear();
        }
        this.providers.add(provider);
    }

    private static String makeUserId() {
        try {
            NetworkInterface network = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            byte[] mac = network.getHardwareAddress();
            MessageDigest hasher = MessageDigest.getInstance("SHA-1");
            return AnalyticsManager.createHexBinary(hasher.digest(mac));
        }
        catch (Exception e) {
            log.warn((Object)"Error generating Analytics session ID - returning empty String", (Throwable)e);
            return "";
        }
    }

    private static String createHexBinary(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    private boolean trackAction(Category category, String actionName, Map<String, String> params) {
        if (this.providers.isEmpty()) {
            return false;
        }
        final ActionDescription description = new ActionDescription(this.sessionId, category, actionName, params);
        this.runInBackground(new Runnable(){

            public void run() {
                for (AnalyticsProvider provider : AnalyticsManager.this.providers) {
                    provider.trackAction(description);
                }
            }
        });
        return this.providers.size() > 0;
    }

    private void runInBackground(Runnable runnable) {
        if (this.executorService != null) {
            this.executorService.execute(runnable);
        } else {
            new Thread(runnable).start();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Category {
        SESSION_START,
        SESSION_STOP,
        ACTION,
        CUSTOM_PLUGIN_ACTION,
        LICENSE_UPDATE;

    }
}

