/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.jrockit.jfr.DCmdException;
import oracle.jrockit.jfr.FlightRecorder;
import oracle.jrockit.jfr.Recording;
import oracle.jrockit.jfr.VMJFR;

class DCmd {
    protected static final String JFC_LOCATION = "JRE_HOME/lib/jfr";
    protected final VMJFR jfr;
    protected final FlightRecorder jfrMBean;
    private final StringWriter result;
    private final PrintWriter log;

    public DCmd(VMJFR vMJFR) {
        this.jfr = vMJFR;
        this.result = new StringWriter();
        this.log = new PrintWriter(this.result);
        this.jfrMBean = this.jfr.getMBean();
    }

    public final String getResult() {
        return this.result.toString();
    }

    protected final String formatException(Exception exception) {
        return exception.getClass().getSimpleName() + ": " + exception.getMessage();
    }

    protected final Recording findRecording(RecordingIdentifier recordingIdentifier) throws DCmdException {
        for (Recording recording : this.getRecordings()) {
            if (!recordingIdentifier.match(recording)) continue;
            return recording;
        }
        throw new DCmdException("Could not find %s.\n\nUse JFR.check without options to see list of all available recordings.", recordingIdentifier);
    }

    protected final List<Recording> getRecordings() {
        ArrayList<Recording> arrayList = new ArrayList<Recording>(this.jfr.getRecordings());
        Collections.sort(arrayList, new Comparator<Recording>(){

            @Override
            public int compare(Recording recording, Recording recording2) {
                Long l = recording.getId();
                Long l2 = recording2.getId();
                return l.compareTo(l2);
            }
        });
        return arrayList;
    }

    protected final void writeToDisk(Recording recording, String string, boolean bl, RecordingIdentifier recordingIdentifier) throws DCmdException {
        try {
            long l = recording.copyTo(string, bl);
            this.printBytes(l, " ");
            if (bl) {
                this.print(" (before compresssion) ");
            }
            this.println(" written to:", new Object[0]);
            this.println();
            this.printPath(string);
        }
        catch (IOException iOException) {
            throw new DCmdException(iOException, "Could not write %s to file %s. (%s)", recordingIdentifier, string, this.formatException(iOException));
        }
    }

    protected static String quoteIfNeeded(String string) {
        if (string.contains(" ")) {
            return "\\\"" + string + "\\\"";
        }
        return string;
    }

    protected final void println() {
        this.log.println();
    }

    protected final void print(String string) {
        this.log.print(string);
    }

    protected final void print(String string, Object ... objectArray) {
        this.log.printf(string, objectArray);
    }

    protected final void println(String string, Object ... objectArray) {
        this.print(string, objectArray);
        this.println();
    }

    protected final void printBytes(long l, String string) {
        if (l < 1024L) {
            this.print(l + " bytes");
            return;
        }
        int n = (int)(Math.log(l) / Math.log(1024.0));
        char c = "kMGTPE".charAt(n - 1);
        this.print("%.1f%s%cB", (double)l / Math.pow(1024.0, n), string, Character.valueOf(c));
    }

    protected final void printTimespan(long l, String string) {
        Unit unit = Unit.NANOSECONDS;
        Unit[] unitArray = Unit.values();
        int n = unitArray.length;
        for (int i = 0; i < n; ++i) {
            Unit unit2;
            unit = unit2 = unitArray[i];
            long l2 = unit2.amount;
            if (unit == Unit.DAYS || l < l2 || l % l2 != 0L) break;
            l /= l2;
        }
        this.print("%d%s%s", l, string, unit.text);
    }

    protected final void printPath(String string) {
        try {
            this.println(new File(string).getCanonicalPath(), new Object[0]);
        }
        catch (IOException | SecurityException exception) {
            this.println(string, new Object[0]);
        }
    }

    protected static final class RecordingIdentifier {
        static final long INVALID_ID = -1L;
        private final String name;
        private final long id;

        private RecordingIdentifier(String string, long l) {
            this.name = string;
            this.id = l;
        }

        static final RecordingIdentifier createValid(String string, long l) throws DCmdException {
            if (l == -1L && string == null) {
                throw new DCmdException("Must provide either name or recording.", new Object[0]);
            }
            if (l != -1L && string != null) {
                throw new DCmdException("Use either name or recording, not both.", new Object[0]);
            }
            return new RecordingIdentifier(string, l);
        }

        boolean match(Recording recording) {
            if (this.id != -1L) {
                return recording.getId() == this.id;
            }
            return this.name != null && this.name.equals(recording.getName());
        }

        public String toString() {
            return "recording " + (this.id == -1L ? "\"" + this.name + "\"" : Long.valueOf(this.id));
        }
    }

    private static enum Unit {
        NANOSECONDS("ns", 1000L),
        MICROSECONDS("us", 1000L),
        MILLISECONDS("ms", 1000L),
        SECONDS("s", 60L),
        MINUTES("m", 60L),
        HOURS("h", 24L),
        DAYS("d", 7L);

        private final String text;
        private final long amount;

        private Unit(String string2, long l) {
            this.text = string2;
            this.amount = l;
        }
    }
}

