/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.test.validator.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLFileAccessor {
    private Document doc;

    public XMLFileAccessor(String url) throws ValidatorException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.parse(url);
        }
        catch (Exception e) {
            throw new ValidatorException(e);
        }
    }

    public String getTextChildOfSingleNode(String namespace, String tag) throws ValidatorException {
        NodeList parentList = this.doc.getElementsByTagNameNS(namespace, tag);
        if (parentList.getLength() != 1) {
            return null;
        }
        Node parentNode = parentList.item(0);
        NodeList childrenList = parentNode.getChildNodes();
        if (childrenList.getLength() > 1) {
            throw new ValidatorException("XML file is invalid");
        }
        if (childrenList.getLength() == 0) {
            return "";
        }
        CharacterData textNode = (CharacterData)childrenList.item(0);
        return textNode.getData().trim();
    }

    public List<Element> getAttributesForElement(String namespace, String element, String attribute) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList elements = this.doc.getElementsByTagNameNS(namespace, element);
        int i = 0;
        while (i < elements.getLength()) {
            Element el = (Element)elements.item(i);
            result.add(el);
            ++i;
        }
        return result;
    }

    public List<Element> getElementsByName(String namespace, String tag) {
        NodeList elementNL = this.doc.getElementsByTagNameNS(namespace, tag);
        ArrayList<Element> result = new ArrayList<Element>();
        int i = 0;
        while (i < elementNL.getLength()) {
            result.add((Element)elementNL.item(i));
            ++i;
        }
        return result;
    }
}

