/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.validate;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureTrustValidator
implements Validator {
    private static final Log LOG = LogFactory.getLog(SignatureTrustValidator.class);

    @Override
    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        boolean trust;
        if (credential == null) {
            throw new WSSecurityException(0, "noCredential");
        }
        X509Certificate[] certs = credential.getCertificates();
        PublicKey publicKey = credential.getPublicKey();
        Crypto crypto = this.getCrypto(data);
        if (crypto == null) {
            throw new WSSecurityException(0, "noSigCryptoFile");
        }
        if (certs != null && certs.length > 0) {
            this.validateCertificates(certs);
            trust = false;
            boolean enableRevocation = data.isRevocationEnabled();
            trust = certs.length == 1 ? this.verifyTrustInCert(certs[0], crypto, data, enableRevocation) : this.verifyTrustInCerts(certs, crypto, data, enableRevocation);
            if (trust) {
                return credential;
            }
        }
        if (publicKey != null && (trust = this.validatePublicKey(publicKey, crypto))) {
            return credential;
        }
        throw new WSSecurityException(5);
    }

    protected Crypto getCrypto(RequestData data) {
        return data.getSigCrypto();
    }

    protected void validateCertificates(X509Certificate[] certificates) throws WSSecurityException {
        try {
            for (int i = 0; i < certificates.length; ++i) {
                certificates[i].checkValidity();
            }
        }
        catch (CertificateExpiredException e) {
            throw new WSSecurityException(6, "invalidCert", null, e);
        }
        catch (CertificateNotYetValidException e) {
            throw new WSSecurityException(6, "invalidCert", null, e);
        }
    }

    @Deprecated
    protected boolean verifyTrustInCert(X509Certificate cert, Crypto crypto) throws WSSecurityException {
        return this.verifyTrustInCert(cert, crypto, new RequestData(), false);
    }

    @Deprecated
    protected boolean verifyTrustInCert(X509Certificate cert, Crypto crypto, boolean enableRevocation) throws WSSecurityException {
        return this.verifyTrustInCert(cert, crypto, new RequestData(), enableRevocation);
    }

    protected boolean verifyTrustInCert(X509Certificate cert, Crypto crypto, RequestData data, boolean enableRevocation) throws WSSecurityException {
        if (cert == null) {
            return false;
        }
        String subjectString = cert.getSubjectX500Principal().getName();
        if (crypto.verifyTrust(new X509Certificate[]{cert}, enableRevocation)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Certificate path has been verified for certificate with subject " + subjectString));
            }
            if (this.isCertificateInKeyStore(crypto, cert)) {
                return true;
            }
            Collection<Pattern> subjectCertConstraints = data.getSubjectCertConstraints();
            if (this.matches(cert, subjectCertConstraints)) {
                return true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Certificate path could not be verified for certificate with subject " + subjectString));
        }
        return false;
    }

    @Deprecated
    protected boolean isCertificateInKeyStore(Crypto crypto, X509Certificate cert) throws WSSecurityException {
        String issuerString = cert.getIssuerX500Principal().getName();
        BigInteger issuerSerial = cert.getSerialNumber();
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ISSUER_SERIAL);
        cryptoType.setIssuerSerial(issuerString, issuerSerial);
        X509Certificate[] foundCerts = crypto.getX509Certificates(cryptoType);
        if (foundCerts != null && foundCerts[0] != null && foundCerts[0].equals(cert)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Direct trust for certificate with " + cert.getSubjectX500Principal().getName()));
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("No certificate found for subject from issuer with " + issuerString + " (serial " + issuerSerial + ")"));
        }
        return false;
    }

    @Deprecated
    protected boolean verifyTrustInCerts(X509Certificate[] certificates, Crypto crypto) throws WSSecurityException {
        return this.verifyTrustInCerts(certificates, crypto, new RequestData(), false);
    }

    @Deprecated
    protected boolean verifyTrustInCerts(X509Certificate[] certificates, Crypto crypto, boolean enableRevocation) throws WSSecurityException {
        return this.verifyTrustInCerts(certificates, crypto, new RequestData(), enableRevocation);
    }

    protected boolean verifyTrustInCerts(X509Certificate[] certificates, Crypto crypto, RequestData data, boolean enableRevocation) throws WSSecurityException {
        if (certificates == null || certificates.length < 2) {
            return false;
        }
        String subjectString = certificates[0].getSubjectX500Principal().getName();
        if (crypto.verifyTrust(certificates, enableRevocation)) {
            Collection<Pattern> subjectCertConstraints;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Certificate path has been verified for certificate with subject " + subjectString));
            }
            if (this.matches(certificates[0], subjectCertConstraints = data.getSubjectCertConstraints())) {
                return true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Certificate path could not be verified for certificate with subject " + subjectString));
        }
        return false;
    }

    protected boolean validatePublicKey(PublicKey publicKey, Crypto crypto) throws WSSecurityException {
        return crypto.verifyTrust(publicKey);
    }

    protected boolean matches(X509Certificate cert, Collection<Pattern> subjectDNPatterns) {
        if (subjectDNPatterns.isEmpty()) {
            LOG.warn((Object)"No Subject DN Certificate Constraints were defined. This could be a security issue");
        }
        if (!subjectDNPatterns.isEmpty()) {
            if (cert == null) {
                LOG.debug((Object)"The certificate is null so no constraints matching was possible");
                return false;
            }
            String subjectName = cert.getSubjectX500Principal().getName();
            boolean subjectMatch = false;
            for (Pattern subjectDNPattern : subjectDNPatterns) {
                Matcher matcher = subjectDNPattern.matcher(subjectName);
                if (!matcher.matches()) continue;
                LOG.debug((Object)("Subject DN " + subjectName + " matches with pattern " + subjectDNPattern));
                subjectMatch = true;
                break;
            }
            if (!subjectMatch) {
                return false;
            }
        }
        return true;
    }
}

