/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.jbossmq;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesException;
import hermes.JNDIConnectionFactory;
import hermes.browser.HermesBrowser;
import hermes.config.DestinationConfig;
import hermes.ext.HermesAdminSupport;
import hermes.ext.jbossmq.JBossMQAdminFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.log4j.Logger;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyConnectionFactory;

public class JBossMQAdmin
extends HermesAdminSupport
implements HermesAdmin {
    private static final Logger log = Logger.getLogger(JBossMQAdmin.class);
    private JNDIConnectionFactory jndiCF;
    private SpyConnectionFactory spyCF;
    private RMIAdaptor rmiAdaptor;
    private JBossMQAdminFactory factory;

    public JBossMQAdmin(JBossMQAdminFactory factory, Hermes hermes, JNDIConnectionFactory jndiCF, ConnectionFactory spyCF) throws JMSException {
        super(hermes);
        this.jndiCF = jndiCF;
        this.spyCF = (SpyConnectionFactory)spyCF;
        this.factory = factory;
        if (factory.getRmiAdaptorBinding() == null) {
            throw new HermesException("You must set rmiAdaptorBinding in the Admin Factory ");
        }
    }

    private RMIAdaptor getRMIAdapter() throws NamingException, JMSException {
        if (this.rmiAdaptor == null) {
            Context ctx = this.jndiCF.createContext();
            this.rmiAdaptor = (RMIAdaptor)ctx.lookup(this.factory.getRmiAdaptorBinding());
        }
        return this.rmiAdaptor;
    }

    public int getDepth(DestinationConfig dConfig) throws JMSException {
        ObjectName objectName = null;
        try {
            if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
                objectName = new ObjectName("jboss.mq.destination:name=" + this.getRealDestinationName(dConfig) + ",service=Queue");
                return Integer.parseInt(this.getRMIAdapter().getAttribute(objectName, "QueueDepth").toString());
            }
            if (dConfig.isDurable()) {
                throw new HermesException("JBoss does not support depth of a durable subscription");
            }
            return 0;
        }
        catch (HermesException ex) {
            throw ex;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.rmiAdaptor = null;
            throw new HermesException(e);
        }
    }

    public void close() throws JMSException {
    }

    public Map getStatistics(DestinationConfig dConfig) throws JMSException {
        LinkedHashMap<String, Object> stats = new LinkedHashMap<String, Object>();
        ObjectName objectName = null;
        try {
            if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
                objectName = new ObjectName("jboss.mq.destination:name=" + this.getRealDestinationName(dConfig) + ",service=Queue");
                try {
                    stats.put("QueueName", this.getRMIAdapter().getAttribute(objectName, "QueueName"));
                }
                catch (JMSException ex) {
                    log.error((Object)"Unable to get QueueName property", (Throwable)ex);
                }
                try {
                    stats.put("ScheduledMessageCount", this.getRMIAdapter().getAttribute(objectName, "ScheduledMessageCount"));
                }
                catch (JMSException ex) {
                    log.error((Object)"Unable to get ScheduledMessageCount property", (Throwable)ex);
                }
                try {
                    stats.put("ReceiversCount", this.getRMIAdapter().getAttribute(objectName, "ReceiversCount"));
                }
                catch (JMSException ex) {
                    log.error((Object)"Unable to get ReceiversCount property", (Throwable)ex);
                }
            } else {
                objectName = new ObjectName("jboss.mq.destination:name=" + this.getRealDestinationName(dConfig) + ",service=Topic");
                try {
                    stats.put("TopicName", this.getRMIAdapter().getAttribute(objectName, "TopicName"));
                }
                catch (JMSException ex) {
                    log.error((Object)"Unable to get TopicName property", (Throwable)ex);
                }
            }
            try {
                stats.put("StateString", this.getRMIAdapter().getAttribute(objectName, "StateString"));
            }
            catch (JMSException ex) {
                log.error((Object)"Unable to get StateString property", (Throwable)ex);
            }
            try {
                stats.put("State", this.getRMIAdapter().getAttribute(objectName, "State"));
            }
            catch (JMSException ex) {
                log.error((Object)"Unable to get State property", (Throwable)ex);
            }
        }
        catch (Exception e) {
            throw new HermesException(e);
        }
        return stats;
    }

    protected Collection discoverDurableSubscriptions(String topicName, String jndiName) throws JMSException {
        ArrayList<DestinationConfig> rval = new ArrayList<DestinationConfig>();
        try {
            ObjectName objectName = new ObjectName("jboss.mq.destination:name=" + topicName + ",service=Topic");
            Collection durableSubs = (Collection)this.getRMIAdapter().invoke(objectName, "listDurableSubscriptions", (Object[])new String[0], new String[0]);
            for (DurableSubscriptionID id : durableSubs) {
                if (this.getHermes().getConnection().getClientID() != null && this.getHermes().getConnection().getClientID().equals(id.getClientID())) {
                    DestinationConfig dConfig = HermesBrowser.getConfigDAO().createDestinationConfig();
                    dConfig.setClientID(id.getSubscriptionName());
                    dConfig.setName(jndiName == null ? topicName : jndiName);
                    dConfig.setDomain(Integer.valueOf(Domain.TOPIC.getId()));
                    dConfig.setSelector(id.getSelector());
                    dConfig.setDurable(Boolean.valueOf(true));
                    rval.add(dConfig);
                    continue;
                }
                log.debug((Object)("skipping subscription name=" + id.getSubscriptionName() + " as its not for this connection clientID"));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return rval;
    }

    public int truncate(DestinationConfig dConfig) throws JMSException {
        int rval = this.getDepth(dConfig);
        try {
            if (dConfig.getDomain().intValue() != Domain.QUEUE.getId()) {
                throw new HermesException("JBoss does not support truncating a durable subscription");
            }
            ObjectName objectName = new ObjectName("jboss.mq.destination:name=" + this.getRealDestinationName(dConfig) + ",service=Queue");
            this.getRMIAdapter().invoke(objectName, "removeAllMessages", (Object[])new String[0], new String[0]);
        }
        catch (HermesException ex) {
            throw ex;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.rmiAdaptor = null;
            throw new HermesException(e);
        }
        return rval;
    }

    public QueueBrowser createDurableSubscriptionBrowser(final DestinationConfig dConfig) throws JMSException {
        try {
            String[] signature;
            Object[] params;
            ObjectName objectName = new ObjectName("jboss.mq.destination:name=" + this.getRealDestinationName(dConfig) + ",service=Topic");
            if (dConfig.getSelector() == null) {
                params = new String[]{this.getHermes().getConnection().getClientID(), dConfig.getClientID()};
                signature = new String[]{String.class.getName(), String.class.getName()};
            } else {
                params = new String[]{this.getHermes().getConnection().getClientID(), dConfig.getClientID(), dConfig.getSelector()};
                signature = new String[]{String.class.getName(), String.class.getName(), String.class.getName()};
            }
            final Collection messages = (Collection)this.getRMIAdapter().invoke(objectName, "listDurableMessages", params, signature);
            return new QueueBrowser(){

                public void close() throws JMSException {
                }

                public Enumeration getEnumeration() throws JMSException {
                    return new IteratorEnumeration(messages.iterator());
                }

                public String getMessageSelector() throws JMSException {
                    return dConfig.getSelector();
                }

                public Queue getQueue() throws JMSException {
                    return null;
                }
            };
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new HermesException(e);
        }
    }
}

