/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import sun.tools.jstat.Operator;

public class Expression {
    private static int nextOrdinal;
    private boolean debug = Boolean.getBoolean("Expression.debug");
    private Expression left;
    private Expression right;
    private Operator operator;
    private int ordinal = nextOrdinal++;

    Expression() {
        if (this.debug) {
            System.out.println("Expression " + this.ordinal + " created");
        }
    }

    void setLeft(Expression expression) {
        if (this.debug) {
            System.out.println("Setting left on " + this.ordinal + " to " + expression);
        }
        this.left = expression;
    }

    Expression getLeft() {
        return this.left;
    }

    void setRight(Expression expression) {
        if (this.debug) {
            System.out.println("Setting right on " + this.ordinal + " to " + expression);
        }
        this.right = expression;
    }

    Expression getRight() {
        return this.right;
    }

    void setOperator(Operator operator) {
        if (this.debug) {
            System.out.println("Setting operator on " + this.ordinal + " to " + operator);
        }
        this.operator = operator;
    }

    Operator getOperator() {
        return this.operator;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        if (this.left != null) {
            stringBuilder.append(this.left.toString());
        }
        if (this.operator != null) {
            stringBuilder.append(this.operator.toString());
            if (this.right != null) {
                stringBuilder.append(this.right.toString());
            }
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

