/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.LayoutCharacters;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Position;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class Log
implements LayoutCharacters {
    protected static final Context.Key<Log> logKey = new Context.Key();
    public static final Context.Key<PrintWriter> outKey = new Context.Key();
    public final PrintWriter errWriter;
    public final PrintWriter warnWriter;
    public final PrintWriter noticeWriter;
    private final int MaxErrors;
    private final int MaxWarnings;
    public boolean promptOnError;
    public boolean emitWarnings;
    public boolean dumpOnError;
    private Name sourcename;
    public int nerrors = 0;
    public int nwarnings = 0;
    private Set<Pair<Name, Integer>> recorded = new HashSet<Pair<Name, Integer>>();
    private byte[] buf = null;
    private int bp;
    private int lastLine;
    private static final String compilerRB = "com.sun.tools.javac.resources.compiler";
    private static ResourceBundle messageRB;

    protected Log(Context context, PrintWriter printWriter, PrintWriter printWriter2, PrintWriter printWriter3) {
        context.put(logKey, this);
        this.errWriter = printWriter;
        this.warnWriter = printWriter2;
        this.noticeWriter = printWriter3;
        Options options = Options.instance(context);
        this.dumpOnError = options.get("-doe") != null;
        this.promptOnError = options.get("-prompt") != null;
        this.emitWarnings = options.get("-nowarn") == null;
        this.sourcename = Name.Table.instance((Context)context).__input;
        this.MaxErrors = this.getIntOption(options, "-Xmaxerrs", 100);
        this.MaxWarnings = this.getIntOption(options, "-Xmaxwarns", 100);
    }

    private int getIntOption(Options options, String string, int n) {
        String string2 = (String)options.get(string);
        try {
            if (string2 != null) {
                return Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    static final PrintWriter defaultWriter(Context context) {
        PrintWriter printWriter = context.get(outKey);
        if (printWriter == null) {
            printWriter = new PrintWriter(System.err);
            context.put(outKey, printWriter);
        }
        return printWriter;
    }

    protected Log(Context context) {
        this(context, Log.defaultWriter(context));
    }

    protected Log(Context context, PrintWriter printWriter) {
        this(context, printWriter, printWriter, printWriter);
    }

    public static Log instance(Context context) {
        Log log = context.get(logKey);
        if (log == null) {
            log = new Log(context);
        }
        return log;
    }

    public Name useSource(Name name) {
        Name name2 = this.sourcename;
        this.sourcename = name;
        if (name2 != this.sourcename) {
            this.buf = null;
        }
        return name2;
    }

    public Name currentSource() {
        return this.sourcename;
    }

    public void flush() {
        this.errWriter.flush();
        this.warnWriter.flush();
        this.noticeWriter.flush();
    }

    public void prompt() {
        if (this.promptOnError) {
            System.err.println(Log.getLocalizedString("resume.abort", new Object[0]));
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new AssertionError((Object)"user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printErrLine(int n, int n2, PrintWriter printWriter) {
        try {
            int n3;
            if (this.buf == null) {
                FileInputStream fileInputStream = new FileInputStream(this.sourcename.toString());
                this.buf = new byte[fileInputStream.available()];
                fileInputStream.read(this.buf);
                fileInputStream.close();
                this.bp = 0;
                this.lastLine = 1;
            } else if (this.lastLine > n) {
                this.bp = 0;
                this.lastLine = 1;
            }
            block9: while (this.bp < this.buf.length && this.lastLine < n) {
                switch (this.buf[this.bp]) {
                    case 13: {
                        ++this.bp;
                        if (this.bp < this.buf.length && this.buf[this.bp] == 10) {
                            ++this.bp;
                        }
                        ++this.lastLine;
                        continue block9;
                    }
                    case 10: {
                        ++this.bp;
                        ++this.lastLine;
                        continue block9;
                    }
                }
                ++this.bp;
            }
            for (n3 = this.bp; n3 < this.buf.length && this.buf[n3] != 13 && this.buf[n3] != 10; ++n3) {
            }
            Log.printLines(printWriter, new String(this.buf, this.bp, n3 - this.bp));
            if (n2 == 0) {
                n2 = 1;
            }
            byte[] byArray = new byte[n2];
            for (int i = 0; i < n2 - 1; ++i) {
                byArray[i] = 32;
            }
            byArray[n2 - 1] = 94;
            Log.printLines(printWriter, new String(byArray, 0, n2));
        }
        catch (IOException iOException) {
            Log.printLines(this.errWriter, Log.getLocalizedString("source.unavailable", new Object[0]));
        }
        finally {
            this.errWriter.flush();
        }
    }

    public static void printLines(PrintWriter printWriter, String string) {
        int n;
        while ((n = string.indexOf(10)) != -1) {
            printWriter.println(string.substring(0, n));
            string = string.substring(n + 1);
        }
        if (string.length() != 0) {
            printWriter.println(string);
        }
    }

    private void printDiagnostic(int n, String string, PrintWriter printWriter) {
        if (n == 0) {
            Log.printLines(printWriter, string);
        } else {
            int n2 = Position.line(n);
            int n3 = Position.column(n);
            Log.printLines(printWriter, this.sourcename + ":" + n2 + ": " + string);
            this.printErrLine(n2, n3, printWriter);
        }
        if (this.dumpOnError) {
            new RuntimeException().printStackTrace(printWriter);
        }
        printWriter.flush();
    }

    public void error(int n, String string, Object ... objectArray) {
        Pair<Name, Integer> pair;
        if (this.nerrors < this.MaxErrors && !this.recorded.contains(pair = new Pair<Name, Integer>(this.sourcename, n))) {
            this.recorded.add(pair);
            this.printDiagnostic(n, (n == 0 ? Log.getText("compiler.err.error", new Object[0]) : "") + Log.getText("compiler.err." + string, objectArray), this.errWriter);
            this.prompt();
            ++this.nerrors;
        }
    }

    public void warning(int n, String string, Object ... objectArray) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.printDiagnostic(n, Log.getText("compiler.warn.warning", new Object[0]) + Log.getText("compiler.warn." + string, objectArray), this.warnWriter);
            this.prompt();
            ++this.nwarnings;
        }
    }

    public void note(String string, Object ... objectArray) {
        if (this.emitWarnings) {
            this.noticeWriter.print(Log.getText("compiler.note.note", new Object[0]));
            String string2 = Log.getText("compiler.note." + string, objectArray);
            Log.printLines(this.noticeWriter, string2);
            this.noticeWriter.flush();
        }
    }

    public static String getLocalizedString(String string, Object ... objectArray) {
        return Log.getText("compiler.misc." + string, objectArray);
    }

    private static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle(compilerRB);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for compiler is missing");
        }
    }

    public static String getText(String string, Object ... objectArray) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = "" + objectArray[i];
        }
        if (messageRB == null) {
            Log.initResource();
        }
        try {
            return MessageFormat.format(messageRB.getString(string), stringArray);
        }
        catch (MissingResourceException missingResourceException) {
            String string2 = "compiler message file broken: key=" + string + " arguments={0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}";
            return MessageFormat.format(string2, stringArray);
        }
    }

    private void printRawError(int n, String string) {
        if (n == 0) {
            Log.printLines(this.errWriter, "error: " + string);
        } else {
            int n2 = Position.line(n);
            int n3 = Position.column(n);
            Log.printLines(this.errWriter, this.sourcename + ":" + n2 + ": " + string);
            this.printErrLine(n2, n3, this.errWriter);
        }
        this.errWriter.flush();
    }

    public void rawError(int n, String string) {
        Pair<Name, Integer> pair;
        if (this.nerrors < this.MaxErrors && !this.recorded.contains(pair = new Pair<Name, Integer>(this.sourcename, n))) {
            this.recorded.add(pair);
            this.printRawError(n, string);
            this.prompt();
            ++this.nerrors;
        }
        this.errWriter.flush();
    }

    public void rawWarning(int n, String string) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.printRawError(n, "warning: " + string);
        }
        this.prompt();
        ++this.nwarnings;
        this.errWriter.flush();
    }
}

