/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.openjms;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesException;
import hermes.JNDIConnectionFactory;
import hermes.browser.HermesBrowser;
import hermes.config.DestinationConfig;
import hermes.ext.HermesAdminSupport;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.jms.JMSException;
import org.apache.log4j.Logger;
import org.exolab.jms.administration.AdminConnectionFactory;
import org.exolab.jms.administration.JmsAdminServerIfc;

public class OpenJMSAdmin
extends HermesAdminSupport
implements HermesAdmin {
    private static final Logger log = Logger.getLogger(OpenJMSAdmin.class);
    private JNDIConnectionFactory connectionFactory;
    private JmsAdminServerIfc adminServer;

    public OpenJMSAdmin(Hermes hermes, JNDIConnectionFactory connectionFactory) {
        super(hermes);
        this.connectionFactory = connectionFactory;
    }

    private synchronized JmsAdminServerIfc getAdminServer() throws JMSException {
        try {
            if (this.adminServer == null) {
                this.adminServer = this.connectionFactory.getSecurityPrincipal() == null ? AdminConnectionFactory.create((String)this.connectionFactory.getProviderURL()) : AdminConnectionFactory.create((String)this.connectionFactory.getProviderURL(), (String)this.connectionFactory.getSecurityPrincipal(), (String)this.connectionFactory.getSecurityCredentials());
            }
        }
        catch (MalformedURLException e) {
            throw new HermesException((Exception)e);
        }
        return this.adminServer;
    }

    protected synchronized Collection discoverDurableSubscriptions(String topicName, String jndiName) throws JMSException {
        Vector durables = this.getAdminServer().getDurableConsumers(topicName);
        if (durables.size() > 0) {
            ArrayList<DestinationConfig> rval = new ArrayList<DestinationConfig>();
            for (Object o : durables) {
                String durableName = (String)o;
                DestinationConfig dConfig = HermesBrowser.getConfigDAO().createDestinationConfig();
                dConfig.setClientID(durableName);
                dConfig.setName(jndiName == null ? topicName : jndiName);
                dConfig.setDomain(Integer.valueOf(Domain.TOPIC.getId()));
                dConfig.setDurable(Boolean.valueOf(true));
                rval.add(dConfig);
            }
            return rval;
        }
        return Collections.EMPTY_SET;
    }

    public synchronized int getDepth(DestinationConfig dConfig) throws JMSException {
        if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
            return this.getAdminServer().getQueueMessageCount(this.getRealDestinationName(dConfig));
        }
        if (dConfig.getDomain().intValue() == Domain.TOPIC.getId() && dConfig.isDurable()) {
            return this.getAdminServer().getDurableConsumerMessageCount(dConfig.getName(), dConfig.getClientID());
        }
        throw new HermesException("Cannot provide non-durable topic depth");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws JMSException {
        if (this.adminServer != null) {
            try {
                this.adminServer.close();
            }
            finally {
                this.adminServer = null;
            }
        }
    }
}

