/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth;

import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.ResourceBundle;
import sun.security.x509.X500Name;

public class X500Principal
implements Principal,
Serializable {
    private static final ResourceBundle rb = ResourceBundle.getBundle("com.sun.security.auth.Resources");
    private String name;
    private transient X500Name thisX500Name;

    public int hashCode() {
        return this.thisX500Name.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, NotActiveException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.thisX500Name = new X500Name(this.name);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof X500Principal) {
            X500Principal x500Principal = (X500Principal)object;
            try {
                X500Name x500Name = new X500Name(x500Principal.getName());
                return this.thisX500Name.equals(x500Name);
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (object instanceof Principal) {
            return object.equals(this.thisX500Name);
        }
        return false;
    }

    public String getName() {
        return this.thisX500Name.getName();
    }

    public String toString() {
        return this.thisX500Name.toString();
    }

    public X500Principal(String string) {
        if (string == null) {
            throw new NullPointerException(rb.getString("provided null name"));
        }
        try {
            this.thisX500Name = new X500Name(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.toString());
        }
        this.name = string;
    }
}

