/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.http.proxy;

import flex.messaging.log.Log;
import flex.messaging.services.http.proxy.CookieInfo;
import flex.messaging.services.http.proxy.ProxyConstants;
import flex.messaging.services.http.proxy.SharedProxyContext;

public class RequestUtil {
    public static CookieInfo createCookie(CookieInfo cookie, SharedProxyContext context, String targetHost, String targetPath) {
        String path = cookie.path;
        String name = cookie.name;
        if (path == null) {
            path = "/";
        }
        String domain = null;
        String actualName = null;
        if (name.startsWith("FLEX") && name.indexOf("_") != -1) {
            int pathHash;
            int domainHash;
            int startIndex = name.indexOf("_") + 1;
            int endIndex = name.indexOf("_", startIndex);
            if (endIndex == -1) {
                return null;
            }
            try {
                domainHash = Integer.parseInt(name.substring(startIndex, endIndex));
                startIndex = endIndex + 1;
                endIndex = name.indexOf("_", startIndex);
                if (endIndex == -1) {
                    return null;
                }
                pathHash = Integer.parseInt(name.substring(startIndex, endIndex));
            }
            catch (NumberFormatException e) {
                Log.getLogger((String)"Service.HTTP").error("Could not parse cookie hash value in: " + name + " (may be beta cookie)");
                return null;
            }
            startIndex = endIndex + 1;
            if (name.length() <= startIndex) {
                return null;
            }
            actualName = name.substring(startIndex);
            domain = targetHost;
            while (domain != null && domainHash != domain.hashCode()) {
                int dotIndex = domain.indexOf(".", 1);
                if (dotIndex != -1) {
                    domain = domain.substring(dotIndex);
                    continue;
                }
                domain = null;
            }
            if (domain == null) {
                return null;
            }
            for (path = targetPath; path != null && path.length() != 0 && pathHash != path.hashCode(); path = path.substring(0, path.length() - 1)) {
            }
            if (path == null || path.length() == 0) {
                return null;
            }
        } else if (context.isLocalDomain()) {
            domain = cookie.domain;
            if (domain == null) {
                domain = targetHost;
            }
            actualName = cookie.name;
        } else {
            return null;
        }
        CookieInfo cookieInfo = new CookieInfo(name, domain, actualName, cookie.value, path, cookie.maxAge, cookie.maxAgeObj, cookie.secure);
        return cookieInfo;
    }

    public static boolean ignoreHeader(String headerName, SharedProxyContext context) {
        boolean ignoreHeader = false;
        if ("Host".equalsIgnoreCase(headerName) || "Accept-Encoding".equalsIgnoreCase(headerName) || "Content-Length".equalsIgnoreCase(headerName) || "Set-Cookie".equalsIgnoreCase(headerName) || "Set-Cookie2".equalsIgnoreCase(headerName) || "Cookie".equalsIgnoreCase(headerName) || "Connection".equalsIgnoreCase(headerName) || ProxyConstants.HEADER_CREDENTIALS.equalsIgnoreCase(headerName) || "Authorization".equalsIgnoreCase(headerName) && (context.hasAuthorization() || !context.isLocalDomain())) {
            ignoreHeader = true;
        }
        return ignoreHeader;
    }
}

