/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.prism.MediaFrame;
import com.sun.prism.PixelFormat;
import com.sun.prism.d3d.D3DContext;
import com.sun.prism.d3d.D3DContextSource;
import com.sun.prism.d3d.D3DResource;
import com.sun.prism.d3d.D3DResourceFactory;
import com.sun.prism.impl.BaseTexture;
import com.sun.prism.impl.PrismTrace;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

class D3DTexture
extends BaseTexture
implements D3DContextSource {
    protected D3DTextureRecord d3dResRecord;

    D3DTexture(D3DContext d3DContext, PixelFormat pixelFormat, long l, int n, int n2, int n3, int n4) {
        this(d3DContext, pixelFormat, l, n, n2, n3, n4, false);
    }

    D3DTexture(D3DContext d3DContext, PixelFormat pixelFormat, long l, int n, int n2, int n3, int n4, boolean bl) {
        super(pixelFormat, n, n2, 0, 0, n3, n4, new D3DTextureRecord(d3DContext, l, bl));
        this.d3dResRecord = (D3DTextureRecord)this.disposerRecord;
        if (bl) {
            PrismTrace.rttCreated(l, n, n2, 4);
        } else {
            PrismTrace.textureCreated(l, n, n2, pixelFormat.getBytesPerPixelUnit());
        }
    }

    public long getNativeSourceHandle() {
        return this.d3dResRecord.getResource();
    }

    @Override
    public D3DContext getContext() {
        return this.d3dResRecord.getContext();
    }

    @Override
    public void update(MediaFrame mediaFrame, boolean bl) {
        int n;
        PixelFormat pixelFormat;
        if (mediaFrame.getPixelFormat() == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("Unsupported format " + (Object)((Object)mediaFrame.getPixelFormat()));
        }
        mediaFrame.holdFrame();
        int n2 = 1;
        ByteBuffer byteBuffer = mediaFrame.getBuffer();
        if (!bl) {
            this.d3dResRecord.getContext().flushVertexBuffer();
        }
        if ((pixelFormat = mediaFrame.getPixelFormat()).getDataType() == PixelFormat.DataType.INT) {
            byteBuffer.position(mediaFrame.offsetForPlane(0));
            n = D3DResourceFactory.nUpdateTextureI(this.d3dResRecord.getContext().getContextHandle(), this.d3dResRecord.getResource(), byteBuffer.slice().asIntBuffer(), null, 0, 0, 0, 0, mediaFrame.getEncodedWidth(), mediaFrame.getEncodedHeight(), mediaFrame.strideForPlane(0));
        } else {
            byteBuffer.position(mediaFrame.offsetForPlane(0));
            n = D3DResourceFactory.nUpdateTextureB(this.d3dResRecord.getContext().getContextHandle(), this.d3dResRecord.getResource(), byteBuffer.slice(), null, n2, pixelFormat.ordinal(), 0, 0, 0, 0, mediaFrame.getEncodedWidth(), mediaFrame.getEncodedHeight(), mediaFrame.strideForPlane(0));
        }
        this.d3dResRecord.getContext();
        D3DContext.validate(n);
        mediaFrame.releaseFrame();
    }

    @Override
    public void update(Buffer buffer, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int n8;
        this.checkUpdateParams(buffer, pixelFormat, n, n2, n3, n4, n5, n6, n7);
        if (!bl) {
            this.d3dResRecord.getContext().flushVertexBuffer();
        }
        if (pixelFormat.getDataType() == PixelFormat.DataType.INT) {
            IntBuffer intBuffer = (IntBuffer)buffer;
            int[] nArray = intBuffer.hasArray() ? intBuffer.array() : null;
            n8 = D3DResourceFactory.nUpdateTextureI(this.d3dResRecord.getContext().getContextHandle(), this.d3dResRecord.getResource(), intBuffer, nArray, n, n2, n3, n4, n5, n6, n7);
        } else if (pixelFormat.getDataType() == PixelFormat.DataType.FLOAT) {
            FloatBuffer floatBuffer = (FloatBuffer)buffer;
            float[] fArray = floatBuffer.hasArray() ? floatBuffer.array() : null;
            n8 = D3DResourceFactory.nUpdateTextureF(this.d3dResRecord.getContext().getContextHandle(), this.d3dResRecord.getResource(), floatBuffer, fArray, n, n2, n3, n4, n5, n6, n7);
        } else {
            ByteBuffer byteBuffer = (ByteBuffer)buffer;
            byteBuffer.rewind();
            byte[] byArray = byteBuffer.hasArray() ? byteBuffer.array() : null;
            int n9 = pixelFormat.getBytesPerPixelUnit();
            n8 = D3DResourceFactory.nUpdateTextureB(this.d3dResRecord.getContext().getContextHandle(), this.d3dResRecord.getResource(), byteBuffer, byArray, n9, pixelFormat.ordinal(), n, n2, n3, n4, n5, n6, n7);
        }
        this.d3dResRecord.getContext();
        D3DContext.validate(n8);
    }

    @Override
    public void dispose() {
        this.disposerRecord.dispose();
    }

    protected static class D3DTextureRecord
    extends D3DResource.D3DRecord {
        private final boolean isRTT;

        private D3DTextureRecord(D3DContext d3DContext, long l, boolean bl) {
            super(d3DContext, l);
            this.isRTT = bl;
        }

        @Override
        protected void markDisposed() {
            long l = this.getResource();
            if (l != 0L) {
                if (this.isRTT) {
                    PrismTrace.rttDisposed(l);
                } else {
                    PrismTrace.textureDisposed(l);
                }
            }
            super.markDisposed();
        }

        @Override
        public void dispose() {
            long l = this.getResource();
            if (l != 0L) {
                if (this.isRTT) {
                    PrismTrace.rttDisposed(l);
                } else {
                    PrismTrace.textureDisposed(l);
                }
            }
            super.dispose();
        }
    }
}

