/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.desktop.AppletWindow;
import com.sun.javafx.tk.quantum.WindowStage;
import java.lang.ref.WeakReference;
import java.util.Map;
import javafx.stage.Stage;

public class GlassAppletWindow
implements AppletWindow {
    private final Window glassWindow;
    private WeakReference<Stage> topStage;
    private String serverName;

    GlassAppletWindow(long l, String string) {
        if (0L == l) {
            if (string != null) {
                throw new RuntimeException("GlassAppletWindow constructor used incorrectly.");
            }
            this.glassWindow = Application.GetApplication().createWindow(null, 0);
        } else {
            this.serverName = string;
            this.glassWindow = Application.GetApplication().createWindow(l);
        }
    }

    Window getGlassWindow() {
        return this.glassWindow;
    }

    @Override
    public void setBackgroundColor(int n) {
        float f = (float)(n >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(n >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(n & 0xFF) / 255.0f;
        this.glassWindow.setBackground(f, f2, f3);
    }

    @Override
    public void setForegroundColor(int n) {
    }

    @Override
    public void setVisible(boolean bl) {
        this.glassWindow.setVisible(bl);
    }

    @Override
    public void setSize(int n, int n2) {
        this.glassWindow.setSize(n, n2);
    }

    @Override
    public int getWidth() {
        return this.glassWindow.getWidth();
    }

    @Override
    public int getHeight() {
        return this.glassWindow.getHeight();
    }

    @Override
    public void setPosition(int n, int n2) {
        this.glassWindow.setPosition(n, n2);
    }

    @Override
    public int getPositionX() {
        return this.glassWindow.getX();
    }

    @Override
    public int getPositionY() {
        return this.glassWindow.getY();
    }

    void dispose() {
        this.glassWindow.close();
    }

    @Override
    public void setStageOnTop(Stage stage) {
        this.topStage = null != stage ? new WeakReference<Stage>(stage) : null;
    }

    @Override
    public int getRemoteLayerId() {
        View view = this.glassWindow.getView();
        if (view != null) {
            return view.getNativeRemoteLayerId(this.serverName);
        }
        return -1;
    }

    @Override
    public void dispatchEvent(Map map) {
        this.glassWindow.dispatchNpapiEvent(map);
    }

    void assertStageOrder() {
        Window window;
        TKStage tKStage;
        Stage stage;
        if (null != this.topStage && null != (stage = (Stage)this.topStage.get()) && (tKStage = stage.impl_getPeer()) instanceof WindowStage && ((WindowStage)tKStage).isVisible() && null != (window = ((WindowStage)tKStage).getPlatformWindow())) {
            window.toFront();
        }
    }
}

