/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ELNode;
import org.apache.jasper.compiler.ELParser;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageDataImpl;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.TagLibraryInfoImpl;
import org.apache.jasper.compiler.Validator;
import org.xml.sax.Attributes;

class Validator {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$JspFragment;

    Validator() {
    }

    public static void validate(Compiler compiler, Node.Nodes page) throws JasperException {
        page.visit(new DirectiveVisitor(compiler));
        PageInfo pageInfo = compiler.getPageInfo();
        String contentType = pageInfo.getContentType();
        if (contentType == null || contentType.indexOf("charset=") < 0) {
            boolean isXml = page.getRoot().isXmlSyntax();
            String defaultType = contentType == null ? (isXml ? "text/xml" : "text/html") : contentType;
            String charset = null;
            if (isXml) {
                charset = "UTF-8";
            } else if (!page.getRoot().isDefaultPageEncoding()) {
                charset = page.getRoot().getPageEncoding();
            }
            if (charset != null) {
                pageInfo.setContentType(defaultType + ";charset=" + charset);
            } else {
                pageInfo.setContentType(defaultType);
            }
        }
        page.visit(new ValidateVisitor(compiler));
        Validator.validateXmlView(new PageDataImpl(page, compiler), compiler);
        page.visit(new TagExtraInfoVisitor(compiler));
    }

    private static void validateXmlView(PageData xmlView, Compiler compiler) throws JasperException {
        StringBuffer errMsg = null;
        ErrorDispatcher errDisp = compiler.getErrorDispatcher();
        Object[] objs = compiler.getPageInfo().getTagLibraries().values().toArray();
        int i = 0;
        while (i < objs.length) {
            TagLibraryInfoImpl tli;
            ValidationMessage[] errors;
            if (objs[i] instanceof TagLibraryInfoImpl && (errors = (tli = (TagLibraryInfoImpl)((Object)objs[i])).validate(xmlView)) != null && errors.length != 0) {
                if (errMsg == null) {
                    errMsg = new StringBuffer();
                }
                errMsg.append("<h3>");
                errMsg.append(Localizer.getMessage("jsp.error.tlv.invalid.page", tli.getShortName()));
                errMsg.append("</h3>");
                int j = 0;
                while (j < errors.length) {
                    if (errors[j] != null) {
                        errMsg.append("<p>");
                        errMsg.append(errors[j].getId());
                        errMsg.append(": ");
                        errMsg.append(errors[j].getMessage());
                        errMsg.append("</p>");
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (errMsg != null) {
            errDisp.jspError(errMsg.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class TagExtraInfoVisitor
    extends Node.Visitor {
        private PageInfo pageInfo;
        private ErrorDispatcher err;

        TagExtraInfoVisitor(Compiler compiler) {
            this.pageInfo = compiler.getPageInfo();
            this.err = compiler.getErrorDispatcher();
        }

        public void visit(Node.CustomTag n) throws JasperException {
            ValidationMessage[] errors;
            TagInfo tagInfo = n.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError(n, "jsp.error.missing.tagInfo", n.getQName());
            }
            if ((errors = tagInfo.validate(n.getTagData())) != null && errors.length != 0) {
                StringBuffer errMsg = new StringBuffer();
                errMsg.append("<h3>");
                errMsg.append(Localizer.getMessage("jsp.error.tei.invalid.attributes", n.getQName()));
                errMsg.append("</h3>");
                int i = 0;
                while (i < errors.length) {
                    errMsg.append("<p>");
                    if (errors[i].getId() != null) {
                        errMsg.append(errors[i].getId());
                        errMsg.append(": ");
                    }
                    errMsg.append(errors[i].getMessage());
                    errMsg.append("</p>");
                    ++i;
                }
                this.err.jspError(n, errMsg.toString());
            }
            this.visitBody(n);
        }
    }

    static class ValidateVisitor
    extends Node.Visitor {
        private PageInfo pageInfo;
        private ErrorDispatcher err;
        private TagInfo tagInfo;
        private ClassLoader loader;
        private HashMap taglibs;
        private static final JspUtil.ValidAttribute[] jspRootAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("version", true)};
        private static final JspUtil.ValidAttribute[] includeDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("file", true)};
        private static final JspUtil.ValidAttribute[] taglibDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("uri"), new JspUtil.ValidAttribute("tagdir"), new JspUtil.ValidAttribute("prefix", true)};
        private static final JspUtil.ValidAttribute[] includeActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true, true), new JspUtil.ValidAttribute("flush")};
        private static final JspUtil.ValidAttribute[] paramActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("value", true, true)};
        private static final JspUtil.ValidAttribute[] forwardActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true, true)};
        private static final JspUtil.ValidAttribute[] getPropertyAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true)};
        private static final JspUtil.ValidAttribute[] setPropertyAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true), new JspUtil.ValidAttribute("value", false, true), new JspUtil.ValidAttribute("param")};
        private static final JspUtil.ValidAttribute[] useBeanAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("id", true), new JspUtil.ValidAttribute("scope"), new JspUtil.ValidAttribute("class"), new JspUtil.ValidAttribute("type"), new JspUtil.ValidAttribute("beanName", false, true)};
        private static final JspUtil.ValidAttribute[] plugInAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("type", true), new JspUtil.ValidAttribute("code", true), new JspUtil.ValidAttribute("codebase"), new JspUtil.ValidAttribute("align"), new JspUtil.ValidAttribute("archive"), new JspUtil.ValidAttribute("height", false, true), new JspUtil.ValidAttribute("hspace"), new JspUtil.ValidAttribute("jreversion"), new JspUtil.ValidAttribute("name"), new JspUtil.ValidAttribute("vspace"), new JspUtil.ValidAttribute("width", false, true), new JspUtil.ValidAttribute("nspluginurl"), new JspUtil.ValidAttribute("iepluginurl")};
        private static final JspUtil.ValidAttribute[] attributeAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("trim")};
        private static final JspUtil.ValidAttribute[] invokeAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("fragment", true), new JspUtil.ValidAttribute("var"), new JspUtil.ValidAttribute("varReader"), new JspUtil.ValidAttribute("scope")};
        private static final JspUtil.ValidAttribute[] doBodyAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("var"), new JspUtil.ValidAttribute("varReader"), new JspUtil.ValidAttribute("scope")};
        private static final JspUtil.ValidAttribute[] jspOutputAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("omit-xml-declaration")};

        ValidateVisitor(Compiler compiler) {
            this.pageInfo = compiler.getPageInfo();
            this.taglibs = this.pageInfo.getTagLibraries();
            this.err = compiler.getErrorDispatcher();
            this.tagInfo = compiler.getCompilationContext().getTagInfo();
            this.loader = compiler.getCompilationContext().getClassLoader();
        }

        public void visit(Node.JspRoot n) throws JasperException {
            JspUtil.checkAttributes("Jsp:root", n, jspRootAttrs, this.err);
            String version = n.getTextAttribute("version");
            if (!version.equals("1.2") && !version.equals("2.0")) {
                this.err.jspError(n, "jsp.error.jsproot.version.invalid", version);
            }
            this.visitBody(n);
        }

        public void visit(Node.IncludeDirective n) throws JasperException {
            JspUtil.checkAttributes("Include directive", n, includeDirectiveAttrs, this.err);
            this.visitBody(n);
        }

        public void visit(Node.TaglibDirective n) throws JasperException {
            JspUtil.checkAttributes("Taglib directive", n, taglibDirectiveAttrs, this.err);
            String uri = n.getAttributeValue("uri");
            String tagdir = n.getAttributeValue("tagdir");
            if (uri == null && tagdir == null) {
                this.err.jspError(n, "jsp.error.taglibDirective.missing.location");
            }
            if (uri != null && tagdir != null) {
                this.err.jspError(n, "jsp.error.taglibDirective.both_uri_and_tagdir");
            }
        }

        public void visit(Node.ParamAction n) throws JasperException {
            JspUtil.checkAttributes("Param action", n, paramActionAttrs, this.err);
            this.throwErrorIfExpression(n, "name", "jsp:param");
            n.setValue(this.getJspAttribute("value", null, null, n.getAttributeValue("value"), class$java$lang$String == null ? (class$java$lang$String = Validator.class$("java.lang.String")) : class$java$lang$String, n, false));
            this.visitBody(n);
        }

        public void visit(Node.ParamsAction n) throws JasperException {
            Node.Nodes subElems = n.getBody();
            if (subElems == null) {
                this.err.jspError(n, "jsp.error.params.emptyBody");
            }
            this.visitBody(n);
        }

        public void visit(Node.IncludeAction n) throws JasperException {
            JspUtil.checkAttributes("Include action", n, includeActionAttrs, this.err);
            n.setPage(this.getJspAttribute("page", null, null, n.getAttributeValue("page"), class$java$lang$String == null ? (class$java$lang$String = Validator.class$("java.lang.String")) : class$java$lang$String, n, false));
            this.visitBody(n);
        }

        public void visit(Node.ForwardAction n) throws JasperException {
            JspUtil.checkAttributes("Forward", n, forwardActionAttrs, this.err);
            n.setPage(this.getJspAttribute("page", null, null, n.getAttributeValue("page"), class$java$lang$String == null ? (class$java$lang$String = Validator.class$("java.lang.String")) : class$java$lang$String, n, false));
            this.visitBody(n);
        }

        public void visit(Node.GetProperty n) throws JasperException {
            JspUtil.checkAttributes("GetProperty", n, getPropertyAttrs, this.err);
        }

        public void visit(Node.SetProperty n) throws JasperException {
            boolean valueSpecified;
            JspUtil.checkAttributes("SetProperty", n, setPropertyAttrs, this.err);
            String name = n.getTextAttribute("name");
            String property = n.getTextAttribute("property");
            String param = n.getTextAttribute("param");
            String value = n.getAttributeValue("value");
            n.setValue(this.getJspAttribute("value", null, null, value, class$java$lang$Object == null ? (class$java$lang$Object = Validator.class$("java.lang.Object")) : class$java$lang$Object, n, false));
            boolean bl = valueSpecified = n.getValue() != null;
            if ("*".equals(property)) {
                if (param != null || valueSpecified) {
                    this.err.jspError(n, "jsp.error.setProperty.invalid");
                }
            } else if (param != null && valueSpecified) {
                this.err.jspError(n, "jsp.error.setProperty.invalid");
            }
            this.visitBody(n);
        }

        public void visit(Node.UseBean n) throws JasperException {
            JspUtil.checkAttributes("UseBean", n, useBeanAttrs, this.err);
            String name = n.getTextAttribute("id");
            String scope = n.getTextAttribute("scope");
            JspUtil.checkScope(scope, n, this.err);
            String className = n.getTextAttribute("class");
            String type = n.getTextAttribute("type");
            BeanRepository beanInfo = this.pageInfo.getBeanRepository();
            if (className == null && type == null) {
                this.err.jspError(n, "jsp.error.useBean.missingType");
            }
            if (beanInfo.checkVariable(name)) {
                this.err.jspError(n, "jsp.error.useBean.duplicate");
            }
            if ("session".equals(scope) && !this.pageInfo.isSession()) {
                this.err.jspError(n, "jsp.error.useBean.noSession");
            }
            Node.JspAttribute jattr = this.getJspAttribute("beanName", null, null, n.getAttributeValue("beanName"), class$java$lang$String == null ? (class$java$lang$String = Validator.class$("java.lang.String")) : class$java$lang$String, n, false);
            n.setBeanName(jattr);
            if (className != null && jattr != null) {
                this.err.jspError(n, "jsp.error.useBean.notBoth");
            }
            if (className == null) {
                className = type;
            }
            beanInfo.addBean(n, name, className, scope);
            this.visitBody(n);
        }

        public void visit(Node.PlugIn n) throws JasperException {
            JspUtil.checkAttributes("Plugin", n, plugInAttrs, this.err);
            this.throwErrorIfExpression(n, "type", "jsp:plugin");
            this.throwErrorIfExpression(n, "code", "jsp:plugin");
            this.throwErrorIfExpression(n, "codebase", "jsp:plugin");
            this.throwErrorIfExpression(n, "align", "jsp:plugin");
            this.throwErrorIfExpression(n, "archive", "jsp:plugin");
            this.throwErrorIfExpression(n, "hspace", "jsp:plugin");
            this.throwErrorIfExpression(n, "jreversion", "jsp:plugin");
            this.throwErrorIfExpression(n, "name", "jsp:plugin");
            this.throwErrorIfExpression(n, "vspace", "jsp:plugin");
            this.throwErrorIfExpression(n, "nspluginurl", "jsp:plugin");
            this.throwErrorIfExpression(n, "iepluginurl", "jsp:plugin");
            String type = n.getTextAttribute("type");
            if (type == null) {
                this.err.jspError(n, "jsp.error.plugin.notype");
            }
            if (!type.equals("bean") && !type.equals("applet")) {
                this.err.jspError(n, "jsp.error.plugin.badtype");
            }
            if (n.getTextAttribute("code") == null) {
                this.err.jspError(n, "jsp.error.plugin.nocode");
            }
            Node.JspAttribute width = this.getJspAttribute("width", null, null, n.getAttributeValue("width"), class$java$lang$String == null ? (class$java$lang$String = Validator.class$("java.lang.String")) : class$java$lang$String, n, false);
            n.setWidth(width);
            Node.JspAttribute height = this.getJspAttribute("height", null, null, n.getAttributeValue("height"), class$java$lang$String == null ? (class$java$lang$String = Validator.class$("java.lang.String")) : class$java$lang$String, n, false);
            n.setHeight(height);
            this.visitBody(n);
        }

        public void visit(Node.NamedAttribute n) throws JasperException {
            JspUtil.checkAttributes("Attribute", n, attributeAttrs, this.err);
            this.visitBody(n);
        }

        public void visit(Node.JspBody n) throws JasperException {
            this.visitBody(n);
        }

        public void visit(Node.Declaration n) throws JasperException {
            if (this.pageInfo.isScriptingInvalid()) {
                this.err.jspError(n.getStart(), "jsp.error.no.scriptlets");
            }
        }

        public void visit(Node.Expression n) throws JasperException {
            if (this.pageInfo.isScriptingInvalid()) {
                this.err.jspError(n.getStart(), "jsp.error.no.scriptlets");
            }
        }

        public void visit(Node.Scriptlet n) throws JasperException {
            if (this.pageInfo.isScriptingInvalid()) {
                this.err.jspError(n.getStart(), "jsp.error.no.scriptlets");
            }
        }

        public void visit(Node.ELExpression n) throws JasperException {
            if (!this.pageInfo.isELIgnored()) {
                String expressions = "${" + new String(n.getText()) + "}";
                ELNode.Nodes el = ELParser.parse(expressions);
                this.validateFunctions(el, n);
                JspUtil.validateExpressions(n.getStart(), expressions, class$java$lang$String == null ? (class$java$lang$String = Validator.class$("java.lang.String")) : class$java$lang$String, this.getFunctionMapper(el), this.err);
                n.setEL(el);
            }
        }

        public void visit(Node.UninterpretedTag n) throws JasperException {
            Attributes attrs;
            if (n.getNamedAttributeNodes().size() != 0) {
                this.err.jspError(n, "jsp.error.namedAttribute.invalidUse");
            }
            if ((attrs = n.getAttributes()) != null) {
                int attrSize = attrs.getLength();
                Node.JspAttribute[] jspAttrs = new Node.JspAttribute[attrSize];
                int i = 0;
                while (i < attrSize) {
                    jspAttrs[i] = this.getJspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i), class$java$lang$Object == null ? Validator.class$("java.lang.Object") : class$java$lang$Object, n, false);
                    ++i;
                }
                n.setJspAttributes(jspAttrs);
            }
            this.visitBody(n);
        }

        public void visit(Node.CustomTag n) throws JasperException {
            TagInfo tagInfo = n.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError(n, "jsp.error.missing.tagInfo", n.getQName());
            }
            if (tagInfo.hasDynamicAttributes() && !n.implementsDynamicAttributes()) {
                this.err.jspError(n, "jsp.error.dynamic.attributes.not.implemented", n.getQName());
            }
            TagAttributeInfo[] tldAttrs = tagInfo.getAttributes();
            String customActionUri = n.getURI();
            Attributes attrs = n.getAttributes();
            int attrsSize = attrs == null ? 0 : attrs.getLength();
            int i = 0;
            while (i < tldAttrs.length) {
                String attr = null;
                if (attrs != null && (attr = attrs.getValue(tldAttrs[i].getName())) == null) {
                    attr = attrs.getValue(customActionUri, tldAttrs[i].getName());
                }
                Node.NamedAttribute na = n.getNamedAttributeNode(tldAttrs[i].getName());
                if (tldAttrs[i].isRequired() && attr == null && na == null) {
                    this.err.jspError((Node)n, "jsp.error.missing_attribute", tldAttrs[i].getName(), n.getLocalName());
                }
                if (attr != null && na != null) {
                    this.err.jspError(n, "jsp.error.duplicate.name.jspattribute", tldAttrs[i].getName());
                }
                ++i;
            }
            Node.Nodes naNodes = n.getNamedAttributeNodes();
            int jspAttrsSize = naNodes.size() + attrsSize;
            Node.JspAttribute[] jspAttrs = null;
            if (jspAttrsSize > 0) {
                jspAttrs = new Node.JspAttribute[jspAttrsSize];
            }
            Hashtable tagDataAttrs = new Hashtable(attrsSize);
            this.checkXmlAttributes(n, jspAttrs, tagDataAttrs);
            this.checkNamedAttributes(n, jspAttrs, attrsSize, tagDataAttrs);
            TagData tagData = new TagData(tagDataAttrs);
            TagExtraInfo tei = tagInfo.getTagExtraInfo();
            if (tei != null && tei.getVariableInfo(tagData) != null && tei.getVariableInfo(tagData).length > 0 && tagInfo.getTagVariableInfos().length > 0) {
                this.err.jspError("jsp.error.non_null_tei_and_var_subelems", n.getQName());
            }
            n.setTagData(tagData);
            n.setJspAttributes(jspAttrs);
            this.visitBody(n);
        }

        public void visit(Node.JspElement n) throws JasperException {
            Attributes attrs = n.getAttributes();
            if (attrs == null) {
                this.err.jspError(n, "jsp.error.jspelement.missing.name");
            }
            int xmlAttrLen = attrs.getLength();
            Node.Nodes namedAttrs = n.getNamedAttributeNodes();
            int jspAttrSize = xmlAttrLen - 1 + namedAttrs.size();
            Node.JspAttribute[] jspAttrs = new Node.JspAttribute[jspAttrSize];
            int jspAttrIndex = 0;
            int i = 0;
            while (i < xmlAttrLen) {
                if ("name".equals(attrs.getLocalName(i))) {
                    n.setNameAttribute(this.getJspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i), class$java$lang$String == null ? Validator.class$("java.lang.String") : class$java$lang$String, n, false));
                } else if (jspAttrIndex < jspAttrSize) {
                    jspAttrs[jspAttrIndex++] = this.getJspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i), class$java$lang$Object == null ? Validator.class$("java.lang.Object") : class$java$lang$Object, n, false);
                }
                ++i;
            }
            if (n.getNameAttribute() == null) {
                this.err.jspError(n, "jsp.error.jspelement.missing.name");
            }
            int i2 = 0;
            while (i2 < namedAttrs.size()) {
                Node.NamedAttribute na = (Node.NamedAttribute)namedAttrs.getNode(i2);
                jspAttrs[jspAttrIndex++] = new Node.JspAttribute(na, false);
                ++i2;
            }
            n.setJspAttributes(jspAttrs);
            this.visitBody(n);
        }

        public void visit(Node.JspOutput n) throws JasperException {
            JspUtil.checkAttributes("jsp:output", n, jspOutputAttrs, this.err);
            if (n.getBody() != null) {
                this.err.jspError(n, "jsp.error.jspoutput.nonemptybody");
            }
            if (this.pageInfo.getOmitXmlDecl() != null) {
                this.err.jspError(n, "jsp.error.multiple.jspoutput");
            }
            this.pageInfo.setOmitXmlDecl(n.getAttributeValue("omit-xml-declaration"));
        }

        public void visit(Node.InvokeAction n) throws JasperException {
            JspUtil.checkAttributes("Invoke", n, invokeAttrs, this.err);
            String scope = n.getTextAttribute("scope");
            JspUtil.checkScope(scope, n, this.err);
            String var = n.getTextAttribute("var");
            String varReader = n.getTextAttribute("varReader");
            if (scope != null && var == null && varReader == null) {
                this.err.jspError(n, "jsp.error.missing_var_or_varReader");
            }
            if (var != null && varReader != null) {
                this.err.jspError(n, "jsp.error.var_and_varReader");
            }
        }

        public void visit(Node.DoBodyAction n) throws JasperException {
            JspUtil.checkAttributes("DoBody", n, doBodyAttrs, this.err);
            String scope = n.getTextAttribute("scope");
            JspUtil.checkScope(scope, n, this.err);
            String var = n.getTextAttribute("var");
            String varReader = n.getTextAttribute("varReader");
            if (scope != null && var == null && varReader == null) {
                this.err.jspError(n, "jsp.error.missing_var_or_varReader");
            }
            if (var != null && varReader != null) {
                this.err.jspError(n, "jsp.error.var_and_varReader");
            }
        }

        private void checkXmlAttributes(Node.CustomTag n, Node.JspAttribute[] jspAttrs, Hashtable tagDataAttrs) throws JasperException {
            TagInfo tagInfo = n.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError(n, "jsp.error.missing.tagInfo", n.getQName());
            }
            TagAttributeInfo[] tldAttrs = tagInfo.getAttributes();
            Attributes attrs = n.getAttributes();
            int i = 0;
            while (attrs != null && i < attrs.getLength()) {
                boolean found = false;
                int j = 0;
                while (tldAttrs != null && j < tldAttrs.length) {
                    if (attrs.getLocalName(i).equals(tldAttrs[j].getName()) && (attrs.getURI(i) == null || attrs.getURI(i).length() == 0 || attrs.getURI(i).equals(n.getURI()))) {
                        if (tldAttrs[j].canBeRequestTime()) {
                            Class expectedType = class$java$lang$String == null ? Validator.class$("java.lang.String") : class$java$lang$String;
                            try {
                                String typeStr = tldAttrs[j].getTypeName();
                                if (tldAttrs[j].isFragment()) {
                                    expectedType = class$javax$servlet$jsp$tagext$JspFragment == null ? Validator.class$("javax.servlet.jsp.tagext.JspFragment") : class$javax$servlet$jsp$tagext$JspFragment;
                                } else if (typeStr != null) {
                                    expectedType = JspUtil.toClass(typeStr, this.loader);
                                }
                                jspAttrs[i] = this.getJspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i), expectedType, n, false);
                            }
                            catch (ClassNotFoundException e) {
                                this.err.jspError((Node)n, "jsp.error.unknown_attribute_type", tldAttrs[j].getName(), tldAttrs[j].getTypeName());
                            }
                        } else {
                            if (this.isExpression(n, attrs.getValue(i))) {
                                this.err.jspError(n, "jsp.error.attribute.custom.non_rt_with_expr", tldAttrs[j].getName());
                            }
                            jspAttrs[i] = new Node.JspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i), false, null, false);
                        }
                        if (jspAttrs[i].isExpression()) {
                            tagDataAttrs.put(attrs.getQName(i), TagData.REQUEST_TIME_VALUE);
                        } else {
                            tagDataAttrs.put(attrs.getQName(i), attrs.getValue(i));
                        }
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    if (tagInfo.hasDynamicAttributes()) {
                        jspAttrs[i] = this.getJspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i), class$java$lang$Object == null ? Validator.class$("java.lang.Object") : class$java$lang$Object, n, true);
                    } else {
                        this.err.jspError((Node)n, "jsp.error.bad_attribute", attrs.getQName(i), n.getLocalName());
                    }
                }
                ++i;
            }
        }

        private void checkNamedAttributes(Node.CustomTag n, Node.JspAttribute[] jspAttrs, int start, Hashtable tagDataAttrs) throws JasperException {
            TagInfo tagInfo = n.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError(n, "jsp.error.missing.tagInfo", n.getQName());
            }
            TagAttributeInfo[] tldAttrs = tagInfo.getAttributes();
            Node.Nodes naNodes = n.getNamedAttributeNodes();
            int i = 0;
            while (i < naNodes.size()) {
                Node.NamedAttribute na = (Node.NamedAttribute)naNodes.getNode(i);
                boolean found = false;
                int j = 0;
                while (j < tldAttrs.length) {
                    String attrPrefix = na.getPrefix();
                    if (na.getLocalName().equals(tldAttrs[j].getName()) && (attrPrefix == null || attrPrefix.length() == 0 || attrPrefix.equals(n.getPrefix()))) {
                        jspAttrs[start + i] = new Node.JspAttribute(na, false);
                        NamedAttributeVisitor nav = null;
                        if (na.getBody() != null) {
                            nav = new NamedAttributeVisitor();
                            na.getBody().visit(nav);
                        }
                        if (nav != null && nav.hasDynamicContent()) {
                            tagDataAttrs.put(na.getName(), TagData.REQUEST_TIME_VALUE);
                        } else {
                            tagDataAttrs.put(na.getName(), na.getText());
                        }
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    if (tagInfo.hasDynamicAttributes()) {
                        jspAttrs[start + i] = new Node.JspAttribute(na, true);
                    } else {
                        this.err.jspError((Node)n, "jsp.error.bad_attribute", na.getName(), n.getLocalName());
                    }
                }
                ++i;
            }
        }

        private Node.JspAttribute getJspAttribute(String qName, String uri, String localName, String value, Class expectedType, Node n, boolean dynamic) throws JasperException {
            Node.JspAttribute result = null;
            if (value != null) {
                if (n.getRoot().isXmlSyntax() && value.startsWith("%=")) {
                    result = new Node.JspAttribute(qName, uri, localName, value.substring(2, value.length() - 1), true, null, dynamic);
                } else if (!n.getRoot().isXmlSyntax() && value.startsWith("<%=")) {
                    result = new Node.JspAttribute(qName, uri, localName, value.substring(3, value.length() - 2), true, null, dynamic);
                } else {
                    ELNode.Nodes el = ELParser.parse(value);
                    if (el.containsEL() && !this.pageInfo.isELIgnored()) {
                        this.validateFunctions(el, n);
                        JspUtil.validateExpressions(n.getStart(), value, expectedType, this.getFunctionMapper(el), this.err);
                        result = new Node.JspAttribute(qName, uri, localName, value, false, el, dynamic);
                    } else {
                        value = value.replace('\u001b', '$');
                        result = new Node.JspAttribute(qName, uri, localName, value, false, null, dynamic);
                    }
                }
            } else {
                Node.NamedAttribute namedAttributeNode = n.getNamedAttributeNode(qName);
                if (namedAttributeNode != null) {
                    result = new Node.JspAttribute(namedAttributeNode, dynamic);
                }
            }
            return result;
        }

        private boolean isExpression(Node n, String value) {
            return n.getRoot().isXmlSyntax() && value.startsWith("%=") || !n.getRoot().isXmlSyntax() && value.startsWith("<%=") || value.indexOf("${") != -1 && !this.pageInfo.isELIgnored();
        }

        private void throwErrorIfExpression(Node n, String attrName, String actionName) throws JasperException {
            if (n.getAttributes() != null && n.getAttributes().getValue(attrName) != null && this.isExpression(n, n.getAttributes().getValue(attrName))) {
                this.err.jspError(n, "jsp.error.attribute.standard.non_rt_with_expr", attrName, actionName);
            }
        }

        private String findUri(String prefix, Node n) {
            Node p = n;
            while (p != null) {
                Attributes attrs = p.getTaglibAttributes();
                if (attrs != null) {
                    int i = 0;
                    while (i < attrs.getLength()) {
                        String name = attrs.getQName(i);
                        int k = name.indexOf(58);
                        if (prefix == null && k < 0) {
                            return attrs.getValue(i);
                        }
                        if (prefix != null && k >= 0 && prefix.equals(name.substring(k + 1))) {
                            return attrs.getValue(i);
                        }
                        ++i;
                    }
                }
                p = p.getParent();
            }
            return null;
        }

        private void validateFunctions(ELNode.Nodes el, Node n) throws JasperException {
            class FVVisitor
            extends ELNode.Visitor {
                Node n;
                private final /* synthetic */ ValidateVisitor this$0;

                FVVisitor(ValidateVisitor this$0, Node n) {
                    this.this$0 = this$0;
                    this.n = n;
                }

                public void visit(ELNode.Function func) throws JasperException {
                    String prefix = func.getPrefix();
                    String function = func.getName();
                    String uri = null;
                    if (this.n.getRoot().isXmlSyntax()) {
                        uri = ValidateVisitor.access$100(this.this$0, prefix, this.n);
                    } else if (prefix != null) {
                        Hashtable prefixMapper = ValidateVisitor.access$200(this.this$0).getPrefixMapper();
                        uri = (String)prefixMapper.get(prefix);
                    }
                    if (uri == null) {
                        if (prefix == null) {
                            ValidateVisitor.access$300(this.this$0).jspError(this.n, "jsp.error.noFunctionPrefix", function);
                        } else {
                            ValidateVisitor.access$300(this.this$0).jspError(this.n, "jsp.error.attribute.invalidPrefix", prefix);
                        }
                    }
                    TagLibraryInfo taglib = (TagLibraryInfo)ValidateVisitor.access$400(this.this$0).get(uri);
                    FunctionInfo funcInfo = null;
                    if (taglib != null) {
                        funcInfo = taglib.getFunction(function);
                    }
                    if (funcInfo == null) {
                        ValidateVisitor.access$300(this.this$0).jspError(this.n, "jsp.error.noFunction", function);
                    }
                    func.setUri(uri);
                    func.setFunctionInfo(funcInfo);
                    ValidateVisitor.access$500(this.this$0, func);
                }
            }
            el.visit(new FVVisitor(this, n));
        }

        private void processSignature(ELNode.Function func) throws JasperException {
            func.setMethodName(this.getMethod(func));
            func.setParameters(this.getParameters(func));
        }

        private String getMethod(ELNode.Function func) throws JasperException {
            int end;
            FunctionInfo funcInfo = func.getFunctionInfo();
            String signature = funcInfo.getFunctionSignature();
            int start = signature.indexOf(32);
            if (start < 0) {
                this.err.jspError("jsp.error.tld.fn.invalid.signature", func.getPrefix(), func.getName());
            }
            if ((end = signature.indexOf(40)) < 0) {
                this.err.jspError("jsp.error.tld.fn.invalid.signature.parenexpected", func.getPrefix(), func.getName());
            }
            return signature.substring(start + 1, end).trim();
        }

        private String[] getParameters(ELNode.Function func) throws JasperException {
            FunctionInfo funcInfo = func.getFunctionInfo();
            String signature = funcInfo.getFunctionSignature();
            ArrayList<String> params = new ArrayList<String>();
            int start = signature.indexOf(40) + 1;
            boolean lastArg = false;
            while (true) {
                int p;
                if ((p = signature.indexOf(44, start)) < 0) {
                    p = signature.indexOf(41, start);
                    if (p < 0) {
                        this.err.jspError("jsp.error.tld.fn.invalid.signature", func.getPrefix(), func.getName());
                    }
                    lastArg = true;
                }
                params.add(signature.substring(start, p).trim());
                if (lastArg) break;
                start = p + 1;
            }
            return params.toArray(new String[params.size()]);
        }

        private FunctionMapper getFunctionMapper(ELNode.Nodes el) throws JasperException {
            class ValidateFunctionMapper
            implements FunctionMapper {
                private HashMap fnmap;
                private final /* synthetic */ ValidateVisitor this$0;

                ValidateFunctionMapper(ValidateVisitor this$0) {
                    this.this$0 = this$0;
                    this.fnmap = new HashMap<K, V>();
                }

                public void mapFunction(String fnQName, Method method) {
                    this.fnmap.put(fnQName, method);
                }

                public Method resolveFunction(String prefix, String localName) {
                    return (Method)this.fnmap.get(prefix + ":" + localName);
                }
            }
            ValidateFunctionMapper fmapper = new ValidateFunctionMapper(this);
            class MapperELVisitor
            extends ELNode.Visitor {
                ValidateFunctionMapper fmapper;
                private final /* synthetic */ ValidateVisitor this$0;

                MapperELVisitor(ValidateVisitor this$0, ValidateFunctionMapper fmapper) {
                    this.this$0 = this$0;
                    this.fmapper = fmapper;
                }

                public void visit(ELNode.Function n) throws JasperException {
                    Class<?> c = null;
                    Method method = null;
                    try {
                        c = ValidateVisitor.access$600(this.this$0).loadClass(n.getFunctionInfo().getFunctionClass());
                    }
                    catch (ClassNotFoundException e) {
                        ValidateVisitor.access$300(this.this$0).jspError("jsp.error.function.classnotfound", n.getFunctionInfo().getFunctionClass(), n.getPrefix() + ':' + n.getName(), e.getMessage());
                    }
                    String[] paramTypes = n.getParameters();
                    int size = paramTypes.length;
                    Class[] params = new Class[size];
                    int i = 0;
                    try {
                        i = 0;
                        while (i < size) {
                            params[i] = JspUtil.toClass(paramTypes[i], ValidateVisitor.access$600(this.this$0));
                            ++i;
                        }
                        method = c.getDeclaredMethod(n.getMethodName(), params);
                    }
                    catch (ClassNotFoundException e) {
                        ValidateVisitor.access$300(this.this$0).jspError("jsp.error.signature.classnotfound", paramTypes[i], n.getPrefix() + ':' + n.getName(), e.getMessage());
                    }
                    catch (NoSuchMethodException e) {
                        ValidateVisitor.access$300(this.this$0).jspError("jsp.error.noFunctionMethod", n.getMethodName(), n.getName(), c.getName());
                    }
                    this.fmapper.mapFunction(n.getPrefix() + ':' + n.getName(), method);
                }
            }
            el.visit(new MapperELVisitor(this, fmapper));
            return fmapper;
        }

        static /* synthetic */ String access$100(ValidateVisitor x0, String x1, Node x2) {
            return x0.findUri(x1, x2);
        }

        static /* synthetic */ PageInfo access$200(ValidateVisitor x0) {
            return x0.pageInfo;
        }

        static /* synthetic */ ErrorDispatcher access$300(ValidateVisitor x0) {
            return x0.err;
        }

        static /* synthetic */ HashMap access$400(ValidateVisitor x0) {
            return x0.taglibs;
        }

        static /* synthetic */ void access$500(ValidateVisitor x0, ELNode.Function x1) throws JasperException {
            x0.processSignature(x1);
        }

        static /* synthetic */ ClassLoader access$600(ValidateVisitor x0) {
            return x0.loader;
        }

        private static class NamedAttributeVisitor
        extends Node.Visitor {
            private boolean hasDynamicContent;

            private NamedAttributeVisitor() {
            }

            public void doVisit(Node n) throws JasperException {
                if (!(n instanceof Node.JspText) && !(n instanceof Node.TemplateText)) {
                    this.hasDynamicContent = true;
                }
                this.visitBody(n);
            }

            public boolean hasDynamicContent() {
                return this.hasDynamicContent;
            }
        }
    }

    static class DirectiveVisitor
    extends Node.Visitor {
        private PageInfo pageInfo;
        private ErrorDispatcher err;
        private static final JspUtil.ValidAttribute[] pageDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("language"), new JspUtil.ValidAttribute("extends"), new JspUtil.ValidAttribute("import"), new JspUtil.ValidAttribute("session"), new JspUtil.ValidAttribute("buffer"), new JspUtil.ValidAttribute("autoFlush"), new JspUtil.ValidAttribute("isThreadSafe"), new JspUtil.ValidAttribute("info"), new JspUtil.ValidAttribute("errorPage"), new JspUtil.ValidAttribute("isErrorPage"), new JspUtil.ValidAttribute("contentType"), new JspUtil.ValidAttribute("pageEncoding"), new JspUtil.ValidAttribute("isELIgnored")};
        private boolean languageSeen = false;
        private boolean extendsSeen = false;
        private boolean sessionSeen = false;
        private boolean bufferSeen = false;
        private boolean autoFlushSeen = false;
        private boolean isThreadSafeSeen = false;
        private boolean errorPageSeen = false;
        private boolean isErrorPageSeen = false;
        private boolean contentTypeSeen = false;
        private boolean infoSeen = false;
        private boolean pageEncodingSeen = false;

        DirectiveVisitor(Compiler compiler) throws JasperException {
            this.pageInfo = compiler.getPageInfo();
            this.err = compiler.getErrorDispatcher();
            JspCompilationContext jspCompilationContext = compiler.getCompilationContext();
        }

        public void visit(Node.IncludeDirective n) throws JasperException {
            boolean pageEncodingSeenSave = this.pageEncodingSeen;
            this.pageEncodingSeen = false;
            this.visitBody(n);
            this.pageEncodingSeen = pageEncodingSeenSave;
        }

        public void visit(Node.PageDirective n) throws JasperException {
            JspUtil.checkAttributes("Page directive", n, pageDirectiveAttrs, this.err);
            Attributes attrs = n.getAttributes();
            int i = 0;
            while (attrs != null && i < attrs.getLength()) {
                String attr = attrs.getQName(i);
                String value = attrs.getValue(i);
                if ("language".equals(attr)) {
                    if (this.languageSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.language");
                    }
                    this.languageSeen = true;
                    if (!"java".equalsIgnoreCase(value)) {
                        this.err.jspError(n, "jsp.error.language.nonjava");
                    }
                    this.pageInfo.setLanguage(value);
                } else if ("extends".equals(attr)) {
                    if (this.extendsSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.extends");
                    }
                    this.extendsSeen = true;
                    this.pageInfo.setExtends(value);
                    if (value.indexOf(46) < 0) {
                        n.addImport(value);
                    }
                } else if ("contentType".equals(attr)) {
                    if (this.contentTypeSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.contenttypes");
                    }
                    this.contentTypeSeen = true;
                    this.pageInfo.setContentType(value);
                } else if ("session".equals(attr)) {
                    if (this.sessionSeen) {
                        this.err.jspError(n, "jsp.error.session.multiple");
                    }
                    this.sessionSeen = true;
                    if ("true".equalsIgnoreCase(value)) {
                        this.pageInfo.setSession(true);
                    } else if ("false".equalsIgnoreCase(value)) {
                        this.pageInfo.setSession(false);
                    } else {
                        this.err.jspError(n, "jsp.error.session.invalid");
                    }
                } else if ("buffer".equals(attr)) {
                    if (this.bufferSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.buffer");
                    }
                    this.bufferSeen = true;
                    if ("none".equalsIgnoreCase(value)) {
                        this.pageInfo.setBuffer(0);
                    } else {
                        if (value == null || !value.endsWith("kb")) {
                            this.err.jspError(n, "jsp.error.buffer.invalid");
                        }
                        try {
                            Integer k = new Integer(value.substring(0, value.length() - 2));
                            this.pageInfo.setBuffer(k * 1024);
                        }
                        catch (NumberFormatException e) {
                            this.err.jspError(n, "jsp.error.buffer.invalid");
                        }
                    }
                } else if ("autoFlush".equals(attr)) {
                    if (this.autoFlushSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.autoflush");
                    }
                    this.autoFlushSeen = true;
                    if ("true".equalsIgnoreCase(value)) {
                        this.pageInfo.setAutoFlush(true);
                    } else if ("false".equalsIgnoreCase(value)) {
                        this.pageInfo.setAutoFlush(false);
                    } else {
                        this.err.jspError(n, "jsp.error.autoFlush.invalid");
                    }
                } else if ("isThreadSafe".equals(attr)) {
                    if (this.isThreadSafeSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.threadsafe");
                    }
                    this.isThreadSafeSeen = true;
                    if ("true".equalsIgnoreCase(value)) {
                        this.pageInfo.setThreadSafe(true);
                    } else if ("false".equalsIgnoreCase(value)) {
                        this.pageInfo.setThreadSafe(false);
                    } else {
                        this.err.jspError(n, "jsp.error.isThreadSafe.invalid");
                    }
                } else if ("isELIgnored".equals(attr)) {
                    if (!this.pageInfo.isELIgnoredSpecified()) {
                        if ("true".equalsIgnoreCase(value)) {
                            this.pageInfo.setELIgnored(true);
                        } else if ("false".equalsIgnoreCase(value)) {
                            this.pageInfo.setELIgnored(false);
                        } else {
                            this.err.jspError(n, "jsp.error.isELIgnored.invalid");
                        }
                    }
                } else if ("isErrorPage".equals(attr)) {
                    if (this.isErrorPageSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.iserrorpage");
                    }
                    this.isErrorPageSeen = true;
                    if ("true".equalsIgnoreCase(value)) {
                        this.pageInfo.setIsErrorPage(true);
                    } else if ("false".equalsIgnoreCase(value)) {
                        this.pageInfo.setIsErrorPage(false);
                    } else {
                        this.err.jspError(n, "jsp.error.isErrorPage.invalid");
                    }
                } else if ("errorPage".equals(attr)) {
                    if (this.errorPageSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.errorpage");
                    }
                    this.errorPageSeen = true;
                    this.pageInfo.setErrorPage(value);
                } else if ("info".equals(attr)) {
                    if (this.infoSeen) {
                        this.err.jspError(n, "jsp.error.info.multiple");
                    }
                    this.infoSeen = true;
                } else if ("pageEncoding".equals(attr)) {
                    if (this.pageEncodingSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.pageencoding");
                    }
                    this.pageEncodingSeen = true;
                    this.comparePageEncodings(value, n);
                }
                ++i;
            }
            if (this.pageInfo.getBuffer() == 0 && !this.pageInfo.isAutoFlush()) {
                this.err.jspError(n, "jsp.error.page.badCombo");
            }
            this.pageInfo.addImports(n.getImports());
        }

        public void visit(Node.TagDirective n) throws JasperException {
            Attributes attrs = n.getAttributes();
            int i = 0;
            while (attrs != null && i < attrs.getLength()) {
                String attr = attrs.getQName(i);
                String value = attrs.getValue(i);
                if ("language".equals(attr)) {
                    if (this.languageSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.language");
                    }
                    this.languageSeen = true;
                    if (!"java".equalsIgnoreCase(value)) {
                        this.err.jspError(n, "jsp.error.language.nonjava");
                    }
                    this.pageInfo.setLanguage(value);
                } else if ("isELIgnored".equals(attr)) {
                    if (!this.pageInfo.isELIgnoredSpecified()) {
                        if ("true".equalsIgnoreCase(value)) {
                            this.pageInfo.setELIgnored(true);
                        } else if ("false".equalsIgnoreCase(value)) {
                            this.pageInfo.setELIgnored(false);
                        } else {
                            this.err.jspError(n, "jsp.error.isELIgnored.invalid");
                        }
                    }
                } else if ("pageEncoding".equals(attr)) {
                    if (this.pageEncodingSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.pageencoding");
                    }
                    this.pageEncodingSeen = true;
                    n.getRoot().setPageEncoding(value);
                }
                ++i;
            }
            this.pageInfo.addImports(n.getImports());
        }

        public void visit(Node.AttributeDirective n) throws JasperException {
        }

        public void visit(Node.VariableDirective n) throws JasperException {
        }

        private void comparePageEncodings(String pageDirEnc, Node.PageDirective n) throws JasperException {
            String pageEnc;
            String configEnc = n.getRoot().getJspConfigPageEncoding();
            if (!(configEnc == null || pageDirEnc.equals(configEnc) || pageDirEnc.startsWith("UTF-16") && configEnc.startsWith("UTF-16"))) {
                this.err.jspError((Node)n, "jsp.error.config_pagedir_encoding_mismatch", configEnc, pageDirEnc);
            }
            if (!(!n.getRoot().isXmlSyntax() || !n.getRoot().isEncodingSpecifiedInProlog() || pageDirEnc.equals(pageEnc = n.getRoot().getPageEncoding()) || pageDirEnc.startsWith("UTF-16") && pageEnc.startsWith("UTF-16"))) {
                this.err.jspError((Node)n, "jsp.error.prolog_pagedir_encoding_mismatch", pageEnc, pageDirEnc);
            }
        }
    }
}

