/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;

public class TldLocationsCache {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$jasper$compiler$TldLocationsCache == null ? (class$org$apache$jasper$compiler$TldLocationsCache = TldLocationsCache.class$("org.apache.jasper.compiler.TldLocationsCache")) : class$org$apache$jasper$compiler$TldLocationsCache));
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String FILE_PROTOCOL = "file:";
    private static final String JAR_FILE_SUFFIX = ".jar";
    private Hashtable mappings;
    private boolean initialized;
    private ServletContext ctxt;
    private boolean redeployMode;
    static /* synthetic */ Class class$org$apache$jasper$compiler$TldLocationsCache;

    public TldLocationsCache(ServletContext ctxt) {
        this(ctxt, false);
    }

    public TldLocationsCache(ServletContext ctxt, boolean redeployMode) {
        this.ctxt = ctxt;
        this.redeployMode = redeployMode;
        this.mappings = new Hashtable();
        this.initialized = false;
    }

    public String[] getLocation(String uri) throws JasperException {
        if (!this.initialized) {
            this.init();
        }
        return (String[])this.mappings.get(uri);
    }

    public static int uriType(String uri) {
        if (uri.indexOf(58) != -1) {
            return 0;
        }
        if (uri.startsWith("/")) {
            return 1;
        }
        return 2;
    }

    private void init() throws JasperException {
        if (this.initialized) {
            return;
        }
        try {
            this.processWebDotXml();
            this.processJars();
            this.processTldsInFileSystem("/WEB-INF/");
            this.processTldsInGlobalJars();
            this.initialized = true;
        }
        catch (Exception ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.internal.tldinit", ex.getMessage()));
        }
    }

    private void processWebDotXml() throws Exception {
        InputStream is = this.ctxt.getResourceAsStream(WEB_XML);
        if (is == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)Localizer.getMessage("jsp.error.internal.filenotfound", WEB_XML));
            }
            return;
        }
        TreeNode webtld = new ParserUtils().parseXMLDocument(WEB_XML, is);
        TreeNode jspConfig = webtld.findChild("jsp-config");
        if (jspConfig != null) {
            webtld = jspConfig;
        }
        Iterator taglibs = webtld.findChildren("taglib");
        while (taglibs.hasNext()) {
            TreeNode taglib = (TreeNode)taglibs.next();
            String tagUri = null;
            String tagLoc = null;
            TreeNode child = taglib.findChild("taglib-uri");
            if (child != null) {
                tagUri = child.getBody();
            }
            if ((child = taglib.findChild("taglib-location")) != null) {
                tagLoc = child.getBody();
            }
            if (tagLoc == null) continue;
            if (TldLocationsCache.uriType(tagLoc) == 2) {
                tagLoc = "/WEB-INF/" + tagLoc;
            }
            String tagLoc2 = null;
            if (tagLoc.endsWith(JAR_FILE_SUFFIX)) {
                tagLoc = this.ctxt.getResource(tagLoc).toString();
                tagLoc2 = "META-INF/taglib.tld";
            }
            this.mappings.put(tagUri, new String[]{tagLoc, tagLoc2});
        }
    }

    private void processJars() throws Exception {
        Set libSet = this.ctxt.getResourcePaths("/WEB-INF/lib");
        if (libSet != null) {
            Iterator it = libSet.iterator();
            while (it.hasNext()) {
                String resourcePath = (String)it.next();
                if (!resourcePath.endsWith(JAR_FILE_SUFFIX)) continue;
                URL url = this.ctxt.getResource(resourcePath);
                if (url == null) {
                    return;
                }
                URL jarURL = new URL("jar:" + url.toString() + "!/");
                this.processTldsInJar((JarURLConnection)jarURL.openConnection(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTldsInJar(JarURLConnection conn, boolean ignore) throws JasperException {
        JarFile jarFile = null;
        String resourcePath = conn.getJarFileURL().toString();
        try {
            if (this.redeployMode) {
                conn.setUseCaches(false);
            }
            jarFile = conn.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                Throwable t2;
                Object var11_14;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
                InputStream stream = jarFile.getInputStream(entry);
                try {
                    String uri = this.getUriFromTld(resourcePath, stream);
                    if (uri != null && this.mappings.get(uri) == null) {
                        this.mappings.put(uri, new String[]{resourcePath, name});
                    }
                    var11_14 = null;
                    if (stream == null) continue;
                }
                catch (Throwable throwable) {
                    var11_14 = null;
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable t2) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (Throwable t2) {}
            }
        }
        catch (Exception ex) {
            if (!this.redeployMode && jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (!ignore) {
                throw new JasperException((Throwable)ex);
            }
        }
        finally {
            if (this.redeployMode && jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processTldsInFileSystem(String startPath) throws Exception {
        Set dirList = this.ctxt.getResourcePaths(startPath);
        if (dirList == null) return;
        Iterator it = dirList.iterator();
        while (true) {
            String uri;
            String path;
            block8: {
                Throwable t2;
                Object var8_7;
                if (!it.hasNext()) {
                    return;
                }
                path = (String)it.next();
                if (path.endsWith("/")) {
                    this.processTldsInFileSystem(path);
                }
                if (!path.endsWith(".tld")) continue;
                InputStream stream = this.ctxt.getResourceAsStream(path);
                uri = null;
                try {
                    uri = this.getUriFromTld(path, stream);
                    var8_7 = null;
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Throwable t2) {}
                stream.close();
            }
            if (uri == null || this.mappings.get(uri) != null) continue;
            this.mappings.put(uri, new String[]{path, null});
        }
    }

    private String getUriFromTld(String resourcePath, InputStream in) throws JasperException {
        String body;
        TreeNode tld = new ParserUtils().parseXMLDocument(resourcePath, in);
        TreeNode uri = tld.findChild("uri");
        if (uri != null && (body = uri.getBody()) != null) {
            return body;
        }
        return null;
    }

    private void processTldsInGlobalJars() throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        while (loader != null) {
            if (loader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)loader).getURLs();
                int i = 0;
                while (i < urls.length) {
                    URLConnection conn = urls[i].openConnection();
                    if (conn instanceof JarURLConnection) {
                        this.processTldsInJar((JarURLConnection)conn, true);
                    } else {
                        String urlStr = urls[i].toString();
                        if (urlStr.startsWith(FILE_PROTOCOL) && urlStr.endsWith(JAR_FILE_SUFFIX)) {
                            URL jarURL = new URL("jar:" + urlStr + "!/");
                            this.processTldsInJar((JarURLConnection)jarURL.openConnection(), true);
                        }
                    }
                    ++i;
                }
            }
            loader = loader.getParent();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

