/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarFile;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JasperTagInfo;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.servlet.JspServletWrapper;

class TagFileProcessor {
    private Vector tempVector;

    TagFileProcessor() {
    }

    public static TagInfo parseTagFileDirectives(ParserController pc, String name, String path, TagLibraryInfo tagLibInfo) throws JasperException {
        ErrorDispatcher err = pc.getCompiler().getErrorDispatcher();
        Node.Nodes page = null;
        try {
            page = pc.parseTagFileDirectives(path);
        }
        catch (FileNotFoundException e) {
            err.jspError("jsp.error.file.not.found", path);
        }
        catch (IOException e) {
            err.jspError("jsp.error.file.not.found", path);
        }
        TagFileDirectiveVisitor tagFileVisitor = new TagFileDirectiveVisitor(pc.getCompiler(), tagLibInfo, name, path);
        page.visit(tagFileVisitor);
        Iterator attrsIter = tagFileVisitor.getAttributesVector().iterator();
        while (attrsIter.hasNext()) {
            TagAttributeInfo attrInfo = (TagAttributeInfo)attrsIter.next();
            Iterator varsIter = tagFileVisitor.getVariablesVector().iterator();
            while (varsIter.hasNext()) {
                TagVariableInfo varInfo = (TagVariableInfo)varsIter.next();
                String attrName = attrInfo.getName();
                if (!attrName.equals(varInfo.getNameGiven())) continue;
                err.jspError("jsp.error.tagfile.var_name_given_equals_attr_name", path, attrName);
            }
        }
        Iterator varsIter = tagFileVisitor.getVariablesVector().iterator();
        while (varsIter.hasNext()) {
            TagVariableInfo varsInfo = (TagVariableInfo)varsIter.next();
            if (varsInfo.getNameFromAttribute() == null) continue;
            String nameGiven = varsInfo.getNameGiven();
            Iterator varsIter2 = tagFileVisitor.getVariablesVector().iterator();
            while (varsIter2.hasNext()) {
                TagVariableInfo varsInfo2 = (TagVariableInfo)varsIter2.next();
                if (varsInfo2.getNameFromAttribute() != null || !nameGiven.equals(varsInfo2.getNameGiven())) continue;
                err.jspError("jsp.error.tagfile.nameGiven_equals.alias", path, nameGiven);
            }
        }
        TagFileProcessor.checkDynamicAttributesUniqueness(tagFileVisitor, path, err);
        return tagFileVisitor.getTagInfo();
    }

    private static void checkDynamicAttributesUniqueness(TagFileDirectiveVisitor tfv, String path, ErrorDispatcher err) throws JasperException {
        String dynamicAttrsMapName = tfv.getDynamicAttributesMapName();
        if (dynamicAttrsMapName == null) {
            return;
        }
        Iterator attrs = tfv.getAttributesVector().iterator();
        while (attrs.hasNext()) {
            TagAttributeInfo attrInfo = (TagAttributeInfo)attrs.next();
            if (!dynamicAttrsMapName.equals(attrInfo.getName())) continue;
            err.jspError("jsp.error.tagfile.tag_dynamic_attrs_equals_attr_name", path, dynamicAttrsMapName);
        }
        Iterator vars = tfv.getVariablesVector().iterator();
        while (vars.hasNext()) {
            TagVariableInfo varInfo = (TagVariableInfo)vars.next();
            if (!dynamicAttrsMapName.equals(varInfo.getNameGiven())) continue;
            err.jspError("jsp.error.tagfile.tag_dynamic_attrs_equals_var_name_given", path, dynamicAttrsMapName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadTagFile(Compiler compiler, String tagFilePath, TagInfo tagInfo, PageInfo parentPageInfo) throws JasperException {
        JspCompilationContext ctxt = compiler.getCompilationContext();
        JspRuntimeContext rctxt = ctxt.getRuntimeContext();
        JspServletWrapper wrapper = rctxt.getWrapper(tagFilePath);
        JspRuntimeContext jspRuntimeContext = rctxt;
        synchronized (jspRuntimeContext) {
            Iterator iter;
            Class tagClazz;
            if (wrapper == null) {
                wrapper = new JspServletWrapper(ctxt.getServletContext(), ctxt.getOptions(), tagFilePath, tagInfo, ctxt.getRuntimeContext(), (JarFile)ctxt.getTagFileJars().get(tagFilePath));
                rctxt.addWrapper(tagFilePath, wrapper);
                wrapper.getJspEngineContext().setClassLoader((URLClassLoader)ctxt.getClassLoader());
                wrapper.getJspEngineContext().setClassPath(ctxt.getClassPath());
            }
            int tripCount = wrapper.incTripCount();
            try {
                if (tripCount > 0) {
                    JspServletWrapper tempWrapper = new JspServletWrapper(ctxt.getServletContext(), ctxt.getOptions(), tagFilePath, tagInfo, ctxt.getRuntimeContext(), (JarFile)ctxt.getTagFileJars().get(tagFilePath));
                    tagClazz = tempWrapper.loadTagFilePrototype();
                    this.tempVector.add(tempWrapper.getJspEngineContext().getCompiler());
                } else {
                    tagClazz = wrapper.loadTagFile();
                }
                Object var13_12 = null;
                wrapper.decTripCount();
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                wrapper.decTripCount();
                throw throwable;
            }
            PageInfo pageInfo = wrapper.getJspEngineContext().getCompiler().getPageInfo();
            if (pageInfo != null && (iter = pageInfo.getDependants().iterator()).hasNext()) {
                parentPageInfo.addDependant((String)iter.next());
            }
            return tagClazz;
        }
    }

    public void loadTagFiles(Compiler compiler, Node.Nodes page) throws JasperException {
        this.tempVector = new Vector();
        page.visit(new TagFileLoaderVisitor(compiler));
    }

    public void removeProtoTypeFiles(String classFileName) {
        Iterator iter = this.tempVector.iterator();
        while (iter.hasNext()) {
            Compiler c = (Compiler)iter.next();
            if (classFileName == null) {
                c.removeGeneratedClassFiles();
                continue;
            }
            if (!classFileName.equals(c.getCompilationContext().getClassFileName())) continue;
            c.removeGeneratedClassFiles();
            this.tempVector.remove(c);
            return;
        }
    }

    private class TagFileLoaderVisitor
    extends Node.Visitor {
        private Compiler compiler;
        private PageInfo pageInfo;

        TagFileLoaderVisitor(Compiler compiler) {
            this.compiler = compiler;
            this.pageInfo = compiler.getPageInfo();
        }

        public void visit(Node.CustomTag n) throws JasperException {
            TagFileInfo tagFileInfo = n.getTagFileInfo();
            if (tagFileInfo != null) {
                String tagFilePath = tagFileInfo.getPath();
                JspCompilationContext ctxt = this.compiler.getCompilationContext();
                if (ctxt.getTagFileJars().get(tagFilePath) == null) {
                    this.pageInfo.addDependant(tagFilePath);
                }
                Class c = TagFileProcessor.this.loadTagFile(this.compiler, tagFilePath, n.getTagInfo(), this.pageInfo);
                n.setTagHandlerClass(c);
            }
            this.visitBody(n);
        }
    }

    private static class TagFileDirectiveVisitor
    extends Node.Visitor {
        private static final JspUtil.ValidAttribute[] tagDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("display-name"), new JspUtil.ValidAttribute("body-content"), new JspUtil.ValidAttribute("dynamic-attributes"), new JspUtil.ValidAttribute("small-icon"), new JspUtil.ValidAttribute("large-icon"), new JspUtil.ValidAttribute("description"), new JspUtil.ValidAttribute("example"), new JspUtil.ValidAttribute("pageEncoding"), new JspUtil.ValidAttribute("language"), new JspUtil.ValidAttribute("import"), new JspUtil.ValidAttribute("isELIgnored")};
        private static final JspUtil.ValidAttribute[] attributeDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("required"), new JspUtil.ValidAttribute("fragment"), new JspUtil.ValidAttribute("rtexprvalue"), new JspUtil.ValidAttribute("type"), new JspUtil.ValidAttribute("description")};
        private static final JspUtil.ValidAttribute[] variableDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name-given"), new JspUtil.ValidAttribute("name-from-attribute"), new JspUtil.ValidAttribute("alias"), new JspUtil.ValidAttribute("variable-class"), new JspUtil.ValidAttribute("scope"), new JspUtil.ValidAttribute("declare"), new JspUtil.ValidAttribute("description")};
        private ErrorDispatcher err;
        private TagLibraryInfo tagLibInfo;
        private String name = null;
        private String path = null;
        private TagExtraInfo tei = null;
        private String bodycontent = null;
        private String description = null;
        private String displayName = null;
        private String smallIcon = null;
        private String largeIcon = null;
        private String dynamicAttrsMapName;
        private Vector attributeVector;
        private Vector variableVector;

        public TagFileDirectiveVisitor(Compiler compiler, TagLibraryInfo tagLibInfo, String name, String path) {
            this.err = compiler.getErrorDispatcher();
            this.tagLibInfo = tagLibInfo;
            this.name = name;
            this.path = path;
            this.attributeVector = new Vector();
            this.variableVector = new Vector();
        }

        public void visit(Node.TagDirective n) throws JasperException {
            JspUtil.checkAttributes("Tag directive", n, tagDirectiveAttrs, this.err);
            this.bodycontent = n.getAttributeValue("body-content");
            if (!(this.bodycontent == null || this.bodycontent.equalsIgnoreCase("EMPTY") || this.bodycontent.equalsIgnoreCase("TAGDEPENDENT") || this.bodycontent.equalsIgnoreCase("SCRIPTLESS"))) {
                this.err.jspError(n, "jsp.error.tagdirective.badbodycontent", this.bodycontent);
            }
            this.dynamicAttrsMapName = n.getAttributeValue("dynamic-attributes");
            this.smallIcon = n.getAttributeValue("small-icon");
            this.largeIcon = n.getAttributeValue("large-icon");
            this.description = n.getAttributeValue("description");
            this.displayName = n.getAttributeValue("display-name");
        }

        public void visit(Node.AttributeDirective n) throws JasperException {
            JspUtil.checkAttributes("Attribute directive", n, attributeDirectiveAttrs, this.err);
            String attrName = n.getAttributeValue("name");
            boolean required = JspUtil.booleanValue(n.getAttributeValue("required"));
            boolean rtexprvalue = true;
            String rtexprvalueString = n.getAttributeValue("rtexprvalue");
            if (rtexprvalueString != null) {
                rtexprvalue = JspUtil.booleanValue(rtexprvalueString);
            }
            boolean fragment = JspUtil.booleanValue(n.getAttributeValue("fragment"));
            String type = n.getAttributeValue("type");
            if (fragment) {
                if (type != null) {
                    this.err.jspError(n, "jsp.error.fragmentwithtype");
                }
                rtexprvalue = true;
                if (rtexprvalueString != null) {
                    this.err.jspError(n, "jsp.error.frgmentwithrtexprvalue");
                }
            } else if (type == null) {
                type = "java.lang.String";
            }
            this.attributeVector.addElement(new TagAttributeInfo(attrName, required, type, rtexprvalue, fragment));
        }

        public void visit(Node.VariableDirective n) throws JasperException {
            String className;
            JspUtil.checkAttributes("Variable directive", n, variableDirectiveAttrs, this.err);
            String nameGiven = n.getAttributeValue("name-given");
            String nameFromAttribute = n.getAttributeValue("name-from-attribute");
            if (nameGiven == null && nameFromAttribute == null) {
                this.err.jspError("jsp.variable.either.name");
            }
            if (nameGiven != null && nameFromAttribute != null) {
                this.err.jspError("jsp.variable.both.name");
            }
            String alias = n.getAttributeValue("alias");
            if (nameFromAttribute != null && alias == null || nameFromAttribute == null && alias != null) {
                this.err.jspError("jsp.variable.alias");
            }
            if ((className = n.getAttributeValue("variable-class")) == null) {
                className = "java.lang.String";
            }
            String declareStr = n.getAttributeValue("declare");
            boolean declare = true;
            if (declareStr != null) {
                declare = JspUtil.booleanValue(declareStr);
            }
            int scope = 0;
            String scopeStr = n.getAttributeValue("scope");
            if (scopeStr != null && !"NESTED".equals(scopeStr)) {
                if ("AT_BEGIN".equals(scopeStr)) {
                    scope = 1;
                } else if ("AT_END".equals(scopeStr)) {
                    scope = 2;
                }
            }
            if (nameFromAttribute != null) {
                nameGiven = alias;
            }
            this.variableVector.addElement(new TagVariableInfo(nameGiven, nameFromAttribute, className, declare, scope));
        }

        public Vector getAttributesVector() {
            return this.attributeVector;
        }

        public Vector getVariablesVector() {
            return this.variableVector;
        }

        public String getDynamicAttributesMapName() {
            return this.dynamicAttrsMapName;
        }

        public TagInfo getTagInfo() throws JasperException {
            if (this.name == null) {
                // empty if block
            }
            if (this.bodycontent == null) {
                this.bodycontent = "SCRIPTLESS";
            }
            String tagClassName = JspUtil.getTagHandlerClassName(this.path, this.err);
            Object[] tagVariableInfos = new TagVariableInfo[this.variableVector.size()];
            this.variableVector.copyInto(tagVariableInfos);
            Object[] tagAttributeInfo = new TagAttributeInfo[this.attributeVector.size()];
            this.attributeVector.copyInto(tagAttributeInfo);
            return new JasperTagInfo(this.name, tagClassName, this.bodycontent, this.description, this.tagLibInfo, this.tei, (TagAttributeInfo[])tagAttributeInfo, this.displayName, this.smallIcon, this.largeIcon, (TagVariableInfo[])tagVariableInfos, this.dynamicAttrsMapName);
        }
    }
}

