/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.ImplicitTagLibraryInfo;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.TagConstants;
import org.apache.jasper.compiler.TagLibraryInfoImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

class JspDocumentParser
extends DefaultHandler
implements LexicalHandler,
TagConstants {
    private static final String JSP_VERSION = "version";
    private static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private ParserController parserController;
    private JspCompilationContext ctxt;
    private PageInfo pageInfo;
    private InputSource inputSource;
    private String path;
    private Node current;
    private Locator locator;
    private HashMap taglibs;
    private boolean inDTD;
    private ErrorDispatcher err;
    private boolean isTagFile;
    private boolean directivesOnly;
    private boolean isTop;

    public JspDocumentParser(ParserController pc, String path, InputStream inStream, boolean isTagFile, boolean directivesOnly) {
        this.parserController = pc;
        this.ctxt = pc.getJspCompilationContext();
        this.pageInfo = pc.getCompiler().getPageInfo();
        this.taglibs = this.pageInfo.getTagLibraries();
        this.err = pc.getCompiler().getErrorDispatcher();
        this.path = path;
        this.inputSource = new InputSource(inStream);
        this.isTagFile = isTagFile;
        this.directivesOnly = directivesOnly;
        this.isTop = true;
    }

    public static Node.Nodes parse(ParserController pc, String path, InputStream inStream, Node parent, boolean isTagFile, boolean directivesOnly, String pageEnc, String jspConfigPageEnc, boolean isEncodingSpecifiedInProlog) throws JasperException {
        String file;
        JspDocumentParser jspDocParser = new JspDocumentParser(pc, path, inStream, isTagFile, directivesOnly);
        if (!jspDocParser.pageInfo.getIncludePrelude().isEmpty()) {
            file = (String)jspDocParser.pageInfo.getIncludePrelude().get(0);
            jspDocParser.err.jspError("jsp.error.prelude.xml", path, file);
        }
        if (!jspDocParser.pageInfo.getIncludeCoda().isEmpty()) {
            file = (String)jspDocParser.pageInfo.getIncludeCoda().get(0);
            jspDocParser.err.jspError("jsp.error.coda.xml", path, file);
        }
        Node.Nodes pageNodes = null;
        try {
            Node.Root dummyRoot = new Node.Root(null, parent, true);
            dummyRoot.setPageEncoding(pageEnc);
            dummyRoot.setJspConfigPageEncoding(jspConfigPageEnc);
            dummyRoot.setIsEncodingSpecifiedInProlog(isEncodingSpecifiedInProlog);
            jspDocParser.current = dummyRoot;
            if (parent != null) {
                jspDocParser.isTop = false;
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setProperty(LEXICAL_HANDLER_PROPERTY, jspDocParser);
            xmlReader.setErrorHandler(jspDocParser);
            saxParser.parse(jspDocParser.inputSource, (DefaultHandler)jspDocParser);
            pageNodes = new Node.Nodes(dummyRoot);
        }
        catch (IOException ioe) {
            jspDocParser.err.jspError("jsp.error.data.file.read", path, ioe);
        }
        catch (Exception e) {
            jspDocParser.err.jspError(e);
        }
        return pageNodes;
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        AttributesImpl taglibAttrs = null;
        AttributesImpl nonTaglibAttrs = null;
        AttributesImpl nonTaglibXmlnsAttrs = null;
        this.checkPrefixes(uri, qName, attrs);
        if (this.directivesOnly && !localName.startsWith("directive.")) {
            return;
        }
        if ("text".equals(this.current.getLocalName())) {
            throw new SAXParseException(Localizer.getMessage("jsp.error.text.has_subelement"), this.locator);
        }
        Mark start = new Mark(this.path, this.locator.getLineNumber(), this.locator.getColumnNumber());
        if (attrs != null) {
            boolean isTaglib = false;
            int i = attrs.getLength() - 1;
            while (i >= 0) {
                isTaglib = false;
                String attrQName = attrs.getQName(i);
                if (!attrQName.startsWith("xmlns")) {
                    if (nonTaglibAttrs == null) {
                        nonTaglibAttrs = new AttributesImpl();
                    }
                    nonTaglibAttrs.addAttribute(attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getType(i), attrs.getValue(i));
                } else {
                    if (attrQName.startsWith("xmlns:jsp")) {
                        isTaglib = true;
                    } else {
                        String attrUri = attrs.getValue(i);
                        if (!this.taglibs.containsKey(attrUri)) {
                            TagLibraryInfo tagLibInfo = null;
                            try {
                                tagLibInfo = this.getTaglibInfo(attrQName, attrUri);
                            }
                            catch (JasperException je) {
                                throw new SAXParseException(Localizer.getMessage("jsp.error.could.not.add.taglibraries"), this.locator, (Exception)((Object)je));
                            }
                            if (tagLibInfo != null) {
                                isTaglib = true;
                            }
                            this.taglibs.put(attrUri, tagLibInfo);
                        }
                    }
                    if (isTaglib) {
                        if (taglibAttrs == null) {
                            taglibAttrs = new AttributesImpl();
                        }
                        taglibAttrs.addAttribute(attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getType(i), attrs.getValue(i));
                    } else {
                        if (nonTaglibXmlnsAttrs == null) {
                            nonTaglibXmlnsAttrs = new AttributesImpl();
                        }
                        nonTaglibXmlnsAttrs.addAttribute(attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getType(i), attrs.getValue(i));
                    }
                }
                --i;
            }
        }
        Node node = null;
        if ("http://java.sun.com/JSP/Page".equals(uri)) {
            node = this.parseStandardAction(qName, localName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else {
            node = this.parseCustomAction(qName, localName, uri, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
            if (node == null) {
                node = new Node.UninterpretedTag(qName, localName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
            }
        }
        this.current = node;
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        boolean isAllSpace = true;
        if (!(this.current instanceof Node.JspText) && !(this.current instanceof Node.NamedAttribute)) {
            int i = offset;
            while (i < offset + len) {
                if (buf[i] != ' ' && buf[i] != '\n' && buf[i] != '\r' && buf[i] != '\t') {
                    isAllSpace = false;
                    break;
                }
                ++i;
            }
        }
        if (this.current instanceof Node.JspText || this.current instanceof Node.NamedAttribute || !isAllSpace) {
            Mark start = new Mark(this.path, this.locator.getLineNumber(), this.locator.getColumnNumber());
            CharArrayWriter ttext = new CharArrayWriter();
            int limit = offset + len;
            int lastCh = 0;
            int i = offset;
            while (i < limit) {
                int ch;
                block19: {
                    ch = buf[i];
                    if (lastCh == 36 && ch == 123) {
                        if (ttext.size() > 0) {
                            new Node.TemplateText(ttext.toString(), start, this.current);
                            ttext = new CharArrayWriter();
                        }
                        ++i;
                        boolean singleQ = false;
                        boolean doubleQ = false;
                        lastCh = 0;
                        while (true) {
                            if (i >= limit) {
                                throw new SAXParseException(Localizer.getMessage("jsp.error.unterminated", "${"), this.locator);
                            }
                            ch = buf[i];
                            if (lastCh == 92 && (singleQ || doubleQ)) {
                                ttext.write(ch);
                                lastCh = 0;
                            } else {
                                if (ch == 125) {
                                    new Node.ELExpression(ttext.toString(), start, this.current);
                                    ttext = new CharArrayWriter();
                                    break block19;
                                }
                                if (ch == 34) {
                                    doubleQ = !doubleQ;
                                } else if (ch == 39) {
                                    singleQ = !singleQ;
                                }
                                ttext.write(ch);
                                lastCh = ch;
                            }
                            ++i;
                        }
                    }
                    if (lastCh == 36 && ch != 123) {
                        ttext.write(36);
                    }
                    if (ch != 36) {
                        ttext.write(ch);
                    }
                }
                lastCh = ch;
                ++i;
            }
            if (lastCh == 36) {
                ttext.write(36);
            }
            if (ttext.size() > 0) {
                new Node.TemplateText(ttext.toString(), start, this.current);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.directivesOnly && !localName.startsWith("directive.")) {
            return;
        }
        if (this.current instanceof Node.NamedAttribute) {
            boolean isTrim = ((Node.NamedAttribute)this.current).isTrim();
            Node.Nodes subElems = ((Node.NamedAttribute)this.current).getBody();
            int i = 0;
            while (subElems != null && i < subElems.size()) {
                Node subElem = subElems.getNode(i);
                if (subElem instanceof Node.TemplateText) {
                    if (i == 0) {
                        if (isTrim) {
                            ((Node.TemplateText)subElem).ltrim();
                        }
                    } else if (i == subElems.size() - 1) {
                        if (isTrim) {
                            ((Node.TemplateText)subElem).rtrim();
                        }
                    } else if (((Node.TemplateText)subElem).isAllSpace()) {
                        subElems.remove(subElem);
                    }
                }
                ++i;
            }
        } else if (this.current instanceof Node.ScriptingElement) {
            this.checkScriptingBody((Node.ScriptingElement)this.current);
        }
        if (this.current.getParent() != null) {
            this.current = this.current.getParent();
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void comment(char[] buf, int offset, int len) throws SAXException {
        if (!this.inDTD) {
            Mark start = new Mark(this.path, this.locator.getLineNumber(), this.locator.getColumnNumber());
            new Node.Comment(new String(buf, offset, len), start, this.current);
        }
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.inDTD = true;
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    private Node parseStandardAction(String qName, String localName, Attributes nonTaglibAttrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) throws SAXException {
        Node node = null;
        if (localName.equals("root")) {
            node = new Node.JspRoot(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
            if (this.isTop) {
                this.pageInfo.setHasJspRoot(true);
            }
        } else if (localName.equals("directive.page")) {
            if (this.isTagFile) {
                throw new SAXParseException(Localizer.getMessage("jsp.error.action.istagfile", localName), this.locator);
            }
            node = new Node.PageDirective(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
            String imports = nonTaglibAttrs.getValue("import");
            if (imports != null) {
                ((Node.PageDirective)node).addImport(imports);
            }
        } else if (localName.equals("directive.include")) {
            node = new Node.IncludeDirective(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
            this.processIncludeDirective(nonTaglibAttrs.getValue("file"), node);
        } else if (localName.equals("declaration")) {
            node = new Node.Declaration(qName, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("scriptlet")) {
            node = new Node.Scriptlet(qName, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("expression")) {
            node = new Node.Expression(qName, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("useBean")) {
            node = new Node.UseBean(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("setProperty")) {
            node = new Node.SetProperty(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("getProperty")) {
            node = new Node.GetProperty(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("include")) {
            node = new Node.IncludeAction(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("forward")) {
            node = new Node.ForwardAction(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("param")) {
            node = new Node.ParamAction(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("params")) {
            node = new Node.ParamsAction(qName, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("plugin")) {
            node = new Node.PlugIn(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("text")) {
            node = new Node.JspText(qName, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("body")) {
            node = new Node.JspBody(qName, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("attribute")) {
            node = new Node.NamedAttribute(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("output")) {
            node = new Node.JspOutput(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("directive.tag")) {
            if (!this.isTagFile) {
                throw new SAXParseException(Localizer.getMessage("jsp.error.action.isnottagfile", localName), this.locator);
            }
            node = new Node.TagDirective(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
            String imports = nonTaglibAttrs.getValue("import");
            if (imports != null) {
                ((Node.TagDirective)node).addImport(imports);
            }
        } else if (localName.equals("directive.attribute")) {
            if (!this.isTagFile) {
                throw new SAXParseException(Localizer.getMessage("jsp.error.action.isnottagfile", localName), this.locator);
            }
            node = new Node.AttributeDirective(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("directive.variable")) {
            if (!this.isTagFile) {
                throw new SAXParseException(Localizer.getMessage("jsp.error.action.isnottagfile", localName), this.locator);
            }
            node = new Node.VariableDirective(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("invoke")) {
            if (!this.isTagFile) {
                throw new SAXParseException(Localizer.getMessage("jsp.error.action.isnottagfile", localName), this.locator);
            }
            node = new Node.InvokeAction(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("doBody")) {
            if (!this.isTagFile) {
                throw new SAXParseException(Localizer.getMessage("jsp.error.action.isnottagfile", localName), this.locator);
            }
            node = new Node.DoBodyAction(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("element")) {
            node = new Node.JspElement(qName, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else if (localName.equals("fallback")) {
            node = new Node.FallBackAction(qName, nonTaglibXmlnsAttrs, taglibAttrs, start, this.current);
        } else {
            throw new SAXParseException(Localizer.getMessage("jsp.error.xml.badStandardAction", localName), this.locator);
        }
        return node;
    }

    private Node parseCustomAction(String qName, String localName, String uri, Attributes nonTaglibAttrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) throws SAXException {
        TagLibraryInfo tagLibInfo = (TagLibraryInfo)this.taglibs.get(uri);
        if (tagLibInfo == null) {
            return null;
        }
        TagInfo tagInfo = tagLibInfo.getTag(localName);
        TagFileInfo tagFileInfo = tagLibInfo.getTagFile(localName);
        if (tagInfo == null && tagFileInfo == null) {
            throw new SAXException(Localizer.getMessage("jsp.error.xml.bad_tag", localName, uri));
        }
        Class<?> tagHandlerClass = null;
        if (tagInfo != null) {
            String handlerClassName = tagInfo.getTagClassName();
            try {
                tagHandlerClass = this.ctxt.getClassLoader().loadClass(handlerClassName);
            }
            catch (Exception e) {
                throw new SAXException(Localizer.getMessage("jsp.error.loadclass.taghandler", handlerClassName, qName));
            }
        }
        String prefix = "";
        int colon = qName.indexOf(58);
        if (colon != -1) {
            prefix = qName.substring(0, colon);
        }
        Node.CustomTag ret = null;
        ret = tagInfo != null ? new Node.CustomTag(qName, prefix, localName, uri, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent, tagInfo, tagHandlerClass) : new Node.CustomTag(qName, prefix, localName, uri, nonTaglibAttrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent, tagFileInfo);
        return ret;
    }

    private TagLibraryInfo getTaglibInfo(String qName, String uri) throws JasperException {
        TagLibraryInfo result = null;
        String prefix = "";
        int colon = qName.indexOf(58);
        if (colon != -1) {
            prefix = qName.substring(colon + 1);
        }
        if (uri.startsWith("urn:jsptagdir:")) {
            String tagdir = uri.substring("urn:jsptagdir:".length());
            result = new ImplicitTagLibraryInfo(this.ctxt, this.parserController, prefix, tagdir, this.err);
        } else {
            boolean isPlainUri = false;
            if (uri.startsWith("urn:jsptld:")) {
                uri = uri.substring("urn:jsptld:".length());
            } else {
                isPlainUri = true;
            }
            String[] location = this.ctxt.getTldLocation(uri);
            if (location != null || !isPlainUri) {
                result = new TagLibraryInfoImpl(this.ctxt, this.parserController, prefix, uri, location, this.err);
            }
        }
        return result;
    }

    private void checkScriptingBody(Node.ScriptingElement scriptingElem) throws SAXException {
        Node.Nodes body = scriptingElem.getBody();
        if (body != null) {
            int size = body.size();
            int i = 0;
            while (i < size) {
                Node n = body.getNode(i);
                if (!(n instanceof Node.TemplateText)) {
                    String elemType = "scriptlet";
                    if (scriptingElem instanceof Node.Declaration) {
                        elemType = "declaration";
                    }
                    if (scriptingElem instanceof Node.Expression) {
                        elemType = "expression";
                    }
                    String msg = Localizer.getMessage("jsp.error.parse.xml.scripting.invalid.body", elemType);
                    throw new SAXException(msg);
                }
                ++i;
            }
        }
    }

    private void processIncludeDirective(String fname, Node parent) throws SAXException {
        if (fname == null) {
            return;
        }
        try {
            this.parserController.parse(fname, parent, null);
        }
        catch (FileNotFoundException fnfe) {
            throw new SAXParseException(Localizer.getMessage("jsp.error.file.not.found", fname), this.locator, fnfe);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private void checkPrefixes(String uri, String qName, Attributes attrs) {
        this.checkPrefix(uri, qName);
        int len = attrs.getLength();
        int i = 0;
        while (i < len) {
            this.checkPrefix(attrs.getURI(i), attrs.getQName(i));
            ++i;
        }
    }

    private void checkPrefix(String uri, String qName) {
        int index = qName.indexOf(58);
        if (index != -1) {
            String prefix = qName.substring(0, index);
            this.pageInfo.addPrefix(prefix);
            if ("jsp".equals(prefix) && !"http://java.sun.com/JSP/Page".equals(uri)) {
                this.pageInfo.setIsJspPrefixHijacked(true);
            }
        }
    }
}

