/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.JasperTagInfo;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.xml.sax.Attributes;

class Generator {
    private static final Class[] OBJECT_CLASS = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = Generator.class$("java.lang.Object")) : class$java$lang$Object};
    private ServletWriter out;
    private MethodsBuffer methodsBuffer;
    private FragmentHelperClass fragmentHelperClass;
    private ErrorDispatcher err;
    private BeanRepository beanInfo;
    private JspCompilationContext ctxt;
    private boolean breakAtLF;
    private PageInfo pageInfo;
    private int maxTagNesting;
    private Vector tagHandlerPoolNames;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;

    static String quote(String s) {
        if (s == null) {
            return "null";
        }
        return '\"' + Generator.escape(s) + '\"';
    }

    static String escape(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\"') {
                b.append('\\').append('\"');
            } else if (c == '\\') {
                b.append('\\').append('\\');
            } else if (c == '\n') {
                b.append('\\').append('n');
            } else if (c == '\r') {
                b.append('\\').append('r');
            } else {
                b.append(c);
            }
            ++i;
        }
        return b.toString();
    }

    private void generateDeclarations(Node.Nodes page) throws JasperException {
        this.out.println();
        class DeclarationVisitor
        extends Node.Visitor {
            private final /* synthetic */ Generator this$0;

            DeclarationVisitor(Generator this$0) {
                this.this$0 = this$0;
            }

            public void visit(Node.PageDirective n) throws JasperException {
                String info = n.getAttributeValue("info");
                if (info == null) {
                    return;
                }
                Generator.access$000(this.this$0).printil("public String getServletInfo() {");
                Generator.access$000(this.this$0).pushIndent();
                Generator.access$000(this.this$0).printin("return ");
                Generator.access$000(this.this$0).print(Generator.quote(info));
                Generator.access$000(this.this$0).println(";");
                Generator.access$000(this.this$0).popIndent();
                Generator.access$000(this.this$0).print('}');
                Generator.access$000(this.this$0).println();
            }

            public void visit(Node.Declaration n) throws JasperException {
                Generator.access$000(this.this$0).printMultiLn(new String(n.getText()));
                Generator.access$000(this.this$0).println();
            }

            public void visit(Node.CustomTag n) throws JasperException {
                if (n.useTagPlugin()) {
                    if (n.getAtSTag() != null) {
                        n.getAtSTag().visit(this);
                    }
                    this.visitBody(n);
                    if (n.getAtETag() != null) {
                        n.getAtETag().visit(this);
                    }
                }
            }
        }
        page.visit(new DeclarationVisitor(this));
    }

    private void compileTagHandlerPoolList(Node.Nodes page) throws JasperException {
        class TagHandlerPoolVisitor
        extends Node.Visitor {
            private Vector names;
            private final /* synthetic */ Generator this$0;

            TagHandlerPoolVisitor(Generator this$0, Vector v) {
                this.this$0 = this$0;
                this.names = v;
            }

            public void visit(Node.CustomTag n) throws JasperException {
                if (!n.implementsSimpleTag()) {
                    String name = this.createTagHandlerPoolName(n.getPrefix(), n.getLocalName(), n.getAttributes());
                    n.setTagHandlerPoolName(name);
                    if (!this.names.contains(name)) {
                        this.names.add(name);
                    }
                }
                this.visitBody(n);
            }

            private String createTagHandlerPoolName(String prefix, String shortName, Attributes attrs) {
                String poolName = null;
                if (prefix.indexOf(45) >= 0) {
                    prefix = JspUtil.replace(prefix, '-', "$1");
                }
                if (prefix.indexOf(46) >= 0) {
                    prefix = JspUtil.replace(prefix, '.', "$2");
                }
                if (shortName.indexOf(45) >= 0) {
                    shortName = JspUtil.replace(shortName, '-', "$1");
                }
                if (shortName.indexOf(46) >= 0) {
                    shortName = JspUtil.replace(shortName, '.', "$2");
                }
                if (shortName.indexOf(58) >= 0) {
                    shortName = JspUtil.replace(shortName, ':', "$3");
                }
                poolName = "_jspx_tagPool_" + prefix + "_" + shortName;
                if (attrs != null) {
                    String[] attrNames = new String[attrs.getLength()];
                    int i = 0;
                    while (i < attrNames.length) {
                        attrNames[i] = attrs.getQName(i);
                        ++i;
                    }
                    Arrays.sort(attrNames, Collections.<T>reverseOrder());
                    int i2 = 0;
                    while (i2 < attrNames.length) {
                        poolName = poolName + "_" + attrNames[i2];
                        ++i2;
                    }
                }
                return poolName;
            }
        }
        page.visit(new TagHandlerPoolVisitor(this, this.tagHandlerPoolNames));
    }

    private void declareTemporaryScriptingVars(Node.Nodes page) throws JasperException {
        class ScriptingVarVisitor
        extends Node.Visitor {
            private Vector vars;
            private final /* synthetic */ Generator this$0;

            ScriptingVarVisitor(Generator this$0) {
                this.this$0 = this$0;
                this.vars = new Vector<E>();
            }

            public void visit(Node.CustomTag n) throws JasperException {
                block7: {
                    TagVariableInfo[] tagVarInfos;
                    block8: {
                        if (n.getCustomNestingLevel() <= 0) break block7;
                        tagVarInfos = n.getTagVariableInfos();
                        VariableInfo[] varInfos = n.getVariableInfos();
                        if (varInfos.length <= 0) break block8;
                        int i = 0;
                        while (i < varInfos.length) {
                            String varName = varInfos[i].getVarName();
                            String tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel();
                            if (!this.vars.contains(tmpVarName)) {
                                this.vars.add(tmpVarName);
                                Generator.access$000(this.this$0).printin(varInfos[i].getClassName());
                                Generator.access$000(this.this$0).print(" ");
                                Generator.access$000(this.this$0).print(tmpVarName);
                                Generator.access$000(this.this$0).print(" = ");
                                Generator.access$000(this.this$0).print(null);
                                Generator.access$000(this.this$0).println(";");
                            }
                            ++i;
                        }
                        break block7;
                    }
                    int i = 0;
                    while (i < tagVarInfos.length) {
                        block11: {
                            String varName;
                            block10: {
                                block9: {
                                    varName = tagVarInfos[i].getNameGiven();
                                    if (varName != null) break block9;
                                    varName = n.getTagData().getAttributeString(tagVarInfos[i].getNameFromAttribute());
                                    break block10;
                                }
                                if (tagVarInfos[i].getNameFromAttribute() != null) break block11;
                            }
                            String tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel();
                            if (!this.vars.contains(tmpVarName)) {
                                this.vars.add(tmpVarName);
                                Generator.access$000(this.this$0).printin(tagVarInfos[i].getClassName());
                                Generator.access$000(this.this$0).print(" ");
                                Generator.access$000(this.this$0).print(tmpVarName);
                                Generator.access$000(this.this$0).print(" = ");
                                Generator.access$000(this.this$0).print(null);
                                Generator.access$000(this.this$0).println(";");
                            }
                        }
                        ++i;
                    }
                }
                this.visitBody(n);
            }
        }
        page.visit(new ScriptingVarVisitor(this));
    }

    private void generateInit() {
        if (this.ctxt.isTagFile()) {
            this.out.printil("private void _jspInit(ServletConfig config) {");
        } else {
            this.out.printil("public void _jspInit() {");
        }
        this.out.pushIndent();
        int i = 0;
        while (i < this.tagHandlerPoolNames.size()) {
            this.out.printin((String)this.tagHandlerPoolNames.elementAt(i));
            this.out.print(" = org.apache.jasper.runtime.TagHandlerPool.getTagHandlerPool(");
            if (this.ctxt.isTagFile()) {
                this.out.print("config");
            } else {
                this.out.print("getServletConfig()");
            }
            this.out.println(");");
            ++i;
        }
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
    }

    private void generateDestroy() {
        this.out.printil("public void _jspDestroy() {");
        this.out.pushIndent();
        int i = 0;
        while (i < this.tagHandlerPoolNames.size()) {
            this.out.printin((String)this.tagHandlerPoolNames.elementAt(i));
            this.out.println(".release();");
            ++i;
        }
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
    }

    private void genPreamblePackage(String packageName) throws JasperException {
        if (!"".equals(packageName) && packageName != null) {
            this.out.printil("package " + packageName + ";");
            this.out.println();
        }
    }

    private void genPreambleImports() throws JasperException {
        Iterator iter = this.pageInfo.getImports().iterator();
        while (iter.hasNext()) {
            this.out.printin("import ");
            this.out.print((String)iter.next());
            this.out.println(";");
        }
        this.out.println();
    }

    private void genPreambleStaticInitializers() throws JasperException {
        this.out.printil("private static java.util.Vector _jspx_dependants;");
        this.out.println();
        List dependants = this.pageInfo.getDependants();
        Iterator iter = dependants.iterator();
        if (!dependants.isEmpty()) {
            this.out.printil("static {");
            this.out.pushIndent();
            this.out.printin("_jspx_dependants = new java.util.Vector(");
            this.out.print("" + dependants.size());
            this.out.println(");");
            while (iter.hasNext()) {
                this.out.printin("_jspx_dependants.add(\"");
                this.out.print((String)iter.next());
                this.out.println("\");");
            }
            this.out.popIndent();
            this.out.printil("}");
            this.out.println();
        }
    }

    private void genPreambleClassVariableDeclarations(String className) throws JasperException {
        if (this.ctxt.getOptions().isPoolingEnabled() && !this.tagHandlerPoolNames.isEmpty()) {
            int i = 0;
            while (i < this.tagHandlerPoolNames.size()) {
                this.out.printil("private org.apache.jasper.runtime.TagHandlerPool " + this.tagHandlerPoolNames.elementAt(i) + ";");
                ++i;
            }
            this.out.println();
        }
    }

    private void genPreambleMethods() throws JasperException {
        this.out.printil("public java.util.List getDependants() {");
        this.out.pushIndent();
        this.out.printil("return _jspx_dependants;");
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
        if (this.ctxt.getOptions().isPoolingEnabled() && !this.tagHandlerPoolNames.isEmpty()) {
            this.generateInit();
            this.generateDestroy();
        }
    }

    private void generatePreamble(Node.Nodes page) throws JasperException {
        String servletPackageName = this.ctxt.getServletPackageName();
        String servletClassName = this.ctxt.getServletClassName();
        String serviceMethodName = "_jspService";
        this.genPreamblePackage(servletPackageName);
        this.genPreambleImports();
        this.out.printin("public final class ");
        this.out.print(servletClassName);
        this.out.print(" extends ");
        this.out.println(this.pageInfo.getExtends());
        this.out.printin("    implements org.apache.jasper.runtime.JspSourceDependent");
        if (!this.pageInfo.isThreadSafe()) {
            this.out.println(",");
            this.out.printin("                 SingleThreadModel");
        }
        this.out.println(" {");
        this.out.pushIndent();
        this.generateDeclarations(page);
        this.genPreambleStaticInitializers();
        this.genPreambleClassVariableDeclarations(servletClassName);
        this.genPreambleMethods();
        this.out.printin("public void ");
        this.out.print(serviceMethodName);
        this.out.println("(HttpServletRequest request, HttpServletResponse response)");
        this.out.println("        throws java.io.IOException, ServletException {");
        this.out.pushIndent();
        this.out.println();
        this.out.printil("JspFactory _jspxFactory = null;");
        this.out.printil("PageContext pageContext = null;");
        if (this.pageInfo.isSession()) {
            this.out.printil("HttpSession session = null;");
        }
        if (this.pageInfo.isIsErrorPage()) {
            this.out.printil("Throwable exception = org.apache.jasper.runtime.JspRuntimeLibrary.getThrowable(request);");
        }
        this.out.printil("ServletContext application = null;");
        this.out.printil("ServletConfig config = null;");
        this.out.printil("JspWriter out = null;");
        this.out.printil("Object page = this;");
        this.maxTagNesting = this.pageInfo.getMaxTagNesting();
        this.out.printil("JspWriter _jspx_out = null;");
        this.out.println();
        this.declareTemporaryScriptingVars(page);
        this.out.println();
        this.out.printil("try {");
        this.out.pushIndent();
        this.out.printil("_jspxFactory = JspFactory.getDefaultFactory();");
        this.out.printin("response.setContentType(");
        this.out.print(Generator.quote(this.pageInfo.getContentType()));
        this.out.println(");");
        this.out.printil("pageContext = _jspxFactory.getPageContext(this, request, response,");
        this.out.printin("\t\t\t");
        this.out.print(Generator.quote(this.pageInfo.getErrorPage()));
        this.out.print(", " + this.pageInfo.isSession());
        this.out.print(", " + this.pageInfo.getBuffer());
        this.out.print(", " + this.pageInfo.isAutoFlush());
        this.out.println(");");
        this.out.printil("application = pageContext.getServletContext();");
        this.out.printil("config = pageContext.getServletConfig();");
        if (this.pageInfo.isSession()) {
            this.out.printil("session = pageContext.getSession();");
        }
        this.out.printil("out = pageContext.getOut();");
        this.out.printil("_jspx_out = out;");
        this.out.println();
    }

    private void generateXmlDeclaration(Node.Nodes page) {
        String omitXmlDecl = this.pageInfo.getOmitXmlDecl();
        if (omitXmlDecl != null && !JspUtil.booleanValue(omitXmlDecl) || omitXmlDecl == null && page.getRoot().isXmlSyntax() && !this.pageInfo.hasJspRoot() && !this.ctxt.isTagFile()) {
            String cType = this.pageInfo.getContentType();
            String charSet = cType.substring(cType.indexOf("charset=") + 8);
            this.out.printil("out.write(\"<?xml version=\\\"1.0\\\" encoding=\\\"" + charSet + "\\\"?>\\n\");");
        }
    }

    private void generateConstructor(String className) {
        this.out.printil("public " + className + "() {");
        this.out.printil("}");
        this.out.println();
    }

    private void generateJspState() {
    }

    private static void generateLocalVariables(ServletWriter out, Node n) throws JasperException {
        Node.ChildInfo ci;
        if (n instanceof Node.CustomTag) {
            ci = ((Node.CustomTag)n).getChildInfo();
        } else if (n instanceof Node.JspBody) {
            ci = ((Node.JspBody)n).getChildInfo();
        } else if (n instanceof Node.NamedAttribute) {
            ci = ((Node.NamedAttribute)n).getChildInfo();
        } else {
            throw new JasperException("Unexpected Node Type");
        }
        if (ci.hasUseBean()) {
            out.printil("HttpSession session = pageContext.getSession();");
            out.printil("ServletContext application = pageContext.getServletContext();");
        }
        if (ci.hasUseBean() || ci.hasIncludeAction() || ci.hasSetProperty() || ci.hasParamAction()) {
            out.printil("HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();");
        }
        if (ci.hasIncludeAction()) {
            out.printil("HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();");
        }
    }

    private void genCommonPostamble() {
        this.out.printMultiLn(this.methodsBuffer.toString());
        if (this.fragmentHelperClass.isUsed()) {
            this.fragmentHelperClass.generatePostamble();
            this.out.printMultiLn(this.fragmentHelperClass.toString());
        }
        if (this.maxTagNesting > 0) {
            this.generateJspState();
        }
        this.out.popIndent();
        this.out.printil("}");
    }

    private void generatePostamble(Node.Nodes page) {
        this.out.popIndent();
        this.out.printil("} catch (Throwable t) {");
        this.out.pushIndent();
        this.out.printil("if (!(t instanceof javax.servlet.jsp.SkipPageException)){");
        this.out.pushIndent();
        this.out.printil("out = _jspx_out;");
        this.out.printil("if (out != null && out.getBufferSize() != 0)");
        this.out.pushIndent();
        this.out.printil("out.clearBuffer();");
        this.out.popIndent();
        this.out.printil("if (pageContext != null) pageContext.handlePageException(t);");
        this.out.popIndent();
        this.out.printil("}");
        this.out.popIndent();
        this.out.printil("} finally {");
        this.out.pushIndent();
        this.out.printil("if (_jspxFactory != null) _jspxFactory.releasePageContext(pageContext);");
        this.out.popIndent();
        this.out.printil("}");
        this.out.popIndent();
        this.out.printil("}");
        this.genCommonPostamble();
    }

    Generator(ServletWriter out, Compiler compiler) {
        this.out = out;
        this.methodsBuffer = new MethodsBuffer();
        this.err = compiler.getErrorDispatcher();
        this.ctxt = compiler.getCompilationContext();
        this.fragmentHelperClass = new FragmentHelperClass(this.ctxt.getServletClassName() + "Helper");
        this.pageInfo = compiler.getPageInfo();
        this.beanInfo = this.pageInfo.getBeanRepository();
        this.breakAtLF = this.ctxt.getOptions().getMappedFile();
        if (this.ctxt.getOptions().isPoolingEnabled()) {
            this.tagHandlerPoolNames = new Vector();
        }
    }

    public static void generate(ServletWriter out, Compiler compiler, Node.Nodes page) throws JasperException {
        Generator gen = new Generator(out, compiler);
        if (gen.ctxt.getOptions().isPoolingEnabled()) {
            gen.compileTagHandlerPoolList(page);
        }
        if (gen.ctxt.isTagFile()) {
            JasperTagInfo tagInfo = (JasperTagInfo)gen.ctxt.getTagInfo();
            gen.generateTagHandlerPreamble(tagInfo, page);
            if (gen.ctxt.isPrototypeMode()) {
                return;
            }
            gen.generateXmlDeclaration(page);
            gen.fragmentHelperClass.generatePreamble();
            Generator generator = gen;
            generator.getClass();
            page.visit(generator.new GenerateVisitor(gen.ctxt.isTagFile(), out, gen.methodsBuffer, gen.fragmentHelperClass, gen.ctxt.getClassLoader(), tagInfo));
            gen.generateTagHandlerPostamble(tagInfo);
        } else {
            gen.generatePreamble(page);
            gen.generateXmlDeclaration(page);
            gen.fragmentHelperClass.generatePreamble();
            Generator generator = gen;
            generator.getClass();
            page.visit(generator.new GenerateVisitor(gen.ctxt.isTagFile(), out, gen.methodsBuffer, gen.fragmentHelperClass, gen.ctxt.getClassLoader(), null));
            gen.generatePostamble(page);
        }
    }

    private void generateTagHandlerPreamble(JasperTagInfo tagInfo, Node.Nodes tag) throws JasperException {
        String className = tagInfo.getTagClassName();
        int lastIndex = className.lastIndexOf(46);
        if (lastIndex != -1) {
            String pkgName = className.substring(0, lastIndex);
            this.genPreamblePackage(pkgName);
            className = className.substring(lastIndex + 1);
        }
        this.genPreambleImports();
        this.out.printin("public final class ");
        this.out.println(className);
        this.out.printil("    extends javax.servlet.jsp.tagext.SimpleTagSupport");
        this.out.printin("    implements org.apache.jasper.runtime.JspSourceDependent");
        if (tagInfo.hasDynamicAttributes()) {
            this.out.println(",");
            this.out.printin("               javax.servlet.jsp.tagext.DynamicAttributes");
        }
        this.out.println(" {");
        this.out.println();
        this.out.pushIndent();
        this.generateDeclarations(tag);
        this.genPreambleStaticInitializers();
        this.out.printil("private JspContext jspContext;");
        this.out.printil("private java.io.Writer _jspx_sout;");
        this.genPreambleClassVariableDeclarations(tagInfo.getTagName());
        this.generateSetJspContext(tagInfo);
        this.generateTagHandlerAttributes(tagInfo);
        if (tagInfo.hasDynamicAttributes()) {
            this.generateSetDynamicAttribute();
        }
        this.genPreambleMethods();
        this.out.printil("public void doTag() throws javax.servlet.jsp.JspException, java.io.IOException {");
        if (this.ctxt.isPrototypeMode()) {
            this.out.printil("}");
            this.out.popIndent();
            this.out.printil("}");
            return;
        }
        this.out.pushIndent();
        this.out.printil("PageContext pageContext = (PageContext)jspContext;");
        this.out.printil("javax.servlet.ServletRequest request = pageContext.getRequest();");
        this.out.printil("javax.servlet.ServletResponse response = pageContext.getResponse();");
        this.out.printil("javax.servlet.http.HttpSession session = pageContext.getSession();");
        this.out.printil("javax.servlet.ServletContext application = pageContext.getServletContext();");
        this.out.printil("javax.servlet.ServletConfig config = pageContext.getServletConfig();");
        this.out.printil("javax.servlet.jsp.JspWriter out = jspContext.getOut();");
        if (this.ctxt.getOptions().isPoolingEnabled() && !this.tagHandlerPoolNames.isEmpty()) {
            this.out.printil("_jspInit(config);");
        }
        this.generatePageScopedVariables(tagInfo);
        this.maxTagNesting = this.pageInfo.getMaxTagNesting();
        this.declareTemporaryScriptingVars(tag);
        this.out.println();
        this.out.printil("try {");
        this.out.pushIndent();
    }

    private void generateTagHandlerPostamble(TagInfo tagInfo) {
        this.out.popIndent();
        this.out.printil("} catch( Throwable t ) {");
        this.out.pushIndent();
        this.out.printil("if( t instanceof javax.servlet.jsp.SkipPageException )");
        this.out.printil("    throw (javax.servlet.jsp.SkipPageException) t;");
        this.out.printil("if( t instanceof java.io.IOException )");
        this.out.printil("    throw (java.io.IOException) t;");
        this.out.printil("if( t instanceof IllegalStateException )");
        this.out.printil("    throw (IllegalStateException) t;");
        this.out.printil("if( t instanceof javax.servlet.jsp.JspException )");
        this.out.printil("    throw (javax.servlet.jsp.JspException) t;");
        this.out.printil("throw new javax.servlet.jsp.JspException(t);");
        this.out.popIndent();
        this.out.printil("} finally {");
        this.out.pushIndent();
        this.out.printil("((org.apache.jasper.runtime.JspContextWrapper) jspContext).syncEndTagFile();");
        if (this.ctxt.getOptions().isPoolingEnabled() && !this.tagHandlerPoolNames.isEmpty()) {
            this.out.printil("_jspDestroy();");
        }
        this.out.popIndent();
        this.out.printil("}");
        this.out.popIndent();
        this.out.printil("}");
        this.genCommonPostamble();
    }

    private void generateTagHandlerAttributes(TagInfo tagInfo) throws JasperException {
        if (tagInfo.hasDynamicAttributes()) {
            this.out.printil("private java.util.HashMap _jspx_dynamic_attrs = new java.util.HashMap();");
        }
        TagAttributeInfo[] attrInfos = tagInfo.getAttributes();
        int i = 0;
        while (i < attrInfos.length) {
            this.out.printin("private ");
            if (attrInfos[i].isFragment()) {
                this.out.print("javax.servlet.jsp.tagext.JspFragment ");
            } else {
                this.out.print(attrInfos[i].getTypeName());
                this.out.print(" ");
            }
            this.out.print(attrInfos[i].getName());
            this.out.println(";");
            ++i;
        }
        this.out.println();
        if (attrInfos != null) {
            int i2 = 0;
            while (i2 < attrInfos.length) {
                this.out.printin("public ");
                if (attrInfos[i2].isFragment()) {
                    this.out.print("javax.servlet.jsp.tagext.JspFragment ");
                } else {
                    this.out.print(attrInfos[i2].getTypeName());
                    this.out.print(" ");
                }
                this.out.print(this.toGetterMethod(attrInfos[i2].getName()));
                this.out.println(" {");
                this.out.pushIndent();
                this.out.printin("return this.");
                this.out.print(attrInfos[i2].getName());
                this.out.println(";");
                this.out.popIndent();
                this.out.printil("}");
                this.out.println();
                this.out.printin("public void ");
                this.out.print(this.toSetterMethodName(attrInfos[i2].getName()));
                if (attrInfos[i2].isFragment()) {
                    this.out.print("(javax.servlet.jsp.tagext.JspFragment ");
                } else {
                    this.out.print("(");
                    this.out.print(attrInfos[i2].getTypeName());
                    this.out.print(" ");
                }
                this.out.print(attrInfos[i2].getName());
                this.out.println(") {");
                this.out.pushIndent();
                this.out.printin("this.");
                this.out.print(attrInfos[i2].getName());
                this.out.print(" = ");
                this.out.print(attrInfos[i2].getName());
                this.out.println(";");
                this.out.popIndent();
                this.out.printil("}");
                this.out.println();
                ++i2;
            }
        }
    }

    private void generateSetJspContext(TagInfo tagInfo) {
        boolean nestedSeen = false;
        boolean atBeginSeen = false;
        boolean atEndSeen = false;
        boolean aliasSeen = false;
        TagVariableInfo[] tagVars = tagInfo.getTagVariableInfos();
        int i = 0;
        while (i < tagVars.length) {
            if (tagVars[i].getNameFromAttribute() != null && tagVars[i].getNameGiven() != null) {
                aliasSeen = true;
                break;
            }
            ++i;
        }
        if (aliasSeen) {
            this.out.printil("public void setJspContext(JspContext ctx, java.util.Map aliasMap) {");
        } else {
            this.out.printil("public void setJspContext(JspContext ctx) {");
        }
        this.out.pushIndent();
        this.out.printil("super.setJspContext(ctx);");
        this.out.printil("java.util.ArrayList _jspx_nested = null;");
        this.out.printil("java.util.ArrayList _jspx_at_begin = null;");
        this.out.printil("java.util.ArrayList _jspx_at_end = null;");
        int i2 = 0;
        while (i2 < tagVars.length) {
            switch (tagVars[i2].getScope()) {
                case 0: {
                    if (!nestedSeen) {
                        this.out.printil("_jspx_nested = new java.util.ArrayList();");
                        nestedSeen = true;
                    }
                    this.out.printin("_jspx_nested.add(");
                    break;
                }
                case 1: {
                    if (!atBeginSeen) {
                        this.out.printil("_jspx_at_begin = new java.util.ArrayList();");
                        atBeginSeen = true;
                    }
                    this.out.printin("_jspx_at_begin.add(");
                    break;
                }
                case 2: {
                    if (!atEndSeen) {
                        this.out.printil("_jspx_at_end = new java.util.ArrayList();");
                        atEndSeen = true;
                    }
                    this.out.printin("_jspx_at_end.add(");
                }
            }
            this.out.print(Generator.quote(tagVars[i2].getNameGiven()));
            this.out.println(");");
            ++i2;
        }
        if (aliasSeen) {
            this.out.printil("this.jspContext = new org.apache.jasper.runtime.JspContextWrapper(ctx, _jspx_nested, _jspx_at_begin, _jspx_at_end, aliasMap);");
        } else {
            this.out.printil("this.jspContext = new org.apache.jasper.runtime.JspContextWrapper(ctx, _jspx_nested, _jspx_at_begin, _jspx_at_end, null);");
        }
        this.out.popIndent();
        this.out.printil("}");
        this.out.println();
        this.out.printil("public JspContext getJspContext() {");
        this.out.pushIndent();
        this.out.printil("return this.jspContext;");
        this.out.popIndent();
        this.out.printil("}");
    }

    public void generateSetDynamicAttribute() {
        this.out.printil("public void setDynamicAttribute(String uri, String localName, Object value) throws javax.servlet.jsp.JspException {");
        this.out.pushIndent();
        this.out.printil("if (uri == null)");
        this.out.pushIndent();
        this.out.printil("_jspx_dynamic_attrs.put(localName, value);");
        this.out.popIndent();
        this.out.popIndent();
        this.out.printil("}");
    }

    private void generatePageScopedVariables(JasperTagInfo tagInfo) {
        TagAttributeInfo[] attrInfos = tagInfo.getAttributes();
        int i = 0;
        while (i < attrInfos.length) {
            String attrName = attrInfos[i].getName();
            this.out.printil("if( " + this.toGetterMethod(attrName) + " != null ) ");
            this.out.pushIndent();
            this.out.printin("pageContext.setAttribute(");
            this.out.print(Generator.quote(attrName));
            this.out.print(", ");
            this.out.print(this.toGetterMethod(attrName));
            this.out.println(");");
            this.out.popIndent();
            ++i;
        }
        if (tagInfo.hasDynamicAttributes()) {
            this.out.printin("pageContext.setAttribute(\"");
            this.out.print(tagInfo.getDynamicAttributesMapName());
            this.out.print("\", _jspx_dynamic_attrs);");
        }
    }

    private String toGetterMethod(String attrName) {
        char[] attrChars = attrName.toCharArray();
        attrChars[0] = Character.toUpperCase(attrChars[0]);
        return "get" + new String(attrChars) + "()";
    }

    private String toSetterMethodName(String attrName) {
        char[] attrChars = attrName.toCharArray();
        attrChars[0] = Character.toUpperCase(attrChars[0]);
        return "set" + new String(attrChars);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ ServletWriter access$000(Generator x0) {
        return x0.out;
    }

    private static class FragmentHelperClass {
        private boolean used = false;
        private ArrayList fragments = new ArrayList();
        private String className;
        private MethodsBuffer classBuffer = new MethodsBuffer();

        public FragmentHelperClass(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isUsed() {
            return this.used;
        }

        public void generatePreamble() {
            ServletWriter out = this.classBuffer.getOut();
            out.println();
            out.pushIndent();
            out.printil("private class " + this.className);
            out.printil("    extends org.apache.jasper.runtime.JspFragmentHelper");
            out.printil("{");
            out.pushIndent();
            out.printil("private javax.servlet.jsp.tagext.JspTag parentTag;");
            out.println();
            out.printil("public " + this.className + "( int discriminator, JspContext jspContext, " + "javax.servlet.jsp.tagext.JspTag parentTag ) {");
            out.pushIndent();
            out.printil("super( discriminator, jspContext, parentTag );");
            out.printil("this.parentTag = parentTag;");
            out.popIndent();
            out.printil("}");
        }

        public Fragment openFragment(Node parent, String tagHandlerVar, int methodNesting) throws JasperException {
            Fragment result = new Fragment(this.fragments.size());
            this.fragments.add(result);
            this.used = true;
            ServletWriter out = result.getMethodsBuffer().getOut();
            out.pushIndent();
            out.pushIndent();
            if (methodNesting > 0) {
                out.printin("public boolean invoke");
            } else {
                out.printin("public void invoke");
            }
            out.println(result.getId() + "( " + "java.io.Writer out ) ");
            out.pushIndent();
            out.printil("throws Throwable");
            out.popIndent();
            out.printil("{");
            out.pushIndent();
            Generator.generateLocalVariables(out, parent);
            out.printin("javax.servlet.jsp.tagext.JspTag ");
            out.print(tagHandlerVar);
            out.println(" = parentTag;");
            return result;
        }

        public void closeFragment(Fragment fragment, int methodNesting) {
            ServletWriter out = fragment.getMethodsBuffer().getOut();
            if (methodNesting > 0) {
                out.printil("return false;");
            } else {
                out.printil("return;");
            }
            out.popIndent();
            out.printil("}");
        }

        public void generatePostamble() {
            ServletWriter out = this.classBuffer.getOut();
            int i = 0;
            while (i < this.fragments.size()) {
                Fragment fragment = (Fragment)this.fragments.get(i);
                out.printMultiLn(fragment.getMethodsBuffer().toString());
                ++i;
            }
            out.printil("public void invoke( java.io.Writer writer )");
            out.pushIndent();
            out.printil("throws javax.servlet.jsp.JspException");
            out.popIndent();
            out.printil("{");
            out.pushIndent();
            out.printil("java.io.Writer out = null;");
            out.printil("if( writer != null ) {");
            out.pushIndent();
            out.printil("out = this.jspContext.pushBody(writer);");
            out.popIndent();
            out.printil("} else {");
            out.pushIndent();
            out.printil("out = this.jspContext.getOut();");
            out.popIndent();
            out.printil("}");
            out.printil("try {");
            out.pushIndent();
            out.printil("switch( this.discriminator ) {");
            out.pushIndent();
            int i2 = 0;
            while (i2 < this.fragments.size()) {
                out.printil("case " + i2 + ":");
                out.pushIndent();
                out.printil("invoke" + i2 + "( out );");
                out.printil("break;");
                out.popIndent();
                ++i2;
            }
            out.popIndent();
            out.printil("}");
            out.popIndent();
            out.printil("}");
            out.printil("catch( Throwable e ) {");
            out.pushIndent();
            out.printil("if (e instanceof javax.servlet.jsp.SkipPageException)");
            out.printil("    throw (javax.servlet.jsp.SkipPageException) e;");
            out.printil("throw new javax.servlet.jsp.JspException( e );");
            out.popIndent();
            out.printil("}");
            out.printil("finally {");
            out.pushIndent();
            out.printil("if( writer != null ) {");
            out.pushIndent();
            out.printil("this.jspContext.popBody();");
            out.popIndent();
            out.printil("}");
            out.popIndent();
            out.printil("}");
            out.popIndent();
            out.printil("}");
            out.popIndent();
            out.printil("}");
            out.popIndent();
        }

        public String toString() {
            return this.classBuffer.toString();
        }

        private static class Fragment {
            private MethodsBuffer methodsBuffer;
            private int id;

            public Fragment(int id) {
                this.id = id;
                this.methodsBuffer = new MethodsBuffer();
            }

            public MethodsBuffer getMethodsBuffer() {
                return this.methodsBuffer;
            }

            public int getId() {
                return this.id;
            }
        }
    }

    private static class MethodsBuffer {
        private CharArrayWriter charWriter = new CharArrayWriter();
        protected ServletWriter out = new ServletWriter(new PrintWriter(this.charWriter));

        MethodsBuffer() {
        }

        public ServletWriter getOut() {
            return this.out;
        }

        public String toString() {
            return this.charWriter.toString();
        }
    }

    private static class TagHandlerInfo {
        private Hashtable methodMaps;
        private Hashtable propertyEditorMaps;
        private Class tagHandlerClass;

        TagHandlerInfo(Node n, Class tagHandlerClass, ErrorDispatcher err) throws JasperException {
            this.tagHandlerClass = tagHandlerClass;
            this.methodMaps = new Hashtable();
            this.propertyEditorMaps = new Hashtable();
            try {
                BeanInfo tagClassInfo = Introspector.getBeanInfo(tagHandlerClass);
                PropertyDescriptor[] pd = tagClassInfo.getPropertyDescriptors();
                int i = 0;
                while (i < pd.length) {
                    if (pd[i].getWriteMethod() != null) {
                        this.methodMaps.put(pd[i].getName(), pd[i].getWriteMethod());
                    }
                    if (pd[i].getPropertyEditorClass() != null) {
                        this.propertyEditorMaps.put(pd[i].getName(), pd[i].getPropertyEditorClass());
                    }
                    ++i;
                }
            }
            catch (IntrospectionException ie) {
                err.jspError(n, "jsp.error.introspect.taghandler", tagHandlerClass.getName(), ie);
            }
        }

        public Method getSetterMethod(String attrName) {
            return (Method)this.methodMaps.get(attrName);
        }

        public Class getPropertyEditorClass(String attrName) {
            return (Class)this.propertyEditorMaps.get(attrName);
        }

        public Class getTagHandlerClass() {
            return this.tagHandlerClass;
        }
    }

    class GenerateVisitor
    extends Node.Visitor {
        private Hashtable handlerInfos;
        private Hashtable tagVarNumbers;
        private String parent;
        private String pushBodyCountVar;
        private String simpleTagHandlerVar;
        private boolean isSimpleTagHandler;
        private boolean isFragment;
        private boolean isTagFile;
        private ServletWriter out;
        private MethodsBuffer methodsBuffer;
        private FragmentHelperClass fragmentHelperClass;
        private int methodNesting;
        private TagInfo tagInfo;
        private ClassLoader loader;
        private static final String SINGLE_QUOTE = "'";
        private static final String DOUBLE_QUOTE = "\\\"";
        private static final int CHUNKSIZE = 1024;

        public GenerateVisitor(boolean isTagFile, ServletWriter out, MethodsBuffer methodsBuffer, FragmentHelperClass fragmentHelperClass, ClassLoader loader, TagInfo tagInfo) {
            this.isTagFile = isTagFile;
            this.out = out;
            this.methodsBuffer = methodsBuffer;
            this.fragmentHelperClass = fragmentHelperClass;
            this.loader = loader;
            this.tagInfo = tagInfo;
            this.methodNesting = 0;
            this.handlerInfos = new Hashtable();
            this.tagVarNumbers = new Hashtable();
        }

        private String attributeValue(Node.JspAttribute attr, boolean encode, Class expectedType) {
            String v = attr.getValue();
            if (!attr.isNamedAttribute() && v == null) {
                return "";
            }
            if (attr.isExpression() || attr.isELInterpreterInput()) {
                if (attr.isELInterpreterInput()) {
                    boolean replaceESC = v.indexOf(27) > 0;
                    v = JspUtil.interpreterCall(this.isTagFile, v, expectedType, attr.getEL().getMapName(), false);
                    if (replaceESC) {
                        v = "(" + v + ").replace(" + "'\\u001b'" + ", '$')";
                    }
                }
                if (encode) {
                    return "org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(" + v + ", request.getCharacterEncoding())";
                }
                return v;
            }
            if (attr.isNamedAttribute()) {
                return attr.getNamedAttributeNode().getTemporaryVariableName();
            }
            if (encode) {
                return "org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(" + Generator.quote(v) + ", request.getCharacterEncoding())";
            }
            return Generator.quote(v);
        }

        private void printParams(Node n, String pageParam, boolean literal) throws JasperException {
            String sep = literal ? (pageParam.indexOf(63) > 0 ? "\"&\"" : "\"?\"") : "((" + pageParam + ").indexOf('?')>0? '&': '?')";
            if (n.getBody() != null) {
                class ParamVisitor
                extends Node.Visitor {
                    String separator;
                    private final /* synthetic */ GenerateVisitor this$1;

                    ParamVisitor(GenerateVisitor this$1, String separator) {
                        this.this$1 = this$1;
                        this.separator = separator;
                    }

                    public void visit(Node.ParamAction n) throws JasperException {
                        GenerateVisitor.access$100(this.this$1).print(" + ");
                        GenerateVisitor.access$100(this.this$1).print(this.separator);
                        GenerateVisitor.access$100(this.this$1).print(" + ");
                        GenerateVisitor.access$100(this.this$1).print("org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(" + Generator.quote(n.getTextAttribute("name")) + ", request.getCharacterEncoding())");
                        GenerateVisitor.access$100(this.this$1).print("+ \"=\" + ");
                        GenerateVisitor.access$100(this.this$1).print(GenerateVisitor.access$200(this.this$1, n.getValue(), true, Generator.class$java$lang$String == null ? (Generator.class$java$lang$String = Generator.class$("java.lang.String")) : Generator.class$java$lang$String));
                        this.separator = "\"&\"";
                    }
                }
                n.getBody().visit(new ParamVisitor(this, sep));
            }
        }

        public void visit(Node.Expression n) throws JasperException {
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printil("out.write(String.valueOf(" + new String(n.getText()) + "));");
            n.setEndJavaLine(this.out.getJavaLine());
        }

        public void visit(Node.Scriptlet n) throws JasperException {
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printMultiLn(n.getText());
            this.out.println();
            n.setEndJavaLine(this.out.getJavaLine());
        }

        public void visit(Node.ELExpression n) throws JasperException {
            n.setBeginJavaLine(this.out.getJavaLine());
            if (!Generator.this.pageInfo.isELIgnored()) {
                this.out.printil("out.write(" + JspUtil.interpreterCall(this.isTagFile, "${" + new String(n.getText()) + "}", class$java$lang$String == null ? (class$java$lang$String = Generator.class$("java.lang.String")) : class$java$lang$String, n.getEL().getMapName(), false) + ");");
            } else {
                this.out.printil("out.write(" + Generator.quote("${" + new String(n.getText()) + "}") + ");");
            }
            n.setEndJavaLine(this.out.getJavaLine());
        }

        public void visit(Node.IncludeAction n) throws JasperException {
            String flush = n.getTextAttribute("flush");
            Node.JspAttribute page = n.getPage();
            boolean isFlush = false;
            if ("true".equals(flush)) {
                isFlush = true;
            }
            n.setBeginJavaLine(this.out.getJavaLine());
            String pageParam = page.isNamedAttribute() ? this.generateNamedAttributeValue(page.getNamedAttributeNode()) : this.attributeValue(page, false, class$java$lang$String == null ? (class$java$lang$String = Generator.class$("java.lang.String")) : class$java$lang$String);
            Node.JspBody jspBody = this.findJspBody(n);
            if (jspBody != null) {
                this.prepareParams(jspBody);
            } else {
                this.prepareParams(n);
            }
            this.out.printin("org.apache.jasper.runtime.JspRuntimeLibrary.include(request, response, " + pageParam);
            this.printParams(n, pageParam, page.isLiteral());
            this.out.println(", out, " + isFlush + ");");
            n.setEndJavaLine(this.out.getJavaLine());
        }

        private void prepareParams(Node parent) throws JasperException {
            if (parent == null) {
                return;
            }
            Node.Nodes subelements = parent.getBody();
            if (subelements != null) {
                int i = 0;
                while (i < subelements.size()) {
                    Node n = subelements.getNode(i);
                    if (n instanceof Node.ParamAction) {
                        Node.Nodes paramSubElements = n.getBody();
                        int j = 0;
                        while (paramSubElements != null && j < paramSubElements.size()) {
                            Node m = paramSubElements.getNode(j);
                            if (m instanceof Node.NamedAttribute) {
                                this.generateNamedAttributeValue((Node.NamedAttribute)m);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }

        private Node.JspBody findJspBody(Node parent) throws JasperException {
            Node.JspBody result = null;
            Node.Nodes subelements = parent.getBody();
            int i = 0;
            while (subelements != null && i < subelements.size()) {
                Node n = subelements.getNode(i);
                if (n instanceof Node.JspBody) {
                    result = (Node.JspBody)n;
                    break;
                }
                ++i;
            }
            return result;
        }

        public void visit(Node.ForwardAction n) throws JasperException {
            Node.JspAttribute page = n.getPage();
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printil("if (true) {");
            this.out.pushIndent();
            String pageParam = page.isNamedAttribute() ? this.generateNamedAttributeValue(page.getNamedAttributeNode()) : this.attributeValue(page, false, class$java$lang$String == null ? (class$java$lang$String = Generator.class$("java.lang.String")) : class$java$lang$String);
            Node.JspBody jspBody = this.findJspBody(n);
            if (jspBody != null) {
                this.prepareParams(jspBody);
            } else {
                this.prepareParams(n);
            }
            this.out.printin("pageContext.forward(");
            this.out.print(pageParam);
            this.printParams(n, pageParam, page.isLiteral());
            this.out.println(");");
            if (this.isTagFile || this.isFragment) {
                this.out.printil("throw new javax.servlet.jsp.SkipPageException();");
            } else {
                this.out.printil(this.methodNesting > 0 ? "return true;" : "return;");
            }
            this.out.popIndent();
            this.out.printil("}");
            n.setEndJavaLine(this.out.getJavaLine());
        }

        public void visit(Node.GetProperty n) throws JasperException {
            String name = n.getTextAttribute("name");
            String property = n.getTextAttribute("property");
            n.setBeginJavaLine(this.out.getJavaLine());
            if (Generator.this.beanInfo.checkVariable(name)) {
                Class bean = Generator.this.beanInfo.getBeanType(name);
                String beanName = bean.getName();
                Method meth = JspRuntimeLibrary.getReadMethod((Class)bean, (String)property);
                String methodName = meth.getName();
                this.out.printil("out.write(org.apache.jasper.runtime.JspRuntimeLibrary.toString((((" + beanName + ")pageContext.findAttribute(" + "\"" + name + "\"))." + methodName + "())));");
            } else {
                this.out.printil("out.write(org.apache.jasper.runtime.JspRuntimeLibrary.toString(org.apache.jasper.runtime.JspRuntimeLibrary.handleGetProperty(pageContext.findAttribute(\"" + name + "\"), \"" + property + "\")));");
            }
            n.setEndJavaLine(this.out.getJavaLine());
        }

        public void visit(Node.SetProperty n) throws JasperException {
            String name = n.getTextAttribute("name");
            String property = n.getTextAttribute("property");
            String param = n.getTextAttribute("param");
            Node.JspAttribute value = n.getValue();
            n.setBeginJavaLine(this.out.getJavaLine());
            if ("*".equals(property)) {
                this.out.printil("org.apache.jasper.runtime.JspRuntimeLibrary.introspect(pageContext.findAttribute(\"" + name + "\"), request);");
            } else if (value == null) {
                if (param == null) {
                    param = property;
                }
                this.out.printil("org.apache.jasper.runtime.JspRuntimeLibrary.introspecthelper(pageContext.findAttribute(\"" + name + "\"), \"" + property + "\", request.getParameter(\"" + param + "\"), " + "request, \"" + param + "\", false);");
            } else if (value.isExpression()) {
                this.out.printil("org.apache.jasper.runtime.JspRuntimeLibrary.handleSetProperty(pageContext.findAttribute(\"" + name + "\"), \"" + property + "\",");
                this.out.print(this.attributeValue(value, false, null));
                this.out.println(");");
            } else if (value.isELInterpreterInput()) {
                this.out.printil("org.apache.jasper.runtime.JspRuntimeLibrary.handleSetPropertyExpression(pageContext.findAttribute(\"" + name + "\"), \"" + property + "\", " + Generator.quote(value.getValue()) + ", " + "pageContext, " + value.getEL().getMapName() + ");");
            } else if (value.isNamedAttribute()) {
                String valueVarName = this.generateNamedAttributeValue(value.getNamedAttributeNode());
                this.out.printil("org.apache.jasper.runtime.JspRuntimeLibrary.introspecthelper(pageContext.findAttribute(\"" + name + "\"), \"" + property + "\", " + valueVarName + ", null, null, false);");
            } else {
                this.out.printin("org.apache.jasper.runtime.JspRuntimeLibrary.introspecthelper(pageContext.findAttribute(\"" + name + "\"), \"" + property + "\", ");
                this.out.print(this.attributeValue(value, false, null));
                this.out.println(", null, null, false);");
            }
            n.setEndJavaLine(this.out.getJavaLine());
        }

        public void visit(Node.UseBean n) throws JasperException {
            String name = n.getTextAttribute("id");
            String scope = n.getTextAttribute("scope");
            String klass = n.getTextAttribute("class");
            String type = n.getTextAttribute("type");
            Node.JspAttribute beanName = n.getBeanName();
            if (type == null) {
                type = klass;
            }
            String scopename = "PageContext.PAGE_SCOPE";
            String lock = "pageContext";
            if ("request".equals(scope)) {
                scopename = "PageContext.REQUEST_SCOPE";
                lock = "request";
            } else if ("session".equals(scope)) {
                scopename = "PageContext.SESSION_SCOPE";
                lock = "session";
            } else if ("application".equals(scope)) {
                scopename = "PageContext.APPLICATION_SCOPE";
                lock = "application";
            }
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin(type);
            this.out.print(' ');
            this.out.print(name);
            this.out.println(" = null;");
            this.out.printin("synchronized (");
            this.out.print(lock);
            this.out.println(") {");
            this.out.pushIndent();
            this.out.printin(name);
            this.out.print(" = (");
            this.out.print(type);
            this.out.print(") pageContext.getAttribute(");
            this.out.print(Generator.quote(name));
            this.out.print(", ");
            this.out.print(scopename);
            this.out.println(");");
            this.out.printin("if (");
            this.out.print(name);
            this.out.println(" == null){");
            this.out.pushIndent();
            if (klass == null && beanName == null) {
                this.out.printin("throw new java.lang.InstantiationException(\"bean ");
                this.out.print(name);
                this.out.println(" not found within scope\");");
            } else {
                String className = beanName != null ? (beanName.isNamedAttribute() ? this.generateNamedAttributeValue(beanName.getNamedAttributeNode()) : this.attributeValue(beanName, false, class$java$lang$String == null ? (class$java$lang$String = Generator.class$("java.lang.String")) : class$java$lang$String)) : Generator.quote(klass);
                this.out.printil("try {");
                this.out.pushIndent();
                this.out.printin(name);
                this.out.print(" = (");
                this.out.print(type);
                this.out.print(") java.beans.Beans.instantiate(");
                this.out.print("this.getClass().getClassLoader(), ");
                this.out.print(className);
                this.out.println(");");
                this.out.popIndent();
                this.out.printil("} catch (ClassNotFoundException exc) {");
                this.out.pushIndent();
                this.out.printil("throw new InstantiationException(exc.getMessage());");
                this.out.popIndent();
                this.out.printil("} catch (Exception exc) {");
                this.out.pushIndent();
                this.out.printin("throw new ServletException(");
                this.out.print("\"Cannot create bean of class \" + ");
                this.out.print(className);
                this.out.println(", exc);");
                this.out.popIndent();
                this.out.printil("}");
                this.out.printin("pageContext.setAttribute(");
                this.out.print(Generator.quote(name));
                this.out.print(", ");
                this.out.print(name);
                this.out.print(", ");
                this.out.print(scopename);
                this.out.println(");");
                this.visitBody(n);
            }
            this.out.popIndent();
            this.out.printil("}");
            this.out.popIndent();
            this.out.printil("}");
            n.setEndJavaLine(this.out.getJavaLine());
        }

        private String makeAttr(String attr, String value) {
            if (value == null) {
                return "";
            }
            return " " + attr + "=\"" + value + '\"';
        }

        public void visit(Node.PlugIn n) throws JasperException {
            class ParamVisitor
            extends Node.Visitor {
                private boolean ie;
                private final /* synthetic */ GenerateVisitor this$1;

                ParamVisitor(GenerateVisitor this$1, boolean ie) {
                    this.this$1 = this$1;
                    this.ie = ie;
                }

                public void visit(Node.ParamAction n) throws JasperException {
                    String name = n.getTextAttribute("name");
                    if (name.equalsIgnoreCase("object")) {
                        name = "java_object";
                    } else if (name.equalsIgnoreCase("type")) {
                        name = "java_type";
                    }
                    n.setBeginJavaLine(GenerateVisitor.access$100(this.this$1).getJavaLine());
                    if (this.ie) {
                        GenerateVisitor.access$100(this.this$1).printil("out.write( \"<PARAM name=\\\"" + Generator.escape(name) + "\\\" value=\\\"\" + " + GenerateVisitor.access$200(this.this$1, n.getValue(), false, Generator.class$java$lang$String == null ? (Generator.class$java$lang$String = Generator.class$("java.lang.String")) : Generator.class$java$lang$String) + " + \"\\\">\" );");
                        GenerateVisitor.access$100(this.this$1).printil("out.write(\"\\n\");");
                    } else {
                        GenerateVisitor.access$100(this.this$1).printil("out.write( \" " + Generator.escape(name) + "=\\\"\" + " + GenerateVisitor.access$200(this.this$1, n.getValue(), false, Generator.class$java$lang$String == null ? (Generator.class$java$lang$String = Generator.class$("java.lang.String")) : Generator.class$java$lang$String) + " + \"\\\"\" );");
                    }
                    n.setEndJavaLine(GenerateVisitor.access$100(this.this$1).getJavaLine());
                }
            }
            Node.Nodes subelements;
            String type = n.getTextAttribute("type");
            String code = n.getTextAttribute("code");
            String name = n.getTextAttribute("name");
            Node.JspAttribute height = n.getHeight();
            Node.JspAttribute width = n.getWidth();
            String hspace = n.getTextAttribute("hspace");
            String vspace = n.getTextAttribute("vspace");
            String align = n.getTextAttribute("align");
            String iepluginurl = n.getTextAttribute("iepluginurl");
            String nspluginurl = n.getTextAttribute("nspluginurl");
            String codebase = n.getTextAttribute("codebase");
            String archive = n.getTextAttribute("archive");
            String jreversion = n.getTextAttribute("jreversion");
            String widthStr = null;
            if (width != null) {
                widthStr = width.isNamedAttribute() ? this.generateNamedAttributeValue(width.getNamedAttributeNode()) : this.attributeValue(width, false, class$java$lang$String == null ? (class$java$lang$String = Generator.class$("java.lang.String")) : class$java$lang$String);
            }
            String heightStr = null;
            if (height != null) {
                heightStr = height.isNamedAttribute() ? this.generateNamedAttributeValue(height.getNamedAttributeNode()) : this.attributeValue(height, false, class$java$lang$String == null ? (class$java$lang$String = Generator.class$("java.lang.String")) : class$java$lang$String);
            }
            if (iepluginurl == null) {
                iepluginurl = "http://java.sun.com/products/plugin/1.2.2/jinstall-1_2_2-win.cab#Version=1,2,2,0";
            }
            if (nspluginurl == null) {
                nspluginurl = "http://java.sun.com/products/plugin/";
            }
            n.setBeginJavaLine(this.out.getJavaLine());
            Node.JspBody jspBody = this.findJspBody(n);
            if (jspBody != null && (subelements = jspBody.getBody()) != null) {
                int i = 0;
                while (i < subelements.size()) {
                    Node m = subelements.getNode(i);
                    if (m instanceof Node.ParamsAction) {
                        this.prepareParams(m);
                        break;
                    }
                    ++i;
                }
            }
            String s0 = "<OBJECT classid=" + Generator.this.ctxt.getOptions().getIeClassId() + this.makeAttr("name", name);
            String s1 = "";
            if (width != null) {
                s1 = " + \" width=\\\"\" + " + widthStr + " + \"\\\"\"";
            }
            String s2 = "";
            if (height != null) {
                s2 = " + \" height=\\\"\" + " + heightStr + " + \"\\\"\"";
            }
            String s3 = this.makeAttr("hspace", hspace) + this.makeAttr("vspace", vspace) + this.makeAttr("align", align) + this.makeAttr("codebase", iepluginurl) + '>';
            this.out.printil("out.write(" + Generator.quote(s0) + s1 + s2 + " + " + Generator.quote(s3) + ");");
            this.out.printil("out.write(\"\\n\");");
            s0 = "<PARAM name=\"java_code\"" + this.makeAttr("value", code) + '>';
            this.out.printil("out.write(" + Generator.quote(s0) + ");");
            this.out.printil("out.write(\"\\n\");");
            if (codebase != null) {
                s0 = "<PARAM name=\"java_codebase\"" + this.makeAttr("value", codebase) + '>';
                this.out.printil("out.write(" + Generator.quote(s0) + ");");
                this.out.printil("out.write(\"\\n\");");
            }
            if (archive != null) {
                s0 = "<PARAM name=\"java_archive\"" + this.makeAttr("value", archive) + '>';
                this.out.printil("out.write(" + Generator.quote(s0) + ");");
                this.out.printil("out.write(\"\\n\");");
            }
            s0 = "<PARAM name=\"type\"" + this.makeAttr("value", "application/x-java-" + type + ";" + (jreversion == null ? "" : "version=" + jreversion)) + '>';
            this.out.printil("out.write(" + Generator.quote(s0) + ");");
            this.out.printil("out.write(\"\\n\");");
            if (n.getBody() != null) {
                n.getBody().visit(new ParamVisitor(this, true));
            }
            this.out.printil("out.write(" + Generator.quote("<COMMENT>") + ");");
            this.out.printil("out.write(\"\\n\");");
            s0 = "<EMBED" + this.makeAttr("type", "application/x-java-" + type + ";" + (jreversion == null ? "" : "version=" + jreversion)) + this.makeAttr("name", name);
            s3 = this.makeAttr("hspace", hspace) + this.makeAttr("vspace", vspace) + this.makeAttr("align", align) + this.makeAttr("pluginspage", nspluginurl) + this.makeAttr("java_code", code) + this.makeAttr("java_codebase", codebase) + this.makeAttr("java_archive", archive);
            this.out.printil("out.write(" + Generator.quote(s0) + s1 + s2 + " + " + Generator.quote(s3) + ");");
            if (n.getBody() != null) {
                n.getBody().visit(new ParamVisitor(this, false));
            }
            this.out.printil("out.write(" + Generator.quote("/>") + ");");
            this.out.printil("out.write(\"\\n\");");
            this.out.printil("out.write(" + Generator.quote("<NOEMBED>") + ");");
            this.out.printil("out.write(\"\\n\");");
            if (n.getBody() != null) {
                this.visitBody(n);
                this.out.printil("out.write(\"\\n\");");
            }
            this.out.printil("out.write(" + Generator.quote("</NOEMBED>") + ");");
            this.out.printil("out.write(\"\\n\");");
            this.out.printil("out.write(" + Generator.quote("</COMMENT>") + ");");
            this.out.printil("out.write(\"\\n\");");
            this.out.printil("out.write(" + Generator.quote("</OBJECT>") + ");");
            this.out.printil("out.write(\"\\n\");");
            n.setEndJavaLine(this.out.getJavaLine());
        }

        public void visit(Node.NamedAttribute n) throws JasperException {
        }

        public void visit(Node.CustomTag n) throws JasperException {
            if (n.useTagPlugin()) {
                this.generateTagPlugin(n);
                return;
            }
            TagHandlerInfo handlerInfo = this.getTagHandlerInfo(n);
            String baseVar = this.createTagVarName(n.getQName(), n.getPrefix(), n.getLocalName());
            String tagEvalVar = "_jspx_eval_" + baseVar;
            String tagHandlerVar = "_jspx_th_" + baseVar;
            String tagPushBodyCountVar = "_jspx_push_body_count_" + baseVar;
            ServletWriter outSave = null;
            MethodsBuffer methodsBufferSave = null;
            Node.ChildInfo ci = n.getChildInfo();
            if (ci.isScriptless() && !ci.hasScriptingVars()) {
                String tagMethod = "_jspx_meth_" + baseVar;
                this.out.printin("if (");
                this.out.print(tagMethod);
                this.out.print("(");
                if (this.parent != null) {
                    this.out.print(this.parent);
                    this.out.print(", ");
                }
                this.out.print("pageContext");
                if (this.pushBodyCountVar != null) {
                    this.out.print(", ");
                    this.out.print(this.pushBodyCountVar);
                }
                this.out.println("))");
                this.out.pushIndent();
                this.out.printil(this.methodNesting > 0 ? "return true;" : "return;");
                this.out.popIndent();
                outSave = this.out;
                this.out = this.methodsBuffer.getOut();
                methodsBufferSave = this.methodsBuffer;
                this.methodsBuffer = new MethodsBuffer();
                ++this.methodNesting;
                this.out.println();
                this.out.pushIndent();
                this.out.printin("private boolean ");
                this.out.print(tagMethod);
                this.out.print("(");
                if (this.parent != null) {
                    this.out.print("javax.servlet.jsp.tagext.JspTag ");
                    this.out.print(this.parent);
                    this.out.print(", ");
                }
                this.out.print("PageContext pageContext");
                if (this.pushBodyCountVar != null) {
                    this.out.print(", int[] ");
                    this.out.print(this.pushBodyCountVar);
                }
                this.out.println(")");
                this.out.printil("        throws Throwable {");
                this.out.pushIndent();
                this.out.printil("JspWriter out = pageContext.getOut();");
                Generator.generateLocalVariables(this.out, n);
            }
            if (n.implementsSimpleTag()) {
                this.generateCustomDoTag(n, handlerInfo, tagHandlerVar);
            } else {
                this.generateCustomStart(n, handlerInfo, tagHandlerVar, tagEvalVar, tagPushBodyCountVar);
                String tmpParent = this.parent;
                this.parent = tagHandlerVar;
                String tmpPushBodyCountVar = null;
                if (n.implementsTryCatchFinally()) {
                    tmpPushBodyCountVar = this.pushBodyCountVar;
                    this.pushBodyCountVar = tagPushBodyCountVar;
                }
                boolean tmpIsSimpleTagHandler = this.isSimpleTagHandler;
                this.isSimpleTagHandler = false;
                this.visitBody(n);
                this.parent = tmpParent;
                if (n.implementsTryCatchFinally()) {
                    this.pushBodyCountVar = tmpPushBodyCountVar;
                }
                this.isSimpleTagHandler = tmpIsSimpleTagHandler;
                this.generateCustomEnd(n, tagHandlerVar, tagEvalVar, tagPushBodyCountVar);
            }
            if (ci.isScriptless() && !ci.hasScriptingVars()) {
                if (this.methodNesting > 0) {
                    this.out.printil("return false;");
                }
                this.out.popIndent();
                this.out.printil("}");
                this.out.popIndent();
                --this.methodNesting;
                this.out.print(this.methodsBuffer.toString());
                this.methodsBuffer = methodsBufferSave;
                this.out = outSave;
            }
        }

        public void visit(Node.UninterpretedTag n) throws JasperException {
            this.out.printin("out.write(\"<");
            this.out.print(n.getQName());
            Attributes attrs = n.getNonTaglibXmlnsAttributes();
            int attrsLen = attrs == null ? 0 : attrs.getLength();
            int i = 0;
            while (i < attrsLen) {
                this.out.print(" ");
                this.out.print(attrs.getQName(i));
                this.out.print("=");
                String quote = DOUBLE_QUOTE;
                String value = attrs.getValue(i);
                if (value.indexOf(34) != -1) {
                    quote = SINGLE_QUOTE;
                }
                this.out.print(quote);
                this.out.print(value);
                this.out.print(quote);
                ++i;
            }
            attrs = n.getAttributes();
            attrsLen = attrs == null ? 0 : attrs.getLength();
            Node.JspAttribute[] jspAttrs = n.getJspAttributes();
            int i2 = 0;
            while (i2 < attrsLen) {
                this.out.print(" ");
                this.out.print(attrs.getQName(i2));
                this.out.print("=");
                if (jspAttrs[i2].isELInterpreterInput()) {
                    this.out.print("\\\"\" + ");
                    this.out.print(this.attributeValue(jspAttrs[i2], false, class$java$lang$Object == null ? Generator.class$("java.lang.Object") : class$java$lang$Object));
                    this.out.print(" + \"\\\"");
                } else {
                    String quote = DOUBLE_QUOTE;
                    String value = attrs.getValue(i2);
                    if (value.indexOf(34) != -1) {
                        quote = SINGLE_QUOTE;
                    }
                    this.out.print(quote);
                    this.out.print(value);
                    this.out.print(quote);
                }
                ++i2;
            }
            if (n.getBody() != null) {
                this.out.println(">\");");
                this.visitBody(n);
                this.out.printin("out.write(\"</");
                this.out.print(n.getQName());
                this.out.println(">\");");
            } else {
                this.out.println("/>\");");
            }
        }

        public void visit(Node.JspElement n) throws JasperException {
            Hashtable<String, String> map = new Hashtable<String, String>();
            Node.JspAttribute[] attrs = n.getJspAttributes();
            int i = 0;
            while (attrs != null && i < attrs.length) {
                String attrStr = null;
                attrStr = attrs[i].isNamedAttribute() ? this.generateNamedAttributeValue(attrs[i].getNamedAttributeNode()) : this.attributeValue(attrs[i], false, class$java$lang$Object == null ? Generator.class$("java.lang.Object") : class$java$lang$Object);
                String s = " + \" " + attrs[i].getName() + "=\\\"\" + " + attrStr + " + \"\\\"\"";
                map.put(attrs[i].getName(), s);
                ++i;
            }
            String elemName = this.attributeValue(n.getNameAttribute(), false, class$java$lang$String == null ? (class$java$lang$String = Generator.class$("java.lang.String")) : class$java$lang$String);
            this.out.printin("out.write(\"<\"");
            this.out.print(" + " + elemName);
            Enumeration enumeration = map.keys();
            while (enumeration.hasMoreElements()) {
                String attrName = (String)enumeration.nextElement();
                this.out.print((String)map.get(attrName));
            }
            boolean hasBody = false;
            Node.Nodes subelements = n.getBody();
            if (subelements != null) {
                int i2 = 0;
                while (i2 < subelements.size()) {
                    Node subelem = subelements.getNode(i2);
                    if (!(subelem instanceof Node.NamedAttribute)) {
                        hasBody = true;
                        break;
                    }
                    ++i2;
                }
            }
            if (hasBody) {
                this.out.println(" + \">\");");
                this.visitBody(n);
                this.out.printin("out.write(\"</\"");
                this.out.print(" + " + elemName);
                this.out.println(" + \">\");");
            } else {
                this.out.println(" + \"/>\");");
            }
        }

        public void visit(Node.TemplateText n) throws JasperException {
            String text = n.getText();
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin();
            StringBuffer sb = new StringBuffer("out.write(\"");
            int initLength = sb.length();
            int count = 1024;
            int i = 0;
            while (i < text.length()) {
                char ch = text.charAt(i);
                --count;
                switch (ch) {
                    case '\"': {
                        sb.append('\\').append('\"');
                        break;
                    }
                    case '\\': {
                        sb.append('\\').append('\\');
                        break;
                    }
                    case '\r': {
                        sb.append('\\').append('r');
                        break;
                    }
                    case '\n': {
                        sb.append('\\').append('n');
                        if (!Generator.this.breakAtLF && count >= 0) break;
                        sb.append("\");");
                        this.out.println(sb.toString());
                        this.out.printin();
                        sb.setLength(initLength);
                        count = 1024;
                        break;
                    }
                    case '\t': {
                        sb.append('\\').append('t');
                        break;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
                ++i;
            }
            if (sb.length() > initLength) {
                sb.append("\");");
                this.out.println(sb.toString());
            }
            n.setEndJavaLine(this.out.getJavaLine());
        }

        public void visit(Node.JspBody n) throws JasperException {
            if (n.getBody() != null) {
                if (this.isSimpleTagHandler) {
                    this.out.printin(this.simpleTagHandlerVar);
                    this.out.print(".setJspBody(");
                    this.generateJspFragment(n, this.simpleTagHandlerVar);
                    this.out.println(");");
                } else {
                    this.visitBody(n);
                }
            }
        }

        public void visit(Node.InvokeAction n) throws JasperException {
            this.out.printil("((org.apache.jasper.runtime.JspContextWrapper) this.jspContext).syncBeforeInvoke();");
            String varReaderAttr = n.getTextAttribute("varReader");
            String varAttr = n.getTextAttribute("var");
            if (varReaderAttr != null || varAttr != null) {
                this.out.printil("_jspx_sout = new java.io.StringWriter();");
            } else {
                this.out.printil("_jspx_sout = null;");
            }
            this.out.printin(Generator.this.toGetterMethod(n.getTextAttribute("fragment")));
            this.out.println(".invoke(_jspx_sout);");
            if (varReaderAttr != null || varAttr != null) {
                String scopeName = n.getTextAttribute("scope");
                this.out.printin("pageContext.setAttribute(");
                if (varReaderAttr != null) {
                    this.out.print(Generator.quote(varReaderAttr));
                    this.out.print(", new java.io.StringReader(_jspx_sout.toString())");
                } else {
                    this.out.print(Generator.quote(varAttr));
                    this.out.print(", _jspx_sout.toString()");
                }
                if (scopeName != null) {
                    this.out.print(", ");
                    this.out.print(this.getScopeConstant(scopeName));
                }
                this.out.println(");");
            }
        }

        public void visit(Node.DoBodyAction n) throws JasperException {
            this.out.printil("((org.apache.jasper.runtime.JspContextWrapper) this.jspContext).syncBeforeInvoke();");
            String varReaderAttr = n.getTextAttribute("varReader");
            String varAttr = n.getTextAttribute("var");
            if (varReaderAttr != null || varAttr != null) {
                this.out.printil("_jspx_sout = new java.io.StringWriter();");
            } else {
                this.out.printil("_jspx_sout = null;");
            }
            this.out.printil("if (getJspBody() != null)");
            this.out.pushIndent();
            this.out.printil("getJspBody().invoke(_jspx_sout);");
            this.out.popIndent();
            if (varReaderAttr != null || varAttr != null) {
                String scopeName = n.getTextAttribute("scope");
                this.out.printin("pageContext.setAttribute(");
                if (varReaderAttr != null) {
                    this.out.print(Generator.quote(varReaderAttr));
                    this.out.print(", new java.io.StringReader(_jspx_sout.toString())");
                } else {
                    this.out.print(Generator.quote(varAttr));
                    this.out.print(", _jspx_sout.toString()");
                }
                if (scopeName != null) {
                    this.out.print(", ");
                    this.out.print(this.getScopeConstant(scopeName));
                }
                this.out.println(");");
            }
        }

        public void visit(Node.AttributeGenerator n) throws JasperException {
            Node.CustomTag tag = n.getTag();
            Node.JspAttribute[] attrs = tag.getJspAttributes();
            int i = 0;
            while (attrs != null && i < attrs.length) {
                if (attrs[i].getName().equals(n.getName())) {
                    this.out.print(this.evaluateAttribute(this.getTagHandlerInfo(tag), attrs[i], tag, null));
                    break;
                }
                ++i;
            }
        }

        private TagHandlerInfo getTagHandlerInfo(Node.CustomTag n) throws JasperException {
            TagHandlerInfo handlerInfo;
            Hashtable<String, TagHandlerInfo> handlerInfosByShortName = (Hashtable<String, TagHandlerInfo>)this.handlerInfos.get(n.getPrefix());
            if (handlerInfosByShortName == null) {
                handlerInfosByShortName = new Hashtable<String, TagHandlerInfo>();
                this.handlerInfos.put(n.getPrefix(), handlerInfosByShortName);
            }
            if ((handlerInfo = (TagHandlerInfo)handlerInfosByShortName.get(n.getLocalName())) == null) {
                handlerInfo = new TagHandlerInfo(n, n.getTagHandlerClass(), Generator.this.err);
                handlerInfosByShortName.put(n.getLocalName(), handlerInfo);
            }
            return handlerInfo;
        }

        private void generateTagPlugin(Node.CustomTag n) throws JasperException {
            if (n.getAtSTag() != null) {
                n.getAtSTag().visit(this);
            }
            this.visitBody(n);
            if (n.getAtETag() != null) {
                n.getAtETag().visit(this);
            }
        }

        private void generateCustomStart(Node.CustomTag n, TagHandlerInfo handlerInfo, String tagHandlerVar, String tagEvalVar, String tagPushBodyCountVar) throws JasperException {
            Class tagHandlerClass = handlerInfo.getTagHandlerClass();
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin("/* ----  ");
            this.out.print(n.getQName());
            this.out.println(" ---- */");
            this.declareScriptingVars(n, 1);
            this.saveScriptingVars(n, 1);
            this.out.printin(tagHandlerClass.getName());
            this.out.print(" ");
            this.out.print(tagHandlerVar);
            this.out.print(" = ");
            if (Generator.this.ctxt.getOptions().isPoolingEnabled()) {
                this.out.print("(");
                this.out.print(tagHandlerClass.getName());
                this.out.print(") ");
                this.out.print(n.getTagHandlerPoolName());
                this.out.print(".get(");
                this.out.print(tagHandlerClass.getName());
                this.out.println(".class);");
            } else {
                this.out.print("new ");
                this.out.print(tagHandlerClass.getName());
                this.out.println("();");
            }
            this.generateSetters(n, tagHandlerVar, handlerInfo, false);
            if (n.implementsTryCatchFinally()) {
                this.out.printin("int[] ");
                this.out.print(tagPushBodyCountVar);
                this.out.println(" = new int[] { 0 };");
                this.out.printil("try {");
                this.out.pushIndent();
            }
            this.out.printin("int ");
            this.out.print(tagEvalVar);
            this.out.print(" = ");
            this.out.print(tagHandlerVar);
            this.out.println(".doStartTag();");
            if (!n.implementsBodyTag()) {
                this.syncScriptingVars(n, 1);
            }
            if (!n.hasEmptyBody()) {
                this.out.printin("if (");
                this.out.print(tagEvalVar);
                this.out.println(" != javax.servlet.jsp.tagext.Tag.SKIP_BODY) {");
                this.out.pushIndent();
                this.declareScriptingVars(n, 0);
                this.saveScriptingVars(n, 0);
                if (n.implementsBodyTag()) {
                    this.out.printin("if (");
                    this.out.print(tagEvalVar);
                    this.out.println(" != javax.servlet.jsp.tagext.Tag.EVAL_BODY_INCLUDE) {");
                    this.out.pushIndent();
                    this.out.printil("out = pageContext.pushBody();");
                    if (n.implementsTryCatchFinally()) {
                        this.out.printin(tagPushBodyCountVar);
                        this.out.println("[0]++;");
                    } else if (this.pushBodyCountVar != null) {
                        this.out.printin(this.pushBodyCountVar);
                        this.out.println("[0]++;");
                    }
                    this.out.printin(tagHandlerVar);
                    this.out.println(".setBodyContent((javax.servlet.jsp.tagext.BodyContent) out);");
                    this.out.printin(tagHandlerVar);
                    this.out.println(".doInitBody();");
                    this.out.popIndent();
                    this.out.printil("}");
                    this.syncScriptingVars(n, 1);
                    this.syncScriptingVars(n, 0);
                } else {
                    this.syncScriptingVars(n, 0);
                }
                if (n.implementsIterationTag()) {
                    this.out.printil("do {");
                    this.out.pushIndent();
                }
            }
        }

        private void generateCustomEnd(Node.CustomTag n, String tagHandlerVar, String tagEvalVar, String tagPushBodyCountVar) {
            if (!n.hasEmptyBody()) {
                if (n.implementsIterationTag()) {
                    this.out.printin("int evalDoAfterBody = ");
                    this.out.print(tagHandlerVar);
                    this.out.println(".doAfterBody();");
                    this.syncScriptingVars(n, 1);
                    this.syncScriptingVars(n, 0);
                    this.out.printil("if (evalDoAfterBody != javax.servlet.jsp.tagext.BodyTag.EVAL_BODY_AGAIN)");
                    this.out.pushIndent();
                    this.out.printil("break;");
                    this.out.popIndent();
                    this.out.popIndent();
                    this.out.printil("} while (true);");
                }
                this.restoreScriptingVars(n, 0);
                if (n.implementsBodyTag()) {
                    this.out.printin("if (");
                    this.out.print(tagEvalVar);
                    this.out.println(" != javax.servlet.jsp.tagext.Tag.EVAL_BODY_INCLUDE)");
                    this.out.pushIndent();
                    this.out.printil("out = pageContext.popBody();");
                    if (n.implementsTryCatchFinally()) {
                        this.out.printin(tagPushBodyCountVar);
                        this.out.println("[0]--;");
                    } else if (this.pushBodyCountVar != null) {
                        this.out.printin(this.pushBodyCountVar);
                        this.out.println("[0]--;");
                    }
                    this.out.popIndent();
                }
                this.out.popIndent();
                this.out.printil("}");
            }
            this.out.printin("if (");
            this.out.print(tagHandlerVar);
            this.out.println(".doEndTag() == javax.servlet.jsp.tagext.Tag.SKIP_PAGE)");
            this.out.pushIndent();
            if (this.isTagFile || this.isFragment) {
                this.out.printil("throw new javax.servlet.jsp.SkipPageException();");
            } else {
                this.out.printil(this.methodNesting > 0 ? "return true;" : "return;");
            }
            this.out.popIndent();
            this.syncScriptingVars(n, 1);
            if (n.implementsTryCatchFinally()) {
                this.out.popIndent();
                this.out.printil("} catch (Throwable _jspx_exception) {");
                this.out.pushIndent();
                this.out.printin("while (");
                this.out.print(tagPushBodyCountVar);
                this.out.println("[0]-- > 0)");
                this.out.pushIndent();
                this.out.printil("out = pageContext.popBody();");
                this.out.popIndent();
                this.out.printin(tagHandlerVar);
                this.out.println(".doCatch(_jspx_exception);");
                this.out.popIndent();
                this.out.printil("} finally {");
                this.out.pushIndent();
                this.out.printin(tagHandlerVar);
                this.out.println(".doFinally();");
            }
            if (Generator.this.ctxt.getOptions().isPoolingEnabled()) {
                this.out.printin(n.getTagHandlerPoolName());
                this.out.print(".reuse(");
                this.out.print(tagHandlerVar);
                this.out.println(");");
            }
            if (n.implementsTryCatchFinally()) {
                this.out.popIndent();
                this.out.printil("}");
            }
            this.declareScriptingVars(n, 2);
            this.syncScriptingVars(n, 2);
            this.restoreScriptingVars(n, 1);
            n.setEndJavaLine(this.out.getJavaLine());
        }

        private void generateCustomDoTag(Node.CustomTag n, TagHandlerInfo handlerInfo, String tagHandlerVar) throws JasperException {
            Class tagHandlerClass = handlerInfo.getTagHandlerClass();
            n.setBeginJavaLine(this.out.getJavaLine());
            this.out.printin("/* ----  ");
            this.out.print(n.getQName());
            this.out.println(" ---- */");
            this.declareScriptingVars(n, 1);
            this.saveScriptingVars(n, 1);
            this.out.printin(tagHandlerClass.getName());
            this.out.print(" ");
            this.out.print(tagHandlerVar);
            this.out.print(" = ");
            this.out.print("new ");
            this.out.print(tagHandlerClass.getName());
            this.out.println("();");
            this.generateSetters(n, tagHandlerVar, handlerInfo, true);
            if (this.findJspBody(n) == null) {
                if (!n.hasEmptyBody()) {
                    this.out.printin(tagHandlerVar);
                    this.out.print(".setJspBody(");
                    this.generateJspFragment(n, tagHandlerVar);
                    this.out.println(");");
                }
            } else {
                String tmpTagHandlerVar = this.simpleTagHandlerVar;
                this.simpleTagHandlerVar = tagHandlerVar;
                boolean tmpIsSimpleTagHandler = this.isSimpleTagHandler;
                this.isSimpleTagHandler = true;
                this.visitBody(n);
                this.simpleTagHandlerVar = tmpTagHandlerVar;
                this.isSimpleTagHandler = tmpIsSimpleTagHandler;
            }
            this.out.printin(tagHandlerVar);
            this.out.println(".doTag();");
            this.restoreScriptingVars(n, 1);
            this.syncScriptingVars(n, 1);
            this.declareScriptingVars(n, 2);
            this.syncScriptingVars(n, 2);
            n.setEndJavaLine(this.out.getJavaLine());
        }

        private void declareScriptingVars(Node.CustomTag n, int scope) {
            block6: {
                Vector vec = n.getScriptingVars(scope);
                if (vec == null) break block6;
                int i = 0;
                while (i < vec.size()) {
                    block8: {
                        String varName;
                        TagVariableInfo tagVarInfo;
                        block10: {
                            block9: {
                                Object elem;
                                block7: {
                                    elem = vec.elementAt(i);
                                    if (!(elem instanceof VariableInfo)) break block7;
                                    VariableInfo varInfo = (VariableInfo)elem;
                                    if (varInfo.getDeclare()) {
                                        this.out.printin(varInfo.getClassName());
                                        this.out.print(" ");
                                        this.out.print(varInfo.getVarName());
                                        this.out.println(" = null;");
                                    }
                                    break block8;
                                }
                                tagVarInfo = (TagVariableInfo)elem;
                                if (!tagVarInfo.getDeclare()) break block8;
                                varName = tagVarInfo.getNameGiven();
                                if (varName != null) break block9;
                                varName = n.getTagData().getAttributeString(tagVarInfo.getNameFromAttribute());
                                break block10;
                            }
                            if (tagVarInfo.getNameFromAttribute() != null) break block8;
                        }
                        this.out.printin(tagVarInfo.getClassName());
                        this.out.print(" ");
                        this.out.print(varName);
                        this.out.println(" = null;");
                    }
                    ++i;
                }
            }
        }

        private void saveScriptingVars(Node.CustomTag n, int scope) {
            block9: {
                TagVariableInfo[] tagVarInfos;
                block8: {
                    if (n.getCustomNestingLevel() == 0) {
                        return;
                    }
                    tagVarInfos = n.getTagVariableInfos();
                    VariableInfo[] varInfos = n.getVariableInfos();
                    if (varInfos.length == 0 && tagVarInfos.length == 0) {
                        return;
                    }
                    if (varInfos.length <= 0) break block8;
                    int i = 0;
                    while (i < varInfos.length) {
                        if (varInfos[i].getScope() == scope) {
                            String varName = varInfos[i].getVarName();
                            String tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel();
                            this.out.printin(tmpVarName);
                            this.out.print(" = ");
                            this.out.print(varName);
                            this.out.println(";");
                        }
                        ++i;
                    }
                    break block9;
                }
                int i = 0;
                while (i < tagVarInfos.length) {
                    block10: {
                        String varName;
                        block12: {
                            block11: {
                                if (tagVarInfos[i].getScope() != scope) break block10;
                                varName = tagVarInfos[i].getNameGiven();
                                if (varName != null) break block11;
                                varName = n.getTagData().getAttributeString(tagVarInfos[i].getNameFromAttribute());
                                break block12;
                            }
                            if (tagVarInfos[i].getNameFromAttribute() != null) break block10;
                        }
                        String tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel();
                        this.out.printin(tmpVarName);
                        this.out.print(" = ");
                        this.out.print(varName);
                        this.out.println(";");
                    }
                    ++i;
                }
            }
        }

        private void restoreScriptingVars(Node.CustomTag n, int scope) {
            block9: {
                TagVariableInfo[] tagVarInfos;
                block8: {
                    if (n.getCustomNestingLevel() == 0) {
                        return;
                    }
                    tagVarInfos = n.getTagVariableInfos();
                    VariableInfo[] varInfos = n.getVariableInfos();
                    if (varInfos.length == 0 && tagVarInfos.length == 0) {
                        return;
                    }
                    if (varInfos.length <= 0) break block8;
                    int i = 0;
                    while (i < varInfos.length) {
                        if (varInfos[i].getScope() == scope) {
                            String varName = varInfos[i].getVarName();
                            String tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel();
                            this.out.printin(varName);
                            this.out.print(" = ");
                            this.out.print(tmpVarName);
                            this.out.println(";");
                        }
                        ++i;
                    }
                    break block9;
                }
                int i = 0;
                while (i < tagVarInfos.length) {
                    block10: {
                        String varName;
                        block12: {
                            block11: {
                                if (tagVarInfos[i].getScope() != scope) break block10;
                                varName = tagVarInfos[i].getNameGiven();
                                if (varName != null) break block11;
                                varName = n.getTagData().getAttributeString(tagVarInfos[i].getNameFromAttribute());
                                break block12;
                            }
                            if (tagVarInfos[i].getNameFromAttribute() != null) break block10;
                        }
                        String tmpVarName = "_jspx_" + varName + "_" + n.getCustomNestingLevel();
                        this.out.printin(varName);
                        this.out.print(" = ");
                        this.out.print(tmpVarName);
                        this.out.println(";");
                    }
                    ++i;
                }
            }
        }

        private void syncScriptingVars(Node.CustomTag n, int scope) {
            block8: {
                TagVariableInfo[] tagVarInfos;
                block7: {
                    tagVarInfos = n.getTagVariableInfos();
                    VariableInfo[] varInfos = n.getVariableInfos();
                    if (varInfos.length == 0 && tagVarInfos.length == 0) {
                        return;
                    }
                    if (varInfos.length <= 0) break block7;
                    int i = 0;
                    while (i < varInfos.length) {
                        if (varInfos[i].getScope() == scope) {
                            this.out.printin(varInfos[i].getVarName());
                            this.out.print(" = (");
                            this.out.print(varInfos[i].getClassName());
                            this.out.print(") pageContext.findAttribute(");
                            this.out.print(Generator.quote(varInfos[i].getVarName()));
                            this.out.println(");");
                        }
                        ++i;
                    }
                    break block8;
                }
                int i = 0;
                while (i < tagVarInfos.length) {
                    block9: {
                        String name;
                        block11: {
                            block10: {
                                if (tagVarInfos[i].getScope() != scope) break block9;
                                name = tagVarInfos[i].getNameGiven();
                                if (name != null) break block10;
                                name = n.getTagData().getAttributeString(tagVarInfos[i].getNameFromAttribute());
                                break block11;
                            }
                            if (tagVarInfos[i].getNameFromAttribute() != null) break block9;
                        }
                        this.out.printin(name);
                        this.out.print(" = (");
                        this.out.print(tagVarInfos[i].getClassName());
                        this.out.print(") pageContext.findAttribute(");
                        this.out.print(Generator.quote(name));
                        this.out.println(");");
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String createTagVarName(String fullName, String prefix, String shortName) {
            if (prefix.indexOf(45) >= 0) {
                prefix = JspUtil.replace(prefix, '-', "$1");
            }
            if (prefix.indexOf(46) >= 0) {
                prefix = JspUtil.replace(prefix, '.', "$2");
            }
            if (shortName.indexOf(45) >= 0) {
                shortName = JspUtil.replace(shortName, '-', "$1");
            }
            if (shortName.indexOf(46) >= 0) {
                shortName = JspUtil.replace(shortName, '.', "$2");
            }
            if (shortName.indexOf(58) >= 0) {
                shortName = JspUtil.replace(shortName, ':', "$3");
            }
            Hashtable hashtable = this.tagVarNumbers;
            synchronized (hashtable) {
                String varName = prefix + "_" + shortName + "_";
                if (this.tagVarNumbers.get(fullName) != null) {
                    Integer i = (Integer)this.tagVarNumbers.get(fullName);
                    varName = varName + i;
                    this.tagVarNumbers.put(fullName, new Integer(i + 1));
                    return varName;
                }
                this.tagVarNumbers.put(fullName, new Integer(1));
                return varName + "0";
            }
        }

        private String evaluateAttribute(TagHandlerInfo handlerInfo, Node.JspAttribute attr, Node.CustomTag n, String tagHandlerVar) throws JasperException {
            String attrValue = attr.getValue();
            if (attrValue == null) {
                if (attr.isNamedAttribute()) {
                    attrValue = n.checkIfAttributeIsJspFragment(attr.getName()) ? this.generateNamedAttributeJspFragment(attr.getNamedAttributeNode(), tagHandlerVar) : this.generateNamedAttributeValue(attr.getNamedAttributeNode());
                } else {
                    return null;
                }
            }
            String localName = attr.getLocalName();
            Method m = null;
            Class[] c = null;
            if (attr.isDynamic()) {
                c = OBJECT_CLASS;
            } else {
                m = handlerInfo.getSetterMethod(localName);
                if (m == null) {
                    Generator.this.err.jspError(n, "jsp.error.unable.to_find_method", attr.getName());
                }
                c = m.getParameterTypes();
            }
            if (!attr.isExpression()) {
                if (attr.isNamedAttribute()) {
                    if (!n.checkIfAttributeIsJspFragment(attr.getName()) && !attr.isDynamic()) {
                        attrValue = this.convertString(c[0], attrValue, localName, handlerInfo.getPropertyEditorClass(localName), true);
                    }
                } else if (attr.isELInterpreterInput()) {
                    boolean replaceESC = attrValue.indexOf(27) > 0;
                    attrValue = JspUtil.interpreterCall(this.isTagFile, attrValue, c[0], attr.getEL().getMapName(), false);
                    if (replaceESC) {
                        attrValue = "(" + attrValue + ").replace(" + "'\\u001b'" + ", '$')";
                    }
                } else {
                    attrValue = this.convertString(c[0], attrValue, localName, handlerInfo.getPropertyEditorClass(localName), false);
                }
            }
            return attrValue;
        }

        private String generateAliasMap(Node.CustomTag n, String tagHandlerVar) throws JasperException {
            TagVariableInfo[] tagVars = n.getTagVariableInfos();
            String aliasMapVar = null;
            boolean aliasSeen = false;
            int i = 0;
            while (i < tagVars.length) {
                String aliasedName;
                String nameFrom = tagVars[i].getNameFromAttribute();
                if (nameFrom != null && (aliasedName = n.getAttributeValue(nameFrom)) != null) {
                    if (!aliasSeen) {
                        this.out.printin("java.util.HashMap ");
                        aliasMapVar = tagHandlerVar + "_aliasMap";
                        this.out.print(aliasMapVar);
                        this.out.println(" = new java.util.HashMap();");
                        aliasSeen = true;
                    }
                    this.out.printin(aliasMapVar);
                    this.out.print(".put(");
                    this.out.print(Generator.quote(tagVars[i].getNameGiven()));
                    this.out.print(", ");
                    this.out.print(Generator.quote(aliasedName));
                    this.out.println(");");
                }
                ++i;
            }
            return aliasMapVar;
        }

        private void generateSetters(Node.CustomTag n, String tagHandlerVar, TagHandlerInfo handlerInfo, boolean simpleTag) throws JasperException {
            if (simpleTag) {
                String aliasMapVar = null;
                if (n.isTagFile()) {
                    aliasMapVar = this.generateAliasMap(n, tagHandlerVar);
                }
                this.out.printin(tagHandlerVar);
                if (aliasMapVar == null) {
                    this.out.println(".setJspContext(pageContext);");
                } else {
                    this.out.print(".setJspContext(pageContext, ");
                    this.out.print(aliasMapVar);
                    this.out.println(");");
                }
            } else {
                this.out.printin(tagHandlerVar);
                this.out.println(".setPageContext(pageContext);");
            }
            if (!simpleTag) {
                if (this.parent != null) {
                    this.out.printin("if (");
                    this.out.print(this.parent);
                    this.out.println(" instanceof javax.servlet.jsp.tagext.SimpleTag)");
                    this.out.pushIndent();
                    this.out.printin(tagHandlerVar);
                    this.out.print(".setParent(");
                    this.out.print("new javax.servlet.jsp.tagext.TagAdapter(");
                    this.out.print("(javax.servlet.jsp.tagext.SimpleTag) ");
                    this.out.print(this.parent);
                    this.out.println("));");
                    this.out.popIndent();
                    this.out.printil("else");
                    this.out.pushIndent();
                    this.out.printin(tagHandlerVar);
                    this.out.print(".setParent((javax.servlet.jsp.tagext.Tag) ");
                    this.out.print(this.parent);
                    this.out.println(");");
                    this.out.popIndent();
                } else {
                    this.out.printin(tagHandlerVar);
                    this.out.print(".setParent(");
                    this.out.print(this.parent);
                    this.out.println(");");
                }
            } else if (this.parent != null) {
                this.out.printin(tagHandlerVar);
                this.out.print(".setParent(");
                this.out.print(this.parent);
                this.out.println(");");
            }
            Node.JspAttribute[] attrs = n.getJspAttributes();
            int i = 0;
            while (attrs != null && i < attrs.length) {
                String attrValue = this.evaluateAttribute(handlerInfo, attrs[i], n, tagHandlerVar);
                if (attrs[i].isDynamic()) {
                    this.out.printin(tagHandlerVar);
                    this.out.print(".");
                    this.out.print("setDynamicAttribute(");
                    String uri = attrs[i].getURI();
                    if ("".equals(uri) || uri == null) {
                        this.out.print("null");
                    } else {
                        this.out.print("\"" + attrs[i].getURI() + "\"");
                    }
                    this.out.print(", \"");
                    this.out.print(attrs[i].getLocalName());
                    this.out.print("\", ");
                    this.out.print(attrValue);
                    this.out.println(");");
                } else {
                    this.out.printin(tagHandlerVar);
                    this.out.print(".");
                    this.out.print(handlerInfo.getSetterMethod(attrs[i].getLocalName()).getName());
                    this.out.print("(");
                    this.out.print(attrValue);
                    this.out.println(");");
                }
                ++i;
            }
        }

        private String convertString(Class c, String s, String attrName, Class propEditorClass, boolean isNamedAttribute) throws JasperException {
            String quoted = s;
            if (!isNamedAttribute) {
                quoted = Generator.quote(s);
            }
            if (propEditorClass != null) {
                return "(" + c.getName() + ")org.apache.jasper.runtime.JspRuntimeLibrary.getValueFromBeanInfoPropertyEditor(" + c.getName() + ".class, \"" + attrName + "\", " + quoted + ", " + propEditorClass.getName() + ".class)";
            }
            if (c == (class$java$lang$String == null ? (class$java$lang$String = Generator.class$("java.lang.String")) : class$java$lang$String)) {
                return quoted;
            }
            if (c == Boolean.TYPE) {
                return JspUtil.coerceToPrimitiveBoolean(s, isNamedAttribute);
            }
            if (c == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Generator.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return JspUtil.coerceToBoolean(s, isNamedAttribute);
            }
            if (c == Byte.TYPE) {
                return JspUtil.coerceToPrimitiveByte(s, isNamedAttribute);
            }
            if (c == (class$java$lang$Byte == null ? (class$java$lang$Byte = Generator.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return JspUtil.coerceToByte(s, isNamedAttribute);
            }
            if (c == Character.TYPE) {
                return JspUtil.coerceToChar(s, isNamedAttribute);
            }
            if (c == (class$java$lang$Character == null ? (class$java$lang$Character = Generator.class$("java.lang.Character")) : class$java$lang$Character)) {
                return JspUtil.coerceToCharacter(s, isNamedAttribute);
            }
            if (c == Double.TYPE) {
                return JspUtil.coerceToPrimitiveDouble(s, isNamedAttribute);
            }
            if (c == (class$java$lang$Double == null ? (class$java$lang$Double = Generator.class$("java.lang.Double")) : class$java$lang$Double)) {
                return JspUtil.coerceToDouble(s, isNamedAttribute);
            }
            if (c == Float.TYPE) {
                return JspUtil.coerceToPrimitiveFloat(s, isNamedAttribute);
            }
            if (c == (class$java$lang$Float == null ? (class$java$lang$Float = Generator.class$("java.lang.Float")) : class$java$lang$Float)) {
                return JspUtil.coerceToFloat(s, isNamedAttribute);
            }
            if (c == Integer.TYPE) {
                return JspUtil.coerceToInt(s, isNamedAttribute);
            }
            if (c == (class$java$lang$Integer == null ? (class$java$lang$Integer = Generator.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return JspUtil.coerceToInteger(s, isNamedAttribute);
            }
            if (c == Short.TYPE) {
                return JspUtil.coerceToPrimitiveShort(s, isNamedAttribute);
            }
            if (c == (class$java$lang$Short == null ? (class$java$lang$Short = Generator.class$("java.lang.Short")) : class$java$lang$Short)) {
                return JspUtil.coerceToShort(s, isNamedAttribute);
            }
            if (c == Long.TYPE) {
                return JspUtil.coerceToPrimitiveLong(s, isNamedAttribute);
            }
            if (c == (class$java$lang$Long == null ? (class$java$lang$Long = Generator.class$("java.lang.Long")) : class$java$lang$Long)) {
                return JspUtil.coerceToLong(s, isNamedAttribute);
            }
            if (c == (class$java$lang$Object == null ? (class$java$lang$Object = Generator.class$("java.lang.Object")) : class$java$lang$Object)) {
                return "new String(" + quoted + ")";
            }
            return "(" + c.getName() + ")org.apache.jasper.runtime.JspRuntimeLibrary.getValueFromPropertyEditorManager(" + c.getName() + ".class, \"" + attrName + "\", " + quoted + ")";
        }

        private String getScopeConstant(String scope) {
            String scopeName = "PageContext.PAGE_SCOPE";
            if ("request".equals(scope)) {
                scopeName = "PageContext.REQUEST_SCOPE";
            } else if ("session".equals(scope)) {
                scopeName = "PageContext.SESSION_SCOPE";
            } else if ("application".equals(scope)) {
                scopeName = "PageContext.APPLICATION_SCOPE";
            }
            return scopeName;
        }

        private void generateJspFragment(Node n, String tagHandlerVar) throws JasperException {
            FragmentHelperClass.Fragment fragment = this.fragmentHelperClass.openFragment(n, tagHandlerVar, this.methodNesting);
            ServletWriter outSave = this.out;
            this.out = fragment.getMethodsBuffer().getOut();
            String tmpParent = this.parent;
            this.parent = tagHandlerVar;
            boolean tmpIsFragment = this.isFragment;
            this.isFragment = true;
            this.visitBody(n);
            this.out = outSave;
            this.parent = tmpParent;
            this.isFragment = tmpIsFragment;
            this.fragmentHelperClass.closeFragment(fragment, this.methodNesting);
            this.out.print("new " + this.fragmentHelperClass.getClassName() + "( " + fragment.getId() + ", pageContext, " + tagHandlerVar + ")");
        }

        public String generateNamedAttributeValue(Node.NamedAttribute n) throws JasperException {
            String varName = n.getTemporaryVariableName();
            Node.Nodes body = n.getBody();
            if (body != null) {
                Node bodyElement;
                boolean templateTextOptimization = false;
                if (body.size() == 1 && (bodyElement = body.getNode(0)) instanceof Node.TemplateText) {
                    templateTextOptimization = true;
                    this.out.printil("String " + varName + " = " + Generator.quote(new String(((Node.TemplateText)bodyElement).getText())) + ";");
                }
                if (!templateTextOptimization) {
                    this.out.printil("out = pageContext.pushBody();");
                    this.visitBody(n);
                    this.out.printil("String " + varName + " = " + "((javax.servlet.jsp.tagext.BodyContent)" + "out).getString();");
                    this.out.printil("out = pageContext.popBody();");
                }
            } else {
                this.out.printil("String " + varName + " = \"\";");
            }
            return varName;
        }

        public String generateNamedAttributeJspFragment(Node.NamedAttribute n, String tagHandlerVar) throws JasperException {
            String varName = n.getTemporaryVariableName();
            this.out.printin("javax.servlet.jsp.tagext.JspFragment " + varName + " = ");
            this.generateJspFragment(n, tagHandlerVar);
            this.out.println(";");
            return varName;
        }

        static /* synthetic */ ServletWriter access$100(GenerateVisitor x0) {
            return x0.out;
        }

        static /* synthetic */ String access$200(GenerateVisitor x0, Node.JspAttribute x1, boolean x2, Class x3) {
            return x0.attributeValue(x1, x2, x3);
        }
    }
}

