/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspConfig;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.TagPluginManager;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.servlet.JspCServletContext;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.tools.ant.AntClassLoader;

public class JspC
implements Options {
    public static final String DEFAULT_IE_CLASS_ID = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    private static Log log = LogFactory.getLog((Class)(class$org$apache$jasper$JspC == null ? (class$org$apache$jasper$JspC = JspC.class$("org.apache.jasper.JspC")) : class$org$apache$jasper$JspC));
    private static final String SWITCH_VERBOSE = "-v";
    private static final String SWITCH_HELP = "-help";
    private static final String SWITCH_QUIET = "-q";
    private static final String SWITCH_OUTPUT_DIR = "-d";
    private static final String SWITCH_IE_CLASS_ID = "-ieplugin";
    private static final String SWITCH_PACKAGE_NAME = "-p";
    private static final String SWITCH_CLASS_NAME = "-c";
    private static final String SWITCH_FULL_STOP = "--";
    private static final String SWITCH_COMPILE = "-compile";
    private static final String SWITCH_URI_BASE = "-uribase";
    private static final String SWITCH_URI_ROOT = "-uriroot";
    private static final String SWITCH_FILE_WEBAPP = "-webapp";
    private static final String SWITCH_WEBAPP_INC = "-webinc";
    private static final String SWITCH_WEBAPP_XML = "-webxml";
    private static final String SWITCH_MAPPED = "-mapped";
    private static final String SWITCH_DIE = "-die";
    private static final String SHOW_SUCCESS = "-s";
    private static final String LIST_ERRORS = "-l";
    private static final int NO_WEBXML = 0;
    private static final int INC_WEBXML = 10;
    private static final int ALL_WEBXML = 20;
    private static final int DEFAULT_DIE_LEVEL = 1;
    private static final int NO_DIE_LEVEL = 0;
    private static int die;
    private String classPath = null;
    private URLClassLoader loader = null;
    private boolean largeFile = false;
    private boolean mappedFile = false;
    private File scratchDir;
    private String ieClassId = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    private String targetPackage;
    private String targetClassName;
    private String uriBase;
    private String uriRoot;
    private int dieLevel;
    private boolean dieOnExit = false;
    private boolean helpNeeded = false;
    private boolean compile = false;
    private String compiler = null;
    private boolean classDebugInfo = true;
    private Vector extensions;
    private Vector pages = new Vector();
    private String webxmlFile;
    private int webxmlLevel;
    private boolean addWebXmlMappings = false;
    private Writer mapout;
    private CharArrayWriter servletout;
    private CharArrayWriter mappingout;
    private JspCServletContext context;
    private JspRuntimeContext rctxt;
    private TldLocationsCache tldLocationsCache = null;
    private JspConfig jspConfig = null;
    private TagPluginManager tagPluginManager = null;
    private boolean verbose = false;
    private boolean listErrors = false;
    private boolean showSuccess = false;
    private int argPos;
    private boolean fullstop = false;
    private String[] args;
    static /* synthetic */ Class class$org$apache$jasper$JspC;

    public static void main(String[] arg) {
        block5: {
            if (arg.length == 0) {
                System.out.println(Localizer.getMessage("jspc.usage"));
            } else {
                try {
                    JspC jspc = new JspC();
                    jspc.setArgs(arg);
                    if (jspc.helpNeeded) {
                        System.out.println(Localizer.getMessage("jspc.usage"));
                        break block5;
                    }
                    jspc.execute();
                }
                catch (JasperException je) {
                    System.err.print("error:");
                    je.printStackTrace();
                    if (die == 0) break block5;
                    System.exit(die);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setArgs(String[] arg) throws JasperException {
        String file;
        String tok;
        this.args = arg;
        die = this.dieLevel = 0;
        while ((tok = this.nextArg()) != null) {
            void var2_2;
            if (var2_2.equals(SWITCH_VERBOSE)) {
                this.verbose = true;
                this.showSuccess = true;
                this.listErrors = true;
                continue;
            }
            if (var2_2.equals(SWITCH_OUTPUT_DIR)) {
                tok = this.nextArg();
                this.setOutputDir(tok);
                continue;
            }
            if (tok.equals(SWITCH_PACKAGE_NAME)) {
                this.targetPackage = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_COMPILE)) {
                this.compile = true;
                continue;
            }
            if (tok.equals(SWITCH_CLASS_NAME)) {
                this.targetClassName = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_URI_BASE)) {
                this.uriBase = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_URI_ROOT)) {
                this.setUriroot(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_FILE_WEBAPP)) {
                this.setUriroot(this.nextArg());
                continue;
            }
            if (tok.equals(SHOW_SUCCESS)) {
                this.showSuccess = true;
                continue;
            }
            if (tok.equals(LIST_ERRORS)) {
                this.listErrors = true;
                continue;
            }
            if (tok.equals(SWITCH_WEBAPP_INC)) {
                this.webxmlFile = this.nextArg();
                if (this.webxmlFile == null) continue;
                this.webxmlLevel = 10;
                continue;
            }
            if (tok.equals(SWITCH_WEBAPP_XML)) {
                this.webxmlFile = this.nextArg();
                if (this.webxmlFile == null) continue;
                this.webxmlLevel = 20;
                continue;
            }
            if (tok.equals(SWITCH_MAPPED)) {
                this.mappedFile = true;
                continue;
            }
            if (tok.startsWith(SWITCH_DIE)) {
                try {
                    this.dieLevel = Integer.parseInt(tok.substring(SWITCH_DIE.length()));
                }
                catch (NumberFormatException nfe) {
                    this.dieLevel = 1;
                }
                die = this.dieLevel;
                continue;
            }
            if (tok.equals(SWITCH_HELP)) {
                this.helpNeeded = true;
                continue;
            }
            if (tok.startsWith("-")) {
                throw new JasperException("Unrecognized option: " + tok + ".  Use -help for help.");
            }
            if (this.fullstop) break;
            --this.argPos;
            break;
        }
        while ((file = this.nextFile()) != null) {
            this.pages.addElement(file);
        }
    }

    public boolean getKeepGenerated() {
        return true;
    }

    public boolean getLargeFile() {
        return this.largeFile;
    }

    public boolean isPoolingEnabled() {
        return true;
    }

    public int getTagPoolSize() {
        return 5;
    }

    public boolean getMappedFile() {
        return this.mappedFile;
    }

    public Object getProtectionDomain() {
        return null;
    }

    public boolean getSendErrorToClient() {
        return true;
    }

    public void setClassDebugInfo(boolean b) {
        this.classDebugInfo = b;
    }

    public boolean getClassDebugInfo() {
        return this.classDebugInfo;
    }

    public int getCheckInterval() {
        return 300;
    }

    public boolean getDevelopment() {
        return false;
    }

    public boolean getReloading() {
        return true;
    }

    public boolean isSmapSuppressed() {
        return true;
    }

    public boolean isSmapDumped() {
        return false;
    }

    public String getIeClassId() {
        return this.ieClassId;
    }

    public File getScratchDir() {
        return this.scratchDir;
    }

    public Class getJspCompilerPlugin() {
        return null;
    }

    public String getJspCompilerPath() {
        return null;
    }

    public String getCompiler() {
        return this.compiler;
    }

    public void setCompiler(String c) {
        this.compiler = c;
    }

    public TldLocationsCache getTldLocationsCache() {
        return this.tldLocationsCache;
    }

    public String getJavaEncoding() {
        return "UTF-8";
    }

    public boolean getFork() {
        return false;
    }

    public String getClassPath() {
        if (this.classPath != null) {
            return this.classPath;
        }
        return System.getProperty("java.class.path");
    }

    public void setClassPath(String s) {
        this.classPath = s;
    }

    public void setUriroot(String s) {
        if (s == null) {
            this.uriRoot = s;
            return;
        }
        try {
            this.uriRoot = new File(s).getCanonicalPath();
        }
        catch (Exception ex) {
            this.uriRoot = s;
        }
    }

    public void setCompile(boolean b) {
        this.compile = b;
    }

    public void setValidateXml(boolean b) {
        ParserUtils.validating = b;
    }

    public void setListErrors(boolean b) {
        this.listErrors = b;
    }

    public void setOutputDir(String s) {
        this.scratchDir = s != null ? new File(s).getAbsoluteFile() : null;
    }

    public void setPackage(String p) {
        this.targetPackage = p;
    }

    public void setClassName(String p) {
        this.targetClassName = p;
    }

    public void setWebXmlFragment(String s) {
        this.webxmlFile = s;
        this.webxmlLevel = 10;
    }

    public void setWebXml(String s) {
        this.webxmlFile = s;
        this.webxmlLevel = 20;
    }

    public void setAddWebXmlMappings(boolean b) {
        this.addWebXmlMappings = b;
    }

    public JspConfig getJspConfig() {
        return this.jspConfig;
    }

    public TagPluginManager getTagPluginManager() {
        return this.tagPluginManager;
    }

    public void generateWebMapping(String file, JspCompilationContext clctxt) throws IOException {
        String className = clctxt.getServletClassName();
        String packageName = clctxt.getServletPackageName();
        String thisServletName = "".equals(packageName) ? className : packageName + '.' + className;
        if (this.servletout != null) {
            this.servletout.write("\n\t<servlet>\n\t\t<servlet-name>");
            this.servletout.write(thisServletName);
            this.servletout.write("</servlet-name>\n\t\t<servlet-class>");
            this.servletout.write(thisServletName);
            this.servletout.write("</servlet-class>\n\t</servlet>\n");
        }
        if (this.mappingout != null) {
            this.mappingout.write("\n\t<servlet-mapping>\n\t\t<servlet-name>");
            this.mappingout.write(thisServletName);
            this.mappingout.write("</servlet-name>\n\t\t<url-pattern>");
            this.mappingout.write(file.replace('\\', '/'));
            this.mappingout.write("</url-pattern>\n\t</servlet-mapping>\n");
        }
    }

    protected void mergeIntoWebXml() throws Exception {
        int n;
        String line;
        File webappBase = new File(this.uriRoot);
        File webXml = new File(webappBase, "WEB-INF/web.xml");
        File webXml2 = new File(webappBase, "WEB-INF/web2.xml");
        BufferedReader reader = new BufferedReader(new FileReader(webXml));
        BufferedReader fragmentReader = new BufferedReader(new FileReader(this.webxmlFile));
        PrintWriter writer = new PrintWriter(new FileWriter(webXml2));
        while ((line = reader.readLine()) != null) {
            int pos = line.indexOf("</web-app>");
            if (pos >= 0) {
                writer.println(line.substring(0, pos));
                break;
            }
            writer.write(line);
            writer.write("\n");
        }
        while ((line = fragmentReader.readLine()) != null) {
            writer.write(line);
            writer.write("\n");
        }
        writer.write("</web-app>");
        writer.write("\n");
        writer.close();
        reader.close();
        fragmentReader.close();
        FileInputStream fis = new FileInputStream(webXml2);
        FileOutputStream fos = new FileOutputStream(webXml);
        byte[] buf = new byte[512];
        while ((n = fis.read(buf)) >= 0) {
            fos.write(buf, 0, n);
        }
        fis.close();
        fos.close();
        webXml2.delete();
    }

    public boolean processFile(String file) throws JasperException {
        try {
            if (this.scratchDir == null) {
                String temp = System.getProperty("java.io.tmpdir");
                if (temp == null) {
                    temp = "";
                }
                this.scratchDir = new File(new File(temp).getAbsolutePath());
            }
            String jspUri = file.replace('\\', '/');
            JspCompilationContext clctxt = new JspCompilationContext(jspUri, false, this, this.context, null, this.rctxt);
            if (this.targetClassName != null && this.targetClassName.length() > 0) {
                clctxt.setServletClassName(this.targetClassName);
                this.targetClassName = null;
            }
            if (this.targetPackage != null) {
                clctxt.setServletPackageName(this.targetPackage);
            }
            if (this.loader == null) {
                this.initClassLoader(clctxt);
            }
            clctxt.setClassLoader(this.loader);
            clctxt.setClassPath(this.classPath);
            Compiler clc = clctxt.createCompiler();
            if (clc.isOutDated(this.compile)) {
                clc.compile(this.compile);
            }
            this.generateWebMapping(file, clctxt);
            if (this.showSuccess) {
                log.info((Object)("Built File: " + file));
            }
            return true;
        }
        catch (FileNotFoundException fne) {
            if (log.isWarnEnabled()) {
                log.warn((Object)Localizer.getMessage("jspc.error.fileDoesNotExist", fne.getMessage()));
            }
            throw new JasperException((Throwable)fne);
        }
        catch (Exception e) {
            log.error((Object)Localizer.getMessage("jspc.error.generalException", file), (Throwable)e);
            if (this.listErrors) {
                log.warn((Object)("Error in File: " + file), (Throwable)e);
                return true;
            }
            if (this.dieLevel != 0) {
                this.dieOnExit = true;
            }
            throw new JasperException("Error compiling " + file, (Throwable)e);
        }
    }

    public void scanFiles(File base) {
        Stack<Object> dirs = new Stack<Object>();
        dirs.push(base);
        if (this.extensions == null) {
            this.extensions = new Vector();
            this.extensions.addElement("jsp");
            this.extensions.addElement("jspx");
        }
        while (!dirs.isEmpty()) {
            String s = dirs.pop().toString();
            File f = new File(s);
            if (!f.exists() || !f.isDirectory()) continue;
            String[] files = f.list();
            int i = 0;
            while (i < files.length) {
                File f2 = new File(s, files[i]);
                if (f2.isDirectory()) {
                    dirs.push(f2.getPath());
                } else {
                    String ext = files[i].substring(files[i].lastIndexOf(46) + 1);
                    if (this.extensions.contains(ext)) {
                        this.pages.addElement(s + File.separatorChar + files[i]);
                    }
                }
                ++i;
            }
        }
    }

    public void execute() throws JasperException {
        try {
            if (this.uriRoot == null) {
                if (this.pages.size() == 0) {
                    throw new JasperException("No uriRoot or files");
                }
                String firstJsp = (String)this.pages.elementAt(0);
                File firstJspF = new File(firstJsp);
                if (!firstJspF.exists()) {
                    throw new JasperException(Localizer.getMessage("jspc.error.fileDoesNotExist", firstJsp));
                }
                this.locateUriRoot(firstJspF);
            }
            if (this.pages.size() == 0) {
                this.scanFiles(new File(this.uriRoot));
            }
            if (this.uriRoot == null) {
                throw new JasperException(Localizer.getMessage("jsp.error.jspc.no_uriroot"));
            }
            File uriRootF = new File(this.uriRoot);
            if (!uriRootF.exists() || !uriRootF.isDirectory()) {
                throw new JasperException(Localizer.getMessage("jsp.error.jspc.uriroot_not_dir"));
            }
            if (this.context == null) {
                this.initServletContext();
            }
            this.initWebXml();
            Enumeration e = this.pages.elements();
            while (e.hasMoreElements()) {
                String nextjsp = e.nextElement().toString();
                try {
                    File fjsp = new File(nextjsp);
                    if (!fjsp.exists()) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)Localizer.getMessage("jspc.error.fileDoesNotExist", fjsp.toString()));
                        continue;
                    }
                    String s = fjsp.getCanonicalPath();
                    if (s.startsWith(this.uriRoot)) {
                        nextjsp = s.substring(this.uriRoot.length());
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (nextjsp.startsWith("." + File.separatorChar)) {
                    nextjsp = nextjsp.substring(2);
                }
                this.processFile(nextjsp);
            }
            this.completeWebXml();
            if (this.addWebXmlMappings) {
                this.mergeIntoWebXml();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private String nextArg() {
        if (this.argPos >= this.args.length || (this.fullstop = SWITCH_FULL_STOP.equals(this.args[this.argPos]))) {
            return null;
        }
        return this.args[this.argPos++];
    }

    private String nextFile() {
        if (this.fullstop) {
            ++this.argPos;
        }
        if (this.argPos >= this.args.length) {
            return null;
        }
        return this.args[this.argPos++];
    }

    private void initWebXml() {
        try {
            if (this.webxmlLevel >= 10) {
                File fmapings = new File(this.webxmlFile);
                this.mapout = new FileWriter(fmapings);
                this.servletout = new CharArrayWriter();
                this.mappingout = new CharArrayWriter();
            } else {
                this.mapout = null;
                this.servletout = null;
                this.mappingout = null;
            }
            if (this.webxmlLevel >= 20) {
                this.mapout.write(Localizer.getMessage("jspc.webxml.header"));
                this.mapout.flush();
            } else if (this.webxmlLevel >= 10) {
                this.mapout.write(Localizer.getMessage("jspc.webinc.header"));
                this.mapout.flush();
            }
        }
        catch (IOException ioe) {
            this.mapout = null;
            this.servletout = null;
            this.mappingout = null;
        }
    }

    private void completeWebXml() {
        block5: {
            if (this.mapout == null) break block5;
            try {
                this.servletout.writeTo(this.mapout);
                this.mappingout.writeTo(this.mapout);
                if (this.webxmlLevel >= 20) {
                    this.mapout.write(Localizer.getMessage("jspc.webxml.footer"));
                } else if (this.webxmlLevel >= 10) {
                    this.mapout.write(Localizer.getMessage("jspc.webinc.footer"));
                }
                this.mapout.close();
            }
            catch (IOException ioe) {}
        }
    }

    private void initServletContext() {
        try {
            this.context = new JspCServletContext(new PrintWriter(System.out), new URL("file:" + this.uriRoot.replace('\\', '/') + '/'));
            this.tldLocationsCache = new TldLocationsCache(this.context, true);
        }
        catch (MalformedURLException me) {
            System.out.println("**" + me);
        }
        this.rctxt = new JspRuntimeContext(this.context, this);
        this.jspConfig = new JspConfig(this.context);
        this.tagPluginManager = new TagPluginManager(this.context);
    }

    private void initClassLoader(JspCompilationContext clctxt) throws IOException {
        Object path;
        this.classPath = this.getClassPath();
        ClassLoader parent = this.getClass().getClassLoader();
        ArrayList<URL> urls = new ArrayList<URL>();
        File webappBase = new File(this.uriRoot);
        if (parent instanceof URLClassLoader) {
            URLClassLoader uL = (URLClassLoader)parent;
            path = uL.getURLs();
            int i = 0;
            while (i < ((URL[])path).length) {
                urls.add(path[i]);
                this.classPath = this.classPath + File.pathSeparator + path[i].getFile();
                ++i;
            }
        }
        if (parent instanceof AntClassLoader) {
            this.classPath = this.classPath + File.pathSeparator + ((AntClassLoader)parent).getClasspath();
        }
        StringTokenizer tokenizer = new StringTokenizer(this.classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            path = tokenizer.nextToken();
            try {
                File libFile = new File((String)path);
                urls.add(libFile.toURL());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
        }
        if (webappBase.exists()) {
            File classes = new File(webappBase, "/WEB-INF/classes");
            try {
                if (classes.exists()) {
                    this.classPath = this.classPath + File.pathSeparator + classes.getCanonicalPath();
                    urls.add(classes.getCanonicalFile().toURL());
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
            File lib = new File(webappBase, "/WEB-INF/lib");
            if (lib.exists() && lib.isDirectory()) {
                String[] libs = lib.list();
                int i = 0;
                while (i < libs.length) {
                    if (libs[i].length() >= 5) {
                        String ext = libs[i].substring(libs[i].length() - 4);
                        if (!".jar".equalsIgnoreCase(ext)) {
                            System.out.println("XXX bad jar " + libs[i]);
                        } else {
                            try {
                                File libFile = new File(lib, libs[i]);
                                this.classPath = this.classPath + File.pathSeparator + libFile.getCanonicalPath();
                                urls.add(libFile.getCanonicalFile().toURL());
                            }
                            catch (IOException ioe) {
                                throw new RuntimeException(ioe.toString());
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        urls.add(new File(clctxt.getRealPath("/")).getCanonicalFile().toURL());
        URL[] urlsA = new URL[urls.size()];
        urls.toArray(urlsA);
        this.loader = new URLClassLoader(urlsA, this.getClass().getClassLoader());
    }

    private void locateUriRoot(File f) {
        block7: {
            String tUriBase = this.uriBase;
            if (tUriBase == null) {
                tUriBase = "/";
            }
            try {
                if (!f.exists()) break block7;
                f = new File(f.getCanonicalPath());
                while (f != null) {
                    String fParent;
                    File g = new File(f, "WEB-INF");
                    if (g.exists() && g.isDirectory()) {
                        this.uriRoot = f.getCanonicalPath();
                        this.uriBase = tUriBase;
                        if (!log.isInfoEnabled()) break;
                        log.info((Object)Localizer.getMessage("jspc.implicit.uriRoot", this.uriRoot));
                        break;
                    }
                    if (f.exists() && f.isDirectory()) {
                        tUriBase = "/" + f.getName() + "/" + tUriBase;
                    }
                    if ((fParent = f.getParent()) == null) break;
                    f = new File(fParent);
                }
                if (this.uriRoot != null) {
                    File froot = new File(this.uriRoot);
                    this.uriRoot = froot.getCanonicalPath();
                }
            }
            catch (IOException ioe) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

