/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.wme;

import COM.activesw.api.client.BrokerAdminClient;
import COM.activesw.api.client.BrokerConnectionDescriptor;
import COM.activesw.api.client.BrokerException;
import com.wm.broker.jms.QueueConnectionFactoryAdmin;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesAdminFactory;
import hermes.HermesException;
import hermes.JNDIQueueConnectionFactory;
import hermes.ext.wme.WMEAdmin;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.NamingException;

public class WMEAdminFactory
implements HermesAdminFactory {
    public HermesAdmin createSession(Hermes hermes, ConnectionFactory connectionFactory) throws JMSException, NamingException {
        QueueConnectionFactoryAdmin cfAdmin = null;
        if (connectionFactory instanceof JNDIQueueConnectionFactory) {
            JNDIQueueConnectionFactory jndiCF = (JNDIQueueConnectionFactory)connectionFactory;
            return this.createSession(hermes, jndiCF._getConnectionFactory());
        }
        if (connectionFactory instanceof QueueConnectionFactoryAdmin) {
            try {
                cfAdmin = (QueueConnectionFactoryAdmin)connectionFactory;
                BrokerConnectionDescriptor bcd = new BrokerConnectionDescriptor();
                bcd.setConnectionShare(true);
                try {
                    bcd.setConnectionShareLimit(100);
                }
                catch (NoSuchMethodError ex) {
                    // empty catch block
                }
                BrokerAdminClient adminClient = BrokerAdminClient.newOrReconnectAdmin((String)cfAdmin.getBrokerHost(), (String)cfAdmin.getBrokerName(), (String)("admin" + System.currentTimeMillis()), (String)"admin", (String)WMEAdminFactory.class.getName(), (BrokerConnectionDescriptor)bcd);
                return new WMEAdmin(hermes, adminClient);
            }
            catch (BrokerException e) {
                throw new HermesException((Exception)((Object)e));
            }
        }
        throw new HermesException("Provider is not WebMethods JMS");
    }

    public boolean canBlock() throws JMSException {
        return false;
    }
}

