/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.hssf;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellSpanTable;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.CellStyleTable;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.hssf.HssfTableFormat;
import com.jidesoft.swing.StringConverter;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JTable;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hssf.util.Region;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HssfTableUtils {
    private static final Logger a = Logger.getLogger(HssfTableUtils.class.getName());
    static int b = 0;
    public static int c;

    public static boolean isHssfInstalled() {
        try {
            Class.forName("org.apache.poi.hssf.usermodel.HSSFWorkbook");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("You must have hssf.jar in the classpath in order to use Excel exporting feature. Please download it from http://jakarta.apache.org/poi/hssf/index.html and put hssf.jar in the classpath.");
            return false;
        }
    }

    public static boolean export(JTable jTable, String string, String string2, boolean bl) throws IOException {
        return HssfTableUtils.export(jTable, string, string2, bl, true, null);
    }

    public static boolean export(JTable jTable, String string, String string2, boolean bl, boolean bl2) throws IOException {
        return HssfTableUtils.export(jTable, string, string2, bl, bl2, null);
    }

    public static boolean export(JTable jTable, String string, String string2, boolean bl, boolean bl2, CellValueConverter cellValueConverter) throws IOException {
        return HssfTableUtils.export(jTable, 0, 0, -1, -1, string, string2, bl, bl2, cellValueConverter);
    }

    public static boolean export(JTable jTable, int n, int n2, int n3, int n4, String string, String string2, boolean bl, boolean bl2, CellValueConverter cellValueConverter) throws IOException {
        int n5 = c;
        boolean bl3 = HssfTableUtils.isHssfInstalled();
        if (n5 == 0) {
            if (!bl3) {
                return false;
            }
            bl3 = new File(string).exists();
        }
        if (n5 == 0) {
            if (!bl3) {
                bl = false;
            }
            bl3 = bl;
        }
        HSSFWorkbook hSSFWorkbook = bl3 ? new HSSFWorkbook(new POIFSFileSystem(new FileInputStream(string))) : new HSSFWorkbook();
        boolean bl4 = hSSFWorkbook.getSheet(string2) != null;
        HSSFSheet hSSFSheet = bl4 ? hSSFWorkbook.getSheet(string2) : hSSFWorkbook.createSheet(string2);
        HssfTableUtils.exportToSheet(jTable, n, n2, n3, n4, hSSFWorkbook, hSSFSheet, 0, 0, bl2, cellValueConverter);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        hSSFWorkbook.write(fileOutputStream);
        fileOutputStream.close();
        return true;
    }

    public static boolean export(JTable jTable, OutputStream outputStream, String string) throws IOException {
        return HssfTableUtils.export(jTable, outputStream, string, true, null);
    }

    public static boolean export(JTable jTable, OutputStream outputStream, String string, boolean bl) throws IOException {
        return HssfTableUtils.export(jTable, outputStream, string, bl, null);
    }

    public static boolean export(JTable jTable, OutputStream outputStream, String string, boolean bl, CellValueConverter cellValueConverter) throws IOException {
        return HssfTableUtils.export(jTable, outputStream, 0, 0, -1, -1, string, bl, cellValueConverter);
    }

    public static boolean export(JTable jTable, OutputStream outputStream, int n, int n2, int n3, int n4, String string, boolean bl, CellValueConverter cellValueConverter) throws IOException {
        return HssfTableUtils.export(jTable, outputStream, n, n2, n3, n4, string, bl, cellValueConverter, null);
    }

    public static boolean export(JTable jTable, OutputStream outputStream, int n, int n2, int n3, int n4, String string, boolean bl, CellValueConverter cellValueConverter, StringConverter stringConverter) throws IOException {
        block3: {
            boolean bl2;
            block2: {
                bl2 = HssfTableUtils.isHssfInstalled();
                if (c != 0) break block2;
                if (bl2) break block3;
                bl2 = false;
            }
            return bl2;
        }
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook();
        boolean bl3 = hSSFWorkbook.getSheet(string) != null;
        HSSFSheet hSSFSheet = bl3 ? hSSFWorkbook.getSheet(string) : hSSFWorkbook.createSheet(string);
        HssfTableUtils.exportToSheet(jTable, n, n2, n3, n4, hSSFWorkbook, hSSFSheet, 0, 0, bl, cellValueConverter, stringConverter);
        hSSFWorkbook.write(outputStream);
        outputStream.close();
        return true;
    }

    public static void exportToSheet(JTable jTable, HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, int n, int n2) {
        HssfTableUtils.exportToSheet(jTable, hSSFWorkbook, hSSFSheet, n, n2, null);
    }

    public static void exportToSheet(JTable jTable, HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, int n, int n2, CellValueConverter cellValueConverter) {
        HssfTableUtils.exportToSheet(jTable, hSSFWorkbook, hSSFSheet, n, n2, true, cellValueConverter);
    }

    public static void exportToSheet(JTable jTable, HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, int n, int n2, boolean bl) {
        HssfTableUtils.exportToSheet(jTable, hSSFWorkbook, hSSFSheet, n, n2, bl, null);
    }

    public static void exportToSheet(JTable jTable, HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, int n, int n2, boolean bl, CellValueConverter cellValueConverter) {
        HssfTableUtils.exportToSheet(jTable, 0, 0, -1, -1, hSSFWorkbook, hSSFSheet, n, n2, bl, cellValueConverter);
    }

    public static void exportToSheet(JTable jTable, HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, int n, int n2, boolean bl, CellValueConverter cellValueConverter, StringConverter stringConverter) {
        HssfTableUtils.exportToSheet(jTable, 0, 0, -1, -1, hSSFWorkbook, hSSFSheet, n, n2, bl, cellValueConverter, stringConverter);
    }

    public static void exportToSheet(JTable jTable, int n, int n2, int n3, int n4, HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, int n5, int n6, boolean bl, CellValueConverter cellValueConverter) {
        HssfTableUtils.exportToSheet(jTable, n, n2, n3, n4, hSSFWorkbook, hSSFSheet, n5, n6, bl, cellValueConverter, null);
    }

    public static void exportToSheet(JTable jTable, int n, int n2, int n3, int n4, HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, int n5, int n6, boolean bl, CellValueConverter cellValueConverter, StringConverter stringConverter) {
        HssfTableFormat hssfTableFormat = new HssfTableFormat();
        hssfTableFormat.setFirstRow(n);
        hssfTableFormat.setFirstColumn(n2);
        hssfTableFormat.setNumberOfRows(n3);
        hssfTableFormat.setNumberOfColumns(n4);
        hssfTableFormat.setStartRow(n5);
        hssfTableFormat.setStartColumn(n6);
        hssfTableFormat.setIncludeTableHeader(bl);
        hssfTableFormat.setCellValueConverter(cellValueConverter);
        hssfTableFormat.setColumnNameConverter(stringConverter);
        HssfTableUtils.exportToSheet(jTable, hSSFWorkbook, hSSFSheet, hssfTableFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void exportToSheet(JTable var0, HSSFWorkbook var1_1, HSSFSheet var2_2, HssfTableFormat var3_3) {
        block77: {
            var25_4 = HssfTableUtils.c;
            v0 = var3_3;
            if (var25_4 == 0) {
                if (v0 == null) {
                    return;
                }
                v0 = var3_3;
            }
            var4_5 = v0.getNumberOfColumns();
            var5_6 = var3_3.getNumberOfRows();
            var6_7 = var3_3.isIncludeTableHeader();
            var7_8 = var3_3.getStartRow();
            var8_9 = var3_3.getStartColumn();
            var9_10 = var3_3.getFirstColumn();
            var10_11 = var3_3.getFirstRow();
            var11_12 = var3_3.getColumnNameConverter();
            var12_13 = var3_3.getCellValueConverter();
            var13_14 = new HashMap<String, HSSFCellStyle>();
            var14_15 = new HashMap<String, HSSFFont>();
            var0.putClientProperty("HssfTableUtils.HSSFWorkbook", var1_1);
            try {
                block76: {
                    block75: {
                        block74: {
                            block72: {
                                block92: {
                                    block91: {
                                        block81: {
                                            block73: {
                                                block80: {
                                                    block79: {
                                                        block78: {
                                                            var15_16 = var0.getModel();
                                                            v1 = var4_5;
                                                            v2 = -1;
                                                            if (var25_4 != 0) break block78;
                                                            if (v1 == v2) {
                                                                var4_5 = var0.getColumnCount();
                                                            }
                                                            v1 = var5_6;
                                                            if (var25_4 != 0) break block79;
                                                            v2 = -1;
                                                        }
                                                        if (v1 == v2) {
                                                            var5_6 = var0.getRowCount();
                                                        }
                                                        v1 = (int)var6_7;
                                                    }
                                                    if (var25_4 != 0) break block74;
                                                    if (v1 == 0) break block72;
                                                    v3 = var0.getTableHeader();
                                                    if (var25_4 != 0) break block80;
                                                    if (!(v3 instanceof NestedTableHeader)) break block81;
                                                    v3 = var0.getTableHeader();
                                                }
                                                var16_17 = (NestedTableHeader)v3;
                                                var17_21 = var16_17.getRowCount();
                                                var18_24 = 0;
                                                block7: while (true) {
                                                    v4 = var18_24;
                                                    v5 = var17_21;
                                                    block8: while (v4 < v5) {
                                                        block83: {
                                                            block82: {
                                                                var19_29 = var2_2.getRow(var7_8 + var18_24);
                                                                if (var25_4 != 0) break block72;
                                                                v6 = var19_29;
                                                                if (var25_4 != 0) break block82;
                                                                if (v6 != null) break block83;
                                                                v6 = var2_2.createRow(var7_8 + var18_24);
                                                            }
                                                            var19_29 = v6;
                                                        }
                                                        for (var20_35 = 0; var20_35 < var4_5; ++var20_35) {
                                                            block85: {
                                                                block84: {
                                                                    v4 = var9_10 + var20_35;
                                                                    v5 = var0.getColumnCount();
                                                                    if (var25_4 != 0) continue block8;
                                                                    if (v4 >= v5) continue;
                                                                    var21_39 = var19_29.getCell((short)(var20_35 + var8_9));
                                                                    v7 = var21_39;
                                                                    if (var25_4 != 0) break block84;
                                                                    if (v7 != null) break block85;
                                                                    v7 = var19_29.createCell((short)(var20_35 + var8_9));
                                                                }
                                                                var21_39 = v7;
                                                            }
                                                            var22_41 = var18_24 == var17_21 - 1 ? var0.getColumnName(var9_10 + var20_35) : "" + var16_17.getHeaderValueAt(var10_11 + var18_24, var9_10 + var20_35);
                                                            v8 = var11_12;
                                                            if (var25_4 != 0) ** GOTO lbl75
                                                            if (v8 != null) {
                                                                v8 = var11_12;
lbl75:
                                                                // 2 sources

                                                                v9 = v8.convert(var22_41);
                                                            } else {
                                                                v9 = var22_41;
                                                            }
                                                            var21_39.setCellValue(v9);
                                                            if (var25_4 == 0) continue;
                                                        }
                                                        ++var18_24;
                                                        if (var25_4 == 0) continue block7;
                                                    }
                                                    break;
                                                }
                                                var18_25 = new HashSet<E>();
                                                var19_30 = 0;
                                                block10: while (true) {
                                                    v10 = var19_30;
                                                    v11 = var17_21;
                                                    block11: while (v10 < v11) {
                                                        v12 = 0;
                                                        if (var25_4 != 0) break block73;
                                                        var20_35 = v12;
                                                        while (var20_35 < var4_5) {
                                                            block87: {
                                                                block86: {
                                                                    block89: {
                                                                        block90: {
                                                                            block88: {
                                                                                v10 = var9_10 + var20_35;
                                                                                v11 = var0.getColumnCount();
                                                                                if (var25_4 != 0) continue block11;
                                                                                if (v10 >= v11) break block86;
                                                                                var21_39 = var16_17.getCellSpanAt(var7_8 + var19_30, var9_10 + var20_35);
                                                                                if (var25_4 != 0) break block87;
                                                                                if (var21_39 == null) break block86;
                                                                                v13 = var18_25.contains(var21_39);
                                                                                if (var25_4 != 0) break block88;
                                                                                if (v13 != 0) break block86;
                                                                                v13 = var21_39.getRowSpan();
                                                                            }
                                                                            if (var25_4 != 0) break block89;
                                                                            if (v13 != 1) break block90;
                                                                            v13 = var21_39.getColumnSpan();
                                                                            if (var25_4 != 0) break block89;
                                                                            if (v13 == 1) break block86;
                                                                        }
                                                                        v13 = (int)var18_25.add(var21_39);
                                                                    }
                                                                    HssfTableUtils.a(var2_2, (CellSpan)var21_39, var10_11, var9_10, var19_30, var20_35, var17_21, var4_5, var7_8, var8_9);
                                                                }
                                                                ++var20_35;
                                                            }
                                                            if (var25_4 == 0) continue;
                                                        }
                                                        ++var19_30;
                                                        if (var25_4 == 0) continue block10;
                                                    }
                                                    break;
                                                }
                                                v12 = var7_8 = var7_8 + var17_21;
                                            }
                                            if (var25_4 == 0) break block72;
                                        }
                                        v14 = var16_17 = var2_2.getRow(var7_8);
                                        if (var25_4 != 0) break block91;
                                        if (v14 != null) break block92;
                                        v14 = var2_2.createRow(var7_8);
                                    }
                                    var16_17 = v14;
                                }
                                for (var17_21 = 0; var17_21 < var4_5; ++var17_21) {
                                    block94: {
                                        block93: {
                                            v1 = var9_10 + var17_21;
                                            if (var25_4 != 0) break block74;
                                            if (v1 >= var0.getColumnCount()) continue;
                                            v15 = var18_25 = var16_17.getCell((short)(var17_21 + var8_9));
                                            if (var25_4 != 0) break block93;
                                            if (v15 != null) break block94;
                                            v15 = var16_17.createCell((short)(var17_21 + var8_9));
                                        }
                                        var18_25 = v15;
                                    }
                                    var19_32 = var0.getColumnName(var9_10 + var17_21);
                                    v16 = var11_12;
                                    if (var25_4 != 0) ** GOTO lbl146
                                    if (v16 != null) {
                                        v16 = var11_12;
lbl146:
                                        // 2 sources

                                        v17 = v16.convert(var19_32);
                                    } else {
                                        v17 = var19_32;
                                    }
                                    var18_25.setCellValue(v17);
                                    if (var25_4 == 0) continue;
                                }
                                ++var7_8;
                            }
                            v1 = 0;
                        }
                        var16_18 = v1;
                        block14: while (true) {
                            v18 = var16_18;
                            v19 = var5_6;
                            block15: while (v18 < v19) {
                                block96: {
                                    block95: {
                                        try {
                                            var17_22 = var2_2.getRow(var16_18 + var7_8);
                                            if (var25_4 != 0) break block75;
                                        }
                                        catch (IndexOutOfBoundsException var18_26) {
                                            HssfTableUtils.a.warning("Only the first 65536 rows are exported as Microsoft Excel only supports 65536 per sheet.");
                                            break block14;
                                        }
                                        v20 = var17_22;
                                        if (var25_4 != 0) break block95;
                                        if (v20 != null) break block96;
                                        v20 = var2_2.createRow(var16_18 + var7_8);
                                    }
                                    var17_22 = v20;
                                }
                                for (var18_27 = 0; var18_27 < var4_5; ++var18_27) {
                                    v21 = var9_10 + var18_27;
                                    if (var25_4 == 0) {
                                        v19 = var0.getColumnCount();
                                        if (var25_4 != 0) continue block15;
                                        if (v21 >= v19) continue;
                                        v21 = var0.convertColumnIndexToModel(var9_10 + var18_27);
                                    }
                                    if ((var19_33 = v21) == -1) continue;
                                    var20_37 = var17_22.getCell((short)(var18_27 + var8_9));
                                    v22 = var20_37;
                                    if (var25_4 == 0) {
                                        if (v22 == null) {
                                            var20_37 = var17_22.createCell((short)(var18_27 + var8_9));
                                        }
                                        v22 = var15_16.getValueAt(var10_11 + var16_18, var19_33);
                                    }
                                    var21_39 = v22;
                                    v23 = var12_13;
                                    if (var25_4 != 0) ** GOTO lbl195
                                    if (v23 == null) {
                                        v24 = var21_39;
                                    } else {
                                        v23 = var12_13;
lbl195:
                                        // 2 sources

                                        v24 = v23.convert(var0, var21_39, var16_18, var19_33);
                                    }
                                    HssfTableUtils.a(var20_37, v24);
                                    var20_37.setCellStyle(HssfTableUtils.a(var1_1, var0, var16_18, var19_33, var21_39, var12_13, var13_14, var14_15, var3_3));
                                    if (var25_4 == 0) continue;
                                }
                                ++var16_18;
                                if (var25_4 == 0) continue block14;
                            }
                            break;
                        }
                        v25 = var0 instanceof CellSpanTable;
                        if (var25_4 != 0) break block76;
                        if (v25 == 0) break block75;
                        v25 = ((CellSpanTable)var0).isCellSpanOn();
                        if (var25_4 != 0) break block76;
                        if (v25 == 0) break block75;
                        var16_19 = new HashSet<E>();
                        var17_23 = 0;
                        block17: while (true) {
                            v26 = var17_23;
                            v27 = var5_6;
                            block18: while (v26 < v27) {
                                v25 = 0;
                                if (var25_4 != 0) break block76;
                                var18_28 = v25;
                                while (var18_28 < var4_5) {
                                    block98: {
                                        block97: {
                                            block100: {
                                                block101: {
                                                    block99: {
                                                        v26 = var9_10 + var18_28;
                                                        v27 = var0.getColumnCount();
                                                        if (var25_4 != 0) continue block18;
                                                        if (v26 >= v27) break block97;
                                                        var19_34 = ((CellSpanTable)var0).getCellSpanAt(var10_11 + var17_23, var18_28);
                                                        if (var25_4 != 0) break block98;
                                                        if (var19_34 == null) break block97;
                                                        v28 = var16_19.contains(var19_34);
                                                        if (var25_4 != 0) break block99;
                                                        if (v28 != 0) break block97;
                                                        v28 = var19_34.getRowSpan();
                                                    }
                                                    if (var25_4 != 0) break block100;
                                                    if (v28 != 1) break block101;
                                                    v28 = var19_34.getColumnSpan();
                                                    if (var25_4 != 0) break block100;
                                                    if (v28 == 1) break block97;
                                                }
                                                v28 = (int)var16_19.add(var19_34);
                                            }
                                            try {
                                                var20_38 = var2_2.getRow(var17_23 + var7_8);
                                            }
                                            catch (IndexOutOfBoundsException var21_40) {
                                                HssfTableUtils.a.warning("Only the first 65536 rows are exported as Microsoft Excel only supports 65536 per sheet.");
                                                break;
                                            }
                                            var21_39 = var20_38.getCell((short)(var18_28 + var8_9));
                                            var22_42 = var0.convertColumnIndexToModel(var19_34.getColumn());
                                            if (var22_42 == -1) break block97;
                                            var23_43 = var15_16.getValueAt(var19_34.getRow(), var22_42);
                                            v29 = var12_13;
                                            if (var25_4 != 0) ** GOTO lbl253
                                            if (v29 == null) {
                                                v30 = var23_43;
                                            } else {
                                                v29 = var12_13;
lbl253:
                                                // 2 sources

                                                v30 = v29.convert(var0, var23_43, var19_34.getRow(), var22_42);
                                            }
                                            HssfTableUtils.a((HSSFCell)var21_39, v30);
                                            var21_39.setCellStyle(HssfTableUtils.a(var1_1, var0, var19_34.getRow(), var22_42, var23_43, var12_13, var13_14, var14_15, var3_3));
                                            HssfTableUtils.a(var2_2, var19_34, var10_11, var9_10, var17_23, var18_28, var5_6, var4_5, var7_8, var8_9);
                                        }
                                        ++var18_28;
                                    }
                                    if (var25_4 == 0) continue;
                                }
                                ++var17_23;
                                if (var25_4 == 0) continue block17;
                            }
                            break;
                        }
                    }
                    v25 = var3_3.isAutoSizeColumns();
                }
                if (var25_4 == 0) {
                    if (v25 == 0) break block77;
                    v25 = var16_20 = 0;
                }
                while (var16_20 < var4_5) {
                    var2_2.autoSizeColumn((short)(var16_20 + var8_9));
                    var16_20 = (short)(var16_20 + 1);
                    if (var25_4 == 0 && var25_4 == 0) continue;
                    break;
                }
            }
            finally {
                var13_14.clear();
                var14_15.clear();
                var0.putClientProperty("HssfTableUtils.HSSFWorkbook", null);
            }
        }
    }

    private static void a(HSSFCell hSSFCell, Object object) {
        block4: {
            block17: {
                Object object2;
                int n;
                block15: {
                    block16: {
                        boolean bl;
                        block13: {
                            block14: {
                                block11: {
                                    block12: {
                                        block9: {
                                            block10: {
                                                block7: {
                                                    block8: {
                                                        block5: {
                                                            block6: {
                                                                block2: {
                                                                    block3: {
                                                                        n = c;
                                                                        bl = object instanceof Double;
                                                                        if (n != 0) break block2;
                                                                        if (!bl) break block3;
                                                                        hSSFCell.setCellValue((Double)object);
                                                                        if (n == 0) break block4;
                                                                    }
                                                                    bl = object instanceof Integer;
                                                                }
                                                                if (n != 0) break block5;
                                                                if (!bl) break block6;
                                                                hSSFCell.setCellValue(((Integer)object).intValue());
                                                                if (n == 0) break block4;
                                                            }
                                                            bl = object instanceof Float;
                                                        }
                                                        if (n != 0) break block7;
                                                        if (!bl) break block8;
                                                        hSSFCell.setCellValue(((Float)object).floatValue());
                                                        if (n == 0) break block4;
                                                    }
                                                    bl = object instanceof Short;
                                                }
                                                if (n != 0) break block9;
                                                if (!bl) break block10;
                                                hSSFCell.setCellValue(((Short)object).shortValue());
                                                if (n == 0) break block4;
                                            }
                                            bl = object instanceof Date;
                                        }
                                        if (n != 0) break block11;
                                        if (!bl) break block12;
                                        hSSFCell.setCellValue((Date)object);
                                        if (n == 0) break block4;
                                    }
                                    bl = object instanceof Calendar;
                                }
                                if (n != 0) break block13;
                                if (!bl) break block14;
                                hSSFCell.setCellValue((Calendar)object);
                                if (n == 0) break block4;
                            }
                            object2 = object;
                            if (n != 0) break block15;
                            bl = object2 instanceof Boolean;
                        }
                        if (!bl) break block16;
                        hSSFCell.setCellValue((Boolean)object);
                        if (n == 0) break block4;
                    }
                    object2 = object;
                }
                if (object2 == null) break block17;
                hSSFCell.setCellValue(object.toString());
                if (n == 0) break block4;
            }
            hSSFCell.setCellValue("");
        }
    }

    private static void a(HSSFSheet hSSFSheet, CellSpan cellSpan, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        block10: {
            int n9;
            int n10;
            short s;
            Region region;
            block9: {
                int n11 = c;
                region = new Region();
                region.setRowFrom(n7 + n3);
                int n12 = n7 + n3 + cellSpan.getRowSpan() - 1;
                int n13 = cellSpan.getRow();
                int n14 = n + n3;
                if (n11 == 0) {
                    if (n13 < n14) {
                        n12 -= n + n3 - cellSpan.getRow();
                    }
                    n13 = cellSpan.getRow() + cellSpan.getRowSpan();
                    n14 = n + n5;
                }
                if (n11 == 0) {
                    if (n13 >= n14) {
                        n12 -= cellSpan.getRow() + cellSpan.getRowSpan() - (n + n5);
                    }
                    region.setRowTo(n12);
                    region.setColumnFrom((short)(n8 + n4));
                    n13 = n8 + n4 + cellSpan.getColumnSpan();
                    n14 = 1;
                }
                s = (short)(n13 - n14);
                n10 = cellSpan.getColumn();
                n9 = n2 + n4;
                if (n11 != 0) break block9;
                if (n10 < n9) {
                    s = (short)(s - (n2 + n4 - cellSpan.getColumn()));
                }
                n10 = cellSpan.getColumn() + cellSpan.getColumnSpan();
                if (n11 != 0) break block10;
                n9 = n2 + n6;
            }
            if (n10 >= n9) {
                s = (short)(s - (cellSpan.getColumn() + cellSpan.getColumnSpan() - (n2 + n6)));
            }
            region.setColumnTo(s);
            n10 = hSSFSheet.addMergedRegion(region);
        }
    }

    public static void exportToCell(HSSFSheet hSSFSheet, int n, int n2, Object object) {
        HSSFCell hSSFCell;
        HSSFRow hSSFRow;
        int n3 = c;
        HSSFRow hSSFRow2 = hSSFRow = hSSFSheet.getRow(n);
        if (n3 == 0) {
            if (hSSFRow2 == null) {
                hSSFRow = hSSFSheet.createRow(n);
            }
            hSSFRow2 = hSSFRow;
        }
        HSSFCell hSSFCell2 = hSSFCell = hSSFRow2.getCell((short)n2);
        if (n3 == 0) {
            if (hSSFCell2 == null) {
                hSSFCell = hSSFRow.createCell((short)n2);
            }
            hSSFCell2 = hSSFCell;
        }
        HssfTableUtils.a(hSSFCell2, object);
    }

    /*
     * Unable to fully structure code
     */
    private static HSSFCellStyle a(HSSFWorkbook var0, JTable var1_1, int var2_2, int var3_3, Object var4_4, CellValueConverter var5_5, Map<String, HSSFCellStyle> var6_6, Map<String, HSSFFont> var7_7, HssfTableFormat var8_8) {
        block17: {
            block19: {
                block18: {
                    block16: {
                        block15: {
                            block14: {
                                var16_9 = HssfTableUtils.c;
                                var9_10 = -1;
                                v0 = var5_5;
                                if (var16_9 != 0) break block14;
                                if (v0 == null) break block15;
                                v0 = var5_5;
                            }
                            var9_10 = v0.getDataFormat(var1_1, var4_4, var2_2, var3_3);
                        }
                        var10_11 = new StringBuffer("default").append("_").append(var9_10).toString();
                        v1 = var11_12 = var6_6.get(var10_11);
                        if (var16_9 == 0 && v1 == null) {
                            var11_12 = HssfTableUtils.b(var0);
                            v1 = var6_6.put(var10_11, var11_12);
                        }
                        v2 = var1_1;
                        if (var16_9 != 0) ** GOTO lbl19
                        if (v2 instanceof CellStyleTable) {
                            v2 = var1_1;
lbl19:
                            // 2 sources

                            v3 = ((CellStyleTable)v2).getStyleModel();
                        } else {
                            v3 = null;
                        }
                        var12_13 = v3;
                        v4 = var12_13 instanceof StyleModel;
                        if (var16_9 != 0) break block16;
                        if (!v4) break block17;
                        v5 = var12_13;
                        if (var16_9 != 0) break block18;
                        v4 = ((StyleModel)v5).isCellStyleOn();
                    }
                    if (!v4) break block17;
                    v5 = var1_1.getModel();
                }
                if (var16_9 != 0) ** GOTO lbl38
                if (v5 == var12_13) {
                    v6 = var2_2;
                } else {
                    v5 = var1_1.getModel();
lbl38:
                    // 2 sources

                    v6 = TableModelWrapperUtils.getActualRowAt(v5, var2_2, StyleModel.class);
                }
                var13_14 = v6;
                v7 = var14_15 = ((StyleModel)var12_13).getCellStyleAt(var13_14, var3_3);
                if (var16_9 != 0) break block19;
                if (v7 == null) break block17;
                v7 = var14_15;
            }
            var15_16 = v7.hashCode();
            var10_11 = new StringBuffer(var15_16.toString()).append("_").append(var9_10).toString();
            v8 = var11_12 = var6_6.get(var10_11);
            if (var16_9 == 0 && v8 == null) {
                var11_12 = HssfTableUtils.b(var0);
                var11_12 = HssfTableUtils.a(var0, var11_12, var14_15, null, var7_7, var8_8);
                v8 = var6_6.put(var10_11, var11_12);
            }
        }
        if (var5_5 != null) {
            v9 = var9_10;
            if (var16_9 == 0) {
                v9 = v9 < 0 ? 0 : var9_10;
            }
            var11_12.setDataFormat((short)v9);
        }
        return var11_12;
    }

    private static HSSFCellStyle a(HSSFWorkbook hSSFWorkbook, HSSFCellStyle hSSFCellStyle, CellStyle cellStyle, String string, Map<String, HSSFFont> map, HssfTableFormat hssfTableFormat) {
        int n = c;
        HSSFFont hSSFFont = map.get(string);
        int n2 = 0;
        CellStyle cellStyle2 = cellStyle;
        if (n == 0) {
            if (cellStyle2.getFont() != null) {
                HSSFFont hSSFFont2 = hSSFFont;
                if (n == 0) {
                    if (hSSFFont2 == null) {
                        hSSFFont = HssfTableUtils.a(hSSFWorkbook);
                        map.put("" + hSSFFont.hashCode(), hSSFFont);
                    }
                    hSSFFont2 = hSSFFont;
                }
                Font font = cellStyle.getFont();
                if (n == 0) {
                    hSSFFont2.setFontName(font.getFontName());
                    if (cellStyle.getFont().getStyle() == 1) {
                        hSSFFont.setBoldweight((short)700);
                    }
                    hSSFFont2 = hSSFFont;
                    font = cellStyle.getFont();
                }
                boolean bl = font.getStyle();
                if (n == 0) {
                    bl = bl;
                }
                hSSFFont2.setItalic(bl);
                n2 = 1;
            }
            cellStyle2 = cellStyle;
        }
        if (n == 0) {
            if (cellStyle2.getForeground() != null) {
                HSSFFont hSSFFont3 = hSSFFont;
                if (n == 0) {
                    if (hSSFFont3 == null) {
                        hSSFFont = HssfTableUtils.a(hSSFWorkbook);
                        map.put("" + hSSFFont.hashCode(), hSSFFont);
                    }
                    hSSFFont3 = hSSFFont;
                }
                hSSFFont3.setColor(HssfTableUtils.a(cellStyle.getForeground()));
                n2 = 1;
            }
            cellStyle2 = cellStyle;
        }
        int n3 = cellStyle2.getFontStyle();
        if (n == 0) {
            if (n3 != -1) {
                HSSFFont hSSFFont4 = hSSFFont;
                if (n == 0 && hSSFFont4 == null) {
                    hSSFFont = HssfTableUtils.a(hSSFWorkbook);
                    hSSFFont4 = map.put("" + hSSFFont.hashCode(), hSSFFont);
                }
                int n4 = cellStyle.getFontStyle();
                boolean bl = n4 & 2;
                if (n == 0) {
                    bl = bl;
                }
                hSSFFont.setItalic(bl);
                short s = n4 & 1;
                if (n == 0) {
                    s = s != 0 ? (short)700 : 400;
                }
                hSSFFont.setBoldweight(s);
                n2 = 1;
            }
            n3 = n2;
        }
        if (n3 != 0) {
            hSSFCellStyle.setFont(hSSFFont);
        }
        CellStyle cellStyle3 = cellStyle;
        if (n == 0) {
            if (cellStyle3.getBackground() != null) {
                hSSFCellStyle.setFillPattern((short)1);
                hSSFCellStyle.setFillForegroundColor(HssfTableUtils.a(cellStyle.getBackground()));
            }
            cellStyle3 = cellStyle;
        }
        int n5 = cellStyle3.getHorizontalAlignment();
        n5 = -1;
        if (n == 0) {
            if (n4 != n5) {
                hSSFCellStyle.setAlignment(HssfTableUtils.a(cellStyle.getHorizontalAlignment()));
            }
            int n5 = cellStyle.getVerticalAlignment();
            n5 = -1;
        }
        if (n4 != n5) {
            hSSFCellStyle.setVerticalAlignment(HssfTableUtils.b(cellStyle.getVerticalAlignment()));
        }
        hSSFCellStyle.setBorderBottom(hssfTableFormat.getBottomBorder());
        hSSFCellStyle.setBorderTop(hssfTableFormat.getTopBorder());
        hSSFCellStyle.setBorderLeft(hssfTableFormat.getLeftBorder());
        hSSFCellStyle.setBorderRight(hssfTableFormat.getRightBorder());
        return hSSFCellStyle;
    }

    private static short a(int n) {
        short s = n;
        if (c == 0) {
            switch (s) {
                case 0: {
                    return 2;
                }
                case 2: 
                case 10: {
                    return 1;
                }
                case 4: 
                case 11: {
                    return 3;
                }
            }
            s = 0;
        }
        return s;
    }

    private static short b(int n) {
        int n2 = n;
        if (c == 0) {
            switch (n2) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 0;
                }
                case 3: {
                    return 2;
                }
            }
            n2 = 3;
        }
        return (short)n2;
    }

    private static HSSFFont a(HSSFWorkbook hSSFWorkbook) {
        return hSSFWorkbook.createFont();
    }

    private static HSSFCellStyle b(HSSFWorkbook hSSFWorkbook) {
        ++b;
        HSSFCellStyle hSSFCellStyle = hSSFWorkbook.createCellStyle();
        hSSFCellStyle.setAlignment((short)0);
        hSSFCellStyle.setVerticalAlignment((short)0);
        return hSSFCellStyle;
    }

    private static short a(Color color) {
        short s;
        short s2;
        int n;
        block5: {
            n = c;
            Hashtable hashtable = HSSFColor.getIndexHash();
            Enumeration enumeration = hashtable.keys();
            double d2 = Double.MAX_VALUE;
            s2 = -1;
            while (enumeration.hasMoreElements()) {
                Integer n2 = (Integer)enumeration.nextElement();
                HSSFColor hSSFColor = (HSSFColor)hashtable.get(n2);
                short[] sArray = hSSFColor.getTriplet();
                double d3 = Math.sqrt(sArray[0] - color.getRed()) + Math.sqrt(sArray[1] - color.getGreen()) + Math.sqrt(sArray[2] - color.getBlue());
                s = (short)(d3 == d2 ? 0 : (d3 < d2 ? -1 : 1));
                if (n == 0) {
                    if (n == 0 && s < 0) {
                        d2 = d3;
                        short s3 = s2 = n2.shortValue();
                    }
                    if (n == 0) continue;
                }
                break block5;
            }
            s = s2;
        }
        if (n == 0) {
            if (s != -1) {
                return s2;
            }
            s = 64;
        }
        return s;
    }

    public static class ContextSensitiveCellValueConverter
    implements CellValueConverter {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object convert(JTable jTable, Object object, int n, int n2) {
            ContextSensitiveTableModel contextSensitiveTableModel;
            int n3 = c;
            ContextSensitiveTableModel contextSensitiveTableModel2 = contextSensitiveTableModel = (ContextSensitiveTableModel)TableModelWrapperUtils.getActualTableModel(jTable.getModel(), ContextSensitiveTableModel.class);
            if (n3 == 0) {
                if (contextSensitiveTableModel2 == null) {
                    return object;
                }
                contextSensitiveTableModel2 = contextSensitiveTableModel;
            }
            ConverterContext converterContext = contextSensitiveTableModel2.getConverterContextAt(n, n2);
            Object object2 = converterContext;
            if (n3 != 0) return object2;
            if (object2 != null) {
                ObjectConverter objectConverter = ObjectConverterManager.getConverter(object.getClass(), converterContext);
                object2 = objectConverter;
                if (n3 != 0) return object2;
                if (object2 != null) {
                    object2 = objectConverter;
                    if (n3 != 0) return object2;
                    if (object2.supportToString(object, converterContext)) {
                        return objectConverter.toString(object, converterContext);
                    }
                }
            }
            object2 = object;
            return object2;
        }

        public int getDataFormat(JTable jTable, Object object, int n, int n2) {
            return -1;
        }
    }

    public static class DefaultCellValueConverter
    implements CellValueConverter {
        public Object convert(JTable jTable, Object object, int n, int n2) {
            return object;
        }

        public int getDataFormat(JTable jTable, Object object, int n, int n2) {
            return -1;
        }
    }

    public static interface CellValueConverter {
        public Object convert(JTable var1, Object var2, int var3, int var4);

        public int getDataFormat(JTable var1, Object var2, int var3, int var4);
    }
}

