/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.mq;

import com.ibm.mq.MQMessage;
import com.jidesoft.grid.SortableTable;
import hermes.browser.model.OneRowMapTableModel;
import hermes.ext.mq.MQSeriesAdmin;
import hermes.ext.mq.MsgUtils;
import hermes.renderers.AbstractMessageRenderer;
import hermes.util.TextUtils;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class MQSeriesMessageRenderer
extends AbstractMessageRenderer {
    private static final Logger log = Logger.getLogger(MQSeriesMessageRenderer.class);
    private MQSeriesAdmin admin;

    public MQSeriesMessageRenderer(MQSeriesAdmin admin) {
        this.admin = admin;
    }

    public JComponent render(Message message) {
        SortableTable rval = null;
        try {
            MQMessage mqMessage = this.admin.getMQMessage(message);
            LinkedHashMap map = new LinkedHashMap();
            try {
                this.inspectMessage(map, mqMessage);
                OneRowMapTableModel model = new OneRowMapTableModel(map);
                rval = new SortableTable((TableModel)model);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (JMSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return rval;
    }

    public void inspectMessage(Map map, MQMessage message) throws IOException {
        map.put("AccountingToken", TextUtils.toHexString((byte[])message.accountingToken, (boolean)false));
        map.put("ApplicationIdData", message.applicationIdData);
        map.put("ApplicationOriginData", message.applicationOriginData);
        map.put("BackoutCount", new Integer(message.backoutCount));
        map.put("CharacterSet", new Integer(message.characterSet));
        map.put("Encoding", new Integer(message.encoding));
        map.put("Expiry", new Integer(message.expiry));
        map.put("Feedback", new Integer(message.feedback));
        map.put("Format", message.format);
        map.put("DataLength", new Integer(message.getDataLength()));
        map.put("DataOffset", new Integer(message.getDataOffset()));
        map.put("TotalMessageLength", new Integer(message.getTotalMessageLength()));
        map.put("Version", new Integer(message.getVersion()));
        map.put("GroupId", TextUtils.toHexString((byte[])message.groupId, (boolean)false));
        map.put("MessageFlags", new Integer(message.messageFlags));
        map.put("MessageId", TextUtils.toHexString((byte[])message.messageId, (boolean)false));
        map.put("MessageSequenceNumber", new Integer(message.messageSequenceNumber));
        map.put("MessageType", new Integer(message.messageType));
        map.put("Offset", new Integer(message.offset));
        map.put("OriginalLength", new Integer(message.originalLength));
        map.put("Persistence", new Integer(message.persistence));
        map.put("PutApplicationName", message.putApplicationName);
        map.put("PutApplicationType", new Integer(message.putApplicationType));
        map.put("PutDateTime", message.putDateTime.getTime());
        map.put("ReplyToQueueManager", message.replyToQueueManagerName);
        map.put("ReplyToQueueName", message.replyToQueueName);
        map.put("Report", new Integer(message.report));
        map.put("TotalMessageLength", new Integer(message.getTotalMessageLength()));
        int dataLength = message.getTotalMessageLength();
        if (message.format.equals("MQHRF   ")) {
            MsgUtils.MqRfh header = MsgUtils.getRfhHeader(message);
            this.inspectHeader(map, header);
            dataLength = message.getDataLength();
        } else if (message.format.equals("MQHRF2  ")) {
            MsgUtils.MqRfh2 header = MsgUtils.getRfh2Header(message);
            this.inspectHeader(map, header);
            dataLength = message.getDataLength();
        }
    }

    private void inspectHeader(Map map, MsgUtils.MqRfh header) {
        map.put("RFH.StructId", header.strucId);
        map.put("RFH.Version", new Long(header.version));
        map.put("RFH.Length", new Long(header.length));
        map.put("RFH.Encoding", new Long(header.encoding));
        map.put("RFH.EncodedCharSetId", new Long(header.codedCharSetId));
        map.put("RFH.Format", header.format);
        map.put("RFH.Flags", new Long(header.flags));
        if (header instanceof MsgUtils.MqRfh2) {
            MsgUtils.MqRfh2 header2 = (MsgUtils.MqRfh2)header;
            map.put("RFH2.NamesValuesCharSetId", new Long(header2.nameValuesCharSetId));
            map.put("RFH2.NamesValuesLength", new Long(header2.nameValuesLength));
        }
        for (Map.Entry entry : header.nameValues.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue());
        }
    }

    public boolean canRender(Message message) {
        return false;
    }

    public String getDisplayName() {
        return "RFH2";
    }
}

