/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.jms.MQConnectionFactory;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesAdminFactory;
import hermes.HermesException;
import hermes.JNDIConnectionFactory;
import hermes.ext.mq.MQSeriesAdmin;
import java.util.StringTokenizer;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class MQSeriesAdminFactory
implements HermesAdminFactory {
    private static final Logger log = Logger.getLogger(MQSeriesAdminFactory.class);
    private String logExclude;

    public void setLogExclude(String logExclude) {
        this.logExclude = logExclude;
        StringTokenizer tokens = new StringTokenizer(logExclude, ",");
        while (tokens.hasMoreTokens()) {
            String code = tokens.nextToken();
            try {
                MQException.logExclude((Integer)Integer.decode(code));
                log.debug((Object)("set MQException.logExclude(" + code + ")"));
            }
            catch (Throwable t) {
                log.error((Object)("cannot set MQException.logExclude, probably pre WMQ 6.0:" + t.getMessage()));
            }
        }
    }

    public String getLogExclude() {
        return this.logExclude;
    }

    public HermesAdmin createSession(Hermes hermes, ConnectionFactory connectionFactory) throws JMSException, NamingException {
        if (connectionFactory instanceof MQConnectionFactory) {
            MQConnectionFactory mqCF = (MQConnectionFactory)connectionFactory;
            return new MQSeriesAdmin(hermes, mqCF);
        }
        if (connectionFactory instanceof JNDIConnectionFactory) {
            JNDIConnectionFactory jndiCF = (JNDIConnectionFactory)connectionFactory;
            return this.createSession(hermes, jndiCF._getConnectionFactory());
        }
        throw new HermesException("JMS provider " + connectionFactory.getClass().getName() + " is not MQSeries");
    }
}

