/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.CheckBoxListWithSelectable;
import com.jidesoft.swing.DefaultSelectable;
import com.jidesoft.swing.NullCheckBox;
import com.jidesoft.swing.NullLabel;
import com.jidesoft.swing.Selectable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

public class CheckBoxListCellRenderer
extends JPanel
implements ListCellRenderer,
Serializable {
    private static final long serialVersionUID = 2003073492549917883L;
    protected JCheckBox _checkBox = new NullCheckBox();
    protected JLabel _label = new NullLabel();
    protected ListCellRenderer _actualListRenderer;

    public CheckBoxListCellRenderer(ListCellRenderer listCellRenderer) {
        this.setOpaque(true);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this._checkBox, "Before");
        this._actualListRenderer = listCellRenderer;
    }

    public CheckBoxListCellRenderer() {
        this((ListCellRenderer)null);
    }

    public ListCellRenderer getActualListRenderer() {
        return this._actualListRenderer;
    }

    public void setActualListRenderer(ListCellRenderer listCellRenderer) {
        this._actualListRenderer = listCellRenderer;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this._actualListRenderer instanceof JComponent) {
            Point point = mouseEvent.getPoint();
            point.translate(-this._checkBox.getWidth(), 0);
            MouseEvent mouseEvent2 = new MouseEvent((JComponent)((Object)this._actualListRenderer), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            String string = ((JComponent)((Object)this._actualListRenderer)).getToolTipText(mouseEvent2);
            if (string != null) {
                return string;
            }
        }
        return super.getToolTipText(mouseEvent);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Object object2;
        Serializable serializable;
        this._checkBox.setPreferredSize(new Dimension(this._checkBox.getPreferredSize().width, 0));
        this.applyComponentOrientation(jList.getComponentOrientation());
        if (jList instanceof CheckBoxList) {
            serializable = ((CheckBoxList)jList).getCheckBoxListSelectionModel();
            if (serializable != null) {
                boolean bl3;
                boolean bl4 = bl3 = jList.isEnabled() && ((CheckBoxList)jList).isCheckBoxEnabled() && ((CheckBoxList)jList).isCheckBoxEnabled(n);
                if (!bl3 && !bl && this.getBackground() != null) {
                    this.setForeground(this.getBackground().darker());
                }
                this._checkBox.setEnabled(bl3);
                this._checkBox.setSelected(((DefaultListSelectionModel)serializable).isSelectedIndex(n));
            }
            object2 = object;
        } else if (jList instanceof CheckBoxListWithSelectable) {
            boolean bl5;
            if (object instanceof Selectable) {
                this._checkBox.setSelected(((Selectable)object).isSelected());
                boolean bl6 = bl5 = jList.isEnabled() && ((Selectable)object).isEnabled() && ((CheckBoxListWithSelectable)jList).isCheckBoxEnabled();
                if (!bl5 && !bl) {
                    this.setForeground(this.getBackground().darker());
                }
                this._checkBox.setEnabled(bl5);
            } else {
                bl5 = jList.isEnabled();
                if (!bl5 && !bl) {
                    this.setForeground(this.getBackground().darker());
                }
                this._checkBox.setEnabled(bl5);
            }
            object2 = object instanceof DefaultSelectable ? ((DefaultSelectable)object).getObject() : object;
        } else {
            throw new IllegalArgumentException("CheckBoxListCellRenderer should only be used for CheckBoxList.");
        }
        if (this._actualListRenderer != null) {
            serializable = (JComponent)this._actualListRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (jList instanceof CheckBoxListWithSelectable && !((CheckBoxListWithSelectable)jList).isCheckBoxVisible(n)) {
                return serializable;
            }
            if (jList instanceof CheckBoxList && !((CheckBoxList)jList).isCheckBoxVisible(n)) {
                return serializable;
            }
            Border border = ((JComponent)serializable).getBorder();
            this.setBorder(border);
            ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder());
            if (this.getComponentCount() == 2) {
                this.remove(1);
            }
            this.add((Component)serializable);
            this.setBackground(((Component)serializable).getBackground());
            this.setForeground(((Component)serializable).getForeground());
        } else {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (this.getComponentCount() == 2) {
                this.remove(1);
            }
            this.add(this._label);
            this.customizeDefaultCellRenderer(object2);
            this.setFont(jList.getFont());
        }
        return this;
    }

    protected void customizeDefaultCellRenderer(Object object) {
        if (object instanceof Icon) {
            this._label.setIcon((Icon)object);
            this._label.setText("");
        } else {
            this._label.setIcon(null);
            this._label.setText(object == null ? "" : object.toString());
        }
    }

    public static class UIResource
    extends CheckBoxListCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

