/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.JideTabbedPaneUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.plaf.basic.Resource;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.PartialLineBorder;
import com.jidesoft.swing.Sticky;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicJideTabbedPaneUI
extends JideTabbedPaneUI
implements SwingConstants,
DocumentListener {
    protected int _tabRectPadding;
    protected int _closeButtonMarginHorizon;
    protected int _closeButtonMarginVertical;
    protected int _textMarginVertical;
    protected int _noIconMargin;
    protected int _iconMargin;
    protected int _textPadding;
    protected int _buttonSize;
    protected int _buttonMargin;
    protected int _fitStyleBoundSize;
    protected int _fitStyleFirstTabMargin;
    protected int _fitStyleIconMinWidth;
    protected int _fitStyleTextMinWidth;
    protected int _compressedStyleNoIconRectSize;
    protected int _compressedStyleIconMargin;
    protected int _compressedStyleCloseButtonMarginHorizon;
    protected int _compressedStyleCloseButtonMarginVertical;
    protected int _fixedStyleRectSize;
    protected int _closeButtonMargin;
    protected int _gripLeftMargin;
    protected int _closeButtonMarginSize;
    protected int _closeButtonLeftMargin;
    protected int _closeButtonRightMargin;
    protected Component _tabLeadingComponent = null;
    protected Component _tabTrailingComponent = null;
    protected JideTabbedPane _tabPane;
    protected Color _tabBackground;
    protected Color _background;
    protected Color _highlight;
    protected Color _lightHighlight;
    protected Color _shadow;
    protected Color _darkShadow;
    protected Color _focus;
    protected Color _inactiveTabForeground;
    protected Color _activeTabForeground;
    protected Color _tabListBackground;
    protected Color _selectedColor;
    protected int _textIconGap;
    protected int _tabRunOverlay;
    protected boolean _showIconOnTab;
    protected boolean _showCloseButtonOnTab;
    protected int _closeButtonAlignment = 11;
    protected Insets _tabInsets;
    protected Insets _selectedTabPadInsets;
    protected Insets _tabAreaInsets;
    protected boolean _ignoreContentBorderInsetsIfNoTabs;
    protected int[] _tabRuns = new int[10];
    protected int _runCount = 0;
    protected int _selectedRun = -1;
    protected Rectangle[] _rects = new Rectangle[0];
    protected int _maxTabHeight;
    protected int _maxTabWidth;
    protected int _gripperWidth = 6;
    protected int _gripperHeight = 6;
    protected ChangeListener _tabChangeListener;
    protected FocusListener _tabFocusListener;
    protected PropertyChangeListener _propertyChangeListener;
    protected MouseListener _mouseListener;
    protected MouseMotionListener _mousemotionListener;
    protected MouseWheelListener _mouseWheelListener;
    private ContainerListener _containerListener;
    private ComponentListener _componentListener;
    private Insets _currentTabInsets = new Insets(0, 0, 0, 0);
    private Insets _currentPadInsets = new Insets(0, 0, 0, 0);
    private Insets _currentTabAreaInsets = new Insets(2, 4, 0, 4);
    private Insets _currentContentBorderInsets = new Insets(3, 0, 0, 0);
    private Component visibleComponent;
    private Vector htmlViews;
    private Hashtable _mnemonicToIndexMap;
    private InputMap _mnemonicInputMap;
    public ScrollableTabSupport _tabScroller;
    protected transient Rectangle _calcRect = new Rectangle(0, 0, 0, 0);
    protected int _tabCount;
    protected TabCloseButton[] _closeButtons;
    private ThemePainter _painter;
    private Painter _gripperPainter;
    private DropTargetListener _dropListener;
    public DropTarget _dt;
    public static final int DEFAULT_LEFT_MARGIN = 0;
    public static final int OFFICE2003_LEFT_MARGIN = 18;
    public static final int EXCEL_LEFT_MARGIN = 6;
    protected int _rectSizeExtend = 0;
    protected Polygon tabRegion = null;
    protected Color _selectColor1 = null;
    protected Color _selectColor2 = null;
    protected Color _selectColor3 = null;
    protected Color _unselectColor1 = null;
    protected Color _unselectColor2 = null;
    protected Color _unselectColor3 = null;
    protected Color _officeTabBorderColor;
    protected Color _defaultTabBorderShadowColor;
    protected boolean _mouseEnter = false;
    protected int _indexMouseOver = -1;
    protected boolean _alwaysShowLineBorder = false;
    protected boolean _showFocusIndicator = false;
    public static final String BUTTON_NAME_CLOSE = "JideTabbedPane.close";
    public static final String BUTTON_NAME_TAB_LIST = "JideTabbedPane.showList";
    public static final String BUTTON_NAME_SCROLL_BACKWARD = "JideTabbedPane.scrollBackward";
    public static final String BUTTON_NAME_SCROLL_FORWARD = "JideTabbedPane.scrollForward";
    private int[] xCropLen = new int[]{1, 1, 0, 0, 1, 1, 2, 2};
    private int[] yCropLen = new int[]{0, 3, 3, 6, 6, 9, 9, 12};
    private static final int CROP_SEGMENT = 12;
    protected TabSpaceAllocator tryTabSpacer = new TabSpaceAllocator();
    protected Color _closeButtonSelectedColor = new Color(255, 162, 165);
    protected Color _closeButtonColor = Color.BLACK;
    protected Color _popupColor = Color.BLACK;
    protected TabEditor _tabEditor;
    protected boolean _isEditing;
    protected int _editingTab = -1;
    protected String _oldValue;
    protected String _oldPrefix;
    protected String _oldPostfix;
    protected Component _originalFocusComponent;
    protected final boolean PAINT_TAB = true;
    protected final boolean PAINT_TAB_BORDER = true;
    protected final boolean PAINT_TAB_BACKGROUND = true;
    protected final boolean PAINT_TABAREA = true;
    protected final boolean PAINT_CONTENT_BORDER = true;
    protected final boolean PAINT_CONTENT_BORDER_EDGE = true;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicJideTabbedPaneUI();
    }

    public void installUI(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        this._tabPane = (JideTabbedPane)jComponent;
        if (this._tabPane.isTabShown() && this._tabPane.getTabLeadingComponent() != null) {
            this._tabLeadingComponent = this._tabPane.getTabLeadingComponent();
        }
        if (this._tabPane.isTabShown() && this._tabPane.getTabTrailingComponent() != null) {
            this._tabTrailingComponent = this._tabPane.getTabTrailingComponent();
        }
        jComponent.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installColorTheme();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void installColorTheme() {
        switch (this.getTabShape()) {
            case 8: {
                this._selectColor1 = this._darkShadow;
                this._selectColor2 = this._lightHighlight;
                this._selectColor3 = this._shadow;
                this._unselectColor1 = this._darkShadow;
                this._unselectColor2 = this._lightHighlight;
                this._unselectColor3 = this._shadow;
                break;
            }
            case 1: 
            case 11: {
                this._selectColor1 = this._lightHighlight;
                this._selectColor2 = this._shadow;
                this._selectColor3 = this._defaultTabBorderShadowColor;
                this._unselectColor1 = this._selectColor1;
                this._unselectColor2 = this._selectColor2;
                this._unselectColor3 = this._selectColor3;
                break;
            }
            case 2: {
                this._selectColor1 = this._shadow;
                this._selectColor2 = this._shadow;
                this._unselectColor1 = this._selectColor1;
                break;
            }
            case 9: {
                this._selectColor2 = this._selectColor1 = this._shadow;
                this._unselectColor1 = this._selectColor1;
                break;
            }
            case 5: {
                this._unselectColor1 = this._selectColor1 = this._shadow;
                break;
            }
            case 10: {
                this._selectColor1 = this._shadow;
                this._selectColor2 = this._shadow;
                this._unselectColor1 = this._selectColor1;
                this._unselectColor2 = this._selectColor2;
                break;
            }
            case 3: {
                this._selectColor1 = this._shadow;
                this._selectColor2 = this._lightHighlight;
                this._unselectColor1 = this.getPainter().getControlShadow();
                this._unselectColor2 = this._lightHighlight;
                break;
            }
            default: {
                this._selectColor1 = this._shadow;
                this._selectColor2 = this._lightHighlight;
                this._unselectColor1 = this._shadow;
                this._unselectColor2 = null;
                this._unselectColor3 = null;
            }
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallColorTheme();
        this.uninstallDefaults();
        this.uninstallComponents();
        jComponent.setLayout(null);
        this._tabTrailingComponent = null;
        this._tabLeadingComponent = null;
        this._tabPane = null;
    }

    public void uninstallColorTheme() {
        this._selectColor1 = null;
        this._selectColor2 = null;
        this._selectColor3 = null;
        this._unselectColor1 = null;
        this._unselectColor2 = null;
        this._unselectColor3 = null;
    }

    protected LayoutManager createLayoutManager() {
        if (this._tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout();
        }
        return new TabbedPaneLayout();
    }

    protected boolean scrollableTabLayoutEnabled() {
        return this._tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this._tabScroller == null) {
            this._tabScroller = new ScrollableTabSupport(this._tabPane.getTabPlacement());
            this._tabPane.add(this._tabScroller.viewport);
            this._tabPane.add(this._tabScroller.scrollForwardButton);
            this._tabPane.add(this._tabScroller.scrollBackwardButton);
            this._tabPane.add(this._tabScroller.listButton);
            this._tabPane.add(this._tabScroller.closeButton);
            if (this._tabLeadingComponent != null) {
                this._tabPane.add(this._tabLeadingComponent);
            }
            if (this._tabTrailingComponent != null) {
                this._tabPane.add(this._tabTrailingComponent);
            }
        }
    }

    protected void uninstallComponents() {
        if (this.scrollableTabLayoutEnabled()) {
            this._tabPane.remove(this._tabScroller.viewport);
            this._tabPane.remove(this._tabScroller.scrollForwardButton);
            this._tabPane.remove(this._tabScroller.scrollBackwardButton);
            this._tabPane.remove(this._tabScroller.listButton);
            this._tabPane.remove(this._tabScroller.closeButton);
            if (this._tabLeadingComponent != null) {
                this._tabPane.remove(this._tabLeadingComponent);
            }
            if (this._tabTrailingComponent != null) {
                this._tabPane.remove(this._tabTrailingComponent);
            }
            this._tabScroller = null;
        }
    }

    protected void installDefaults() {
        Insets insets;
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._gripperPainter = (Painter)UIDefaultsLookup.get("JideTabbedPane.gripperPainter");
        LookAndFeel.installColorsAndFont(this._tabPane, "JideTabbedPane.background", "JideTabbedPane.foreground", "JideTabbedPane.font");
        LookAndFeel.installBorder(this._tabPane, "JideTabbedPane.border");
        Font font = this._tabPane.getSelectedTabFont();
        if (font == null || font instanceof UIResource) {
            this._tabPane.setSelectedTabFont(UIDefaultsLookup.getFont("JideTabbedPane.selectedTabFont"));
        }
        this._highlight = UIDefaultsLookup.getColor("JideTabbedPane.light");
        this._lightHighlight = UIDefaultsLookup.getColor("JideTabbedPane.highlight");
        this._shadow = UIDefaultsLookup.getColor("JideTabbedPane.shadow");
        this._darkShadow = UIDefaultsLookup.getColor("JideTabbedPane.darkShadow");
        this._focus = UIDefaultsLookup.getColor("TabbedPane.focus");
        if (this.getTabShape() == 3) {
            this._background = UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackground");
            this._tabBackground = UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackground");
            this._inactiveTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.foreground");
            this._activeTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.foreground");
            this._selectedColor = this._lightHighlight;
        } else {
            this._background = UIDefaultsLookup.getColor("JideTabbedPane.background");
            this._tabBackground = UIDefaultsLookup.getColor("JideTabbedPane.tabAreaBackground");
            this._inactiveTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.unselectedTabTextForeground");
            this._activeTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.selectedTabTextForeground");
            this._selectedColor = UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackground");
        }
        this._tabListBackground = UIDefaultsLookup.getColor("JideTabbedPane.tabListBackground");
        this._textIconGap = UIDefaultsLookup.getInt("JideTabbedPane.textIconGap");
        this._tabInsets = UIDefaultsLookup.getInsets("JideTabbedPane.tabInsets");
        this._selectedTabPadInsets = UIDefaultsLookup.getInsets("TabbedPane.selectedTabPadInsets");
        if (this._selectedTabPadInsets == null) {
            this._selectedTabPadInsets = new InsetsUIResource(0, 0, 0, 0);
        }
        this._tabAreaInsets = UIDefaultsLookup.getInsets("JideTabbedPane.tabAreaInsets");
        if (this._tabAreaInsets == null) {
            this._tabAreaInsets = new InsetsUIResource(0, 0, 0, 0);
        }
        if ((insets = this._tabPane.getContentBorderInsets()) == null || insets instanceof UIResource) {
            this._tabPane.setContentBorderInsets(UIDefaultsLookup.getInsets("JideTabbedPane.contentBorderInsets"));
        }
        this._ignoreContentBorderInsetsIfNoTabs = UIDefaultsLookup.getBoolean("JideTabbedPane.ignoreContentBorderInsetsIfNoTabs");
        this._tabRunOverlay = UIDefaultsLookup.getInt("JideTabbedPane.tabRunOverlay");
        this._showIconOnTab = UIDefaultsLookup.getBoolean("JideTabbedPane.showIconOnTab");
        this._showCloseButtonOnTab = UIDefaultsLookup.getBoolean("JideTabbedPane.showCloseButtonOnTab");
        this._closeButtonAlignment = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonAlignment");
        this._gripperWidth = UIDefaultsLookup.getInt("Gripper.size");
        this._tabRectPadding = UIDefaultsLookup.getInt("JideTabbedPane.tabRectPadding");
        this._closeButtonMarginHorizon = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMarginHorizonal");
        this._closeButtonMarginVertical = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMarginVertical");
        this._textMarginVertical = UIDefaultsLookup.getInt("JideTabbedPane.textMarginVertical");
        this._noIconMargin = UIDefaultsLookup.getInt("JideTabbedPane.noIconMargin");
        this._iconMargin = UIDefaultsLookup.getInt("JideTabbedPane.iconMargin");
        this._textPadding = UIDefaultsLookup.getInt("JideTabbedPane.textPadding");
        this._buttonSize = UIDefaultsLookup.getInt("JideTabbedPane.buttonSize");
        this._buttonMargin = UIDefaultsLookup.getInt("JideTabbedPane.buttonMargin");
        this._fitStyleBoundSize = UIDefaultsLookup.getInt("JideTabbedPane.fitStyleBoundSize");
        this._fitStyleFirstTabMargin = UIDefaultsLookup.getInt("JideTabbedPane.fitStyleFirstTabMargin");
        this._fitStyleIconMinWidth = UIDefaultsLookup.getInt("JideTabbedPane.fitStyleIconMinWidth");
        this._fitStyleTextMinWidth = UIDefaultsLookup.getInt("JideTabbedPane.fitStyleTextMinWidth");
        this._compressedStyleNoIconRectSize = UIDefaultsLookup.getInt("JideTabbedPane.compressedStyleNoIconRectSize");
        this._compressedStyleIconMargin = UIDefaultsLookup.getInt("JideTabbedPane.compressedStyleIconMargin");
        this._compressedStyleCloseButtonMarginHorizon = UIDefaultsLookup.getInt("JideTabbedPane.compressedStyleCloseButtonMarginHorizontal");
        this._compressedStyleCloseButtonMarginVertical = UIDefaultsLookup.getInt("JideTabbedPane.compressedStyleCloseButtonMarginVertical");
        this._fixedStyleRectSize = UIDefaultsLookup.getInt("JideTabbedPane.fixedStyleRectSize");
        this._closeButtonMargin = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMargin");
        this._gripLeftMargin = UIDefaultsLookup.getInt("JideTabbedPane.gripLeftMargin");
        this._closeButtonMarginSize = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMarginSize");
        this._closeButtonLeftMargin = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonLeftMargin");
        this._closeButtonRightMargin = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonRightMargin");
        this._defaultTabBorderShadowColor = UIDefaultsLookup.getColor("JideTabbedPane.defaultTabBorderShadowColor");
        this._alwaysShowLineBorder = UIDefaultsLookup.getBoolean("JideTabbedPane.alwaysShowLineBorder");
        this._showFocusIndicator = UIDefaultsLookup.getBoolean("JideTabbedPane.showFocusIndicator");
    }

    protected void uninstallDefaults() {
        this._painter = null;
        this._gripperPainter = null;
        this._highlight = null;
        this._lightHighlight = null;
        this._shadow = null;
        this._darkShadow = null;
        this._focus = null;
        this._inactiveTabForeground = null;
        this._selectedColor = null;
        this._tabInsets = null;
        this._selectedTabPadInsets = null;
        this._tabAreaInsets = null;
        this._defaultTabBorderShadowColor = null;
    }

    protected void installListeners() {
        if (this._propertyChangeListener == null) {
            this._propertyChangeListener = this.createPropertyChangeListener();
            this._tabPane.addPropertyChangeListener(this._propertyChangeListener);
        }
        if (this._tabChangeListener == null) {
            this._tabChangeListener = this.createChangeListener();
            this._tabPane.addChangeListener(this._tabChangeListener);
        }
        if (this._tabFocusListener == null) {
            this._tabFocusListener = this.createFocusListener();
            this._tabPane.addFocusListener(this._tabFocusListener);
        }
        if (this._mouseListener == null) {
            this._mouseListener = this.createMouseListener();
            this._tabPane.addMouseListener(this._mouseListener);
        }
        if (this._mousemotionListener == null) {
            this._mousemotionListener = this.createMouseMotionListener();
            this._tabPane.addMouseMotionListener(this._mousemotionListener);
        }
        if (this._mouseWheelListener == null) {
            this._mouseWheelListener = this.createMouseWheelListener();
            this._tabPane.addMouseWheelListener(this._mouseWheelListener);
        }
        if (this._containerListener == null) {
            this._containerListener = new ContainerHandler();
            this._tabPane.addContainerListener(this._containerListener);
            if (this._tabPane.getTabCount() > 0) {
                this.htmlViews = this.createHTMLVector();
            }
        }
        if (this._componentListener == null) {
            this._componentListener = new ComponentHandler();
            this._tabPane.addComponentListener(this._componentListener);
        }
        if (!this._tabPane.isDragOverDisabled() && this._dropListener == null) {
            this._dropListener = this.createDropListener();
            this._dt = new DropTarget(this.getTabPanel(), this._dropListener);
        }
    }

    protected DropListener createDropListener() {
        return new DropListener();
    }

    protected void uninstallListeners() {
        if (this._containerListener != null) {
            this._tabPane.removeContainerListener(this._containerListener);
            this._containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.removeAllElements();
                this.htmlViews = null;
            }
        }
        if (this._componentListener != null) {
            this._tabPane.removeComponentListener(this._componentListener);
            this._componentListener = null;
        }
        if (this._tabChangeListener != null) {
            this._tabPane.removeChangeListener(this._tabChangeListener);
            this._tabChangeListener = null;
        }
        if (this._tabFocusListener != null) {
            this._tabPane.removeFocusListener(this._tabFocusListener);
            this._tabFocusListener = null;
        }
        if (this._mouseListener != null) {
            this._tabPane.removeMouseListener(this._mouseListener);
            this._mouseListener = null;
        }
        if (this._mousemotionListener != null) {
            this._tabPane.removeMouseMotionListener(this._mousemotionListener);
            this._mousemotionListener = null;
        }
        if (this._mouseWheelListener != null) {
            this._tabPane.removeMouseWheelListener(this._mouseWheelListener);
            this._mouseWheelListener = null;
        }
        if (this._propertyChangeListener != null) {
            this._tabPane.removePropertyChangeListener(this._propertyChangeListener);
            this._propertyChangeListener = null;
        }
        if (this._dt != null && this._dropListener != null) {
            this._dt.removeDropTargetListener(this._dropListener);
            this._dropListener = null;
            this._dt = null;
            this.getTabPanel().setDropTarget(null);
        }
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    protected FocusListener createFocusListener() {
        return new TabFocusListener();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this._tabPane, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this._tabPane, 0, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this._tabPane, actionMap);
        this.ensureCloseButtonCreated();
        if (this.scrollableTabLayoutEnabled()) {
            this._tabScroller.scrollForwardButton.setAction(actionMap.get("scrollTabsForwardAction"));
            this._tabScroller.scrollBackwardButton.setAction(actionMap.get("scrollTabsBackwardAction"));
            this._tabScroller.listButton.setAction(actionMap.get("scrollTabsListAction"));
            Action action = this._tabPane.getCloseAction();
            this.updateButtonFromAction(this._tabScroller.closeButton, action);
            this._tabScroller.closeButton.setAction(actionMap.get("closeTabAction"));
        }
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIDefaultsLookup.get("JideTabbedPane.ancestorInputMap");
        }
        if (n == 0) {
            return (InputMap)UIDefaultsLookup.get("JideTabbedPane.focusInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIDefaultsLookup.get("JideTabbedPane.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("JideTabbedPane.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("navigateNext", new NextAction());
        actionMapUIResource.put("navigatePrevious", new PreviousAction());
        actionMapUIResource.put("navigateRight", new RightAction());
        actionMapUIResource.put("navigateLeft", new LeftAction());
        actionMapUIResource.put("navigateUp", new UpAction());
        actionMapUIResource.put("navigateDown", new DownAction());
        actionMapUIResource.put("navigatePageUp", new PageUpAction());
        actionMapUIResource.put("navigatePageDown", new PageDownAction());
        actionMapUIResource.put("requestFocus", new RequestFocusAction());
        actionMapUIResource.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction());
        actionMapUIResource.put("setSelectedIndex", new SetSelectedIndexAction());
        actionMapUIResource.put("scrollTabsForwardAction", new ScrollTabsForwardAction());
        actionMapUIResource.put("scrollTabsBackwardAction", new ScrollTabsBackwardAction());
        actionMapUIResource.put("scrollTabsListAction", new ScrollTabsListAction());
        actionMapUIResource.put("closeTabAction", new CloseTabAction());
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this._tabPane, null);
        SwingUtilities.replaceUIInputMap(this._tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this._tabPane, 0, null);
        if (this._closeButtons != null) {
            for (int i = 0; i < this._closeButtons.length; ++i) {
                this._closeButtons[i] = null;
            }
            this._closeButtons = null;
        }
    }

    protected void updateMnemonics() {
        this.resetMnemonics();
        for (int i = this._tabPane.getTabCount() - 1; i >= 0; --i) {
            int n = this._tabPane.getMnemonicAt(i);
            if (n <= 0) continue;
            this.addMnemonic(i, n);
        }
    }

    private void resetMnemonics() {
        if (this._mnemonicToIndexMap != null) {
            this._mnemonicToIndexMap.clear();
            this._mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int n, int n2) {
        if (this._mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this._mnemonicInputMap.put(KeyStroke.getKeyStroke(n2, 8), "setSelectedIndex");
        this._mnemonicToIndexMap.put(n2, n);
    }

    private void initMnemonics() {
        this._mnemonicToIndexMap = new Hashtable();
        this._mnemonicInputMap = new InputMapUIResource();
        this._mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this._tabPane, 1));
        SwingUtilities.replaceUIInputMap(this._tabPane, 1, this._mnemonicInputMap);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n = this._tabPane.getTabCount();
        this.paintBackground(graphics, jComponent);
        if (n == 0) {
            return;
        }
        if (this._tabCount != n) {
            this._tabCount = n;
            this.updateMnemonics();
        }
        int n2 = this._tabPane.getSelectedIndex();
        int n3 = this._tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(graphics, n3, n2, jComponent);
        }
        this.paintContentBorder(graphics, n3, n2);
    }

    public void paintBackground(Graphics graphics, Component component) {
        if (this._tabPane.isOpaque()) {
            int n = component.getWidth();
            int n2 = component.getHeight();
            graphics.setColor(this._background);
            graphics.fillRect(0, 0, n, n2);
        }
    }

    protected void paintTabArea(Graphics graphics, int n, int n2, Component component) {
        int n3 = this._tabPane.getTabCount();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(0, 0, component.getWidth(), component.getHeight());
        this.paintTabAreaBackground(graphics, rectangle3, n);
        for (int i = this._runCount - 1; i >= 0; --i) {
            int n4 = this._tabRuns[i];
            int n5 = this._tabRuns[i == this._runCount - 1 ? 0 : i + 1];
            int n6 = n5 != 0 ? n5 - 1 : n3 - 1;
            for (int j = n4; j <= n6; ++j) {
                if (!this._rects[j].intersects(rectangle3) || j == n2) continue;
                this.paintTab(graphics, n, this._rects, j, rectangle, rectangle2);
            }
        }
        if (n2 >= 0 && this.getRunForTab(n3, n2) == 0 && this._rects[n2].intersects(rectangle3)) {
            this.paintTab(graphics, n, this._rects, n2, rectangle, rectangle2);
        }
    }

    protected void paintTabAreaBackground(Graphics graphics, Rectangle rectangle, int n) {
        this.getPainter().paintTabAreaBackground(this._tabPane, graphics, rectangle, n == 1 || n == 3 ? 0 : 1, 0);
    }

    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        Object object;
        Rectangle rectangle3 = rectangleArray[n2];
        int n3 = this._tabPane.getSelectedIndex();
        boolean bl = n3 == n2;
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        this.paintTabBackground(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        Object object2 = JideSwingUtilities.setupShapeAntialiasing(graphics);
        this.paintTabBorder(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        JideSwingUtilities.restoreShapeAntialiasing(graphics, object2);
        Icon icon = this._tabPane.getIconForTab(n2);
        Rectangle rectangle4 = new Rectangle(rectangle3);
        if (this._tabPane.isShowGripper()) {
            if (bl2) {
                rectangle4.x += this._gripperWidth;
            }
            rectangle4.width -= this._gripperWidth;
            object = new Rectangle(rectangle3);
            ((Rectangle)object).x = bl2 ? (((Rectangle)object).x += this._gripLeftMargin) : rectangle3.x + rectangle3.width - this._gripLeftMargin - this._gripperWidth;
            ((Rectangle)object).width = this._gripperWidth;
            if (this._gripperPainter != null) {
                this._gripperPainter.paint(this._tabPane, graphics, (Rectangle)object, 0, bl ? 3 : 0);
            } else {
                this.getPainter().paintGripper(this._tabPane, graphics, (Rectangle)object, 0, bl ? 3 : 0);
            }
        }
        if (this.isShowCloseButton() && this.isShowCloseButtonOnTab() && this._tabPane.isTabClosableAt(n2) && (!this._tabPane.isShowCloseButtonOnSelectedTab() || bl)) {
            if (n == 1 || n == 3) {
                int n4 = this._closeButtons[n2].getPreferredSize().width + this._closeButtonLeftMargin + this._closeButtonRightMargin;
                if (!(this._closeButtonAlignment == 10 ^ bl2)) {
                    rectangle4.x += n4;
                }
                rectangle4.width -= n4;
            } else {
                int n5 = this._closeButtons[n2].getPreferredSize().height + this._closeButtonLeftMargin + this._closeButtonRightMargin;
                if (this._closeButtonAlignment == 10) {
                    rectangle4.y += n5;
                    rectangle4.height -= n5;
                } else {
                    rectangle4.height -= n5;
                }
            }
        }
        object = this.getCurrentDisplayTitleAt(this._tabPane, n2);
        Font font = null;
        font = bl && this._tabPane.getSelectedTabFont() != null ? this._tabPane.getSelectedTabFont() : this._tabPane.getFont();
        if (bl && this._tabPane.isBoldActiveTab() && font.getStyle() != 1) {
            font = font.deriveFont(1);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        while (object == null || ((String)object).length() < 3) {
            object = (String)object + " ";
        }
        this.layoutLabel(n, fontMetrics, n2, (String)object, icon, rectangle4, rectangle, rectangle2, bl);
        if (!this._isEditing || !bl) {
            this.paintText(graphics, n, font, fontMetrics, n2, (String)object, rectangle2, bl);
        }
        this.paintIcon(graphics, n, n2, icon, rectangle, bl);
        this.paintFocusIndicator(graphics, n, rectangleArray, n2, rectangle, rectangle2, bl);
    }

    private void paintCroppedTabEdge(Graphics graphics, int n, int n2, boolean bl, int n3, int n4) {
        switch (n) {
            case 2: 
            case 4: {
                graphics.setColor(this._shadow);
                for (int i = n3; i <= n3 + this._rects[n2].width; i += 12) {
                    for (int j = 0; j < this.xCropLen.length; j += 2) {
                        graphics.drawLine(i + this.yCropLen[j], n4 - this.xCropLen[j], i + this.yCropLen[j + 1] - 1, n4 - this.xCropLen[j + 1]);
                    }
                }
                break;
            }
            default: {
                graphics.setColor(this._shadow);
                for (int i = n4; i <= n4 + this._rects[n2].height; i += 12) {
                    for (int j = 0; j < this.xCropLen.length; j += 2) {
                        graphics.drawLine(n3 - this.xCropLen[j], i + this.yCropLen[j], n3 - this.xCropLen[j + 1], i + this.yCropLen[j + 1] - 1);
                    }
                }
            }
        }
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            this._tabPane.putClientProperty("html", view);
        }
        SwingUtilities.layoutCompoundLabel(this._tabPane, fontMetrics, string, icon, 0, 0, 0, 11, rectangle, rectangle2, rectangle3, this._textIconGap);
        this._tabPane.putClientProperty("html", null);
        if (n == 1 || n == 3) {
            if (this.getTabResizeMode() == 4 && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab() && !bl) {
                rectangle2.width = rectangle2.width + this._closeButtons[n2].getPreferredSize().width + this._closeButtonMarginHorizon;
                rectangle3.width = 0;
            }
        } else {
            rectangle2.y = rectangle.y + this._iconMargin;
            rectangle3.y = icon != null ? rectangle2.y + rectangle2.height + this._textIconGap : rectangle.y + this._textPadding;
            rectangle2.x = rectangle.x + 2;
            rectangle3.x = rectangle.x + 2;
            rectangle3.width = rectangle.width - this._textMarginVertical;
            rectangle3.height = rectangle.height - this._tabRectPadding - rectangle2.height - (icon != null ? this._textIconGap + this._iconMargin : this._noIconMargin);
            if (this.getTabResizeMode() == 4 && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab() && !bl) {
                rectangle2.height = rectangle2.height + this._closeButtons[n2].getPreferredSize().height + this._closeButtonMarginVertical;
                rectangle3.height = 0;
            }
        }
    }

    protected void paintIcon(Graphics graphics, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
        if (icon != null && rectangle.width >= icon.getIconWidth()) {
            if (n == 1 || n == 3) {
                icon.paintIcon(this._tabPane, graphics, rectangle.x, rectangle.y);
            } else if (rectangle.height < this._rects[n2].height - this._gripperHeight) {
                icon.paintIcon(this._tabPane, graphics, rectangle.x, rectangle.y);
            }
        }
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        View view;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (bl && this._tabPane.isBoldActiveTab()) {
            graphics2D.setFont(font.deriveFont(1));
        } else {
            graphics2D.setFont(font);
        }
        String string2 = string;
        if (n == 1 || n == 3) {
            if (rectangle.width <= 0) {
                return;
            }
            while (SwingUtilities.computeStringWidth(fontMetrics, string2) > rectangle.width) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (!string2.equals(string)) {
                string2 = string2.length() >= 2 ? string2.substring(0, string2.length() - 2) + ".." : "";
            }
        } else {
            if (rectangle.height <= 0) {
                return;
            }
            while (SwingUtilities.computeStringWidth(fontMetrics, string2) > rectangle.height) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (!string2.equals(string)) {
                string2 = string2.length() >= 2 ? string2.substring(0, string2.length() - 2) + ".." : "";
            }
        }
        if ((view = this.getTextViewForTab(n2)) != null) {
            view.paint(graphics2D, rectangle);
        } else {
            int n3 = this._tabPane.getDisplayedMnemonicIndexAt(n2);
            JideTabbedPane.ColorProvider colorProvider = this._tabPane.getTabColorProvider();
            if (this._tabPane.isEnabled() && this._tabPane.isEnabledAt(n2)) {
                Serializable serializable;
                if (colorProvider != null) {
                    graphics2D.setColor(colorProvider.getForegroudAt(n2));
                } else {
                    serializable = this._tabPane.getForegroundAt(n2);
                    if (bl && this.showFocusIndicator()) {
                        if (!(serializable instanceof ColorUIResource)) {
                            graphics2D.setColor((Color)serializable);
                        } else {
                            graphics2D.setColor(this._activeTabForeground);
                        }
                    } else if (!(serializable instanceof ColorUIResource)) {
                        graphics2D.setColor((Color)serializable);
                    } else {
                        graphics2D.setColor(this._inactiveTabForeground);
                    }
                }
                if (n == 1 || n == 3) {
                    JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, graphics2D, string2, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
                } else {
                    serializable = graphics2D.getTransform();
                    graphics2D.translate(rectangle.x, rectangle.y);
                    if (n == 4) {
                        graphics2D.rotate(1.5707963267948966);
                        graphics2D.translate(0, -rectangle.width);
                    } else {
                        graphics2D.rotate(-1.5707963267948966);
                        graphics2D.translate(-rectangle.height + fontMetrics.getHeight() / 2 + this._rectSizeExtend, 0);
                    }
                    JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, graphics2D, string2, n3, 0, (rectangle.width - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
                    graphics2D.setTransform((AffineTransform)serializable);
                }
            } else if (n == 1 || n == 3) {
                graphics2D.setColor(this._tabPane.getBackgroundAt(n2).brighter());
                JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, graphics2D, string2, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics2D.setColor(this._tabPane.getBackgroundAt(n2).darker());
                JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, graphics2D, string2, n3, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            } else {
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.translate(rectangle.x, rectangle.y);
                if (n == 4) {
                    graphics2D.rotate(1.5707963267948966);
                    graphics2D.translate(0, -rectangle.width);
                } else {
                    graphics2D.rotate(-1.5707963267948966);
                    graphics2D.translate(-rectangle.height + fontMetrics.getHeight() / 2 + this._rectSizeExtend, 0);
                }
                graphics2D.setColor(this._tabPane.getBackgroundAt(n2).brighter());
                JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, graphics2D, string2, n3, 0, (rectangle.width - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
                graphics2D.setColor(this._tabPane.getBackgroundAt(n2).darker());
                JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, graphics2D, string2, n3, n == 4 ? -1 : 1, (rectangle.width - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() - 1);
                graphics2D.setTransform(affineTransform);
            }
        }
        graphics2D.dispose();
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        switch (this.getTabShape()) {
            case 3: {
                this.paintBoxTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
                break;
            }
            case 8: {
                this.paintExcelTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
                break;
            }
            case 1: {
                this.paintWindowsTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
                break;
            }
            case 11: {
                if (!bl) break;
                this.paintWindowsTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
                break;
            }
            case 2: {
                this.paintVsnetTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
                break;
            }
            case 9: {
                this.paintRoundedVsnetTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
                break;
            }
            case 5: {
                this.paintFlatTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
                break;
            }
            case 10: {
                this.paintRoundedFlatTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
                break;
            }
            default: {
                this.paintOffice2003TabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
            }
        }
        int n7 = this.getTabShape();
        if (n7 == 1) {
            if (this._mouseEnter && this._tabPane.getColorTheme() == 4 && n2 == this._indexMouseOver && !bl && this._tabPane.isEnabledAt(this._indexMouseOver)) {
                this.paintTabBorderMouseOver(graphics, n, n2, n3, n4, n5, n6, bl);
            }
        } else if (n7 == 11 && this._mouseEnter && n2 == this._indexMouseOver && !bl && this._tabPane.isEnabledAt(this._indexMouseOver)) {
            this.paintTabBorderMouseOver(graphics, n, n2, n3, n4, n5, n6, bl);
        }
    }

    protected void paintOffice2003TabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (n) {
            case 2: {
                n4 += 2;
                if (bl) {
                    int n7;
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3, n4 + 3, n3, n4 + n6 - 5);
                    graphics.drawLine(n3 + 1, n4 + n6 - 4, n3 + 1, n4 + n6 - 4);
                    graphics.drawLine(n3 + 2, n4 + n6 - 3, n3 + n5 - 1, n4 + n6 - 3);
                    graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + 1);
                    graphics.drawLine(n3 + 2, n4, n3 + 2, n4 - 1);
                    for (n7 = 0; n7 < n5 - 4; ++n7) {
                        graphics.drawLine(n3 + 3 + n7, n4 - 2 - n7, n3 + 3 + n7, n4 - 2 - n7);
                    }
                    graphics.drawLine(n3 + n5 - 1, n4 - n5 + 1, n3 + n5 - 1, n4 - n5 + 2);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + 1, n4 + 3, n3 + 1, n4 + n6 - 5);
                    graphics.drawLine(n3 + 2, n4 + n6 - 4, n3 + n5 - 1, n4 + n6 - 4);
                    graphics.drawLine(n3 + 2, n4 + 2, n3 + 2, n4 + 1);
                    graphics.drawLine(n3 + 3, n4, n3 + 3, n4 - 1);
                    for (n7 = 0; n7 < n5 - 4; ++n7) {
                        graphics.drawLine(n3 + 4 + n7, n4 - 2 - n7, n3 + 4 + n7, n4 - 2 - n7);
                    }
                    break;
                }
                if (n2 == 0) {
                    int n8;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3, n4 + 3, n3, n4 + n6 - 5);
                    graphics.drawLine(n3 + 1, n4 + n6 - 4, n3 + 1, n4 + n6 - 4);
                    graphics.drawLine(n3 + 2, n4 + n6 - 3, n3 + n5 - 1, n4 + n6 - 3);
                    graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + 1);
                    graphics.drawLine(n3 + 2, n4, n3 + 2, n4 - 1);
                    for (n8 = 0; n8 < n5 - 4; ++n8) {
                        graphics.drawLine(n3 + 3 + n8, n4 - 2 - n8, n3 + 3 + n8, n4 - 2 - n8);
                    }
                    graphics.drawLine(n3 + n5 - 1, n4 - n5 + 1, n3 + n5 - 1, n4 - n5 + 2);
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + 1, n4 + 3, n3 + 1, n4 + n6 - 6);
                        graphics.drawLine(n3 + 2, n4 + 2, n3 + 2, n4 + 1);
                        graphics.drawLine(n3 + 3, n4, n3 + 3, n4 - 1);
                        for (n8 = 0; n8 < n5 - 4; ++n8) {
                            graphics.drawLine(n3 + 4 + n8, n4 - 2 - n8, n3 + 4 + n8, n4 - 2 - n8);
                        }
                        graphics.setColor(this.getPainter().getControlDk());
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + 2, n4 + n6 - 4, n3 + n5 - 1, n4 + n6 - 4);
                    graphics.drawLine(n3 + 1, n4 + n6 - 5, n3 + 1, n4 + n6 - 5);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n3, n4 + 3, n3, n4 + n6 - 5);
                graphics.drawLine(n3 + 1, n4 + n6 - 4, n3 + 1, n4 + n6 - 4);
                graphics.drawLine(n3 + 2, n4 + n6 - 3, n3 + n5 - 1, n4 + n6 - 3);
                graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + 1);
                graphics.drawLine(n3 + 2, n4, n3 + 2, n4 - 1);
                graphics.drawLine(n3 + 3, n4 - 2, n3 + 3, n4 - 2);
                if (this._unselectColor2 != null) {
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n3 + 1, n4 + 3, n3 + 1, n4 + n6 - 6);
                    graphics.drawLine(n3 + 2, n4 + 2, n3 + 2, n4 + 1);
                    graphics.drawLine(n3 + 3, n4, n3 + 3, n4 - 1);
                    graphics.drawLine(n3 + 4, n4 - 2, n3 + 4, n4 - 2);
                }
                if (this._unselectColor3 == null) break;
                graphics.setColor(this._unselectColor3);
                graphics.drawLine(n3 + 2, n4 + n6 - 4, n3 + n5 - 1, n4 + n6 - 4);
                graphics.drawLine(n3 + 1, n4 + n6 - 5, n3 + 1, n4 + n6 - 5);
                break;
            }
            case 4: {
                if (bl) {
                    int n9;
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3 + n5 - 1, n4 + 5, n3 + n5 - 1, n4 + n6 - 3);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 3, n4 + n6 - 1, n3, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5 - 2, n4 + 4, n3 + n5 - 2, n4 + 3);
                    graphics.drawLine(n3 + n5 - 3, n4 + 2, n3 + n5 - 3, n4 + 1);
                    for (n9 = 0; n9 < n5 - 4; ++n9) {
                        graphics.drawLine(n3 + n5 - 4 - n9, n4 - n9, n3 + n5 - 4 - n9, n4 - n9);
                    }
                    graphics.drawLine(n3, n4 - n5 + 3, n3, n4 - n5 + 4);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + n5 - 2, n4 + 5, n3 + n5 - 2, n4 + n6 - 3);
                    graphics.drawLine(n3 + n5 - 3, n4 + n6 - 2, n3, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 3, n4 + 4, n3 + n5 - 3, n4 + 3);
                    graphics.drawLine(n3 + n5 - 4, n4 + 2, n3 + n5 - 4, n4 + 1);
                    for (n9 = 0; n9 < n5 - 4; ++n9) {
                        graphics.drawLine(n3 + n5 - 5 - n9, n4 - n9, n3 + n5 - 5 - n9, n4 - n9);
                    }
                    break;
                }
                if (n2 == 0) {
                    int n10;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + n5 - 1, n4 + 5, n3 + n5 - 1, n4 + n6 - 3);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 3, n4 + n6 - 1, n3, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5 - 2, n4 + 4, n3 + n5 - 2, n4 + 3);
                    graphics.drawLine(n3 + n5 - 3, n4 + 2, n3 + n5 - 3, n4 + 1);
                    for (n10 = 0; n10 < n5 - 4; ++n10) {
                        graphics.drawLine(n3 + n5 - 4 - n10, n4 - n10, n3 + n5 - 4 - n10, n4 - n10);
                    }
                    graphics.drawLine(n3, n4 - n5 + 3, n3, n4 - n5 + 4);
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + n5 - 2, n4 + 5, n3 + n5 - 2, n4 + n6 - 4);
                        graphics.drawLine(n3 + n5 - 3, n4 + 4, n3 + n5 - 3, n4 + 3);
                        graphics.drawLine(n3 + n5 - 4, n4 + 2, n3 + n5 - 4, n4 + 1);
                        for (n10 = 0; n10 < n5 - 4; ++n10) {
                            graphics.drawLine(n3 + n5 - 5 - n10, n4 - n10, n3 + n5 - 5 - n10, n4 - n10);
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 3, n3 + n5 - 2, n4 + n6 - 3);
                    graphics.drawLine(n3 + n5 - 3, n4 + n6 - 2, n3, n4 + n6 - 2);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n3 + n5 - 1, n4 + 5, n3 + n5 - 1, n4 + n6 - 3);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 3, n4 + n6 - 1, n3, n4 + n6 - 1);
                graphics.drawLine(n3 + n5 - 2, n4 + 4, n3 + n5 - 2, n4 + 3);
                graphics.drawLine(n3 + n5 - 3, n4 + 2, n3 + n5 - 3, n4 + 1);
                graphics.drawLine(n3 + n5 - 4, n4, n3 + n5 - 4, n4);
                if (this._unselectColor2 != null) {
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n3 + n5 - 2, n4 + 5, n3 + n5 - 2, n4 + n6 - 4);
                    graphics.drawLine(n3 + n5 - 3, n4 + 4, n3 + n5 - 3, n4 + 3);
                    graphics.drawLine(n3 + n5 - 4, n4 + 2, n3 + n5 - 4, n4 + 1);
                    graphics.drawLine(n3 + n5 - 5, n4, n3 + n5 - 5, n4);
                }
                if (this._unselectColor3 == null) break;
                graphics.setColor(this._unselectColor3);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 3, n3 + n5 - 2, n4 + n6 - 3);
                graphics.drawLine(n3 + n5 - 3, n4 + n6 - 2, n3, n4 + n6 - 2);
                break;
            }
            case 3: {
                if (bl2) {
                    if (bl) {
                        int n11;
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n3 + n5 - 1, n4 + n6 - 3, n3 + n5 - 1, n4);
                        graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                        graphics.drawLine(n3 + 5, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                        graphics.drawLine(n3 + 3, n4 + n6 - 2, n3 + 4, n4 + n6 - 2);
                        graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + 2, n4 + n6 - 3);
                        graphics.drawLine(n3, n4 + n6 - 4, n3, n4 + n6 - 4);
                        for (n11 = 3; n11 < n6 - 2; ++n11) {
                            graphics.drawLine(n3 + 2 - n11, n4 + n6 - 2 - n11, n3 + 2 - n11, n4 + n6 - 2 - n11);
                        }
                        graphics.drawLine(n3 - n6 + 3, n4, n3 - n6 + 4, n4);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n3 + 5, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 2);
                        graphics.drawLine(n3 + n5 - 2, n4, n3 + n5 - 2, n4 + n6 - 3);
                        graphics.drawLine(n3 + 3, n4 + n6 - 3, n3 + 4, n4 + n6 - 3);
                        graphics.drawLine(n3 + 1, n4 + n6 - 4, n3 + 2, n4 + n6 - 4);
                        graphics.drawLine(n3, n4 + n6 - 5, n3, n4 + n6 - 5);
                        for (n11 = 3; n11 < n6 - 2; ++n11) {
                            graphics.drawLine(n3 + 2 - n11, n4 + n6 - 3 - n11, n3 + 2 - n11, n4 + n6 - 3 - n11);
                        }
                        break;
                    }
                    if (n2 == 0) {
                        int n12;
                        graphics.setColor(this._unselectColor1);
                        graphics.drawLine(n3 + n5 - 1, n4 + n6 - 3, n3 + n5 - 1, n4);
                        graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                        graphics.drawLine(n3 + 5, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                        graphics.drawLine(n3 + 3, n4 + n6 - 2, n3 + 4, n4 + n6 - 2);
                        graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + 2, n4 + n6 - 3);
                        graphics.drawLine(n3, n4 + n6 - 4, n3, n4 + n6 - 4);
                        for (n12 = 3; n12 < n6 - 2; ++n12) {
                            graphics.drawLine(n3 + 2 - n12, n4 + n6 - 2 - n12, n3 + 2 - n12, n4 + n6 - 2 - n12);
                        }
                        graphics.drawLine(n3 - n6 + 3, n4, n3 - n6 + 4, n4);
                        if (this._unselectColor2 != null) {
                            graphics.setColor(this._unselectColor2);
                            graphics.drawLine(n3 + 3, n4 + n6 - 3, n3 + 4, n4 + n6 - 3);
                            graphics.drawLine(n3 + 1, n4 + n6 - 4, n3 + 2, n4 + n6 - 4);
                            graphics.drawLine(n3, n4 + n6 - 5, n3, n4 + n6 - 5);
                            for (n12 = 3; n12 < n6 - 2; ++n12) {
                                graphics.drawLine(n3 + 2 - n12, n4 + n6 - 3 - n12, n3 + 2 - n12, n4 + n6 - 3 - n12);
                            }
                            graphics.drawLine(n3 + 5, n4 + n6 - 2, n3 + n5 - 4, n4 + n6 - 2);
                        }
                        if (this._unselectColor3 == null) break;
                        graphics.setColor(this._unselectColor3);
                        graphics.drawLine(n3 + n5 - 3, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 2);
                        graphics.drawLine(n3 + n5 - 2, n4 + n6 - 3, n3 + n5 - 2, n4);
                        break;
                    }
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + 5, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5 - 1, n4 + n6 - 3, n3 + n5 - 1, n4);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                    graphics.drawLine(n3 + 3, n4 + n6 - 2, n3 + 4, n4 + n6 - 2);
                    graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + 2, n4 + n6 - 3);
                    graphics.drawLine(n3, n4 + n6 - 4, n3, n4 + n6 - 4);
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + 3, n4 + n6 - 3, n3 + 4, n4 + n6 - 3);
                        graphics.drawLine(n3 + 1, n4 + n6 - 4, n3 + 2, n4 + n6 - 4);
                        graphics.drawLine(n3, n4 + n6 - 5, n3, n4 + n6 - 5);
                        graphics.drawLine(n3 + 5, n4 + n6 - 2, n3 + n5 - 4, n4 + n6 - 2);
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + n5 - 3, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 3, n3 + n5 - 2, n4);
                    break;
                }
                if (bl) {
                    int n13;
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3, n4 + n6 - 3, n3, n4);
                    graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + 1, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 6, n4 + n6 - 1, n3 + 2, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5 - 4, n4 + n6 - 2, n3 + n5 - 5, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 3, n3 + n5 - 3, n4 + n6 - 3);
                    graphics.drawLine(n3 + n5 - 1, n4 + n6 - 4, n3 + n5 - 1, n4 + n6 - 4);
                    for (n13 = 3; n13 < n6 - 2; ++n13) {
                        graphics.drawLine(n3 + n5 - 3 + n13, n4 + n6 - 2 - n13, n3 + n5 - 3 + n13, n4 + n6 - 2 - n13);
                    }
                    graphics.drawLine(n3 + n5 - 4 + n6, n4, n3 + n5 - 5 + n6, n4);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + n5 - 6, n4 + n6 - 2, n3 + 2, n4 + n6 - 2);
                    graphics.drawLine(n3 + 1, n4, n3 + 1, n4 + n6 - 3);
                    graphics.drawLine(n3 + n5 - 4, n4 + n6 - 3, n3 + n5 - 5, n4 + n6 - 3);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 4, n3 + n5 - 3, n4 + n6 - 4);
                    graphics.drawLine(n3 + n5 - 1, n4 + n6 - 5, n3 + n5 - 1, n4 + n6 - 5);
                    for (n13 = 3; n13 < n6 - 2; ++n13) {
                        graphics.drawLine(n3 + n5 - 3 + n13, n4 + n6 - 3 - n13, n3 + n5 - 3 + n13, n4 + n6 - 3 - n13);
                    }
                    break;
                }
                if (n2 == 0) {
                    int n14;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3, n4 + n6 - 3, n3, n4);
                    graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + 1, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 6, n4 + n6 - 1, n3 + 2, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5 - 4, n4 + n6 - 2, n3 + n5 - 5, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 3, n3 + n5 - 3, n4 + n6 - 3);
                    graphics.drawLine(n3 + n5 - 1, n4 + n6 - 4, n3 + n5 - 1, n4 + n6 - 4);
                    for (n14 = 3; n14 < n6 - 2; ++n14) {
                        graphics.drawLine(n3 + n5 - 3 + n14, n4 + n6 - 2 - n14, n3 + n5 - 3 + n14, n4 + n6 - 2 - n14);
                    }
                    graphics.drawLine(n3 + n5 - 4 + n6, n4, n3 + n5 - 5 + n6, n4);
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + n5 - 4, n4 + n6 - 3, n3 + n5 - 5, n4 + n6 - 3);
                        graphics.drawLine(n3 + n5 - 2, n4 + n6 - 4, n3 + n5 - 3, n4 + n6 - 4);
                        graphics.drawLine(n3 + n5 - 1, n4 + n6 - 5, n3 + n5 - 1, n4 + n6 - 5);
                        for (n14 = 3; n14 < n6 - 2; ++n14) {
                            graphics.drawLine(n3 + n5 - 3 + n14, n4 + n6 - 3 - n14, n3 + n5 - 3 + n14, n4 + n6 - 3 - n14);
                        }
                        graphics.drawLine(n3 + n5 - 6, n4 + n6 - 2, n3 + 3, n4 + n6 - 2);
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + 2, n4 + n6 - 2);
                    graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + 1, n4);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n3 + n5 - 6, n4 + n6 - 1, n3 + 2, n4 + n6 - 1);
                graphics.drawLine(n3, n4 + n6 - 3, n3, n4);
                graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + 1, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 4, n4 + n6 - 2, n3 + n5 - 5, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 3, n3 + n5 - 3, n4 + n6 - 3);
                graphics.drawLine(n3 + n5 - 1, n4 + n6 - 4, n3 + n5 - 1, n4 + n6 - 4);
                if (this._unselectColor2 != null) {
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n3 + n5 - 4, n4 + n6 - 3, n3 + n5 - 5, n4 + n6 - 3);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 4, n3 + n5 - 3, n4 + n6 - 4);
                    graphics.drawLine(n3 + n5 - 1, n4 + n6 - 5, n3 + n5 - 1, n4 + n6 - 5);
                    graphics.drawLine(n3 + n5 - 6, n4 + n6 - 2, n3 + 3, n4 + n6 - 2);
                }
                if (this._unselectColor3 == null) break;
                graphics.setColor(this._unselectColor3);
                graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + 2, n4 + n6 - 2);
                graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + 1, n4);
                break;
            }
            default: {
                if (bl2) {
                    if (bl) {
                        int n15;
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n3 + 3, n4 + 1, n3 + 4, n4 + 1);
                        graphics.drawLine(n3 + 1, n4 + 2, n3 + 2, n4 + 2);
                        graphics.drawLine(n3, n4 + 3, n3, n4 + 3);
                        graphics.drawLine(n3 + 5, n4, n3 + n5 - 3, n4);
                        graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                        graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 1);
                        for (n15 = 3; n15 < n6 - 2; ++n15) {
                            graphics.drawLine(n3 + 2 - n15, n4 + 1 + n15, n3 + 2 - n15, n4 + 1 + n15);
                        }
                        graphics.drawLine(n3 - n6 + 3, n4 + n6 - 1, n3 - n6 + 4, n4 + n6 - 1);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n3 + 3, n4 + 2, n3 + 4, n4 + 2);
                        graphics.drawLine(n3 + 1, n4 + 3, n3 + 2, n4 + 3);
                        graphics.drawLine(n3, n4 + 4, n3, n4 + 4);
                        graphics.drawLine(n3 + 5, n4 + 1, n3 + n5 - 3, n4 + 1);
                        graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 1);
                        for (n15 = 3; n15 < n6 - 2; ++n15) {
                            graphics.drawLine(n3 + 2 - n15, n4 + 2 + n15, n3 + 2 - n15, n4 + 2 + n15);
                        }
                        break;
                    }
                    if (n2 == 0) {
                        int n16;
                        graphics.setColor(this._unselectColor1);
                        graphics.drawLine(n3 + 3, n4 + 1, n3 + 4, n4 + 1);
                        graphics.drawLine(n3 + 1, n4 + 2, n3 + 2, n4 + 2);
                        graphics.drawLine(n3, n4 + 3, n3, n4 + 3);
                        graphics.drawLine(n3 + 5, n4, n3 + n5 - 3, n4);
                        graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                        graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 1);
                        for (n16 = 3; n16 < n6 - 2; ++n16) {
                            graphics.drawLine(n3 + 2 - n16, n4 + 1 + n16, n3 + 2 - n16, n4 + 1 + n16);
                        }
                        graphics.drawLine(n3 - n6 + 3, n4 + n6 - 1, n3 - n6 + 4, n4 + n6 - 1);
                        if (this._unselectColor2 != null) {
                            graphics.setColor(this._unselectColor2);
                            graphics.drawLine(n3 + 3, n4 + 2, n3 + 4, n4 + 2);
                            graphics.drawLine(n3 + 1, n4 + 3, n3 + 2, n4 + 3);
                            graphics.drawLine(n3, n4 + 4, n3, n4 + 4);
                            for (n16 = 3; n16 < n6 - 2; ++n16) {
                                graphics.drawLine(n3 + 2 - n16, n4 + 2 + n16, n3 + 2 - n16, n4 + 2 + n16);
                            }
                            graphics.drawLine(n3 + 5, n4 + 1, n3 + n5 - 4, n4 + 1);
                        }
                        if (this._unselectColor3 == null) break;
                        graphics.setColor(this._unselectColor3);
                        graphics.drawLine(n3 + n5 - 3, n4 + 1, n3 + n5 - 3, n4 + 1);
                        graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 1);
                        break;
                    }
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + 3, n4 + 1, n3 + 4, n4 + 1);
                    graphics.drawLine(n3 + 1, n4 + 2, n3 + 2, n4 + 2);
                    graphics.drawLine(n3, n4 + 3, n3, n4 + 3);
                    graphics.drawLine(n3 + 5, n4, n3 + n5 - 3, n4);
                    graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                    graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 1);
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + 3, n4 + 2, n3 + 4, n4 + 2);
                        graphics.drawLine(n3 + 1, n4 + 3, n3 + 2, n4 + 3);
                        graphics.drawLine(n3, n4 + 4, n3, n4 + 4);
                        graphics.drawLine(n3 + 5, n4 + 1, n3 + n5 - 4, n4 + 1);
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + n5 - 3, n4 + 1, n3 + n5 - 3, n4 + 1);
                    graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 1);
                    break;
                }
                if (bl) {
                    int n17;
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3 + n5 - 4, n4 + 1, n3 + n5 - 5, n4 + 1);
                    graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 3, n4 + 2);
                    graphics.drawLine(n3 + n5 - 1, n4 + 3, n3 + n5 - 1, n4 + 3);
                    graphics.drawLine(n3 + n5 - 6, n4, n3 + 2, n4);
                    graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                    graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 1);
                    for (n17 = 3; n17 < n6 - 2; ++n17) {
                        graphics.drawLine(n3 + n5 - 3 + n17, n4 + 1 + n17, n3 + n5 - 3 + n17, n4 + 1 + n17);
                    }
                    graphics.drawLine(n3 + n5 - 4 + n6, n4 + n6 - 1, n3 + n5 - 5 + n6, n4 + n6 - 1);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + n5 - 4, n4 + 2, n3 + n5 - 5, n4 + 2);
                    graphics.drawLine(n3 + n5 - 2, n4 + 3, n3 + n5 - 3, n4 + 3);
                    graphics.drawLine(n3 + n5 - 1, n4 + 4, n3 + n5 - 1, n4 + 4);
                    graphics.drawLine(n3 + n5 - 6, n4 + 1, n3 + 2, n4 + 1);
                    graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + n6 - 1);
                    for (n17 = 3; n17 < n6 - 2; ++n17) {
                        graphics.drawLine(n3 + n5 - 3 + n17, n4 + 2 + n17, n3 + n5 - 3 + n17, n4 + 2 + n17);
                    }
                    break;
                }
                if (n2 == 0) {
                    int n18;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + n5 - 4, n4 + 1, n3 + n5 - 5, n4 + 1);
                    graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 3, n4 + 2);
                    graphics.drawLine(n3 + n5 - 1, n4 + 3, n3 + n5 - 1, n4 + 3);
                    graphics.drawLine(n3 + n5 - 6, n4, n3 + 2, n4);
                    graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                    graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 1);
                    for (n18 = 3; n18 < n6 - 2; ++n18) {
                        graphics.drawLine(n3 + n5 - 3 + n18, n4 + 1 + n18, n3 + n5 - 3 + n18, n4 + 1 + n18);
                    }
                    graphics.drawLine(n3 + n5 - 4 + n6, n4 + n6 - 1, n3 + n5 - 5 + n6, n4 + n6 - 1);
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + n5 - 4, n4 + 2, n3 + n5 - 5, n4 + 2);
                        graphics.drawLine(n3 + n5 - 2, n4 + 3, n3 + n5 - 3, n4 + 3);
                        graphics.drawLine(n3 + n5 - 1, n4 + 4, n3 + n5 - 1, n4 + 4);
                        for (n18 = 3; n18 < n6 - 2; ++n18) {
                            graphics.drawLine(n3 + n5 - 3 + n18, n4 + 2 + n18, n3 + n5 - 3 + n18, n4 + 2 + n18);
                        }
                        graphics.drawLine(n3 + n5 - 6, n4 + 1, n3 + 3, n4 + 1);
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + 2, n4 + 1, n3 + 2, n4 + 1);
                    graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + n6 - 1);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n3 + n5 - 4, n4 + 1, n3 + n5 - 5, n4 + 1);
                graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 3, n4 + 2);
                graphics.drawLine(n3 + n5 - 1, n4 + 3, n3 + n5 - 1, n4 + 3);
                graphics.drawLine(n3 + n5 - 6, n4, n3 + 2, n4);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 1);
                if (this._unselectColor2 != null) {
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n3 + n5 - 4, n4 + 2, n3 + n5 - 5, n4 + 2);
                    graphics.drawLine(n3 + n5 - 2, n4 + 3, n3 + n5 - 3, n4 + 3);
                    graphics.drawLine(n3 + n5 - 1, n4 + 4, n3 + n5 - 1, n4 + 4);
                    graphics.drawLine(n3 + n5 - 6, n4 + 1, n3 + 3, n4 + 1);
                }
                if (this._unselectColor3 == null) break;
                graphics.setColor(this._unselectColor3);
                graphics.drawLine(n3 + 2, n4 + 1, n3 + 2, n4 + 1);
                graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + n6 - 1);
            }
        }
    }

    protected void paintExcelTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (n) {
            case 2: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3, n4 + 5, n3, n4 + n6 - 5);
                    int n7 = 0;
                    int n8 = 0;
                    while (n7 < n5 / 2 + 1) {
                        graphics.drawLine(n3 + 1 + n8, n4 + 4 - n7, n3 + 2 + n8, n4 + 4 - n7);
                        ++n7;
                        n8 += 2;
                    }
                    n7 = 0;
                    n8 = 0;
                    while (n7 < n5 / 2 + 1) {
                        graphics.drawLine(n3 + n8, n4 + n6 - 4 + n7, n3 + 1 + n8, n4 + n6 - 4 + n7);
                        ++n7;
                        n8 += 2;
                    }
                    if (this._selectColor2 != null) {
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n3 + 1, n4 + 6, n3 + 1, n4 + n6 - 6);
                        n7 = 0;
                        n8 = 0;
                        while (n7 < n5 / 2 + 1) {
                            graphics.drawLine(n3 + 1 + n8, n4 + 5 - n7, n3 + 2 + n8, n4 + 5 - n7);
                            ++n7;
                            n8 += 2;
                        }
                    }
                    if (this._selectColor3 == null) break;
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n3 + 1, n4 + n6 - 5, n3 + 1, n4 + n6 - 5);
                    n7 = 0;
                    n8 = 0;
                    while (n7 < n5 / 2 + 1) {
                        graphics.drawLine(n3 + 2 + n8, n4 + n6 - 4 + n7, n3 + 3 + n8, n4 + n6 - 4 + n7);
                        ++n7;
                        n8 += 2;
                    }
                } else if (n2 == 0) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3, n4 + 5, n3, n4 + n6 - 5);
                    int n9 = 0;
                    int n10 = 0;
                    while (n9 < n5 / 2 + 1) {
                        graphics.drawLine(n3 + 1 + n10, n4 + 4 - n9, n3 + 2 + n10, n4 + 4 - n9);
                        ++n9;
                        n10 += 2;
                    }
                    n9 = 0;
                    n10 = 0;
                    while (n9 < n5 / 2 + 1) {
                        graphics.drawLine(n3 + n10, n4 + n6 - 4 + n9, n3 + 1 + n10, n4 + n6 - 4 + n9);
                        ++n9;
                        n10 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + 1, n4 + 6, n3 + 1, n4 + n6 - 6);
                        n9 = 0;
                        n10 = 0;
                        while (n9 < n5 / 2) {
                            graphics.drawLine(n3 + 1 + n10, n4 + 5 - n9, n3 + 2 + n10, n4 + 5 - n9);
                            ++n9;
                            n10 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + 1, n4 + n6 - 5, n3 + 1, n4 + n6 - 5);
                    n9 = 0;
                    n10 = 0;
                    while (n9 < n5 / 2 + 1) {
                        graphics.drawLine(n3 + 2 + n10, n4 + n6 - 4 + n9, n3 + 3 + n10, n4 + n6 - 4 + n9);
                        ++n9;
                        n10 += 2;
                    }
                } else if (n2 == this._tabPane.getSelectedIndex() - 1) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3, n4 + 5, n3, n4 + n6 - 5);
                    int n11 = 0;
                    int n12 = 0;
                    while (n11 < 4) {
                        graphics.drawLine(n3 + 1 + n12, n4 + 4 - n11, n3 + 2 + n12, n4 + 4 - n11);
                        ++n11;
                        n12 += 2;
                    }
                    n11 = 0;
                    n12 = 0;
                    while (n11 < 5) {
                        graphics.drawLine(n3 + n12, n4 + n6 - 4 + n11, n3 + 1 + n12, n4 + n6 - 4 + n11);
                        ++n11;
                        n12 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + 1, n4 + 6, n3 + 1, n4 + n6 - 6);
                        n11 = 0;
                        n12 = 0;
                        while (n11 < 4) {
                            graphics.drawLine(n3 + 1 + n12, n4 + 5 - n11, n3 + 2 + n12, n4 + 5 - n11);
                            ++n11;
                            n12 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + 1, n4 + n6 - 5, n3 + 1, n4 + n6 - 5);
                    n11 = 0;
                    n12 = 0;
                    while (n11 < 5) {
                        graphics.drawLine(n3 + 2 + n12, n4 + n6 - 4 + n11, n3 + 3 + n12, n4 + n6 - 4 + n11);
                        ++n11;
                        n12 += 2;
                    }
                } else {
                    if (n2 == this._tabPane.getSelectedIndex() - 1) break;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3, n4 + 5, n3, n4 + n6 - 5);
                    int n13 = 0;
                    int n14 = 0;
                    while (n13 < 4) {
                        graphics.drawLine(n3 + 1 + n14, n4 + 4 - n13, n3 + 2 + n14, n4 + 4 - n13);
                        ++n13;
                        n14 += 2;
                    }
                    n13 = 0;
                    n14 = 0;
                    while (n13 < n5 / 2 + 1) {
                        graphics.drawLine(n3 + n14, n4 + n6 - 4 + n13, n3 + 1 + n14, n4 + n6 - 4 + n13);
                        ++n13;
                        n14 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + 1, n4 + 6, n3 + 1, n4 + n6 - 6);
                        n13 = 0;
                        n14 = 0;
                        while (n13 < 4) {
                            graphics.drawLine(n3 + 1 + n14, n4 + 5 - n13, n3 + 2 + n14, n4 + 5 - n13);
                            ++n13;
                            n14 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + 1, n4 + n6 - 5, n3 + 1, n4 + n6 - 5);
                    n13 = 0;
                    n14 = 0;
                    while (n13 < n5 / 2 + 1) {
                        graphics.drawLine(n3 + 2 + n14, n4 + n6 - 4 + n13, n3 + 3 + n14, n4 + n6 - 4 + n13);
                        ++n13;
                        n14 += 2;
                    }
                }
                break;
            }
            case 4: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3 + n5 - 1, n4 + 5, n3 + n5 - 1, n4 + n6 - 5);
                    int n15 = 0;
                    int n16 = 0;
                    while (n15 < n5 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 2 - n16, n4 + 4 - n15, n3 + n5 - 3 - n16, n4 + 4 - n15);
                        ++n15;
                        n16 += 2;
                    }
                    n15 = 0;
                    n16 = 0;
                    while (n15 < n5 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 1 - n16, n4 + n6 - 4 + n15, n3 + n5 - 2 - n16, n4 + n6 - 4 + n15);
                        ++n15;
                        n16 += 2;
                    }
                    if (this._selectColor2 != null) {
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n3 + n5 - 2, n4 + 6, n3 + n5 - 2, n4 + n6 - 6);
                        n15 = 0;
                        n16 = 0;
                        while (n15 < n5 / 2 + 1) {
                            graphics.drawLine(n3 + n5 - 2 - n16, n4 + 5 - n15, n3 + n5 - 3 - n16, n4 + 5 - n15);
                            ++n15;
                            n16 += 2;
                        }
                    }
                    if (this._selectColor3 == null) break;
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 5, n3 + n5 - 2, n4 + n6 - 5);
                    n15 = 0;
                    n16 = 0;
                    while (n15 < n5 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 3 - n16, n4 + n6 - 4 + n15, n3 + n5 - 4 - n16, n4 + n6 - 4 + n15);
                        ++n15;
                        n16 += 2;
                    }
                } else if (n2 == 0) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + n5 - 1, n4 + 5, n3 + n5 - 1, n4 + n6 - 5);
                    int n17 = 0;
                    int n18 = 0;
                    while (n17 < n5 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 2 - n18, n4 + 4 - n17, n3 + n5 - 3 - n18, n4 + 4 - n17);
                        ++n17;
                        n18 += 2;
                    }
                    n17 = 0;
                    n18 = 0;
                    while (n17 < n5 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 1 - n18, n4 + n6 - 4 + n17, n3 + n5 - 2 - n18, n4 + n6 - 4 + n17);
                        ++n17;
                        n18 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + n5 - 2, n4 + 6, n3 + n5 - 2, n4 + n6 - 6);
                        n17 = 0;
                        n18 = 0;
                        while (n17 < n5 / 2 + 1) {
                            graphics.drawLine(n3 + n5 - 2 - n18, n4 + 5 - n17, n3 + n5 - 3 - n18, n4 + 5 - n17);
                            ++n17;
                            n18 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 5, n3 + n5 - 2, n4 + n6 - 5);
                    n17 = 0;
                    n18 = 0;
                    while (n17 < n5 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 3 - n18, n4 + n6 - 4 + n17, n3 + n5 - 4 - n18, n4 + n6 - 4 + n17);
                        ++n17;
                        n18 += 2;
                    }
                } else if (n2 == this._tabPane.getSelectedIndex() - 1) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + n5 - 1, n4 + 5, n3 + n5 - 1, n4 + n6 - 5);
                    int n19 = 0;
                    int n20 = 0;
                    while (n19 < 4) {
                        graphics.drawLine(n3 + n5 - 2 - n20, n4 + 4 - n19, n3 + n5 - 3 - n20, n4 + 4 - n19);
                        ++n19;
                        n20 += 2;
                    }
                    n19 = 0;
                    n20 = 0;
                    while (n19 < 5) {
                        graphics.drawLine(n3 + n5 - 1 - n20, n4 + n6 - 4 + n19, n3 + n5 - 2 - n20, n4 + n6 - 4 + n19);
                        ++n19;
                        n20 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + n5 - 2, n4 + 6, n3 + n5 - 2, n4 + n6 - 6);
                        n19 = 0;
                        n20 = 0;
                        while (n19 < 4) {
                            graphics.drawLine(n3 + n5 - 2 - n20, n4 + 5 - n19, n3 + n5 - 3 - n20, n4 + 5 - n19);
                            ++n19;
                            n20 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 5, n3 + n5 - 2, n4 + n6 - 5);
                    n19 = 0;
                    n20 = 0;
                    while (n19 < 5) {
                        graphics.drawLine(n3 + n5 - 3 - n20, n4 + n6 - 4 + n19, n3 + n5 - 4 - n20, n4 + n6 - 4 + n19);
                        ++n19;
                        n20 += 2;
                    }
                } else {
                    if (n2 == this._tabPane.getSelectedIndex() - 1) break;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + n5 - 1, n4 + 5, n3 + n5 - 1, n4 + n6 - 5);
                    int n21 = 0;
                    int n22 = 0;
                    while (n21 < 4) {
                        graphics.drawLine(n3 + n5 - 2 - n22, n4 + 4 - n21, n3 + n5 - 3 - n22, n4 + 4 - n21);
                        ++n21;
                        n22 += 2;
                    }
                    n21 = 0;
                    n22 = 0;
                    while (n21 < n5 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 1 - n22, n4 + n6 - 4 + n21, n3 + n5 - 2 - n22, n4 + n6 - 4 + n21);
                        ++n21;
                        n22 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + n5 - 2, n4 + 6, n3 + n5 - 2, n4 + n6 - 6);
                        n21 = 0;
                        n22 = 0;
                        while (n21 < 4) {
                            graphics.drawLine(n3 + n5 - 2 - n22, n4 + 5 - n21, n3 + n5 - 3 - n22, n4 + 5 - n21);
                            ++n21;
                            n22 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 5, n3 + n5 - 2, n4 + n6 - 5);
                    n21 = 0;
                    n22 = 0;
                    while (n21 < n5 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 3 - n22, n4 + n6 - 4 + n21, n3 + n5 - 4 - n22, n4 + n6 - 4 + n21);
                        ++n21;
                        n22 += 2;
                    }
                }
                break;
            }
            case 3: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3 + 5, n4 + n6 - 1, n3 + n5 - 5, n4 + n6 - 1);
                    int n23 = 0;
                    int n24 = 0;
                    while (n23 < n6 / 2 + 1) {
                        graphics.drawLine(n3 + 4 - n23, n4 + n6 - 2 - n24, n3 + 4 - n23, n4 + n6 - 3 - n24);
                        ++n23;
                        n24 += 2;
                    }
                    n23 = 0;
                    n24 = 0;
                    while (n23 < n6 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 4 - 1 + n23, n4 + n6 - 1 - n24, n3 + n5 - 4 - 1 + n23, n4 + n6 - 2 - n24);
                        ++n23;
                        n24 += 2;
                    }
                    if (this._selectColor2 != null) {
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n3 + 5, n4 + n6 - 3, n3 + 5, n4 + n6 - 3);
                        n23 = 0;
                        n24 = 0;
                        while (n23 < n6 / 2 + 1) {
                            graphics.drawLine(n3 + 4 - n23, n4 + n6 - 4 - n24, n3 + 4 - n23, n4 + n6 - 5 - n24);
                            ++n23;
                            n24 += 2;
                        }
                    }
                    if (this._selectColor3 == null) break;
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n3 + 5, n4 + n6 - 2, n3 + n5 - 6, n4 + n6 - 2);
                    n23 = 0;
                    n24 = 0;
                    while (n23 < n6 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 5 + n23, n4 + n6 - 3 - n24, n3 + n5 - 5 + n23, n4 + n6 - 4 - n24);
                        ++n23;
                        n24 += 2;
                    }
                } else if (bl2 && n2 == 0 || !bl2 && n2 == this._tabPane.getTabCount() - 1) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + 5, n4 + n6 - 1, n3 + n5 - 5, n4 + n6 - 1);
                    int n25 = 0;
                    int n26 = 0;
                    while (n25 < n6 / 2 + 1) {
                        graphics.drawLine(n3 + 4 - n25, n4 + n6 - 2 - n26, n3 + 4 - n25, n4 + n6 - 3 - n26);
                        ++n25;
                        n26 += 2;
                    }
                    n25 = 0;
                    n26 = 0;
                    while (n25 < n6 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 4 - 1 + n25, n4 + n6 - 1 - n26, n3 + n5 - 4 - 1 + n25, n4 + n6 - 2 - n26);
                        ++n25;
                        n26 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        n25 = 0;
                        n26 = 0;
                        while (n25 < n6 / 2 + 1) {
                            graphics.drawLine(n3 + 5 - n25, n4 + n6 - 2 - n26, n3 + 5 - n25, n4 + n6 - 3 - n26);
                            ++n25;
                            n26 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + n5 - 6, n4 + n6 - 2, n3 + n5 - 6, n4 + n6 - 2);
                    n25 = 0;
                    n26 = 0;
                    while (n25 < n6 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 5 + n25, n4 + n6 - 3 - n26, n3 + n5 - 5 + n25, n4 + n6 - 4 - n26);
                        ++n25;
                        n26 += 2;
                    }
                } else if (n2 == this._tabPane.getSelectedIndex() + (bl2 ? -1 : 1)) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + 5, n4 + n6 - 1, n3 + n5 - 6, n4 + n6 - 1);
                    int n27 = 0;
                    int n28 = 0;
                    while (n27 < 5) {
                        graphics.drawLine(n3 + 4 - n27, n4 + n6 - 2 - n28, n3 + 4 - n27, n4 + n6 - 3 - n28);
                        ++n27;
                        n28 += 2;
                    }
                    n27 = 0;
                    n28 = 0;
                    while (n27 < 5) {
                        graphics.drawLine(n3 + n5 - 5 + n27, n4 + n6 - 1 - n28, n3 + n5 - 5 + n27, n4 + n6 - 2 - n28);
                        ++n27;
                        n28 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        n27 = 0;
                        n28 = 0;
                        while (n27 < 5) {
                            graphics.drawLine(n3 + 5 - n27, n4 + n6 - 2 - n28, n3 + 5 - n27, n4 + n6 - 3 - n28);
                            ++n27;
                            n28 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + n5 - 6, n4 + n6 - 2, n3 + n5 - 6, n4 + n6 - 2);
                    n27 = 0;
                    n28 = 0;
                    while (n27 < 5) {
                        graphics.drawLine(n3 + n5 - 5 + n27, n4 + n6 - 3 - n28, n3 + n5 - 5 + n27, n4 + n6 - 4 - n28);
                        ++n27;
                        n28 += 2;
                    }
                } else {
                    if (n2 == this._tabPane.getSelectedIndex() + (bl2 ? -1 : 1)) break;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + 5, n4 + n6 - 1, n3 + n5 - 6, n4 + n6 - 1);
                    int n29 = 0;
                    int n30 = 0;
                    while (n29 < 5) {
                        graphics.drawLine(n3 + 4 - n29, n4 + n6 - 2 - n30, n3 + 4 - n29, n4 + n6 - 3 - n30);
                        ++n29;
                        n30 += 2;
                    }
                    n29 = 0;
                    n30 = 0;
                    while (n29 < n6 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 5 + n29, n4 + n6 - 1 - n30, n3 + n5 - 5 + n29, n4 + n6 - 2 - n30);
                        ++n29;
                        n30 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        n29 = 0;
                        n30 = 0;
                        while (n29 < 5) {
                            graphics.drawLine(n3 + 5 - n29, n4 + n6 - 2 - n30, n3 + 5 - n29, n4 + n6 - 3 - n30);
                            ++n29;
                            n30 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + n5 - 6, n4 + n6 - 2, n3 + n5 - 6, n4 + n6 - 2);
                    n29 = 0;
                    n30 = 0;
                    while (n29 < n6 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 5 + n29, n4 + n6 - 3 - n30, n3 + n5 - 5 + n29, n4 + n6 - 4 - n30);
                        ++n29;
                        n30 += 2;
                    }
                }
                break;
            }
            default: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3 + 5, n4, n3 + n5 - 5, n4);
                    int n31 = 0;
                    int n32 = 0;
                    while (n31 < n6 / 2 + 1) {
                        graphics.drawLine(n3 + 4 - n31, n4 + 1 + n32, n3 + 4 - n31, n4 + 2 + n32);
                        ++n31;
                        n32 += 2;
                    }
                    n31 = 0;
                    n32 = 0;
                    while (n31 < n6 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 4 - 1 + n31, n4 + n32, n3 + n5 - 4 - 1 + n31, n4 + 1 + n32);
                        ++n31;
                        n32 += 2;
                    }
                    if (this._selectColor2 != null) {
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n3 + 6, n4 + 1, n3 + n5 - 7, n4 + 1);
                        n31 = 0;
                        n32 = 0;
                        while (n31 < n6 / 2 + 1) {
                            graphics.drawLine(n3 + 5 - n31, n4 + 1 + n32, n3 + 5 - n31, n4 + 2 + n32);
                            ++n31;
                            n32 += 2;
                        }
                    }
                    if (this._selectColor3 == null) break;
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n3 + n5 - 6, n4 + 1, n3 + n5 - 6, n4 + 1);
                    n31 = 0;
                    n32 = 0;
                    while (n31 < n6 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 5 + n31, n4 + 2 + n32, n3 + n5 - 5 + n31, n4 + 3 + n32);
                        ++n31;
                        n32 += 2;
                    }
                } else if (bl2 && n2 == 0 || !bl2 && n2 == this._tabPane.getTabCount() - 1) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + 5, n4, n3 + n5 - 5, n4);
                    int n33 = 0;
                    int n34 = 0;
                    while (n33 < n6 / 2 + 1) {
                        graphics.drawLine(n3 + 4 - n33, n4 + 1 + n34, n3 + 4 - n33, n4 + 2 + n34);
                        ++n33;
                        n34 += 2;
                    }
                    n33 = 0;
                    n34 = 0;
                    while (n33 < n6 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 4 - 1 + n33, n4 + n34, n3 + n5 - 4 - 1 + n33, n4 + 1 + n34);
                        ++n33;
                        n34 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + 6, n4 + 1, n3 + n5 - 7, n4 + 1);
                        n33 = 0;
                        n34 = 0;
                        while (n33 < n6 / 2 + 1) {
                            graphics.drawLine(n3 + 5 - n33, n4 + 1 + n34, n3 + 5 - n33, n4 + 2 + n34);
                            ++n33;
                            n34 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + n5 - 6, n4 + 1, n3 + n5 - 6, n4 + 1);
                    n33 = 0;
                    n34 = 0;
                    while (n33 < n6 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 5 + n33, n4 + 2 + n34, n3 + n5 - 5 + n33, n4 + 3 + n34);
                        ++n33;
                        n34 += 2;
                    }
                } else if (n2 == this._tabPane.getSelectedIndex() + (bl2 ? -1 : 1)) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + 5, n4, n3 + n5 - 5, n4);
                    int n35 = 0;
                    int n36 = 0;
                    while (n35 < 5) {
                        graphics.drawLine(n3 + 4 - n35, n4 + 1 + n36, n3 + 4 - n35, n4 + 2 + n36);
                        ++n35;
                        n36 += 2;
                    }
                    n35 = 0;
                    n36 = 0;
                    while (n35 < 5) {
                        graphics.drawLine(n3 + n5 - 4 - 1 + n35, n4 + n36, n3 + n5 - 4 - 1 + n35, n4 + 1 + n36);
                        ++n35;
                        n36 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + 6, n4 + 1, n3 + n5 - 7, n4 + 1);
                        n35 = 0;
                        n36 = 0;
                        while (n35 < 5) {
                            graphics.drawLine(n3 + 5 - n35, n4 + 1 + n36, n3 + 5 - n35, n4 + 2 + n36);
                            ++n35;
                            n36 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + n5 - 6, n4 + 1, n3 + n5 - 6, n4 + 1);
                    n35 = 0;
                    n36 = 0;
                    while (n35 < 5) {
                        graphics.drawLine(n3 + n5 - 5 + n35, n4 + 2 + n36, n3 + n5 - 5 + n35, n4 + 3 + n36);
                        ++n35;
                        n36 += 2;
                    }
                } else {
                    if (n2 == this._tabPane.getSelectedIndex() + (bl2 ? -1 : 1)) break;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + 5, n4, n3 + n5 - 5, n4);
                    int n37 = 0;
                    int n38 = 0;
                    while (n37 < 5) {
                        graphics.drawLine(n3 + 4 - n37, n4 + 1 + n38, n3 + 4 - n37, n4 + 2 + n38);
                        ++n37;
                        n38 += 2;
                    }
                    n37 = 0;
                    n38 = 0;
                    while (n37 < n6 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 4 - 1 + n37, n4 + n38, n3 + n5 - 4 - 1 + n37, n4 + 1 + n38);
                        ++n37;
                        n38 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + 6, n4 + 1, n3 + n5 - 7, n4 + 1);
                        n37 = 0;
                        n38 = 0;
                        while (n37 < 5) {
                            graphics.drawLine(n3 + 5 - n37, n4 + 1 + n38, n3 + 5 - n37, n4 + 2 + n38);
                            ++n37;
                            n38 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + n5 - 6, n4 + 1, n3 + n5 - 6, n4 + 1);
                    n37 = 0;
                    n38 = 0;
                    while (n37 < n6 / 2 + 1) {
                        graphics.drawLine(n3 + n5 - 5 + n37, n4 + 2 + n38, n3 + n5 - 5 + n37, n4 + 3 + n38);
                        ++n37;
                        n38 += 2;
                    }
                }
                break;
            }
        }
    }

    protected void paintWindowsTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = this.getColorTheme();
        switch (n) {
            case 2: {
                if (n7 == 2 || n7 == 1) {
                    if (bl) {
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n3 - 2, n4 + 1, n3 - 2, n4 + n6 - 1);
                        graphics.drawLine(n3 - 1, n4, n3 - 1, n4);
                        graphics.drawLine(n3, n4 - 1, n3 + n5 - 1, n4 - 1);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n3 - 1, n4 + n6, n3 - 1, n4 + n6);
                        graphics.drawLine(n3, n4 + n6 + 1, n3, n4 + n6 + 1);
                        graphics.drawLine(n3 + 1, n4 + n6, n3 + n5 - 1, n4 + n6);
                        graphics.setColor(this._selectColor3);
                        graphics.drawLine(n3, n4 + n6, n3, n4 + n6);
                        graphics.drawLine(n3 + 1, n4 + n6 + 1, n3 + n5 - 1, n4 + n6 + 1);
                        break;
                    }
                    if (n2 > this._tabPane.getSelectedIndex()) {
                        graphics.setColor(this._unselectColor1);
                        graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 3);
                        graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                        graphics.drawLine(n3 + 2, n4, n3 + n5 - 1, n4);
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + 1, n4 + n6 - 2);
                        graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + 2, n4 + n6 - 1);
                        graphics.drawLine(n3 + 3, n4 + n6 - 2, n3 + n5 - 1, n4 + n6 - 2);
                        graphics.setColor(this._unselectColor3);
                        graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + 2, n4 + n6 - 2);
                        graphics.drawLine(n3 + 3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
                        break;
                    }
                    if (n2 >= this._tabPane.getSelectedIndex()) break;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3, n4 + 3, n3, n4 + n6 - 2);
                    graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + 2);
                    graphics.drawLine(n3 + 2, n4 + 1, n3 + n5 - 1, n4 + 1);
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n3 + 1, n4 + n6 - 1, n3 + 1, n4 + n6 - 1);
                    graphics.drawLine(n3 + 2, n4 + n6, n3 + 2, n4 + n6);
                    graphics.drawLine(n3 + 3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + 2, n4 + n6 - 1);
                    graphics.drawLine(n3 + 3, n4 + n6, n3 + n5 - 1, n4 + n6);
                    break;
                }
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3 - 2, n4 + 1, n3 - 2, n4 + n6 - 1);
                    graphics.drawLine(n3 - 1, n4, n3 - 1, n4);
                    graphics.drawLine(n3, n4 - 1, n3, n4 - 1);
                    graphics.drawLine(n3 - 1, n4 + n6, n3 - 1, n4 + n6);
                    graphics.drawLine(n3, n4 + n6 + 1, n3, n4 + n6 + 1);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 - 1, n4 + 1, n3 - 1, n4 + n6 - 1);
                    graphics.drawLine(n3, n4, n3, n4 + n6);
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n3 + 1, n4 - 2, n3 + n5 - 1, n4 - 2);
                    graphics.drawLine(n3 + 1, n4 + n6 + 2, n3 + n5 - 1, n4 + n6 + 2);
                    break;
                }
                if (n2 > this._tabPane.getSelectedIndex()) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 4);
                    graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                    graphics.drawLine(n3 + 2, n4, n3 + n5 - 1, n4);
                    graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + 1, n4 + n6 - 3);
                    graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + n5 - 1, n4 + n6 - 2);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex()) break;
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n3, n4 + 4, n3, n4 + n6 - 2);
                graphics.drawLine(n3 + 1, n4 + 3, n3 + 1, n4 + 3);
                graphics.drawLine(n3 + 2, n4 + 2, n3 + n5 - 1, n4 + 2);
                graphics.drawLine(n3 + 1, n4 + n6 - 1, n3 + 1, n4 + n6 - 1);
                graphics.drawLine(n3 + 2, n4 + n6, n3 + n5 - 1, n4 + n6);
                break;
            }
            case 4: {
                if (n7 == 2 || n7 == 1) {
                    if (bl) {
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n3 + n5 - 1, n4 - 1, n3, n4 - 1);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n3 + n5, n4 + 1, n3 + n5, n4 + n6 - 1);
                        graphics.drawLine(n3 + n5 - 1, n4 + n6, n3, n4 + n6);
                        graphics.setColor(this._selectColor3);
                        graphics.drawLine(n3 + n5, n4, n3 + n5, n4);
                        graphics.drawLine(n3 + n5 + 1, n4 + 1, n3 + n5 + 1, n4 + n6 - 1);
                        graphics.drawLine(n3 + n5, n4 + n6, n3 + n5, n4 + n6);
                        graphics.drawLine(n3 + n5 - 1, n4 + n6 + 1, n3, n4 + n6 + 1);
                        break;
                    }
                    if (n2 > this._tabPane.getSelectedIndex()) {
                        graphics.setColor(this._unselectColor1);
                        graphics.drawLine(n3 + n5 - 3, n4, n3, n4);
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 3);
                        graphics.drawLine(n3 + n5 - 3, n4 + n6 - 2, n3, n4 + n6 - 2);
                        graphics.setColor(this._unselectColor3);
                        graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                        graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 3);
                        graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                        graphics.drawLine(n3 + n5 - 3, n4 + n6 - 1, n3, n4 + n6 - 1);
                        break;
                    }
                    if (n2 >= this._tabPane.getSelectedIndex()) break;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + n5 - 3, n4 + 1, n3, n4 + 1);
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n3 + n5 - 2, n4 + 3, n3 + n5 - 2, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 3, n4 + n6 - 1, n3, n4 + n6 - 1);
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + 2);
                    graphics.drawLine(n3 + n5 - 1, n4 + 3, n3 + n5 - 1, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5 - 3, n4 + n6, n3, n4 + n6);
                    break;
                }
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3 + n5 + 1, n4 + 1, n3 + n5 + 1, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5, n4, n3 + n5, n4);
                    graphics.drawLine(n3 + n5 - 1, n4 - 1, n3 + n5 - 1, n4 - 1);
                    graphics.drawLine(n3 + n5, n4 + n6, n3 + n5, n4 + n6);
                    graphics.drawLine(n3 + n5 - 1, n4 + n6 + 1, n3 + n5 - 1, n4 + n6 + 1);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + n5, n4 + 1, n3 + n5, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6);
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n3 + n5 - 2, n4 - 2, n3, n4 - 2);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 + 2, n3, n4 + n6 + 2);
                    break;
                }
                if (n2 > this._tabPane.getSelectedIndex()) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 4);
                    graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 3, n3 + n5 - 2, n4 + n6 - 3);
                    graphics.drawLine(n3 + n5 - 3, n4, n3, n4);
                    graphics.drawLine(n3 + n5 - 3, n4 + n6 - 2, n3, n4 + n6 - 2);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex()) break;
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n3 + n5 - 1, n4 + 4, n3 + n5 - 1, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 2, n4 + 3, n3 + n5 - 2, n4 + 3);
                graphics.drawLine(n3 + n5 - 3, n4 + 2, n3, n4 + 2);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
                graphics.drawLine(n3 + n5 - 3, n4 + n6, n3, n4 + n6);
                break;
            }
            case 3: {
                if (n7 == 2 || n7 == 1) {
                    if (bl) {
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n3, n4 + n6, n3, n4 + n6);
                        graphics.drawLine(n3 - 1, n4 + n6 - 1, n3 - 1, n4);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n3 + 1, n4 + n6, n3 + n5 - 2, n4 + n6);
                        graphics.drawLine(n3 + n5 - 1, n4 + n6 - 1, n3 + n5 - 1, n4 - 1);
                        graphics.setColor(this._selectColor3);
                        graphics.drawLine(n3 + 1, n4 + n6 + 1, n3 + n5 - 2, n4 + n6 + 1);
                        graphics.drawLine(n3 + n5 - 1, n4 + n6, n3 + n5 - 1, n4 + n6);
                        graphics.drawLine(n3 + n5, n4 + n6 - 1, n3 + n5, n4 - 1);
                        break;
                    }
                    if (n2 > this._tabPane.getSelectedIndex()) {
                        graphics.setColor(this._unselectColor1);
                        graphics.drawLine(n3, n4 + n6 - 2, n3, n4 + n6 - 2);
                        graphics.drawLine(n3 - 1, n4 + n6 - 3, n3 - 1, n4);
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + n5 - 4, n4 + n6 - 2);
                        graphics.drawLine(n3 + n5 - 3, n4 + n6 - 3, n3 + n5 - 3, n4 - 1);
                        graphics.setColor(this._unselectColor3);
                        graphics.drawLine(n3 + 1, n4 + n6 - 1, n3 + n5 - 4, n4 + n6 - 1);
                        graphics.drawLine(n3 + n5 - 3, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 2);
                        graphics.drawLine(n3 + n5 - 2, n4 + n6 - 3, n3 + n5 - 2, n4 - 1);
                        break;
                    }
                    if (n2 >= this._tabPane.getSelectedIndex()) break;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + 2, n4 + n6 - 2);
                    graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + 1, n4);
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n3 + 3, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 1, n4 + n6 - 3, n3 + n5 - 1, n4);
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + 3, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5 - 1, n4 + n6 - 2, n3 + n5 - 1, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5, n4 + n6 - 3, n3 + n5, n4);
                    break;
                }
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3 + 1, n4 + n6 + 1, n3 + n5, n4 + n6 + 1);
                    graphics.drawLine(n3, n4 + n6, n3, n4 + n6);
                    graphics.drawLine(n3 - 1, n4 + n6 - 1, n3 - 1, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5 + 1, n4 + n6, n3 + n5 + 1, n4 + n6);
                    graphics.drawLine(n3 + n5 + 2, n4 + n6 - 1, n3 + n5 + 2, n4 + n6 - 1);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + 1, n4 + n6, n3 + n5, n4 + n6);
                    graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 + 1, n4 + n6 - 1);
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n3 - 1, n4 + n6 - 2, n3 - 1, n4);
                    graphics.drawLine(n3 + n5 + 2, n4 + n6 - 2, n3 + n5 + 2, n4);
                    break;
                }
                if (n2 > this._tabPane.getSelectedIndex()) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + 3, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 1, n4 + n6 - 3, n3 + n5 - 1, n4 - 1);
                    graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + 2, n4 + n6 - 2);
                    graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + 1, n4);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex()) break;
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n3 + 3, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 1, n4 + n6 - 3, n3 + n5 - 1, n4 - 1);
                graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + 2, n4 + n6 - 2);
                graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + 1, n4);
                break;
            }
            default: {
                if (n7 == 2 || n7 == 1) {
                    if (bl) {
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n3, n4 - 1, n3, n4 - 1);
                        graphics.drawLine(n3 - 1, n4, n3 - 1, n4 + n6 - 1);
                        graphics.drawLine(n3 + 1, n4 - 2, n3 + n5 + 1, n4 - 2);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n3 + n5 + 2, n4 - 1, n3 + n5 + 2, n4 + n6 - 1);
                        graphics.setColor(this._selectColor3);
                        graphics.drawLine(n3 + n5 + 2, n4 - 1, n3 + n5 + 2, n4 - 1);
                        graphics.drawLine(n3 + n5 + 3, n4, n3 + n5 + 3, n4 + n6 - 1);
                        break;
                    }
                    if (n2 > this._tabPane.getSelectedIndex()) {
                        graphics.setColor(this._unselectColor1);
                        graphics.drawLine(n3 + 2, n4 + 1, n3 + 2, n4 + 1);
                        graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + n6 - 1);
                        graphics.drawLine(n3 + 3, n4, n3 + n5 - 2, n4);
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + n5 - 1, n4 + 1, n3 + n5 - 1, n4 + n6 - 1);
                        graphics.setColor(this._unselectColor3);
                        graphics.drawLine(n3 + n5 - 1, n4 + 1, n3 + n5 - 1, n4 + 1);
                        graphics.drawLine(n3 + n5, n4 + 2, n3 + n5, n4 + n6 - 1);
                        break;
                    }
                    if (n2 >= this._tabPane.getSelectedIndex()) break;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + 2, n4 + 1, n3 + 2, n4 + 1);
                    graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + n6 - 1);
                    graphics.drawLine(n3 + 3, n4, n3 + n5 - 2, n4);
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n3 + n5 - 1, n4 + 1, n3 + n5 - 1, n4 + n6 - 1);
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n3 + n5 - 1, n4 + 1, n3 + n5 - 1, n4 + 1);
                    graphics.drawLine(n3 + n5, n4 + 2, n3 + n5, n4 + n6 - 1);
                    break;
                }
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3 + 1, n4 - 2, n3 + n5, n4 - 2);
                    graphics.drawLine(n3, n4 - 1, n3, n4 - 1);
                    graphics.drawLine(n3 - 1, n4, n3 - 1, n4);
                    graphics.drawLine(n3 + n5 + 1, n4 - 1, n3 + n5 + 1, n4 - 1);
                    graphics.drawLine(n3 + n5 + 2, n4, n3 + n5 + 2, n4);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + 1, n4 - 1, n3 + n5, n4 - 1);
                    graphics.drawLine(n3, n4, n3 + n5 + 1, n4);
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n3 - 1, n4 + 1, n3 - 1, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5 + 2, n4 + 1, n3 + n5 + 2, n4 + n6 - 1);
                    break;
                }
                if (n2 > this._tabPane.getSelectedIndex()) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + n6 - 1);
                    graphics.drawLine(n3 + 2, n4 + 1, n3 + 2, n4 + 1);
                    graphics.drawLine(n3 + 3, n4, n3 + n5 - 3, n4);
                    graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                    graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 1);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex()) break;
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + n6 - 1);
                graphics.drawLine(n3 + 2, n4 + 1, n3 + 2, n4 + 1);
                graphics.drawLine(n3 + 3, n4, n3 + n5 - 3, n4);
                graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 1);
            }
        }
    }

    protected void paintTabBorderMouseOver(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (this.getTabShape() == 1) {
            switch (n) {
                case 2: {
                    if (n2 > this._tabPane.getSelectedIndex()) {
                        n4 -= 2;
                    }
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3, n4 + 4, n3, n4 + n6 - 2);
                    graphics.drawLine(n3 + 1, n4 + 3, n3 + 1, n4 + 3);
                    graphics.drawLine(n3 + 2, n4 + 2, n3 + 2, n4 + 2);
                    graphics.drawLine(n3 + 1, n4 + n6 - 1, n3 + 1, n4 + n6 - 1);
                    graphics.drawLine(n3 + 2, n4 + n6, n3 + 2, n4 + n6);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + 1, n4 + 4, n3 + 1, n4 + n6 - 2);
                    graphics.drawLine(n3 + 2, n4 + 3, n3 + 2, n4 + n6 - 1);
                    break;
                }
                case 4: {
                    if (n2 > this._tabPane.getSelectedIndex()) {
                        n4 -= 2;
                    }
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3 + n5 - 1, n4 + 4, n3 + n5 - 1, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 2, n4 + 3, n3 + n5 - 2, n4 + 3);
                    graphics.drawLine(n3 + n5 - 3, n4 + 2, n3 + n5 - 3, n4 + 2);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5 - 3, n4 + n6, n3 + n5 - 3, n4 + n6);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + n5 - 2, n4 + 4, n3 + n5 - 2, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 3, n4 + 3, n3 + n5 - 3, n4 + n6 - 1);
                    break;
                }
                case 3: {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3 + 3, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                    graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + 2, n4 + n6 - 2);
                    graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + 1, n4 + n6 - 3);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 1, n4 + n6 - 3, n3 + n5 - 1, n4 + n6 - 3);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + 3, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 2);
                    graphics.drawLine(n3 + 2, n4 + n6 - 3, n3 + n5 - 2, n4 + n6 - 3);
                    break;
                }
                default: {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3 + 3, n4, n3 + n5 - 3, n4);
                    graphics.drawLine(n3 + 2, n4 + 1, n3 + 2, n4 + 1);
                    graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + 2);
                    graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                    graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + 2);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + 3, n4 + 1, n3 + n5 - 3, n4 + 1);
                    graphics.drawLine(n3 + 2, n4 + 2, n3 + n5 - 2, n4 + 2);
                    break;
                }
            }
        } else if (this.getTabShape() == 11) {
            switch (n) {
                case 2: {
                    if (this.getColorTheme() == 4) {
                        if (n2 > this._tabPane.getSelectedIndex()) {
                            n4 -= 2;
                        }
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n3, n4 + 4, n3, n4 + n6 - 2);
                        graphics.drawLine(n3 + 1, n4 + 3, n3 + 1, n4 + 3);
                        graphics.drawLine(n3 + 2, n4 + 2, n3 + 2, n4 + 2);
                        graphics.drawLine(n3 + 1, n4 + n6 - 1, n3 + 1, n4 + n6 - 1);
                        graphics.drawLine(n3 + 2, n4 + n6, n3 + 2, n4 + n6);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n3 + 1, n4 + 4, n3 + 1, n4 + n6 - 2);
                        graphics.drawLine(n3 + 2, n4 + 3, n3 + 2, n4 + n6 - 1);
                        graphics.setColor(this._selectColor3);
                        graphics.drawLine(n3 + 3, n4 + 2, n3 + n5 - 1, n4 + 2);
                        graphics.drawLine(n3 + 3, n4 + n6, n3 + n5 - 1, n4 + n6);
                        break;
                    }
                    if (n2 > this._tabPane.getSelectedIndex()) {
                        --n4;
                    }
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3, n4 + 3, n3, n4 + n6 - 2);
                    graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + 2);
                    graphics.drawLine(n3 + 2, n4 + 1, n3 + n5 - 1, n4 + 1);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + 1, n4 + n6 - 1, n3 + 1, n4 + n6 - 1);
                    graphics.drawLine(n3 + 2, n4 + n6, n3 + 2, n4 + n6);
                    graphics.drawLine(n3 + 3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + 2, n4 + n6 - 1);
                    graphics.drawLine(n3 + 3, n4 + n6, n3 + n5 - 1, n4 + n6);
                    break;
                }
                case 4: {
                    if (this.getColorTheme() == 4) {
                        if (n2 > this._tabPane.getSelectedIndex()) {
                            n4 -= 2;
                        }
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n3 + n5 - 1, n4 + 4, n3 + n5 - 1, n4 + n6 - 2);
                        graphics.drawLine(n3 + n5 - 2, n4 + 3, n3 + n5 - 2, n4 + 3);
                        graphics.drawLine(n3 + n5 - 3, n4 + 2, n3 + n5 - 3, n4 + 2);
                        graphics.drawLine(n3 + n5 - 2, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
                        graphics.drawLine(n3 + n5 - 3, n4 + n6, n3 + n5 - 3, n4 + n6);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n3 + n5 - 2, n4 + 4, n3 + n5 - 2, n4 + n6 - 2);
                        graphics.drawLine(n3 + n5 - 3, n4 + 3, n3 + n5 - 3, n4 + n6 - 1);
                        graphics.setColor(this._selectColor3);
                        graphics.drawLine(n3 + n5 - 4, n4 + 2, n3, n4 + 2);
                        graphics.drawLine(n3 + n5 - 4, n4 + n6, n3, n4 + n6);
                        break;
                    }
                    if (n2 > this._tabPane.getSelectedIndex()) {
                        --n4;
                    }
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n3 + n5 - 1, n4 + 3, n3 + n5 - 1, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5 - 3, n4 + n6, n3, n4 + n6);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + n5 - 2, n4 + 3, n3 + n5 - 2, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 3, n4 + n6 - 1, n3, n4 + n6 - 1);
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + 2);
                    graphics.drawLine(n3 + n5 - 3, n4 + 1, n3, n4 + 1);
                    break;
                }
                case 3: {
                    if (this.getColorTheme() == 4) {
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n3 + 3, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                        graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + 2, n4 + n6 - 2);
                        graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + 1, n4 + n6 - 3);
                        graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                        graphics.drawLine(n3 + n5 - 1, n4 + n6 - 3, n3 + n5 - 1, n4 + n6 - 3);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n3 + 3, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 2);
                        graphics.drawLine(n3 + 2, n4 + n6 - 3, n3 + n5 - 2, n4 + n6 - 3);
                        graphics.setColor(this._selectColor3);
                        graphics.drawLine(n3 + 1, n4, n3 + 1, n4 + n6 - 4);
                        graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 4);
                        break;
                    }
                    if (n2 > this._tabPane.getSelectedIndex()) {
                        n3 -= 2;
                    }
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n3 + 3, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5 - 1, n4 + n6 - 2, n3 + n5 - 1, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5, n4 + n6 - 3, n3 + n5, n4);
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + 2, n4 + n6 - 2);
                    graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + 1, n4);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + 3, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 1, n4 + n6 - 3, n3 + n5 - 1, n4);
                    break;
                }
                default: {
                    if (this.getColorTheme() == 4) {
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n3 + 3, n4, n3 + n5 - 3, n4);
                        graphics.drawLine(n3 + 2, n4 + 1, n3 + 2, n4 + 1);
                        graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + 2);
                        graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                        graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + 2);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n3 + 3, n4 + 1, n3 + n5 - 3, n4 + 1);
                        graphics.drawLine(n3 + 2, n4 + 2, n3 + n5 - 2, n4 + 2);
                        graphics.setColor(this._selectColor3);
                        graphics.drawLine(n3 + 1, n4 + 3, n3 + 1, n4 + n6 - 1);
                        graphics.drawLine(n3 + n5 - 1, n4 + 3, n3 + n5 - 1, n4 + n6 - 1);
                        break;
                    }
                    if (n2 > this._tabPane.getSelectedIndex()) {
                        --n3;
                    }
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3 + 2, n4 + 1, n3 + 2, n4 + 1);
                    graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + n6 - 1);
                    graphics.drawLine(n3 + 3, n4, n3 + n5 - 2, n4);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + n5 - 1, n4 + 1, n3 + n5 - 1, n4 + n6 - 1);
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n3 + n5 - 1, n4 + 1, n3 + n5 - 1, n4 + 1);
                    graphics.drawLine(n3 + n5, n4 + 2, n3 + n5, n4 + n6 - 1);
                }
            }
        }
    }

    protected void paintVsnetTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (n) {
            case 2: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3, n4, n3 + n5 - 1, n4);
                    graphics.drawLine(n3, n4, n3, n4 + n6 - 2);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (n2 > this._tabPane.getSelectedIndex()) {
                    graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex() || n2 == 0) break;
                graphics.drawLine(n3 + 2, n4, n3 + n5 - 2, n4);
                break;
            }
            case 4: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3, n4, n3 + n5 - 1, n4);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 2);
                    graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (n2 > this._tabPane.getSelectedIndex()) {
                    graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 2);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex() || n2 == 0) break;
                graphics.drawLine(n3 + 1, n4, n3 + n5 - 3, n4);
                break;
            }
            case 3: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3, n4, n3, n4 + n6 - 1);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 2);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (bl2) {
                    if (n2 > this._tabPane.getSelectedIndex()) {
                        graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 2);
                        break;
                    }
                    if (n2 >= this._tabPane.getSelectedIndex() || n2 == 0) break;
                    graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 2);
                    break;
                }
                if (n2 > this._tabPane.getSelectedIndex()) {
                    graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 2);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex() || n2 == this._tabPane.getTabCount() - 1) break;
                graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 2);
                break;
            }
            default: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3, n4 + 1, n3, n4 + n6 - 1);
                    graphics.drawLine(n3, n4, n3 + n5 - 1, n4);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 1);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (bl2) {
                    if (n2 > this._tabPane.getSelectedIndex()) {
                        graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 2);
                        break;
                    }
                    if (n2 >= this._tabPane.getSelectedIndex() || n2 == 0) break;
                    graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 2);
                    break;
                }
                if (n2 > this._tabPane.getSelectedIndex()) {
                    graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 2);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex() || n2 == this._tabPane.getTabCount() - 1) break;
                graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 2);
            }
        }
    }

    protected void paintRoundedVsnetTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (n) {
            case 2: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3 + 2, n4, n3 + n5 - 1, n4);
                    graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                    graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 3);
                    graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + 1, n4 + n6 - 2);
                    graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (n2 > this._tabPane.getSelectedIndex()) {
                    graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex() || n2 == 0) break;
                graphics.drawLine(n3 + 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                break;
            }
            case 4: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3, n4, n3 + n5 - 3, n4);
                    graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                    graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 3);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                    graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (n2 > this._tabPane.getSelectedIndex()) {
                    graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 2);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex() || n2 == 0) break;
                graphics.drawLine(n3 + 1, n4 + 1, n3 + n5 - 3, n4 + 1);
                break;
            }
            case 3: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3, n4, n3, n4 + n6 - 3);
                    graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + 1, n4 + n6 - 2);
                    graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 3);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (bl2) {
                    if (n2 > this._tabPane.getSelectedIndex()) {
                        graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 2);
                        break;
                    }
                    if (n2 >= this._tabPane.getSelectedIndex() || n2 == 0) break;
                    graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 2);
                    break;
                }
                if (n2 > this._tabPane.getSelectedIndex()) {
                    graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 2);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex() || n2 == this._tabPane.getTabCount() - 1) break;
                graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 2);
                break;
            }
            default: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 1);
                    graphics.drawLine(n3, n4 + 2, n3 + 2, n4);
                    graphics.drawLine(n3 + 2, n4, n3 + n5 - 3, n4);
                    graphics.drawLine(n3 + n5 - 3, n4, n3 + n5 - 1, n4 + 2);
                    graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 1);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (bl2) {
                    if (n2 > this._tabPane.getSelectedIndex()) {
                        graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 2);
                        break;
                    }
                    if (n2 >= this._tabPane.getSelectedIndex() || n2 == 0) break;
                    graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 2);
                    break;
                }
                if (n2 > this._tabPane.getSelectedIndex()) {
                    graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 2);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex() || n2 == this._tabPane.getTabCount() - 1) break;
                graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 2);
            }
        }
    }

    protected void paintFlatTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        switch (n) {
            case 2: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawRect(n3, n4, n5, n6);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (n2 > this._tabPane.getSelectedIndex()) {
                    if (n2 == this._tabPane.getTabCount() - 1) {
                        graphics.drawRect(n3, n4, n5, n6 - 1);
                        break;
                    }
                    graphics.drawRect(n3, n4, n5, n6);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex()) break;
                graphics.drawRect(n3, n4, n5, n6);
                break;
            }
            case 4: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawRect(n3 - 1, n4, n5, n6);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (n2 > this._tabPane.getSelectedIndex()) {
                    if (n2 == this._tabPane.getTabCount() - 1) {
                        graphics.drawRect(n3 - 1, n4, n5, n6 - 1);
                        break;
                    }
                    graphics.drawRect(n3 - 1, n4, n5, n6);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex()) break;
                graphics.drawRect(n3 - 1, n4, n5, n6);
                break;
            }
            case 3: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawRect(n3, n4 - 1, n5, n6);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                graphics.drawRect(n3, n4 - 1, n5, n6);
                break;
            }
            default: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawRect(n3, n4, n5, n6);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                graphics.drawRect(n3, n4, n5, n6);
            }
        }
    }

    protected void paintRoundedFlatTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        switch (n) {
            case 2: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3 + 2, n4, n3 + n5 - 1, n4);
                    graphics.drawLine(n3 + 2, n4 + n6, n3 + n5 - 1, n4 + n6);
                    graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 2);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                    graphics.drawLine(n3 + 1, n4 + n6 - 1, n3 + 1, n4 + n6 - 1);
                    break;
                }
                if (n2 > this._tabPane.getSelectedIndex()) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + 2, n4, n3 + n5 - 1, n4);
                    if (n2 == this._tabPane.getTabCount() - 1) {
                        graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
                        graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 3);
                    } else {
                        graphics.drawLine(n3 + 2, n4 + n6, n3 + n5 - 1, n4 + n6);
                        graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 2);
                    }
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                    if (n2 == this._tabPane.getTabCount() - 1) {
                        graphics.drawLine(n3, n4 + n6 - 2, n3, n4 + n6 - 2);
                        graphics.drawLine(n3 + 1, n4 + n6 - 1, n3 + 1, n4 + n6 - 1);
                        break;
                    }
                    graphics.drawLine(n3, n4 + n6 - 1, n3, n4 + n6 - 1);
                    graphics.drawLine(n3 + 1, n4 + n6, n3 + 1, n4 + n6);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex()) break;
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n3 + 2, n4, n3 + n5 - 1, n4);
                graphics.drawLine(n3 + 2, n4 + n6, n3 + n5 - 1, n4 + n6);
                graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 2);
                graphics.setColor(this._unselectColor2);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                graphics.drawLine(n3 + 1, n4 + n6 - 1, n3 + 1, n4 + n6 - 1);
                break;
            }
            case 4: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3, n4, n3 + n5 - 3, n4);
                    graphics.drawLine(n3, n4 + n6, n3 + n5 - 3, n4 + n6);
                    graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 2);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
                    break;
                }
                if (n2 > this._tabPane.getSelectedIndex()) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3, n4, n3 + n5 - 3, n4);
                    if (n2 == this._tabPane.getTabCount() - 1) {
                        graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                        graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 3);
                    } else {
                        graphics.drawLine(n3, n4 + n6, n3 + n5 - 3, n4 + n6);
                        graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 2);
                    }
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                    if (n2 == this._tabPane.getTabCount() - 1) {
                        graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                        break;
                    }
                    graphics.drawLine(n3 + n5 - 2, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex()) break;
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n3, n4, n3 + n5 - 3, n4);
                graphics.drawLine(n3, n4 + n6, n3 + n5 - 3, n4 + n6);
                graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 2);
                graphics.setColor(this._unselectColor2);
                graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
                break;
            }
            case 3: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3, n4, n3, n4 + n6 - 3);
                    graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
                    graphics.drawLine(n3 + n5, n4, n3 + n5, n4 + n6 - 3);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + 1, n4 + n6 - 2);
                    graphics.drawLine(n3 + n5 - 1, n4 + n6 - 2, n3 + n5 - 1, n4 + n6 - 2);
                    break;
                }
                if (n2 > this._tabPane.getSelectedIndex()) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3, n4, n3, n4 + n6 - 3);
                    if (n2 == this._tabPane.getTabCount() - 1) {
                        graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                        graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 3);
                    } else {
                        graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
                        graphics.drawLine(n3 + n5, n4, n3 + n5, n4 + n6 - 3);
                    }
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + 1, n4 + n6 - 2);
                    if (n2 == this._tabPane.getTabCount() - 1) {
                        graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                        break;
                    }
                    graphics.drawLine(n3 + n5 - 1, n4 + n6 - 2, n3 + n5 - 1, n4 + n6 - 2);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex()) break;
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n3, n4, n3, n4 + n6 - 3);
                graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
                graphics.drawLine(n3 + n5, n4, n3 + n5, n4 + n6 - 3);
                graphics.setColor(this._unselectColor2);
                graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + 1, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 1, n4 + n6 - 2, n3 + n5 - 1, n4 + n6 - 2);
                break;
            }
            default: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n3, n4 + n6 - 1, n3, n4 + 2);
                    graphics.drawLine(n3 + 2, n4, n3 + n5 - 2, n4);
                    graphics.drawLine(n3 + n5, n4 + 2, n3 + n5, n4 + n6 - 1);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n3, n4 + 2, n3 + 2, n4);
                    graphics.drawLine(n3 + n5 - 2, n4, n3 + n5, n4 + 2);
                    break;
                }
                if (n2 > this._tabPane.getSelectedIndex()) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3, n4 + n6 - 1, n3, n4 + 2);
                    if (n2 == this._tabPane.getTabCount() - 1) {
                        graphics.drawLine(n3 + 2, n4, n3 + n5 - 3, n4);
                        graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 1);
                    } else {
                        graphics.drawLine(n3 + 2, n4, n3 + n5 - 2, n4);
                        graphics.drawLine(n3 + n5, n4 + 2, n3 + n5, n4 + n6 - 1);
                    }
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n3, n4 + 2, n3 + 2, n4);
                    if (n2 == this._tabPane.getTabCount() - 1) {
                        graphics.drawLine(n3 + n5 - 3, n4, n3 + n5 - 1, n4 + 2);
                        break;
                    }
                    graphics.drawLine(n3 + n5 - 2, n4, n3 + n5, n4 + 2);
                    break;
                }
                if (n2 >= this._tabPane.getSelectedIndex()) break;
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n3, n4 + n6 - 1, n3, n4 + 2);
                graphics.drawLine(n3 + 2, n4, n3 + n5 - 2, n4);
                graphics.drawLine(n3 + n5, n4 + 2, n3 + n5, n4 + n6 - 1);
                graphics.setColor(this._unselectColor2);
                graphics.drawLine(n3, n4 + 2, n3 + 2, n4);
                graphics.drawLine(n3 + n5 - 2, n4, n3 + n5, n4 + 2);
            }
        }
    }

    protected void paintBoxTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        if (bl) {
            graphics.setColor(this._selectColor1);
            graphics.drawLine(n3, n4, n3 + n5 - 2, n4);
            graphics.drawLine(n3, n4, n3, n4 + n6 - 2);
            graphics.setColor(this._selectColor2);
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 1);
            graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
        } else if (n2 != this._tabPane.getSelectedIndex() - 1) {
            switch (n) {
                case 2: 
                case 4: {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3 + 2, n4 + n6, n3 + n5 - 2, n4 + n6);
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n3 + 2, n4 + n6 + 1, n3 + n5 - 2, n4 + n6 + 1);
                    break;
                }
                default: {
                    if (bl2) {
                        graphics.setColor(this._unselectColor1);
                        graphics.drawLine(n3 + n5, n4 + 2, n3 + n5, n4 + n6 - 2);
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n3 + n5 + 1, n4 + 2, n3 + n5 + 1, n4 + n6 - 2);
                        break;
                    }
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 2);
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + n6 - 2);
                }
            }
        }
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        switch (this.getTabShape()) {
            case 3: {
                this.paintButtonTabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
                break;
            }
            case 8: {
                this.paintExcelTabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
                break;
            }
            case 1: {
                this.paintDefaultTabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
                break;
            }
            case 11: {
                if (!bl) break;
                this.paintDefaultTabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
                break;
            }
            case 2: 
            case 9: {
                this.paintVsnetTabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
                break;
            }
            case 5: 
            case 10: {
                this.paintFlatTabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
                break;
            }
            default: {
                this.paintOffice2003TabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
            }
        }
    }

    protected void paintOffice2003TabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (n) {
            case 2: {
                if (n2 != 0 && !bl) {
                    int[] nArray = new int[]{n3 + n5, n3 + 4, n3 + 2, n3, n3, n3 + 3, n3 + n5};
                    int[] nArray2 = new int[]{n4, n4, n4 + 2, n4 + 5, n4 + n6 - 5, n4 + n6 - 2, n4 + n6 - 2};
                    int n7 = nArray2.length;
                    this.tabRegion = new Polygon(nArray, nArray2, n7);
                    break;
                }
                int[] nArray = new int[]{n3 + n5, n3 + 2, n3, n3, n3 + 3, n3 + n5};
                int[] nArray3 = new int[]{n4 - n5 + 2 + 2, n4 + 2, n4 + 5, n4 + n6 - 5, n4 + n6 - 2, n4 + n6 - 2};
                int n8 = nArray3.length;
                this.tabRegion = new Polygon(nArray, nArray3, n8);
                break;
            }
            case 4: {
                if (n2 != 0 && !bl) {
                    int[] nArray = new int[]{n3, n3 + n5 - 4, n3 + n5 - 3, n3 + n5 - 1, n3 + n5 - 1, n3 + n5 - 3, n3};
                    int[] nArray4 = new int[]{n4, n4, n4 + 2, n4 + 5, n4 + n6 - 5, n4 + n6 - 2, n4 + n6 - 2};
                    int n9 = nArray4.length;
                    this.tabRegion = new Polygon(nArray, nArray4, n9);
                    break;
                }
                int[] nArray = new int[]{n3, n3 + n5 - 3, n3 + n5 - 1, n3 + n5 - 1, n3 + n5 - 3, n3};
                int[] nArray5 = new int[]{n4 - n5 + 2 + 2, n4 + 2, n4 + 5, n4 + n6 - 5, n4 + n6 - 2, n4 + n6 - 2};
                int n10 = nArray5.length;
                this.tabRegion = new Polygon(nArray, nArray5, n10);
                break;
            }
            case 3: {
                if (bl2) {
                    int[] nArray = new int[]{n3 - (n2 == 0 || bl ? n6 - 5 : 0), n3, n3 + 4, n3 + n5 - 3, n3 + n5 - 1, n3 + n5 - 1};
                    int[] nArray6 = new int[]{n4, n4 + n6 - 5, n4 + n6 - 1, n4 + n6 - 1, n4 + n6 - 5, n4};
                    int n11 = nArray6.length;
                    this.tabRegion = new Polygon(nArray, nArray6, n11);
                    break;
                }
                int[] nArray = new int[]{n3, n3, n3 + 2, n3 + n5 - 5, n3 + n5 - 1, n3 + n5 - 1 + (n2 == 0 || bl ? n6 - 5 : 0)};
                int[] nArray7 = new int[]{n4, n4 + n6 - 5, n4 + n6 - 1, n4 + n6 - 1, n4 + n6 - 5, n4};
                int n12 = nArray7.length;
                this.tabRegion = new Polygon(nArray, nArray7, n12);
                break;
            }
            default: {
                if (bl2) {
                    int[] nArray = new int[]{n3 - (n2 == 0 || bl ? n6 - 5 : 0), n3, n3 + 4, n3 + n5 - 3, n3 + n5 - 1, n3 + n5 - 1};
                    int[] nArray8 = new int[]{n4 + n6, n4 + 3, n4 + 1, n4 + 1, n4 + 3, n4 + n6};
                    int n13 = nArray8.length;
                    this.tabRegion = new Polygon(nArray, nArray8, n13);
                    break;
                }
                int[] nArray = new int[]{n3, n3, n3 + 2, n3 + n5 - 5, n3 + n5 - 1, n3 + n5 - 1 + (n2 == 0 || bl ? n6 - 5 : 0)};
                int[] nArray9 = new int[]{n4 + n6, n4 + 3, n4 + 1, n4 + 1, n4 + 3, n4 + n6};
                int n14 = nArray9.length;
                this.tabRegion = new Polygon(nArray, nArray9, n14);
            }
        }
    }

    protected void paintExcelTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (n) {
            case 2: {
                if (!bl) {
                    if (bl2 && n2 == 0 || !bl2 && n2 == this._tabPane.getTabCount() - 1) {
                        int[] nArray = new int[]{n3 + n5, n3, n3, n3 + n5};
                        int[] nArray2 = new int[]{n4 - 5, n4 + 5, n4 + n6 - 5, n4 + n6 + 6};
                        int n7 = nArray2.length;
                        this.tabRegion = new Polygon(nArray, nArray2, n7);
                        break;
                    }
                    int[] nArray = new int[]{n3 + n5, n3 + 9, n3, n3, n3 + n5};
                    int[] nArray3 = new int[]{n4 + 8, n4 + 2, n4 + 6, n4 + n6 - 5, n4 + n6 + 6};
                    int n8 = nArray3.length;
                    this.tabRegion = new Polygon(nArray, nArray3, n8);
                    break;
                }
                int[] nArray = new int[]{n3 + n5, n3, n3, n3 + n5};
                int[] nArray4 = new int[]{n4 - 5, n4 + 5, n4 + n6 - 5, n4 + n6 + 6};
                int n9 = nArray4.length;
                this.tabRegion = new Polygon(nArray, nArray4, n9);
                break;
            }
            case 4: {
                if (!bl) {
                    if (bl2 && n2 == 0 || !bl2 && n2 == this._tabPane.getTabCount() - 1) {
                        int[] nArray = new int[]{n3, n3 + n5 - 1, n3 + n5 - 1, n3};
                        int[] nArray5 = new int[]{n4 - 5, n4 + 5, n4 + n6 - 5, n4 + n6 + 6};
                        int n10 = nArray5.length;
                        this.tabRegion = new Polygon(nArray, nArray5, n10);
                        break;
                    }
                    int[] nArray = new int[]{n3, n3 + n5 - 10, n3 + n5 - 1, n3 + n5 - 1, n3};
                    int[] nArray6 = new int[]{n4 + 8, n4 + 2, n4 + 6, n4 + n6 - 5, n4 + n6 + 6};
                    int n11 = nArray6.length;
                    this.tabRegion = new Polygon(nArray, nArray6, n11);
                    break;
                }
                int[] nArray = new int[]{n3, n3 + n5 - 1, n3 + n5 - 1, n3};
                int[] nArray7 = new int[]{n4 - 5, n4 + 5, n4 + n6 - 4, n4 + n6 + 6};
                int n12 = nArray7.length;
                this.tabRegion = new Polygon(nArray, nArray7, n12);
                break;
            }
            case 3: {
                if (!bl) {
                    if (bl2 && n2 == 0 || !bl2 && n2 == this._tabPane.getTabCount() - 1) {
                        int[] nArray = new int[]{n3 - 5, n3 + 5, n3 + n5 - 5, n3 + n5 + 5};
                        int[] nArray8 = new int[]{n4, n4 + n6 - 1, n4 + n6 - 1, n4};
                        int n13 = nArray8.length;
                        this.tabRegion = new Polygon(nArray, nArray8, n13);
                        break;
                    }
                    int[] nArray = new int[]{n3 + 7, n3 + 1, n3 + 5, n3 + n5 - 5, n3 + n5 + 5};
                    int[] nArray9 = new int[]{n4, n4 + n6 - 10, n4 + n6 - 1, n4 + n6 - 1, n4};
                    int n14 = nArray9.length;
                    this.tabRegion = new Polygon(nArray, nArray9, n14);
                    break;
                }
                int[] nArray = new int[]{n3 - 5, n3 + 5, n3 + n5 - 5, n3 + n5 + 5};
                int[] nArray10 = new int[]{n4, n4 + n6 - 1, n4 + n6 - 1, n4};
                int n15 = nArray10.length;
                this.tabRegion = new Polygon(nArray, nArray10, n15);
                break;
            }
            default: {
                if (!bl) {
                    if (bl2 && n2 == 0 || !bl2 && n2 == this._tabPane.getTabCount() - 1) {
                        int[] nArray = new int[]{n3 - 6, n3 + 5, n3 + n5 - 5, n3 + n5 + 5};
                        int[] nArray11 = new int[]{n4 + n6, n4, n4, n4 + n6};
                        int n16 = nArray11.length;
                        this.tabRegion = new Polygon(nArray, nArray11, n16);
                        break;
                    }
                    int[] nArray = new int[]{n3 + 7, n3 + 1, n3 + 6, n3 + n5 - 5, n3 + n5 + 5};
                    int[] nArray12 = new int[]{n4 + n6, n4 + 9, n4, n4, n4 + n6};
                    int n17 = nArray12.length;
                    this.tabRegion = new Polygon(nArray, nArray12, n17);
                    break;
                }
                int[] nArray = new int[]{n3 - 6, n3 + 5, n3 + n5 - 5, n3 + n5 + 5};
                int[] nArray13 = new int[]{n4 + n6, n4, n4, n4 + n6};
                int n18 = nArray13.length;
                this.tabRegion = new Polygon(nArray, nArray13, n18);
            }
        }
    }

    protected void paintDefaultTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        switch (n) {
            case 2: {
                if (bl) {
                    int[] nArray = new int[]{++n3 + n5, n3, n3 - 2, n3 - 2, n3 + n5};
                    int[] nArray2 = new int[]{n4 - 1, n4 - 1, n4 + 1, n4 + n6 + 2, n4 + n6 + 2};
                    int n7 = nArray2.length;
                    this.tabRegion = new Polygon(nArray, nArray2, n7);
                    break;
                }
                if (n2 < this._tabPane.getSelectedIndex()) {
                    int[] nArray = new int[]{n3 + n5, n3 + 2, n3, n3, n3 + n5};
                    int[] nArray3 = new int[]{++n4 + 1, n4 + 1, n4 + 3, n4 + n6 - 1, n4 + n6 - 1};
                    int n8 = nArray3.length;
                    this.tabRegion = new Polygon(nArray, nArray3, n8);
                    break;
                }
                int[] nArray = new int[]{n3 + n5, n3 + 2, n3, n3, n3 + n5};
                int[] nArray4 = new int[]{n4 + 1, n4 + 1, n4 + 3, n4 + n6 - 2, n4 + n6 - 2};
                int n9 = nArray4.length;
                this.tabRegion = new Polygon(nArray, nArray4, n9);
                break;
            }
            case 4: {
                if (bl) {
                    int[] nArray = new int[]{n3, n3 + n5 - 1, n3 + n5, n3 + n5, n3};
                    int[] nArray5 = new int[]{n4 - 1, n4 - 1, n4 + 1, n4 + n6 + 2, n4 + n6 + 2};
                    int n10 = nArray5.length;
                    this.tabRegion = new Polygon(nArray, nArray5, n10);
                    break;
                }
                if (n2 < this._tabPane.getSelectedIndex()) {
                    int[] nArray = new int[]{n3, n3 + n5 - 3, n3 + n5 - 1, n3 + n5 - 1, n3};
                    int[] nArray6 = new int[]{++n4 + 1, n4 + 1, n4 + 3, n4 + n6 - 1, n4 + n6 - 1};
                    int n11 = nArray6.length;
                    this.tabRegion = new Polygon(nArray, nArray6, n11);
                    break;
                }
                int[] nArray = new int[]{n3, n3 + n5 - 2, n3 + n5 - 1, n3 + n5 - 1, n3};
                int[] nArray7 = new int[]{n4 + 1, n4 + 1, n4 + 3, n4 + n6 - 2, n4 + n6 - 2};
                int n12 = nArray7.length;
                this.tabRegion = new Polygon(nArray, nArray7, n12);
                break;
            }
            case 3: {
                if (bl) {
                    int[] nArray = new int[]{n3, n3, n3 + 2, n3 + n5 + 2, n3 + n5 + 2};
                    int[] nArray8 = new int[]{n4 + n6, n4, n4 - 2, n4 - 2, n4 + n6};
                    int n13 = nArray8.length;
                    this.tabRegion = new Polygon(nArray, nArray8, n13);
                    break;
                }
                int[] nArray = new int[]{n3 + 1, n3 + 1, n3 + 1, n3 + n5 - 1, n3 + n5 - 1};
                int[] nArray9 = new int[]{n4 + n6 - 1, n4 + 2, n4, n4, n4 + n6 - 1};
                int n14 = nArray9.length;
                this.tabRegion = new Polygon(nArray, nArray9, n14);
                break;
            }
            default: {
                if (bl) {
                    int[] nArray = new int[]{n3, n3, n3 + 2, n3 + n5 + 2, n3 + n5 + 2};
                    int[] nArray10 = new int[]{n4 + n6 + 1, n4, n4 - 2, n4 - 2, n4 + n6 + 1};
                    int n15 = nArray10.length;
                    this.tabRegion = new Polygon(nArray, nArray10, n15);
                    break;
                }
                int[] nArray = new int[]{n3 + 1, n3 + 1, n3 + 3, n3 + n5 - 1, n3 + n5 - 1};
                int[] nArray11 = new int[]{n4 + n6, n4 + 2, n4, n4, n4 + n6};
                int n16 = nArray11.length;
                this.tabRegion = new Polygon(nArray, nArray11, n16);
            }
        }
    }

    protected void paintTabBackgroundMouseOver(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, Color color, Color color2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Polygon polygon = null;
        switch (n) {
            case 2: {
                if (n2 < this._tabPane.getSelectedIndex()) {
                    int[] nArray = new int[]{n3 + n5, n3 + 2, n3, n3, n3 + 2, n3 + n5};
                    int[] nArray2 = new int[]{n4 + 2, n4 + 2, n4 + 4, n4 + n6 - 1, n4 + n6, n4 + n6};
                    int n7 = nArray2.length;
                    polygon = new Polygon(nArray, nArray2, n7);
                } else {
                    int[] nArray = new int[]{n3 + n5, n3 + 2, n3, n3, n3 + 2, n3 + n5};
                    int[] nArray3 = new int[]{n4 + 1, n4 + 1, n4 + 3, n4 + n6 - 3, n4 + n6 - 2, n4 + n6 - 2};
                    int n8 = nArray3.length;
                    polygon = new Polygon(nArray, nArray3, n8);
                }
                JideSwingUtilities.fillGradient(graphics2D, polygon, color, color2, false);
                break;
            }
            case 4: {
                if (n2 < this._tabPane.getSelectedIndex()) {
                    int[] nArray = new int[]{n3, n3 + n5 - 3, n3 + n5 - 1, n3 + n5 - 1, n3 + n5 - 3, n3};
                    int[] nArray4 = new int[]{n4 + 2, n4 + 2, n4 + 4, n4 + n6 - 1, n4 + n6, n4 + n6};
                    int n9 = nArray4.length;
                    polygon = new Polygon(nArray, nArray4, n9);
                } else {
                    int[] nArray = new int[]{n3, n3 + n5 - 2, n3 + n5 - 1, n3 + n5 - 1, n3 + n5 - 3, n3};
                    int[] nArray5 = new int[]{n4 + 1, n4 + 1, n4 + 3, n4 + n6 - 3, n4 + n6 - 2, n4 + n6 - 2};
                    int n10 = nArray5.length;
                    polygon = new Polygon(nArray, nArray5, n10);
                }
                JideSwingUtilities.fillGradient(graphics2D, polygon, color2, color, false);
                break;
            }
            case 3: {
                int[] nArray = new int[]{n3 + 1, n3 + 1, n3 + 1, n3 + n5 - 1, n3 + n5 - 1};
                int[] nArray6 = new int[]{n4 + n6 - 2, n4 + 2, n4, n4, n4 + n6 - 2};
                int n11 = nArray6.length;
                polygon = new Polygon(nArray, nArray6, n11);
                JideSwingUtilities.fillGradient(graphics2D, polygon, color2, color, true);
                break;
            }
            default: {
                int[] nArray = new int[]{n3 + 1, n3 + 1, n3 + 3, n3 + n5 - 1, n3 + n5 - 1};
                int[] nArray7 = new int[]{n4 + n6, n4 + 2, n4, n4, n4 + n6};
                int n12 = nArray7.length;
                polygon = new Polygon(nArray, nArray7, n12);
                JideSwingUtilities.fillGradient(graphics2D, polygon, color, color2, true);
            }
        }
    }

    protected void paintVsnetTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int[] nArray;
        int[] nArray2;
        switch (n) {
            case 2: {
                nArray2 = new int[]{n3 + 1, n3 + 1, n3 + n5, n3 + n5};
                nArray = new int[]{n4 + n6 - 1, n4 + 1, n4 + 1, n4 + n6 - 1};
                break;
            }
            case 4: {
                nArray2 = new int[]{n3, n3, n3 + n5 - 1, n3 + n5 - 1};
                nArray = new int[]{n4 + n6 - 1, n4 + 1, n4 + 1, n4 + n6 - 1};
                break;
            }
            case 3: {
                nArray2 = new int[]{n3 + 1, n3 + 1, n3 + n5 - 1, n3 + n5 - 1};
                nArray = new int[]{n4 + n6 - 1, n4, n4, n4 + n6 - 1};
                break;
            }
            default: {
                nArray2 = new int[]{n3 + 1, n3 + 1, n3 + n5 - 1, n3 + n5 - 1};
                nArray = new int[]{n4 + n6, n4 + 1, n4 + 1, n4 + n6};
            }
        }
        int n7 = nArray.length;
        this.tabRegion = new Polygon(nArray2, nArray, n7);
    }

    protected void paintFlatTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        switch (n) {
            case 2: {
                int[] nArray = new int[]{n3 + 1, n3 + 1, n3 + n5, n3 + n5};
                int[] nArray2 = new int[]{n4 + n6, n4 + 1, n4 + 1, n4 + n6};
                int n7 = nArray2.length;
                this.tabRegion = new Polygon(nArray, nArray2, n7);
                break;
            }
            case 4: {
                int[] nArray = new int[]{n3, n3, n3 + n5 - 1, n3 + n5 - 1};
                int[] nArray3 = new int[]{n4 + n6, n4 + 1, n4 + 1, n4 + n6};
                int n8 = nArray3.length;
                this.tabRegion = new Polygon(nArray, nArray3, n8);
                break;
            }
            case 3: {
                int[] nArray = new int[]{n3 + 1, n3 + 1, n3 + n5, n3 + n5};
                int[] nArray4 = new int[]{n4 + n6 - 1, n4, n4, n4 + n6 - 1};
                int n9 = nArray4.length;
                this.tabRegion = new Polygon(nArray, nArray4, n9);
                break;
            }
            default: {
                int[] nArray = new int[]{n3, n3 + 1, n3 + n5, n3 + n5};
                int[] nArray5 = new int[]{n4 + n6, n4 + 1, n4 + 1, n4 + n6};
                int n10 = nArray5.length;
                this.tabRegion = new Polygon(nArray, nArray5, n10);
            }
        }
    }

    protected void paintButtonTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int[] nArray = new int[]{n3, n3, n3 + n5, n3 + n5};
        int[] nArray2 = new int[]{n4 + n6, n4, n4, n4 + n6};
        int n7 = nArray2.length;
        this.tabRegion = new Polygon(nArray, nArray2, n7);
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        int n3 = this._tabPane.getWidth();
        int n4 = this._tabPane.getHeight();
        Insets insets = this._tabPane.getInsets();
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n3 - insets.right - insets.left;
        int n8 = n4 - insets.top - insets.bottom;
        int n9 = -1;
        Dimension dimension = new Dimension(0, 0);
        Dimension dimension2 = new Dimension(0, 0);
        if (this.isTabLeadingComponentVisible()) {
            dimension = this._tabLeadingComponent.getPreferredSize();
        }
        if (this.isTabTrailingComponentVisible()) {
            dimension2 = this._tabTrailingComponent.getPreferredSize();
        }
        switch (n) {
            case 2: {
                n5 += this.calculateTabAreaWidth(n, this._runCount, this._maxTabWidth);
                if (this.isTabLeadingComponentVisible() && dimension.width > this.calculateTabAreaWidth(n, this._runCount, this._maxTabWidth)) {
                    n5 = insets.left + dimension.width;
                    n9 = this._tabLeadingComponent.getSize().width;
                }
                if (this.isTabTrailingComponentVisible() && this._maxTabWidth < dimension2.width && n9 < dimension2.width) {
                    n5 = insets.left + dimension2.width;
                }
                n7 -= n5 - insets.left;
                break;
            }
            case 4: {
                n7 -= this.calculateTabAreaWidth(n, this._runCount, this._maxTabWidth);
                break;
            }
            case 3: {
                n8 -= this.calculateTabAreaHeight(n, this._runCount, this._maxTabHeight);
                break;
            }
            default: {
                n6 += this.calculateTabAreaHeight(n, this._runCount, this._maxTabHeight);
                if (this.isTabLeadingComponentVisible() && dimension.height > this.calculateTabAreaHeight(n, this._runCount, this._maxTabHeight)) {
                    n6 = insets.top + dimension.height;
                    n9 = dimension.height;
                }
                if (this.isTabTrailingComponentVisible() && this._maxTabHeight < dimension2.height && n9 < dimension2.height) {
                    n6 = insets.top + dimension2.height;
                }
                n8 -= n6 - insets.top;
            }
        }
        if (this.getTabShape() != 3) {
            this.paintContentBorder(graphics, n5, n6, n7, n8);
            switch (n) {
                case 2: {
                    this.paintContentBorderLeftEdge(graphics, n, n2, n5, n6, n7, n8);
                    break;
                }
                case 4: {
                    this.paintContentBorderRightEdge(graphics, n, n2, n5, n6, n7, n8);
                    break;
                }
                case 3: {
                    this.paintContentBorderBottomEdge(graphics, n, n2, n5, n6, n7, n8);
                    break;
                }
                default: {
                    this.paintContentBorderTopEdge(graphics, n, n2, n5, n6, n7, n8);
                }
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this._tabPane.isOpaque()) {
            graphics.setColor(this._tabBackground);
            graphics.fillRect(n, n2, n3, n4);
        }
    }

    protected Color getBorderEdgeColor() {
        if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
            return this._shadow;
        }
        return this._lightHighlight;
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n2 < 0) {
            return;
        }
        if (!this._tabPane.isTabShown()) {
            return;
        }
        Rectangle rectangle = this.getTabBounds(n2, this._calcRect);
        graphics.setColor(this.getBorderEdgeColor());
        if (n != 1 || n2 < 0 || rectangle.x < n3 || rectangle.x > n3 + n5) {
            graphics.drawLine(n3, n4, n3 + n5 - 1, n4);
        } else {
            graphics.drawLine(n3, n4, rectangle.x, n4);
            if (!this.getBorderEdgeColor().equals(this._lightHighlight)) {
                if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                    graphics.drawLine(rectangle.x + rectangle.width - 1, n4, rectangle.x + rectangle.width - 1, n4);
                    graphics.drawLine(rectangle.x + rectangle.width, n4, n3 + n5 - 1, n4);
                } else {
                    graphics.drawLine(n3 + n5 - 2, n4, n3 + n5 - 1, n4);
                }
            } else if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                graphics.setColor(this._darkShadow);
                graphics.drawLine(rectangle.x + rectangle.width - 1, n4, rectangle.x + rectangle.width - 1, n4);
                graphics.setColor(this._lightHighlight);
                graphics.drawLine(rectangle.x + rectangle.width, n4, n3 + n5 - 1, n4);
            } else {
                graphics.setColor(this._selectedColor == null ? this._tabPane.getBackground() : this._selectedColor);
                graphics.drawLine(n3 + n5 - 2, n4, n3 + n5 - 1, n4);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n2 < 0) {
            return;
        }
        if (!this._tabPane.isTabShown()) {
            return;
        }
        Rectangle rectangle = this.getTabBounds(n2, this._calcRect);
        if (n != 3 || n2 < 0 || rectangle.x < n3 || rectangle.x > n3 + n5) {
            graphics.setColor(this.getBorderEdgeColor());
            graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
        } else if (!this.getBorderEdgeColor().equals(this._lightHighlight)) {
            graphics.setColor(this.getBorderEdgeColor());
            graphics.drawLine(n3, n4 + n6 - 1, rectangle.x - 1, n4 + n6 - 1);
            graphics.drawLine(rectangle.x, n4 + n6 - 1, rectangle.x, n4 + n6 - 1);
            if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                graphics.drawLine(rectangle.x + rectangle.width - 1, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
            }
        } else {
            graphics.setColor(this._darkShadow);
            graphics.drawLine(n3, n4 + n6 - 1, rectangle.x - 1, n4 + n6 - 1);
            graphics.setColor(this._lightHighlight);
            graphics.drawLine(rectangle.x, n4 + n6 - 1, rectangle.x, n4 + n6 - 1);
            if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                graphics.setColor(this._darkShadow);
                graphics.drawLine(rectangle.x + rectangle.width - 1, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
            }
        }
    }

    protected void ensureCurrentLayout() {
        if (!this._tabPane.isValid()) {
            TabbedPaneLayout tabbedPaneLayout = (TabbedPaneLayout)this._tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    private void updateCloseButtons() {
        boolean bl = this._tabPane.getComponentOrientation().isLeftToRight();
        if (this.scrollableTabLayoutEnabled() && this.isShowCloseButton() && this.isShowCloseButtonOnTab()) {
            for (int i = 0; i < this._closeButtons.length; ++i) {
                Rectangle rectangle;
                if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                    if (i != this._tabPane.getSelectedIndex()) {
                        this._closeButtons[i].setBounds(0, 0, 0, 0);
                        continue;
                    }
                } else if (i >= this._rects.length) {
                    this._closeButtons[i].setBounds(0, 0, 0, 0);
                    continue;
                }
                if (!this._tabPane.isTabClosableAt(i)) {
                    this._closeButtons[i].setBounds(0, 0, 0, 0);
                    continue;
                }
                Dimension dimension = this._closeButtons[i].getPreferredSize();
                if (this._closeButtonAlignment == 11) {
                    if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
                        if (bl) {
                            rectangle = new Rectangle(this._rects[i].x + this._rects[i].width - dimension.width - this._closeButtonRightMargin, this._rects[i].y + (this._rects[i].height - dimension.height) / 2, dimension.width, dimension.height);
                            rectangle.x -= this.getTabGap();
                        } else {
                            rectangle = new Rectangle(this._rects[i].x + this._closeButtonLeftMargin + this.getTabGap(), this._rects[i].y + (this._rects[i].height - dimension.height) / 2, dimension.width, dimension.height);
                        }
                    } else {
                        rectangle = new Rectangle(this._rects[i].x + (this._rects[i].width - dimension.width) / 2, this._rects[i].y + this._rects[i].height - dimension.height - this._closeButtonRightMargin, dimension.width, dimension.height);
                        rectangle.y -= this.getTabGap();
                    }
                } else if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
                    if (bl) {
                        rectangle = new Rectangle(this._rects[i].x + this._closeButtonLeftMargin + this.getTabGap(), this._rects[i].y + (this._rects[i].height - dimension.height) / 2, dimension.width, dimension.height);
                    } else {
                        rectangle = new Rectangle(this._rects[i].x + this._rects[i].width - dimension.width - this._closeButtonRightMargin, this._rects[i].y + (this._rects[i].height - dimension.height) / 2, dimension.width, dimension.height);
                        rectangle.x -= this.getTabGap();
                    }
                } else {
                    rectangle = this._tabPane.getTabPlacement() == 2 ? new Rectangle(this._rects[i].x + (this._rects[i].width - dimension.width) / 2, this._rects[i].y + this._closeButtonLeftMargin, dimension.width, dimension.height) : new Rectangle(this._rects[i].x + (this._rects[i].width - dimension.width) / 2 - 2, this._rects[i].y + this._closeButtonLeftMargin, dimension.width, dimension.height);
                }
                this._closeButtons[i].setIndex(i);
                if (!rectangle.equals(this._closeButtons[i].getBounds())) {
                    this._closeButtons[i].setBounds(rectangle);
                }
                if (this._tabPane.getSelectedIndex() == i) {
                    this._closeButtons[i].setBackground(this._selectedColor == null ? this._tabPane.getBackgroundAt(i) : this._selectedColor);
                    continue;
                }
                this._closeButtons[i].setBackground(this._tabPane.getBackgroundAt(i));
            }
        }
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        this.ensureCurrentLayout();
        Rectangle rectangle = new Rectangle();
        return this.getTabBounds(n, rectangle);
    }

    public int getTabRunCount(JTabbedPane jTabbedPane) {
        this.ensureCurrentLayout();
        return this._runCount;
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        this.ensureCurrentLayout();
        Point point = new Point(n, n2);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(n, n2, point);
        }
        int n3 = this._tabPane.getTabCount();
        for (int i = 0; i < n3; ++i) {
            if (!this._rects[i].contains(point.x, point.y)) continue;
            return i;
        }
        return -1;
    }

    protected Rectangle getTabBounds(int n, Rectangle rectangle) {
        if (this._rects.length == 0) {
            return null;
        }
        if (n > this._rects.length - 1) {
            n = this._rects.length - 1;
        }
        if (n < 0) {
            n = 0;
        }
        rectangle.width = this._rects[n].width;
        rectangle.height = this._rects[n].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point point = this._tabScroller.viewport.getLocation();
            Point point2 = this._tabScroller.viewport.getViewPosition();
            rectangle.x = this._rects[n].x + point.x - point2.x;
            rectangle.y = this._rects[n].y + point.y - point2.y;
        } else {
            rectangle.x = this._rects[n].x;
            rectangle.y = this._rects[n].y;
        }
        return rectangle;
    }

    public int getTabAtLocation(int n, int n2) {
        this.ensureCurrentLayout();
        int n3 = this._tabPane.getTabCount();
        for (int i = 0; i < n3; ++i) {
            if (!this._rects[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    private int getClosestTab(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = n4 = Math.min(this._rects.length, this._tabPane.getTabCount());
        int n7 = this._tabPane.getTabPlacement();
        boolean bl = n7 == 1 || n7 == 3;
        int n8 = bl ? n : n2;
        Rectangle[] rectangleArray = new Rectangle[this._rects.length];
        boolean bl2 = false;
        if (!bl || this._tabPane.getComponentOrientation().isLeftToRight()) {
            System.arraycopy(this._rects, 0, rectangleArray, 0, this._rects.length);
        } else {
            bl2 = true;
            for (n3 = 0; n3 < this._rects.length; ++n3) {
                rectangleArray[n3] = this._rects[this._rects.length - 1 - n3];
            }
        }
        while (n5 != n6) {
            int n9;
            int n10;
            n3 = n6 + n5 >> 1;
            if (bl) {
                n10 = rectangleArray[n3].x;
                n9 = n10 + rectangleArray[n3].width;
            } else {
                n10 = rectangleArray[n3].y;
                n9 = n10 + rectangleArray[n3].height;
            }
            if (n8 < n10) {
                n6 = n3;
                if (n5 != n6) continue;
                int n11 = Math.max(0, n3 - 1);
                return bl2 ? rectangleArray.length - 1 - n11 : n11;
            }
            if (n8 >= n9) {
                n5 = n3;
                if (n6 - n5 > 1) continue;
                int n12 = Math.max(n3 + 1, n4 - 1);
                return bl2 ? rectangleArray.length - 1 - n12 : n12;
            }
            return bl2 ? rectangleArray.length - 1 - n3 : n3;
        }
        return bl2 ? rectangleArray.length - 1 - n5 : n5;
    }

    private Point translatePointToTabPanel(int n, int n2, Point point) {
        Point point2 = this._tabScroller.viewport.getLocation();
        Point point3 = this._tabScroller.viewport.getViewPosition();
        point.x = n - point2.x + point3.x;
        point.y = n2 - point2.y + point3.y;
        return point;
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this._tabPane) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected void assureRectsCreated(int n) {
        int n2 = this._rects.length;
        if (n != n2) {
            Rectangle[] rectangleArray = new Rectangle[n];
            System.arraycopy(this._rects, 0, rectangleArray, 0, Math.min(n2, n));
            this._rects = rectangleArray;
            for (int i = n2; i < n; ++i) {
                this._rects[i] = new Rectangle();
            }
        }
    }

    protected void expandTabRunsArray() {
        int n = this._tabRuns.length;
        int[] nArray = new int[n + 10];
        System.arraycopy(this._tabRuns, 0, nArray, 0, this._runCount);
        this._tabRuns = nArray;
    }

    protected int getRunForTab(int n, int n2) {
        for (int i = 0; i < this._runCount; ++i) {
            int n3 = this._tabRuns[i];
            int n4 = this.lastTabInRun(n, i);
            if (n2 < n3 || n2 > n4) continue;
            return i;
        }
        return 0;
    }

    protected int lastTabInRun(int n, int n2) {
        int n3;
        if (this._runCount == 1) {
            return n - 1;
        }
        int n4 = n3 = n2 == this._runCount - 1 ? 0 : n2 + 1;
        if (this._tabRuns[n3] == 0) {
            return n - 1;
        }
        return this._tabRuns[n3] - 1;
    }

    protected int getTabRunOverlay(int n) {
        return this._tabRunOverlay;
    }

    protected int getTabRunIndent(int n, int n2) {
        return 0;
    }

    protected boolean shouldPadTabRun(int n, int n2) {
        return this._runCount > 1;
    }

    protected boolean shouldRotateTabRuns(int n) {
        return true;
    }

    protected View getTextViewForTab(int n) {
        if (this.htmlViews != null && n < this.htmlViews.size()) {
            return (View)this.htmlViews.elementAt(n);
        }
        return null;
    }

    protected int calculateTabHeight(int n, int n2, FontMetrics fontMetrics) {
        int n3 = 0;
        if (n == 1 || n == 3) {
            View view = this.getTextViewForTab(n2);
            n3 = view != null ? (n3 += (int)view.getPreferredSpan(1)) : (n3 += fontMetrics.getHeight());
            Icon icon = this._tabPane.getIconForTab(n2);
            Insets insets = this.getTabInsets(n, n2);
            if (icon != null) {
                n3 = Math.max(n3, icon.getIconHeight());
            }
            n3 += insets.top + insets.bottom + 2;
        } else {
            View view;
            Icon icon = this._tabPane.getIconForTab(n2);
            Insets insets = this.getTabInsets(n, n2);
            n3 = insets.top + insets.bottom + 3;
            if (icon != null) {
                n3 += icon.getIconHeight() + this._textIconGap;
            }
            if ((view = this.getTextViewForTab(n2)) != null) {
                n3 += (int)view.getPreferredSpan(0);
            } else {
                String string = this.getCurrentDisplayTitleAt(this._tabPane, n2);
                n3 += SwingUtilities.computeStringWidth(fontMetrics, string);
            }
            if (this._tabPane.isShowGripper()) {
                n3 += this._gripperHeight;
            }
            if (this.scrollableTabLayoutEnabled() && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && this._tabPane.isTabClosableAt(n2)) {
                if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                    if (this._tabPane.getSelectedIndex() == n2) {
                        n3 += this._closeButtons[n2].getPreferredSize().height + this._closeButtonRightMargin + this._closeButtonLeftMargin;
                    }
                } else {
                    n3 += this._closeButtons[n2].getPreferredSize().height + this._closeButtonRightMargin + this._closeButtonLeftMargin;
                }
            }
        }
        return n3;
    }

    protected int calculateMaxTabHeight(int n) {
        int n2 = this._tabPane.getTabCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            FontMetrics fontMetrics = this.getFontMetrics(i);
            n3 = Math.max(this.calculateTabHeight(n, i, fontMetrics), n3);
        }
        return n3;
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        int n3 = 0;
        if (n == 1 || n == 3) {
            View view;
            Icon icon = this._tabPane.getIconForTab(n2);
            Insets insets = this.getTabInsets(n, n2);
            n3 = insets.left + insets.right + 3 + this.getTabGap();
            if (icon != null) {
                n3 += icon.getIconWidth() + this._textIconGap;
            }
            if ((view = this.getTextViewForTab(n2)) != null) {
                n3 += (int)view.getPreferredSpan(0);
            } else {
                String string = this.getCurrentDisplayTitleAt(this._tabPane, n2);
                while (string == null || string.length() < 3) {
                    string = string + " ";
                }
                n3 += SwingUtilities.computeStringWidth(fontMetrics, string);
            }
            if (this._tabPane.isShowGripper()) {
                n3 += this._gripperWidth;
            }
            if (this.scrollableTabLayoutEnabled() && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && this._tabPane.isTabClosableAt(n2)) {
                if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                    if (this._tabPane.getSelectedIndex() == n2) {
                        n3 += this._closeButtons[n2].getPreferredSize().width + this._closeButtonRightMargin + this._closeButtonLeftMargin;
                    }
                } else {
                    n3 += this._closeButtons[n2].getPreferredSize().width + this._closeButtonRightMargin + this._closeButtonLeftMargin;
                }
            }
        } else {
            View view = this.getTextViewForTab(n2);
            n3 = view != null ? (n3 += (int)view.getPreferredSpan(1)) : (n3 += fontMetrics.getHeight());
            Icon icon = this._tabPane.getIconForTab(n2);
            Insets insets = this.getTabInsets(n, n2);
            if (icon != null) {
                n3 = Math.max(n3, icon.getIconWidth());
            }
            n3 += insets.left + insets.right + 2;
        }
        return n3;
    }

    protected int calculateMaxTabWidth(int n) {
        int n2 = this._tabPane.getTabCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            FontMetrics fontMetrics = this.getFontMetrics(i);
            n3 = Math.max(this.calculateTabWidth(n, i, fontMetrics), n3);
        }
        return n3;
    }

    protected int calculateTabAreaHeight(int n, int n2, int n3) {
        if (!this._tabPane.isTabShown()) {
            return 0;
        }
        Insets insets = this.getTabAreaInsets(n);
        int n4 = this.getTabRunOverlay(n);
        return n2 > 0 ? n2 * (n3 - n4) + n4 + insets.top + insets.bottom : 0;
    }

    protected int calculateTabAreaWidth(int n, int n2, int n3) {
        if (!this._tabPane.isTabShown()) {
            return 0;
        }
        Insets insets = this.getTabAreaInsets(n);
        int n4 = this.getTabRunOverlay(n);
        return n2 > 0 ? n2 * (n3 - n4) + n4 + insets.left + insets.right : 0;
    }

    protected Insets getTabInsets(int n, int n2) {
        BasicJideTabbedPaneUI.rotateInsets(this._tabInsets, this._currentTabInsets, n);
        return this._currentTabInsets;
    }

    protected Insets getSelectedTabPadInsets(int n) {
        BasicJideTabbedPaneUI.rotateInsets(this._selectedTabPadInsets, this._currentPadInsets, n);
        return this._currentPadInsets;
    }

    protected Insets getTabAreaInsets(int n) {
        BasicJideTabbedPaneUI.rotateInsets(this._tabAreaInsets, this._currentTabAreaInsets, n);
        return this._currentTabAreaInsets;
    }

    protected Insets getContentBorderInsets(int n) {
        BasicJideTabbedPaneUI.rotateInsets(this._tabPane.getContentBorderInsets(), this._currentContentBorderInsets, n);
        if (this._ignoreContentBorderInsetsIfNoTabs && !this._tabPane.isTabShown()) {
            return new Insets(0, 0, 0, 0);
        }
        return this._currentContentBorderInsets;
    }

    protected FontMetrics getFontMetrics(int n) {
        Font font = null;
        int n2 = this._tabPane.getSelectedIndex();
        font = n2 == n && this._tabPane.getSelectedTabFont() != null ? this._tabPane.getSelectedTabFont() : this._tabPane.getFont();
        if (n2 == n && this._tabPane.isBoldActiveTab() && font.getStyle() != 1) {
            font = font.deriveFont(1);
        }
        return this._tabPane.getFontMetrics(font);
    }

    protected void navigateSelectedTab(int n) {
        int n2 = this._tabPane.getTabPlacement();
        int n3 = this._tabPane.getSelectedIndex();
        int n4 = this._tabPane.getTabCount();
        boolean bl = this._tabPane.getComponentOrientation().isLeftToRight();
        if (n4 <= 0) {
            return;
        }
        block0 : switch (n2) {
            case 12: {
                this.selectNextTab(n3);
                break;
            }
            case 13: {
                this.selectPreviousTab(n3);
                break;
            }
            case 2: 
            case 4: {
                switch (n) {
                    case 1: {
                        this.selectPreviousTabInRun(n3);
                        break block0;
                    }
                    case 5: {
                        this.selectNextTabInRun(n3);
                        break block0;
                    }
                    case 7: {
                        int n5 = this.getTabRunOffset(n2, n4, n3, false);
                        this.selectAdjacentRunTab(n2, n3, n5);
                        break block0;
                    }
                    case 3: {
                        int n6 = this.getTabRunOffset(n2, n4, n3, true);
                        this.selectAdjacentRunTab(n2, n3, n6);
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (n) {
                    case 1: {
                        int n7 = this.getTabRunOffset(n2, n4, n3, false);
                        this.selectAdjacentRunTab(n2, n3, n7);
                        break block0;
                    }
                    case 5: {
                        int n8 = this.getTabRunOffset(n2, n4, n3, true);
                        this.selectAdjacentRunTab(n2, n3, n8);
                        break block0;
                    }
                    case 3: {
                        if (bl) {
                            this.selectNextTabInRun(n3);
                            break block0;
                        }
                        this.selectPreviousTabInRun(n3);
                        break block0;
                    }
                    case 7: {
                        if (bl) {
                            this.selectPreviousTabInRun(n3);
                            break block0;
                        }
                        this.selectNextTabInRun(n3);
                        break block0;
                    }
                }
            }
        }
    }

    protected void selectNextTabInRun(int n) {
        int n2 = this._tabPane.getTabCount();
        int n3 = this.getNextTabIndexInRun(n2, n);
        while (n3 != n && !this._tabPane.isEnabledAt(n3)) {
            n3 = this.getNextTabIndexInRun(n2, n3);
        }
        this._tabPane.setSelectedIndex(n3);
    }

    protected void selectPreviousTabInRun(int n) {
        int n2 = this._tabPane.getTabCount();
        int n3 = this.getPreviousTabIndexInRun(n2, n);
        while (n3 != n && !this._tabPane.isEnabledAt(n3)) {
            n3 = this.getPreviousTabIndexInRun(n2, n3);
        }
        this._tabPane.setSelectedIndex(n3);
    }

    protected void selectNextTab(int n) {
        int n2 = this.getNextTabIndex(n);
        while (n2 != n && !this._tabPane.isEnabledAt(n2)) {
            n2 = this.getNextTabIndex(n2);
        }
        this._tabPane.setSelectedIndex(n2);
    }

    protected void selectPreviousTab(int n) {
        int n2 = this.getPreviousTabIndex(n);
        while (n2 != n && !this._tabPane.isEnabledAt(n2)) {
            n2 = this.getPreviousTabIndex(n2);
        }
        this._tabPane.setSelectedIndex(n2);
    }

    protected void selectAdjacentRunTab(int n, int n2, int n3) {
        int n4;
        if (this._runCount < 2) {
            return;
        }
        Rectangle rectangle = this._rects[n2];
        switch (n) {
            case 2: 
            case 4: {
                n4 = this.getTabAtLocation(rectangle.x + (rectangle.width >> 1) + n3, rectangle.y + (rectangle.height >> 1));
                break;
            }
            default: {
                n4 = this.getTabAtLocation(rectangle.x + (rectangle.width >> 1), rectangle.y + (rectangle.height >> 1) + n3);
            }
        }
        if (n4 != -1) {
            while (!this._tabPane.isEnabledAt(n4) && n4 != n2) {
                n4 = this.getNextTabIndex(n4);
            }
            this._tabPane.setSelectedIndex(n4);
        }
    }

    protected int getTabRunOffset(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5 = this.getRunForTab(n2, n3);
        switch (n) {
            case 2: {
                if (n5 == 0) {
                    n4 = bl ? -(this.calculateTabAreaWidth(n, this._runCount, this._maxTabWidth) - this._maxTabWidth) : -this._maxTabWidth;
                    break;
                }
                if (n5 == this._runCount - 1) {
                    n4 = bl ? this._maxTabWidth : this.calculateTabAreaWidth(n, this._runCount, this._maxTabWidth) - this._maxTabWidth;
                    break;
                }
                n4 = bl ? this._maxTabWidth : -this._maxTabWidth;
                break;
            }
            case 4: {
                if (n5 == 0) {
                    n4 = bl ? this._maxTabWidth : this.calculateTabAreaWidth(n, this._runCount, this._maxTabWidth) - this._maxTabWidth;
                    break;
                }
                if (n5 == this._runCount - 1) {
                    n4 = bl ? -(this.calculateTabAreaWidth(n, this._runCount, this._maxTabWidth) - this._maxTabWidth) : -this._maxTabWidth;
                    break;
                }
                n4 = bl ? this._maxTabWidth : -this._maxTabWidth;
                break;
            }
            case 3: {
                if (n5 == 0) {
                    n4 = bl ? this._maxTabHeight : this.calculateTabAreaHeight(n, this._runCount, this._maxTabHeight) - this._maxTabHeight;
                    break;
                }
                if (n5 == this._runCount - 1) {
                    n4 = bl ? -(this.calculateTabAreaHeight(n, this._runCount, this._maxTabHeight) - this._maxTabHeight) : -this._maxTabHeight;
                    break;
                }
                n4 = bl ? this._maxTabHeight : -this._maxTabHeight;
                break;
            }
            default: {
                n4 = n5 == 0 ? (bl ? -(this.calculateTabAreaHeight(n, this._runCount, this._maxTabHeight) - this._maxTabHeight) : -this._maxTabHeight) : (n5 == this._runCount - 1 ? (bl ? this._maxTabHeight : this.calculateTabAreaHeight(n, this._runCount, this._maxTabHeight) - this._maxTabHeight) : (bl ? this._maxTabHeight : -this._maxTabHeight));
            }
        }
        return n4;
    }

    protected int getPreviousTabIndex(int n) {
        int n2 = n - 1 >= 0 ? n - 1 : this._tabPane.getTabCount() - 1;
        return n2 >= 0 ? n2 : 0;
    }

    protected int getNextTabIndex(int n) {
        return (n + 1) % this._tabPane.getTabCount();
    }

    protected int getNextTabIndexInRun(int n, int n2) {
        if (this._runCount < 2) {
            return this.getNextTabIndex(n2);
        }
        int n3 = this.getRunForTab(n, n2);
        int n4 = this.getNextTabIndex(n2);
        if (n4 == this._tabRuns[this.getNextTabRun(n3)]) {
            return this._tabRuns[n3];
        }
        return n4;
    }

    protected int getPreviousTabIndexInRun(int n, int n2) {
        if (this._runCount < 2) {
            return this.getPreviousTabIndex(n2);
        }
        int n3 = this.getRunForTab(n, n2);
        if (n2 == this._tabRuns[n3]) {
            int n4 = this._tabRuns[this.getNextTabRun(n3)] - 1;
            return n4 != -1 ? n4 : n - 1;
        }
        return this.getPreviousTabIndex(n2);
    }

    protected int getPreviousTabRun(int n) {
        int n2 = n - 1 >= 0 ? n - 1 : this._runCount - 1;
        return n2 >= 0 ? n2 : 0;
    }

    protected int getNextTabRun(int n) {
        return (n + 1) % this._runCount;
    }

    public static void rotateInsets(Insets insets, Insets insets2, int n) {
        switch (n) {
            case 2: {
                insets2.top = insets.left;
                insets2.left = insets.top;
                insets2.bottom = insets.right;
                insets2.right = insets.bottom;
                break;
            }
            case 3: {
                insets2.top = insets.bottom;
                insets2.left = insets.left;
                insets2.bottom = insets.top;
                insets2.right = insets.right;
                break;
            }
            case 4: {
                insets2.top = insets.left;
                insets2.left = insets.bottom;
                insets2.bottom = insets.right;
                insets2.right = insets.top;
                break;
            }
            default: {
                insets2.top = insets.top;
                insets2.left = insets.left;
                insets2.bottom = insets.bottom;
                insets2.right = insets.right;
            }
        }
    }

    protected boolean requestFocusForVisibleComponent() {
        Component component = this.getVisibleComponent();
        Component component2 = this._tabPane.getLastFocusedComponent(component);
        if (component2 != null && component2.requestFocusInWindow()) {
            return true;
        }
        if (component != null && JideSwingUtilities.passesFocusabilityTest(component)) {
            JideSwingUtilities.compositeRequestFocus(component);
            return true;
        }
        return component instanceof JComponent && ((JComponent)component).requestDefaultFocus();
    }

    protected TabCloseButton createNoFocusButton(int n) {
        return new TabCloseButton(n);
    }

    protected void stopOrCancelEditing() {
        boolean bl = true;
        if (this._tabPane != null && this._tabPane.isTabEditing() && this._tabPane.getTabEditingValidator() != null) {
            bl = this._tabPane.getTabEditingValidator().isValid(this._editingTab, this._oldPrefix + this._tabEditor.getText() + this._oldPostfix);
        }
        if (bl) {
            this._tabPane.stopTabEditing();
        } else {
            this._tabPane.cancelTabEditing();
        }
    }

    protected void ensureCurrentRects(int n, int n2) {
        int n3;
        int n4;
        Dimension dimension = this._tabPane.getSize();
        Insets insets = this._tabPane.getInsets();
        int n5 = 0;
        int n6 = 0;
        boolean bl = this._tabPane.getTabPlacement() == 2 || this._tabPane.getTabPlacement() == 4;
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        if (n2 == 0) {
            return;
        }
        Rectangle rectangle = this._rects[n2 - 1];
        Dimension dimension2 = new Dimension(0, 0);
        Dimension dimension3 = new Dimension(0, 0);
        if (this.isTabLeadingComponentVisible()) {
            dimension2 = this._tabLeadingComponent.getPreferredSize();
        }
        if (this.isTabTrailingComponentVisible()) {
            dimension3 = this._tabTrailingComponent.getPreferredSize();
        }
        if (bl) {
            n6 = rectangle.y + rectangle.height;
            if (this._tabLeadingComponent != null) {
                n6 -= dimension2.height;
            }
        } else {
            Rectangle[] rectangleArray = this._rects;
            n4 = rectangleArray.length;
            for (n3 = 0; n3 < n4; ++n3) {
                Rectangle rectangle2 = rectangleArray[n3];
                n5 += rectangle2.width;
            }
            n5 = bl2 ? (n5 += this._rects[0].x) : (n5 += dimension.width - this._rects[0].x - this._rects[0].width);
            if (this._tabLeadingComponent != null) {
                n5 -= dimension2.width;
            }
        }
        if (this.getTabResizeMode() == 2) {
            if (bl) {
                int n7 = this.getTabShape() != 3 ? (int)dimension.getHeight() - this._fitStyleBoundSize - insets.top - insets.bottom - n - this.getTabRightPadding() : (int)dimension.getHeight() - this._fitStyleBoundSize - insets.top - insets.bottom;
                if (this._tabPane.isShowCloseButton()) {
                    n7 -= this._buttonSize;
                }
                if (this.isTabLeadingComponentVisible()) {
                    n7 -= dimension2.height;
                }
                if (this.isTabTrailingComponentVisible()) {
                    n7 -= dimension3.height;
                }
                if (n6 > (n7 -= this._buttonSize * (n4 = this.getNumberOfTabButtons()))) {
                    n3 = n7 / n2;
                    n6 = this._fitStyleFirstTabMargin;
                    for (int i = 0; i < n2; ++i) {
                        this._rects[i].height = n3;
                        Rectangle rectangle3 = this._rects[i];
                        rectangle3.y = this.getTabShape() != 3 ? n6 + n : n6;
                        n6 += rectangle3.height;
                    }
                }
            } else {
                int n8 = this.getTabShape() != 3 ? (int)dimension.getWidth() - this._fitStyleBoundSize - insets.left - insets.right - n - this.getTabRightPadding() : (int)dimension.getWidth() - this._fitStyleBoundSize - insets.left - insets.right;
                if (this._tabPane.isShowCloseButton()) {
                    n8 -= this._buttonSize;
                }
                if (this.isTabLeadingComponentVisible()) {
                    n8 -= dimension2.width;
                }
                if (this.isTabTrailingComponentVisible()) {
                    n8 -= dimension3.width;
                }
                if (n5 > (n8 -= this._buttonSize * (n4 = this.getNumberOfTabButtons()))) {
                    int n9;
                    n3 = n8 / n2;
                    int n10 = n9 = this._tabPane.isShowGripper() ? this._gripperWidth : 0;
                    if (n3 < this._textIconGap + this._fitStyleTextMinWidth + this._fitStyleIconMinWidth + n9 && n3 > this._fitStyleIconMinWidth + n9) {
                        n3 = this._fitStyleIconMinWidth + n9;
                    }
                    if (n3 < this._fitStyleIconMinWidth + n9 && n3 > this._fitStyleFirstTabMargin + n9) {
                        n3 = this._fitStyleFirstTabMargin + n9;
                    }
                    this.tryTabSpacer.reArrange(this._rects, insets, n8);
                }
                n5 = this._fitStyleFirstTabMargin;
                for (n3 = 0; n3 < n2; ++n3) {
                    Rectangle rectangle4 = this._rects[n3];
                    rectangle4.x = this.getTabShape() != 3 ? (bl2 ? n5 + n : n8 - n5 - rectangle4.width + n) : (bl2 ? n5 : n8 - n5 - rectangle4.width);
                    n5 += rectangle4.width;
                }
            }
        }
        if (this.getTabResizeMode() == 3) {
            if (bl) {
                for (int i = 0; i < n2; ++i) {
                    this._rects[i].height = this._fixedStyleRectSize;
                    if (this.isShowCloseButton() && this._tabPane.isShowCloseButtonOnTab()) {
                        this._rects[i].height += this._closeButtons[i].getPreferredSize().height;
                    }
                    if (i != 0) {
                        this._rects[i].y = this._rects[i - 1].y + this._rects[i - 1].height;
                    }
                    n6 = this._rects[i].y + this._rects[i].height;
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    n4 = this._rects[i].width;
                    this._rects[i].width = this._fixedStyleRectSize;
                    if (this.isShowCloseButton() && this._tabPane.isShowCloseButtonOnTab()) {
                        this._rects[i].width += this._closeButtons[i].getPreferredSize().width;
                    }
                    if (i == 0 && !bl2) {
                        this._rects[i].x += n4 - this._rects[i].width;
                    }
                    if (i != 0) {
                        this._rects[i].x = bl2 ? this._rects[i - 1].x + this._rects[i - 1].width : this._rects[i - 1].x - this._rects[i - 1].width;
                    }
                    n5 = this._rects[i].x + this._rects[i].width;
                }
            }
        }
        if (this.getTabResizeMode() == 4) {
            if (bl) {
                for (int i = 0; i < n2; ++i) {
                    if (i != this._tabPane.getSelectedIndex()) {
                        if (!this._tabPane.isShowIconsOnTab() && !this._tabPane.isUseDefaultShowIconsOnTab()) {
                            this._rects[i].height = this._compressedStyleNoIconRectSize;
                        } else {
                            Icon icon = this._tabPane.getIconForTab(i);
                            this._rects[i].height = icon.getIconHeight() + this._compressedStyleIconMargin;
                        }
                        if (this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab()) {
                            this._rects[i].height = this._rects[i].height + this._closeButtons[i].getPreferredSize().height + this._compressedStyleCloseButtonMarginVertical;
                        }
                    }
                    if (i != 0) {
                        this._rects[i].y = this._rects[i - 1].y + this._rects[i - 1].height;
                    }
                    n6 = this._rects[i].y + this._rects[i].height;
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    n4 = this._rects[i].width;
                    if (i != this._tabPane.getSelectedIndex()) {
                        if (!this._tabPane.isShowIconsOnTab() && !this._tabPane.isUseDefaultShowIconsOnTab()) {
                            this._rects[i].width = this._compressedStyleNoIconRectSize;
                        } else {
                            Icon icon = this._tabPane.getIconForTab(i);
                            this._rects[i].width = icon.getIconWidth() + this._compressedStyleIconMargin;
                        }
                        if (this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab()) {
                            this._rects[i].width = this._rects[i].width + this._closeButtons[i].getPreferredSize().width + this._compressedStyleCloseButtonMarginHorizon;
                        }
                    }
                    if (i == 0 && !bl2) {
                        this._rects[i].x += n4 - this._rects[i].width;
                    }
                    if (i != 0) {
                        this._rects[i].x = bl2 ? this._rects[i - 1].x + this._rects[i - 1].width : this._rects[i - 1].x - this._rects[i - 1].width;
                    }
                    n5 = this._rects[i].x + this._rects[i].width;
                }
            }
        }
        if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
            n5 += this.getLayoutSize();
            if (this.isTabLeadingComponentVisible()) {
                n5 += dimension2.width;
            }
        } else {
            n6 += this.getLayoutSize();
            if (this.isTabLeadingComponentVisible()) {
                n6 += dimension3.height;
            }
        }
        this._tabScroller.tabPanel.setPreferredSize(new Dimension(n5, n6));
    }

    protected ListCellRenderer getTabListCellRenderer() {
        return this._tabPane.getTabListCellRenderer();
    }

    protected void updateCloseAction() {
        this.ensureCloseButtonCreated();
    }

    private Vector createHTMLVector() {
        Vector<View> vector = new Vector<View>();
        int n = this._tabPane.getTabCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                String string = this.getCurrentDisplayTitleAt(this._tabPane, i);
                if (BasicHTML.isHTMLString(string)) {
                    vector.addElement(BasicHTML.createHTMLView(this._tabPane, string));
                    continue;
                }
                vector.addElement(null);
            }
        }
        return vector;
    }

    public Component getTabPanel() {
        if (this.scrollableTabLayoutEnabled()) {
            return this._tabScroller.tabPanel;
        }
        return this._tabPane;
    }

    public void ensureActiveTabIsVisible(boolean bl) {
        if (this._tabPane == null || this._tabPane.getWidth() == 0) {
            return;
        }
        if (this.scrollableTabLayoutEnabled()) {
            this.ensureCurrentLayout();
            if (bl && this._rects.length > 0) {
                if (this._tabPane.getTabPlacement() == 2 || this._tabPane.getTabPlacement() == 4 || this._tabPane.getComponentOrientation().isLeftToRight()) {
                    this._tabScroller.viewport.setViewPosition(new Point(0, 0));
                    this._tabScroller.tabPanel.scrollRectToVisible(this._rects[0]);
                } else {
                    this._tabScroller.viewport.setViewPosition(new Point(0, 0));
                }
            }
            int n = this._tabPane.getSelectedIndex();
            if (!(bl && n == 0 || n >= this._rects.length || n == -1)) {
                if (n == 0) {
                    this._tabScroller.viewport.setViewPosition(new Point(0, 0));
                } else if (n == this._rects.length - 1) {
                    Rectangle rectangle = this._rects[n];
                    rectangle.width = this._tabScroller.tabPanel.getWidth() - rectangle.x;
                    this._tabScroller.tabPanel.scrollRectToVisible(rectangle);
                } else if (n == 0) {
                    Rectangle rectangle = this._rects[n];
                    rectangle.x = 0;
                    this._tabScroller.tabPanel.scrollRectToVisible(rectangle);
                } else {
                    this._tabScroller.tabPanel.scrollRectToVisible(this._rects[n]);
                }
                this._tabScroller.tabPanel.getParent().doLayout();
            }
            this._tabPane.revalidate();
            this._tabPane.repaintTabAreaAndContentBorder();
        }
    }

    protected boolean isShowCloseButtonOnTab() {
        if (this._tabPane.isUseDefaultShowCloseButtonOnTab()) {
            return this._showCloseButtonOnTab;
        }
        return this._tabPane.isShowCloseButtonOnTab();
    }

    protected boolean isShowCloseButton() {
        return this._tabPane.isShowCloseButton();
    }

    public void ensureCloseButtonCreated() {
        if (this.isShowCloseButton() && this.isShowCloseButtonOnTab() && this.scrollableTabLayoutEnabled()) {
            TabCloseButton tabCloseButton;
            int n;
            TabCloseButton[] tabCloseButtonArray;
            if (this._closeButtons == null) {
                this._closeButtons = new TabCloseButton[this._tabPane.getTabCount()];
            } else if (this._closeButtons.length > this._tabPane.getTabCount()) {
                tabCloseButtonArray = new TabCloseButton[this._tabPane.getTabCount()];
                System.arraycopy(this._closeButtons, 0, tabCloseButtonArray, 0, tabCloseButtonArray.length);
                for (n = tabCloseButtonArray.length; n < this._closeButtons.length; ++n) {
                    tabCloseButton = this._closeButtons[n];
                    this._tabScroller.tabPanel.remove(tabCloseButton);
                }
                this._closeButtons = tabCloseButtonArray;
            } else if (this._closeButtons.length < this._tabPane.getTabCount()) {
                tabCloseButtonArray = new TabCloseButton[this._tabPane.getTabCount()];
                System.arraycopy(this._closeButtons, 0, tabCloseButtonArray, 0, this._closeButtons.length);
                this._closeButtons = tabCloseButtonArray;
            }
            tabCloseButtonArray = this.getActionMap();
            for (n = 0; n < this._closeButtons.length; ++n) {
                tabCloseButton = this._closeButtons[n];
                if (tabCloseButton == null) {
                    tabCloseButton = this.createNoFocusButton(0);
                    tabCloseButton.setName(BUTTON_NAME_CLOSE);
                    this._closeButtons[n] = tabCloseButton;
                    tabCloseButton.setBounds(0, 0, 0, 0);
                    Action action = this._tabPane.getCloseAction();
                    tabCloseButton.setAction(tabCloseButtonArray.get("closeTabAction"));
                    this.updateButtonFromAction(tabCloseButton, action);
                    this._tabScroller.tabPanel.add(tabCloseButton);
                }
                tabCloseButton.setIndex(n);
            }
        }
    }

    private void updateButtonFromAction(TabCloseButton tabCloseButton, Action action) {
        Object object;
        if (action == null) {
            return;
        }
        tabCloseButton.setEnabled(action.isEnabled());
        Object object2 = action.getValue("ShortDescription");
        if (object2 instanceof String) {
            tabCloseButton.setToolTipText((String)object2);
        }
        if ((object = action.getValue("SmallIcon")) instanceof Icon) {
            tabCloseButton.setIcon((Icon)object);
        }
    }

    protected boolean isShowTabButtons() {
        return this._tabPane.getTabCount() != 0 && this._tabPane.isShowTabArea() && this._tabPane.isShowTabButtons();
    }

    protected boolean isShrinkTabs() {
        return this._tabPane.getTabCount() != 0 && this._tabPane.getTabResizeMode() == 2;
    }

    public boolean isTabEditing() {
        return this._isEditing;
    }

    protected TabEditor createDefaultTabEditor() {
        final TabEditor tabEditor = new TabEditor();
        tabEditor.getDocument().addDocumentListener(this);
        tabEditor.setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent jComponent) {
                return true;
            }

            public boolean shouldYieldFocus(JComponent jComponent) {
                boolean bl = true;
                if (BasicJideTabbedPaneUI.this._tabPane != null && BasicJideTabbedPaneUI.this._tabPane.isTabEditing() && BasicJideTabbedPaneUI.this._tabPane.getTabEditingValidator() != null) {
                    bl = BasicJideTabbedPaneUI.this._tabPane.getTabEditingValidator().alertIfInvalid(BasicJideTabbedPaneUI.this._editingTab, BasicJideTabbedPaneUI.this._oldPrefix + BasicJideTabbedPaneUI.this._tabEditor.getText() + BasicJideTabbedPaneUI.this._oldPostfix);
                }
                if (bl && BasicJideTabbedPaneUI.this._tabPane != null && BasicJideTabbedPaneUI.this._tabPane.isTabEditing()) {
                    BasicJideTabbedPaneUI.this._tabPane.stopTabEditing();
                }
                return bl;
            }
        });
        tabEditor.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                BasicJideTabbedPaneUI.this._originalFocusComponent = focusEvent.getOppositeComponent();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        tabEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                tabEditor.transferFocus();
            }
        });
        tabEditor.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (BasicJideTabbedPaneUI.this._isEditing && keyEvent.getKeyCode() == 27) {
                    if (BasicJideTabbedPaneUI.this._editingTab >= 0 && BasicJideTabbedPaneUI.this._editingTab < BasicJideTabbedPaneUI.this._tabPane.getTabCount()) {
                        BasicJideTabbedPaneUI.this._tabPane.setTitleAt(BasicJideTabbedPaneUI.this._editingTab, BasicJideTabbedPaneUI.this._oldValue);
                    }
                    BasicJideTabbedPaneUI.this._tabPane.cancelTabEditing();
                }
            }
        });
        tabEditor.setFont(this._tabPane.getFont());
        return tabEditor;
    }

    public void stopTabEditing() {
        if (this._editingTab >= 0 && this._editingTab < this._tabPane.getTabCount()) {
            this._tabPane.setTitleAt(this._editingTab, this._oldPrefix + this._tabEditor.getText() + this._oldPostfix);
        }
        this.cancelTabEditing();
    }

    public void cancelTabEditing() {
        if (this._tabEditor != null) {
            this._isEditing = false;
            ((Container)this.getTabPanel()).remove(this._tabEditor);
            if (this._editingTab >= 0 && this._editingTab < this._tabPane.getTabCount()) {
                Rectangle rectangle = this._tabPane.getBoundsAt(this._editingTab);
                this.getTabPanel().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                this.getTabPanel().repaint();
            }
            if (this._originalFocusComponent != null) {
                this._originalFocusComponent.requestFocus();
            } else {
                this._tabPane.requestFocusForVisibleComponent();
            }
            this._editingTab = -1;
            this._oldValue = null;
            this._tabPane.doLayout();
        }
    }

    public boolean editTabAt(int n) {
        if (this._isEditing) {
            return false;
        }
        if (this._tabEditor == null) {
            this._tabEditor = this.createDefaultTabEditor();
        }
        if (this._tabEditor != null) {
            this.prepareEditor(this._tabEditor, n);
            ((Container)this.getTabPanel()).add(this._tabEditor);
            this.resizeEditor(n);
            this._editingTab = n;
            this._isEditing = true;
            this._tabEditor.requestFocusInWindow();
            this._tabEditor.selectAll();
            return true;
        }
        return false;
    }

    public int getEditingTabIndex() {
        return this._editingTab;
    }

    protected void prepareEditor(TabEditor tabEditor, int n) {
        Font font = null;
        font = this._tabPane.getSelectedTabFont() != null ? this._tabPane.getSelectedTabFont() : this._tabPane.getFont();
        if (this._tabPane.isBoldActiveTab() && font.getStyle() != 1) {
            font = font.deriveFont(1);
        }
        tabEditor.setFont(font);
        this._oldValue = this._tabPane.getTitleAt(n);
        if (this._oldValue.startsWith("<HTML>") && this._oldValue.endsWith("/HTML>")) {
            this._oldPrefix = "<HTML>";
            this._oldPostfix = "</HTML>";
            String string = this._oldValue.substring("<HTML>".length(), this._oldValue.length() - "</HTML>".length());
            if (string.startsWith("<B>") && string.endsWith("/B>")) {
                string = string.substring("<B>".length(), string.length() - "</B>".length());
                this._oldPrefix = this._oldPrefix + "<B>";
                this._oldPostfix = "</B>" + this._oldPostfix;
            }
            tabEditor.setText(string);
        } else {
            this._oldPrefix = "";
            this._oldPostfix = "";
            tabEditor.setText(this._oldValue);
        }
        tabEditor.selectAll();
        tabEditor.setForeground(this._tabPane.getForegroundAt(n));
    }

    protected Rectangle getTabsTextBoundsAt(int n) {
        Rectangle rectangle = this._tabPane.getBoundsAt(n);
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        if (rectangle.width < 200) {
            rectangle.width = 200;
        }
        String string = this.getCurrentDisplayTitleAt(this._tabPane, n);
        while (string == null || string.length() < 3) {
            string = string + " ";
        }
        Icon icon = this._tabPane.getIconForTab(n);
        Font font = this._tabPane.getFont();
        if (n == this._tabPane.getSelectedIndex() && this._tabPane.isBoldActiveTab()) {
            font = font.deriveFont(1);
        }
        SwingUtilities.layoutCompoundLabel(this._tabPane, this._tabPane.getGraphics().getFontMetrics(font), string, icon, 0, 0, 0, 11, rectangle, rectangle2, rectangle3, icon == null ? 0 : this._textIconGap);
        if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
            rectangle2.x = rectangle.x + this._iconMargin;
            rectangle3.x = icon != null ? rectangle2.x + rectangle2.width + this._textIconGap : rectangle.x + this._textPadding;
            rectangle3.width += 2;
        } else {
            rectangle2.y = rectangle.y + this._iconMargin;
            rectangle3.y = icon != null ? rectangle2.y + rectangle2.height + this._textIconGap : rectangle.y + this._textPadding;
            rectangle2.x = rectangle.x + 2;
            rectangle3.x = rectangle.x + 2;
            rectangle3.height += 2;
        }
        return rectangle3;
    }

    private void updateTab() {
        if (this._isEditing) {
            this.resizeEditor(this.getEditingTabIndex());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTab();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTab();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTab();
    }

    protected void resizeEditor(int n) {
        Rectangle rectangle = this.getTabsTextBoundsAt(n);
        if (rectangle.isEmpty()) {
            rectangle = new Rectangle(14, 3);
        }
        rectangle.x -= this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).left;
        rectangle.width = rectangle.width + this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).left + this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).right;
        rectangle.y -= this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).top;
        rectangle.height = rectangle.height + this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).top + this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).bottom;
        this._tabEditor.setBounds(SwingUtilities.convertRectangle(this._tabPane, rectangle, this.getTabPanel()));
        this._tabEditor.invalidate();
        this._tabEditor.validate();
        this._tabPane.doLayout();
        this.getTabPanel().getParent().getParent().repaint();
    }

    protected String getCurrentDisplayTitleAt(JideTabbedPane jideTabbedPane, int n) {
        String string = jideTabbedPane.getDisplayTitleAt(n);
        if (this._isEditing && n == this._editingTab) {
            string = this._tabEditor.getText();
        }
        return string;
    }

    public void startEditing(MouseEvent mouseEvent) {
        boolean bl;
        int n = this.tabForCoordinate(this._tabPane, mouseEvent.getX(), mouseEvent.getY());
        if (!mouseEvent.isPopupTrigger() && n >= 0 && this._tabPane.isEnabledAt(n) && this._tabPane.isTabEditingAllowed() && mouseEvent.getClickCount() == 2) {
            bl = true;
            if (this._tabPane.getTabEditingValidator() != null) {
                bl = this._tabPane.getTabEditingValidator().shouldStartEdit(n, mouseEvent);
            }
            if (bl) {
                mouseEvent.consume();
                this._tabPane.editTabAt(n);
            }
        }
        if (mouseEvent.getClickCount() == 1 && this._tabPane.isTabEditing()) {
            bl = true;
            if (this._tabPane.getTabEditingValidator() != null) {
                bl = this._tabPane.getTabEditingValidator().alertIfInvalid(n, this._oldPrefix + this._tabEditor.getText() + this._oldPostfix);
            }
            if (bl) {
                this._tabPane.stopTabEditing();
            }
        }
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        Rectangle rectangle3 = rectangleArray[n2];
        if (this._tabPane.hasFocus() && bl) {
            int n3;
            int n4;
            int n5;
            int n6;
            graphics.setColor(this._focus);
            switch (n) {
                case 2: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 5;
                    n3 = rectangle3.height - 6 - this.getTabGap();
                    break;
                }
                case 4: {
                    n6 = rectangle3.x + 2;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 5;
                    n3 = rectangle3.height - 6 - this.getTabGap();
                    break;
                }
                case 3: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 2;
                    n4 = rectangle3.width - 6 - this.getTabGap();
                    n3 = rectangle3.height - 5;
                    break;
                }
                default: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 6 - this.getTabGap();
                    n3 = rectangle3.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(graphics, n6, n5, n4, n3);
        }
    }

    protected boolean isRoundedCorner() {
        return "true".equals(SecurityUtils.getProperty("shadingtheme", "false"));
    }

    protected int getTabShape() {
        return this._tabPane.getTabShape();
    }

    protected int getTabResizeMode() {
        return this._tabPane.getTabResizeMode();
    }

    protected int getColorTheme() {
        return this._tabPane.getColorTheme();
    }

    protected int getLeftMargin() {
        if (this.getTabShape() == 4) {
            return 18;
        }
        if (this.getTabShape() == 8) {
            return 6;
        }
        return 0;
    }

    protected int getTabGap() {
        if (this.getTabShape() == 4) {
            return 4;
        }
        return 0;
    }

    protected int getLayoutSize() {
        int n = this.getTabShape();
        if (n == 8) {
            return 6;
        }
        if (n == 7) {
            return 15;
        }
        if (this._tabPane.getTabShape() == 5 || this._tabPane.getTabShape() == 10) {
            return 2;
        }
        if (n == 1 || n == 11) {
            return 6;
        }
        return 0;
    }

    protected int getTabRightPadding() {
        if (this.getTabShape() == 8) {
            return 4;
        }
        return 0;
    }

    protected MouseListener createMouseListener() {
        if (this.getTabShape() == 1 || this.getTabShape() == 11) {
            return new RolloverMouseHandler();
        }
        return new MouseHandler();
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        if (this.getTabShape() == 1 || this.getTabShape() == 11) {
            return new RolloverMouseMotionHandler();
        }
        return new MouseMotionHandler();
    }

    protected boolean isTabLeadingComponentVisible() {
        return this._tabPane.isTabShown() && this._tabLeadingComponent != null && this._tabLeadingComponent.isVisible();
    }

    protected boolean isTabTrailingComponentVisible() {
        return this._tabPane.isTabShown() && this._tabTrailingComponent != null && this._tabTrailingComponent.isVisible();
    }

    protected boolean isTabTopVisible(int n) {
        switch (n) {
            case 2: 
            case 4: {
                return this.isTabLeadingComponentVisible() && this._tabLeadingComponent.getPreferredSize().width > this.calculateMaxTabWidth(n) || this.isTabTrailingComponentVisible() && this._tabTrailingComponent.getPreferredSize().width > this.calculateMaxTabWidth(n);
            }
        }
        return this.isTabLeadingComponentVisible() && this._tabLeadingComponent.getPreferredSize().height > this.calculateMaxTabHeight(n) || this.isTabTrailingComponentVisible() && this._tabTrailingComponent.getPreferredSize().height > this.calculateMaxTabHeight(n);
    }

    protected boolean showFocusIndicator() {
        return this._tabPane.hasFocusComponent() && this._showFocusIndicator;
    }

    private int getNumberOfTabButtons() {
        int n;
        int n2 = n = !this.isShowTabButtons() || this.isShrinkTabs() ? 1 : 4;
        if (!this.isShowCloseButton() || this.isShowCloseButtonOnTab()) {
            --n;
        }
        return n;
    }

    protected String getResourceString(String string) {
        return Resource.getResourceBundle(this._tabPane != null ? this._tabPane.getLocale() : Locale.getDefault()).getString(string);
    }

    public class RolloverMouseHandler
    extends MouseHandler {
        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            int n = BasicJideTabbedPaneUI.this.tabForCoordinate(BasicJideTabbedPaneUI.this._tabPane, mouseEvent.getX(), mouseEvent.getY());
            BasicJideTabbedPaneUI.this._mouseEnter = true;
            BasicJideTabbedPaneUI.this._indexMouseOver = n;
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            BasicJideTabbedPaneUI.this._indexMouseOver = -1;
            BasicJideTabbedPaneUI.this._mouseEnter = false;
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }
    }

    public class RolloverMouseMotionHandler
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            int n = BasicJideTabbedPaneUI.this.tabForCoordinate(BasicJideTabbedPaneUI.this._tabPane, mouseEvent.getX(), mouseEvent.getY());
            if (n != BasicJideTabbedPaneUI.this._indexMouseOver) {
                BasicJideTabbedPaneUI.this._indexMouseOver = n;
                BasicJideTabbedPaneUI.this._tabPane.repaint();
            }
        }
    }

    public class DefaultMouseHandler
    extends MouseHandler {
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            int n = BasicJideTabbedPaneUI.this.getTabAtLocation(mouseEvent.getX(), mouseEvent.getY());
            BasicJideTabbedPaneUI.this._mouseEnter = true;
            BasicJideTabbedPaneUI.this._indexMouseOver = n;
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            BasicJideTabbedPaneUI.this._indexMouseOver = -1;
            BasicJideTabbedPaneUI.this._mouseEnter = false;
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }
    }

    public class DefaultMouseMotionHandler
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            int n = BasicJideTabbedPaneUI.this.getTabAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n != BasicJideTabbedPaneUI.this._indexMouseOver) {
                BasicJideTabbedPaneUI.this._indexMouseOver = n;
                BasicJideTabbedPaneUI.this._tabPane.repaint();
            }
        }
    }

    private class DropListener
    implements DropTargetListener {
        private DragOverTimer _timer;
        int _index = -1;

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (!BasicJideTabbedPaneUI.this._tabPane.isEnabled()) {
                return;
            }
            int n = BasicJideTabbedPaneUI.this.getTabAtLocation(dropTargetDragEvent.getLocation().x, dropTargetDragEvent.getLocation().y);
            if (n >= 0 && BasicJideTabbedPaneUI.this._tabPane.isEnabledAt(n)) {
                if (n != BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex() && n != this._index) {
                    this.stopTimer();
                    this.startTimer(n);
                    this._index = n;
                }
            } else {
                this.stopTimer();
            }
            dropTargetDragEvent.rejectDrag();
        }

        private void startTimer(int n) {
            this._timer = new DragOverTimer(n);
            this._timer.start();
        }

        private void stopTimer() {
            if (this._timer != null) {
                this._timer.stop();
                this._timer = null;
                this._index = -1;
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            this.stopTimer();
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            this.stopTimer();
        }
    }

    private class DragOverTimer
    extends Timer
    implements ActionListener {
        private int _index;

        public DragOverTimer(int n) {
            super(500, null);
            this._index = n;
            this.addActionListener(this);
            this.setRepeats(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicJideTabbedPaneUI.this._tabPane.getTabCount() == 0) {
                return;
            }
            if (this._index == BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex()) {
                if (BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled()) {
                    BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow();
                    BasicJideTabbedPaneUI.this._tabPane.repaint(BasicJideTabbedPaneUI.this.getTabBounds(BasicJideTabbedPaneUI.this._tabPane, this._index));
                }
            } else {
                if (BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled()) {
                    BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow();
                }
                BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(this._index);
            }
            this.stop();
        }
    }

    protected class TabEditor
    extends JTextField
    implements UIResource {
        TabEditor() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createCompoundBorder(new PartialLineBorder(Color.BLACK, 1, true), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
        }

        public boolean stopEditing() {
            return true;
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            Color color = graphics2D.getColor();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
            Object object = JideSwingUtilities.setupShapeAntialiasing(graphics);
            graphics2D.setColor(this.getBackground());
            graphics.fillRoundRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, 1, 1);
            JideSwingUtilities.restoreShapeAntialiasing(graphics, object);
            graphics2D.setColor(color);
            graphics2D.setComposite(composite);
            super.paintComponent(graphics);
        }
    }

    public static class TabSpaceAllocator {
        static final int startOffset = 4;
        private Insets insets = null;
        static final int tabWidth = 24;
        static final int textIconGap = 8;
        private AbstractTab[] tabs;

        private void setInsets(Insets insets) {
            this.insets = (Insets)insets.clone();
        }

        private void init(Rectangle[] rectangleArray, Insets insets) {
            this.setInsets(insets);
            this.tabs = new AbstractTab[rectangleArray.length];
            for (int i = 0; i < rectangleArray.length; ++i) {
                this.tabs[i] = new AbstractTab();
                this.tabs[i].id = i;
                this.tabs[i].width = rectangleArray[i].width;
            }
            this.tabSort();
        }

        private void bestfit(AbstractTab[] abstractTabArray, int n, int n2) {
            int n3 = abstractTabArray.length;
            int n4 = abstractTabArray[n2].width;
            int n5 = n2;
            if (n2 == n3 - 1) {
                abstractTabArray[n2].width = n;
                return;
            }
            int n6 = n / (n3 - n2);
            while (n4 < n6) {
                n -= n4;
                if (++n2 < n3 - 1) {
                    n4 = abstractTabArray[n2].width;
                    continue;
                }
                abstractTabArray[n2].width = n6;
                return;
            }
            if (n2 == n5) {
                for (int i = n2; i < n3; ++i) {
                    abstractTabArray[i].width = n6;
                }
            } else if (n2 < n3 - 1) {
                this.bestfit(abstractTabArray, n, n2);
            }
        }

        private void tabSort() {
            int n = this.tabs.length;
            AbstractTab abstractTab = new AbstractTab();
            for (int i = 0; i < n - 1; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    if (this.tabs[i].width <= this.tabs[j].width) continue;
                    abstractTab.copy(this.tabs[j]);
                    this.tabs[j].copy(this.tabs[i]);
                    this.tabs[i].copy(abstractTab);
                }
            }
        }

        private void outpush(Rectangle[] rectangleArray) {
            for (AbstractTab abstractTab : this.tabs) {
                rectangleArray[abstractTab.id].width = abstractTab.width;
            }
            rectangleArray[0].x = 4;
            for (int i = 1; i < rectangleArray.length; ++i) {
                rectangleArray[i].x = rectangleArray[i - 1].x + rectangleArray[i - 1].width;
            }
        }

        public void reArrange(Rectangle[] rectangleArray, Insets insets, int n) {
            this.init(rectangleArray, insets);
            this.bestfit(this.tabs, n, 0);
            this.outpush(rectangleArray);
            this.clearup();
        }

        private void clearup() {
            for (int i = 0; i < this.tabs.length; ++i) {
                this.tabs[i] = null;
            }
            this.tabs = null;
        }
    }

    static class AbstractTab {
        int width;
        int id;

        AbstractTab() {
        }

        public void copy(AbstractTab abstractTab) {
            this.width = abstractTab.width;
            this.id = abstractTab.id;
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            JideTabbedPane jideTabbedPane = (JideTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource || component == jideTabbedPane.getTabLeadingComponent() || component == jideTabbedPane.getTabTrailingComponent()) {
                return;
            }
            int n = jideTabbedPane.indexOfComponent(component);
            String string = BasicJideTabbedPaneUI.this.getCurrentDisplayTitleAt(jideTabbedPane, n);
            boolean bl = BasicHTML.isHTMLString(string);
            if (bl) {
                if (BasicJideTabbedPaneUI.this.htmlViews == null) {
                    BasicJideTabbedPaneUI.this.htmlViews = BasicJideTabbedPaneUI.this.createHTMLVector();
                } else {
                    View view = BasicHTML.createHTMLView(jideTabbedPane, string);
                    BasicJideTabbedPaneUI.this.htmlViews.insertElementAt(view, n);
                }
            } else if (BasicJideTabbedPaneUI.this.htmlViews != null) {
                BasicJideTabbedPaneUI.this.htmlViews.insertElementAt(null, n);
            }
            if (BasicJideTabbedPaneUI.this._tabPane.isTabEditing()) {
                ((BasicJideTabbedPaneUI)BasicJideTabbedPaneUI.this._tabPane.getUI()).stopOrCancelEditing();
            }
            BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            JideTabbedPane jideTabbedPane = (JideTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource || component == jideTabbedPane.getTabLeadingComponent() || component == jideTabbedPane.getTabTrailingComponent()) {
                return;
            }
            Integer n = (Integer)jideTabbedPane.getClientProperty("__index_to_remove__");
            if (n != null) {
                if (BasicJideTabbedPaneUI.this.htmlViews != null && BasicJideTabbedPaneUI.this.htmlViews.size() >= n) {
                    BasicJideTabbedPaneUI.this.htmlViews.removeElementAt(n);
                }
                jideTabbedPane.putClientProperty("__index_to_remove__", null);
            }
            if (BasicJideTabbedPaneUI.this._tabPane.isTabEditing()) {
                ((BasicJideTabbedPaneUI)BasicJideTabbedPaneUI.this._tabPane.getUI()).stopOrCancelEditing();
            }
            BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
        }
    }

    private class ComponentHandler
    implements ComponentListener {
        private ComponentHandler() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                BasicJideTabbedPaneUI.this._tabScroller.viewport.setViewSize(new Dimension(BasicJideTabbedPaneUI.this._tabPane.getWidth(), BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewSize().height));
                BasicJideTabbedPaneUI.this.ensureActiveTabIsVisible(true);
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }
    }

    public class MouseWheelHandler
    implements MouseWheelListener {
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            block3: {
                block4: {
                    block2: {
                        if (!BasicJideTabbedPaneUI.this._tabPane.isScrollSelectedTabOnWheel()) break block2;
                        BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(Math.min(BasicJideTabbedPaneUI.this._tabPane.getTabCount() - 1, Math.max(0, BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex() + mouseWheelEvent.getWheelRotation())));
                        break block3;
                    }
                    if (!BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled() || mouseWheelEvent.getWheelRotation() == 0) break block3;
                    if (mouseWheelEvent.getWheelRotation() <= 0) break block4;
                    for (int i = 0; i < mouseWheelEvent.getScrollAmount(); ++i) {
                        BasicJideTabbedPaneUI.this._tabScroller.scrollForward(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement());
                    }
                    break block3;
                }
                if (mouseWheelEvent.getWheelRotation() >= 0) break block3;
                for (int i = 0; i < mouseWheelEvent.getScrollAmount(); ++i) {
                    BasicJideTabbedPaneUI.this._tabScroller.scrollBackward(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement());
                }
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (BasicJideTabbedPaneUI.this._tabPane == null || !BasicJideTabbedPaneUI.this._tabPane.isEnabled()) {
                return;
            }
            if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                int n = BasicJideTabbedPaneUI.this.tabForCoordinate(BasicJideTabbedPaneUI.this._tabPane, mouseEvent.getX(), mouseEvent.getY());
                Action action = BasicJideTabbedPaneUI.this.getActionMap().get("closeTabAction");
                if (action != null && n >= 0 && BasicJideTabbedPaneUI.this._tabPane.isEnabledAt(n) && BasicJideTabbedPaneUI.this._tabPane.isCloseTabOnMouseMiddleButton() && BasicJideTabbedPaneUI.this._tabPane.isTabClosableAt(n)) {
                    ActionEvent actionEvent = new ActionEvent(BasicJideTabbedPaneUI.this._tabPane, n, "middleMouseButtonClicked");
                    action.actionPerformed(actionEvent);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            if (BasicJideTabbedPaneUI.this._tabPane == null || !BasicJideTabbedPaneUI.this._tabPane.isEnabled()) {
                return;
            }
            if ((SwingUtilities.isLeftMouseButton(mouseEvent) || BasicJideTabbedPaneUI.this._tabPane.isRightClickSelect()) && (n = BasicJideTabbedPaneUI.this.tabForCoordinate(BasicJideTabbedPaneUI.this._tabPane, mouseEvent.getX(), mouseEvent.getY())) >= 0 && BasicJideTabbedPaneUI.this._tabPane.isEnabledAt(n)) {
                if (n == BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex() && JideSwingUtilities.isAncestorOfFocusOwner(BasicJideTabbedPaneUI.this._tabPane)) {
                    if (BasicJideTabbedPaneUI.this._tabPane.isAutoFocusOnTabHideClose() && BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled()) {
                        BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                    }
                } else {
                    BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(n);
                    BasicJideTabbedPaneUI.this._tabPane.processMouseSelection(n, mouseEvent);
                    final Component component = BasicJideTabbedPaneUI.this._tabPane.getComponentAt(n);
                    if (BasicJideTabbedPaneUI.this._tabPane.isAutoFocusOnTabHideClose() && !component.isVisible() && SystemInfo.isJdk15Above() && !SystemInfo.isJdk6Above()) {
                        component.addComponentListener(new ComponentAdapter(){

                            public void componentShown(ComponentEvent componentEvent) {
                                component.removeComponentListener(this);
                                Component component2 = BasicJideTabbedPaneUI.this._tabPane.getLastFocusedComponent(component);
                                if (component2 != null) {
                                    component2.requestFocus();
                                } else if (BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled()) {
                                    BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                                }
                            }
                        });
                    } else {
                        Component component2 = BasicJideTabbedPaneUI.this._tabPane.getLastFocusedComponent(component);
                        if (component2 != null) {
                            component2.requestFocus();
                        } else {
                            boolean bl = JideSwingUtilities.compositeRequestFocus(component);
                            if (!bl) {
                                BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                            }
                        }
                    }
                }
            }
            if (!BasicJideTabbedPaneUI.this.isTabEditing()) {
                BasicJideTabbedPaneUI.this.startEditing(mouseEvent);
            }
        }
    }

    public class MouseMotionHandler
    extends MouseMotionAdapter {
    }

    public class TabFocusListener
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            this.repaintSelectedTab();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintSelectedTab();
        }

        private void repaintSelectedTab() {
            Rectangle rectangle;
            if (BasicJideTabbedPaneUI.this._tabPane.getTabCount() > 0 && (rectangle = BasicJideTabbedPaneUI.this.getTabBounds(BasicJideTabbedPaneUI.this._tabPane, BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex())) != null) {
                BasicJideTabbedPaneUI.this._tabPane.repaint(rectangle);
            }
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            ((BasicJideTabbedPaneUI)BasicJideTabbedPaneUI.this._tabPane.getUI()).stopOrCancelEditing();
            BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
            BasicJideTabbedPaneUI.this.ensureActiveTabIsVisible(false);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if ("mnemonicAt".equals(string)) {
                BasicJideTabbedPaneUI.this.updateMnemonics();
                jTabbedPane.repaint();
            } else if ("displayedMnemonicIndexAt".equals(string)) {
                jTabbedPane.repaint();
            } else if (string.equals("indexForTitle")) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                String string2 = BasicJideTabbedPaneUI.this.getCurrentDisplayTitleAt(BasicJideTabbedPaneUI.this._tabPane, n);
                if (BasicHTML.isHTMLString(string2)) {
                    if (BasicJideTabbedPaneUI.this.htmlViews == null) {
                        BasicJideTabbedPaneUI.this.htmlViews = BasicJideTabbedPaneUI.this.createHTMLVector();
                    } else {
                        View view = BasicHTML.createHTMLView(BasicJideTabbedPaneUI.this._tabPane, string2);
                        BasicJideTabbedPaneUI.this.htmlViews.setElementAt(view, n);
                    }
                } else if (BasicJideTabbedPaneUI.this.htmlViews != null && BasicJideTabbedPaneUI.this.htmlViews.elementAt(n) != null) {
                    BasicJideTabbedPaneUI.this.htmlViews.setElementAt(null, n);
                }
                BasicJideTabbedPaneUI.this.updateMnemonics();
                if (BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                    BasicJideTabbedPaneUI.this._tabScroller.viewport.setViewSize(new Dimension(BasicJideTabbedPaneUI.this._tabPane.getWidth(), BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewSize().height));
                    BasicJideTabbedPaneUI.this.ensureActiveTabIsVisible(false);
                }
            } else if (string.equals("tabLayoutPolicy")) {
                BasicJideTabbedPaneUI.this._tabPane.updateUI();
            } else if (string.equals("closeTabAction")) {
                BasicJideTabbedPaneUI.this.updateCloseAction();
            } else if (string.equals("dragOverDisabled")) {
                BasicJideTabbedPaneUI.this._tabPane.updateUI();
            } else if (string.equals("tabColorProvider")) {
                BasicJideTabbedPaneUI.this._tabPane.repaint();
            } else if (string.equals("locale")) {
                BasicJideTabbedPaneUI.this._tabPane.updateUI();
            } else if (string.equals("boldActiveTab")) {
                BasicJideTabbedPaneUI.this.getTabPanel().invalidate();
                BasicJideTabbedPaneUI.this._tabPane.invalidate();
                if (BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                    BasicJideTabbedPaneUI.this._tabScroller.viewport.setViewSize(new Dimension(BasicJideTabbedPaneUI.this._tabPane.getWidth(), BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewSize().height));
                    BasicJideTabbedPaneUI.this.ensureActiveTabIsVisible(true);
                }
            } else if (string.equals("tabLeadingComponent")) {
                BasicJideTabbedPaneUI.this.ensureCurrentLayout();
                if (BasicJideTabbedPaneUI.this._tabLeadingComponent != null) {
                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setVisible(false);
                    BasicJideTabbedPaneUI.this._tabPane.remove(BasicJideTabbedPaneUI.this._tabLeadingComponent);
                }
                BasicJideTabbedPaneUI.this._tabLeadingComponent = (Component)propertyChangeEvent.getNewValue();
                if (BasicJideTabbedPaneUI.this._tabLeadingComponent != null) {
                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setVisible(true);
                    BasicJideTabbedPaneUI.this._tabPane.add(BasicJideTabbedPaneUI.this._tabLeadingComponent);
                }
                BasicJideTabbedPaneUI.this._tabScroller.tabPanel.updateUI();
            } else if (string.equals("tabTrailingComponent")) {
                BasicJideTabbedPaneUI.this.ensureCurrentLayout();
                if (BasicJideTabbedPaneUI.this._tabTrailingComponent != null) {
                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setVisible(false);
                    BasicJideTabbedPaneUI.this._tabPane.remove(BasicJideTabbedPaneUI.this._tabTrailingComponent);
                }
                BasicJideTabbedPaneUI.this._tabTrailingComponent = (Component)propertyChangeEvent.getNewValue();
                if (BasicJideTabbedPaneUI.this._tabTrailingComponent != null) {
                    BasicJideTabbedPaneUI.this._tabPane.add(BasicJideTabbedPaneUI.this._tabTrailingComponent);
                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setVisible(true);
                }
                BasicJideTabbedPaneUI.this._tabScroller.tabPanel.updateUI();
            } else if (string.equals("shrinkTab") || string.equals("hideIfOneTab") || string.equals("showTabArea") || string.equals("showTabContent") || string.equals("boxStyle") || string.equals("showIconsOnTab") || string.equals("showCloseButton") || string.equals("useDefaultShowIconsOnTab") || string.equals("showCloseButtonOnTab") || string.equals("useDefaultShowCloseButtonOnTab") || string.equals("tabClosable") || string.equals("tabShape") || string.equals("colorTheme") || string.equals("tabResizeMode") || string.equals("showTabButtons")) {
                if ((string.equals("useDefaultShowCloseButtonOnTab") || string.equals("showCloseButtonOnTab")) && BasicJideTabbedPaneUI.this.isShowCloseButton() && BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab()) {
                    BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
                }
                BasicJideTabbedPaneUI.this._tabPane.updateUI();
            }
        }
    }

    public class TabCloseButton
    extends JButton
    implements MouseMotionListener,
    MouseListener,
    UIResource {
        public static final int CLOSE_BUTTON = 0;
        public static final int EAST_BUTTON = 1;
        public static final int WEST_BUTTON = 2;
        public static final int NORTH_BUTTON = 3;
        public static final int SOUTH_BUTTON = 4;
        public static final int LIST_BUTTON = 5;
        private int _type;
        private int _index = -1;
        private boolean _mouseOver = false;
        private boolean _mousePressed = false;

        public void updateUI() {
            super.updateUI();
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
            String string = this.getName();
            if (string != null) {
                this.setToolTipText(BasicJideTabbedPaneUI.this.getResourceString(string));
            }
        }

        public TabCloseButton() {
            this(0);
        }

        public TabCloseButton(int n) {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.setType(n);
        }

        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public int getIndex() {
            return this._index;
        }

        public void setIndex(int n) {
            this._index = n;
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        protected void paintComponent(Graphics graphics) {
            if (!this.isEnabled()) {
                this.setMouseOver(false);
                this.setMousePressed(false);
            }
            if (this.isMouseOver() && this.isMousePressed()) {
                graphics.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                graphics.drawLine(0, 0, this.getWidth() - 1, 0);
                graphics.drawLine(0, this.getHeight() - 2, 0, 1);
                graphics.setColor(UIDefaultsLookup.getColor("control"));
                graphics.drawLine(this.getWidth() - 1, 1, this.getWidth() - 1, this.getHeight() - 2);
                graphics.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
            } else if (this.isMouseOver()) {
                graphics.setColor(UIDefaultsLookup.getColor("control"));
                graphics.drawLine(0, 0, this.getWidth() - 1, 0);
                graphics.drawLine(0, this.getHeight() - 2, 0, 1);
                graphics.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                graphics.drawLine(this.getWidth() - 1, 1, this.getWidth() - 1, this.getHeight() - 2);
                graphics.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
            }
            graphics.setColor(UIDefaultsLookup.getColor("controlShadow").darker());
            int n = this.getWidth() >> 1;
            int n2 = this.getHeight() >> 1;
            switch (this.getType()) {
                case 0: {
                    if (this.isEnabled()) {
                        graphics.drawLine(n - 3, n2 - 3, n + 3, n2 + 3);
                        graphics.drawLine(n - 4, n2 - 3, n + 2, n2 + 3);
                        graphics.drawLine(n + 3, n2 - 3, n - 3, n2 + 3);
                        graphics.drawLine(n + 2, n2 - 3, n - 4, n2 + 3);
                        break;
                    }
                    graphics.drawLine(n - 3, n2 - 3, n + 3, n2 + 3);
                    graphics.drawLine(n + 3, n2 - 3, n - 3, n2 + 3);
                    break;
                }
                case 1: {
                    if (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 1 || BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3) {
                        int n3 = n + 2;
                        int n4 = n2;
                        if (this.isEnabled()) {
                            graphics.drawLine(n3 - 4, n4 - 4, n3 - 4, n4 + 4);
                            graphics.drawLine(n3 - 3, n4 - 3, n3 - 3, n4 + 3);
                            graphics.drawLine(n3 - 2, n4 - 2, n3 - 2, n4 + 2);
                            graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, n4 + 1);
                            graphics.drawLine(n3, n4, n3, n4);
                            break;
                        }
                        graphics.drawLine(n3 - 4, n4 - 4, n3, n4);
                        graphics.drawLine(n3 - 4, n4 - 4, n3 - 4, n4 + 4);
                        graphics.drawLine(n3 - 4, n4 + 4, n3, n4);
                        break;
                    }
                    int n5 = n + 3;
                    int n6 = n2 - 2;
                    if (this.isEnabled()) {
                        graphics.drawLine(n5 - 8, n6, n5, n6);
                        graphics.drawLine(n5 - 7, n6 + 1, n5 - 1, n6 + 1);
                        graphics.drawLine(n5 - 6, n6 + 2, n5 - 2, n6 + 2);
                        graphics.drawLine(n5 - 5, n6 + 3, n5 - 3, n6 + 3);
                        graphics.drawLine(n5 - 4, n6 + 4, n5 - 4, n6 + 4);
                        break;
                    }
                    graphics.drawLine(n5 - 8, n6, n5, n6);
                    graphics.drawLine(n5 - 8, n6, n5 - 4, n6 + 4);
                    graphics.drawLine(n5 - 4, n6 + 4, n5, n6);
                    break;
                }
                case 2: {
                    if (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 1 || BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3) {
                        int n7 = n - 3;
                        int n8 = n2;
                        if (this.isEnabled()) {
                            graphics.drawLine(n7, n8, n7, n8);
                            graphics.drawLine(n7 + 1, n8 - 1, n7 + 1, n8 + 1);
                            graphics.drawLine(n7 + 2, n8 - 2, n7 + 2, n8 + 2);
                            graphics.drawLine(n7 + 3, n8 - 3, n7 + 3, n8 + 3);
                            graphics.drawLine(n7 + 4, n8 - 4, n7 + 4, n8 + 4);
                            break;
                        }
                        graphics.drawLine(n7, n8, n7 + 4, n8 - 4);
                        graphics.drawLine(n7, n8, n7 + 4, n8 + 4);
                        graphics.drawLine(n7 + 4, n8 - 4, n7 + 4, n8 + 4);
                        break;
                    }
                    int n9 = n - 5;
                    int n10 = n2 + 3;
                    if (this.isEnabled()) {
                        graphics.drawLine(n9, n10, n9 + 8, n10);
                        graphics.drawLine(n9 + 1, n10 - 1, n9 + 7, n10 - 1);
                        graphics.drawLine(n9 + 2, n10 - 2, n9 + 6, n10 - 2);
                        graphics.drawLine(n9 + 3, n10 - 3, n9 + 5, n10 - 3);
                        graphics.drawLine(n9 + 4, n10 - 4, n9 + 4, n10 - 4);
                        break;
                    }
                    graphics.drawLine(n9, n10, n9 + 8, n10);
                    graphics.drawLine(n9, n10, n9 + 4, n10 - 4);
                    graphics.drawLine(n9 + 8, n10, n9 + 4, n10 - 4);
                    break;
                }
                case 5: {
                    int n11 = n + 2;
                    int n12 = n2;
                    graphics.drawLine(n11 - 6, n12 - 4, n11 - 6, n12 + 4);
                    graphics.drawLine(n11 + 1, n12 - 4, n11 + 1, n12 + 4);
                    graphics.drawLine(n11 - 6, n12 - 4, n11 + 1, n12 - 4);
                    graphics.drawLine(n11 - 4, n12 - 2, n11 - 1, n12 - 2);
                    graphics.drawLine(n11 - 4, n12, n11 - 1, n12);
                    graphics.drawLine(n11 - 4, n12 + 2, n11 - 1, n12 + 2);
                    graphics.drawLine(n11 - 6, n12 + 4, n11 + 1, n12 + 4);
                    break;
                }
            }
        }

        public boolean isFocusable() {
            return false;
        }

        public void requestFocus() {
        }

        public boolean isOpaque() {
            return false;
        }

        public boolean scrollsForward() {
            return this.getType() == 1 || this.getType() == 4;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(true);
            this.repaint();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(true);
            this.setMousePressed(false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMousePressed(true);
            this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMousePressed(false);
            this.setMouseOver(false);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(true);
            this.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(false);
            this.setMousePressed(false);
            this.repaint();
            BasicJideTabbedPaneUI.this._tabScroller.tabPanel.repaint();
        }

        public int getType() {
            return this._type;
        }

        public void setType(int n) {
            this._type = n;
        }

        public boolean isMouseOver() {
            return this._mouseOver;
        }

        public void setMouseOver(boolean bl) {
            this._mouseOver = bl;
        }

        public boolean isMousePressed() {
            return this._mousePressed;
        }

        public void setMousePressed(boolean bl) {
            this._mousePressed = bl;
        }
    }

    public class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            this.setLayout(null);
        }

        public boolean isOpaque() {
            return false;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (BasicJideTabbedPaneUI.this._tabPane.isOpaque()) {
                if (BasicJideTabbedPaneUI.this.getTabShape() == 3) {
                    graphics.setColor(UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackground"));
                } else {
                    graphics.setColor(UIDefaultsLookup.getColor("JideTabbedPane.tabAreaBackground"));
                }
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            BasicJideTabbedPaneUI.this.paintTabArea(graphics, BasicJideTabbedPaneUI.this._tabPane.getTabPlacement(), BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex(), this);
        }

        public void setToolTipText(String string) {
            BasicJideTabbedPaneUI.this._tabPane.setToolTipText(string);
        }

        public String getToolTipText() {
            return BasicJideTabbedPaneUI.this._tabPane.getToolTipText();
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            return BasicJideTabbedPaneUI.this._tabPane.getToolTipText(SwingUtilities.convertMouseEvent(this, mouseEvent, BasicJideTabbedPaneUI.this._tabPane));
        }

        public Point getToolTipLocation(MouseEvent mouseEvent) {
            return BasicJideTabbedPaneUI.this._tabPane.getToolTipLocation(SwingUtilities.convertMouseEvent(this, mouseEvent, BasicJideTabbedPaneUI.this._tabPane));
        }

        public JToolTip createToolTip() {
            return BasicJideTabbedPaneUI.this._tabPane.createToolTip();
        }
    }

    public class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setScrollMode(0);
            this.setOpaque(false);
        }

        public Color getBackground() {
            return UIDefaultsLookup.getColor("JideTabbedPane.background");
        }
    }

    public class ScrollableTabSupport
    implements ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public TabCloseButton scrollForwardButton;
        public TabCloseButton scrollBackwardButton;
        public TabCloseButton listButton;
        public TabCloseButton closeButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);
        public JidePopup _popup;

        ScrollableTabSupport(int n) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            this.scrollForwardButton = BasicJideTabbedPaneUI.this.createNoFocusButton(1);
            this.scrollForwardButton.setName(BasicJideTabbedPaneUI.BUTTON_NAME_SCROLL_FORWARD);
            this.scrollBackwardButton = BasicJideTabbedPaneUI.this.createNoFocusButton(2);
            this.scrollBackwardButton.setName(BasicJideTabbedPaneUI.BUTTON_NAME_SCROLL_BACKWARD);
            this.scrollForwardButton.setBackground(this.viewport.getBackground());
            this.scrollBackwardButton.setBackground(this.viewport.getBackground());
            this.listButton = BasicJideTabbedPaneUI.this.createNoFocusButton(5);
            this.listButton.setName(BasicJideTabbedPaneUI.BUTTON_NAME_TAB_LIST);
            this.listButton.setBackground(this.viewport.getBackground());
            this.closeButton = BasicJideTabbedPaneUI.this.createNoFocusButton(0);
            this.closeButton.setName(BasicJideTabbedPaneUI.BUTTON_NAME_CLOSE);
            this.closeButton.setBackground(this.viewport.getBackground());
        }

        public void createPopupMenu(int n) {
            Serializable serializable;
            JPopupMenu jPopupMenu = new JPopupMenu();
            int n2 = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            int n3 = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            for (int i = 0; i < n2; ++i) {
                if (!BasicJideTabbedPaneUI.this._tabPane.isEnabledAt(i)) continue;
                serializable = new JCheckBoxMenuItem(new ActivateTabAction(BasicJideTabbedPaneUI.this._tabPane.getTitleAt(i), BasicJideTabbedPaneUI.this._tabPane.getIconForTab(i), i));
                jPopupMenu.add((JMenuItem)serializable);
                ((JComponent)serializable).setToolTipText(BasicJideTabbedPaneUI.this._tabPane.getToolTipTextAt(i));
                ((AbstractButton)serializable).setSelected(n3 == i);
                ((AbstractButton)serializable).setHorizontalTextPosition(4);
            }
            Dimension dimension = jPopupMenu.getPreferredSize();
            serializable = this.listButton.getBounds();
            switch (n) {
                case 1: {
                    jPopupMenu.show(BasicJideTabbedPaneUI.this._tabPane, ((Rectangle)serializable).x + ((Rectangle)serializable).width - dimension.width, ((Rectangle)serializable).y + ((Rectangle)serializable).height);
                    break;
                }
                case 3: {
                    jPopupMenu.show(BasicJideTabbedPaneUI.this._tabPane, ((Rectangle)serializable).x + ((Rectangle)serializable).width - dimension.width, ((Rectangle)serializable).y - dimension.height);
                    break;
                }
                case 2: {
                    jPopupMenu.show(BasicJideTabbedPaneUI.this._tabPane, ((Rectangle)serializable).x + ((Rectangle)serializable).width, ((Rectangle)serializable).y + ((Rectangle)serializable).height - dimension.height);
                    break;
                }
                case 4: {
                    jPopupMenu.show(BasicJideTabbedPaneUI.this._tabPane, ((Rectangle)serializable).x - dimension.width, ((Rectangle)serializable).y + ((Rectangle)serializable).height - dimension.height);
                }
            }
        }

        public void createPopup(int n) {
            int n2;
            int n3;
            final JList jList = new JList(){

                public void removeSelectionInterval(int n, int n2) {
                    super.removeSelectionInterval(n, n2);
                    if (this.getSelectedIndex() == -1) {
                        this.setSelectedIndex(n);
                    }
                }

                public Dimension getPreferredScrollableViewportSize() {
                    Dimension dimension = super.getPreferredScrollableViewportSize();
                    if (dimension.width < 150) {
                        dimension.width = 150;
                    }
                    return dimension;
                }
            };
            new Sticky(jList);
            jList.setBackground(BasicJideTabbedPaneUI.this._tabListBackground);
            JScrollPane jScrollPane = new JScrollPane(jList);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jScrollPane.getViewport().setOpaque(false);
            jScrollPane.setOpaque(false);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBackground(BasicJideTabbedPaneUI.this._tabListBackground);
            jPanel.setOpaque(true);
            jPanel.add(jScrollPane);
            jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            if (this._popup != null) {
                if (this._popup.isPopupVisible()) {
                    this._popup.hidePopupImmediately();
                }
                this._popup = null;
            }
            this._popup = JidePopupFactory.getSharedInstance().createPopup();
            this._popup.setPopupBorder(BorderFactory.createLineBorder(BasicJideTabbedPaneUI.this._darkShadow));
            this._popup.add(jPanel);
            this._popup.addExcludedComponent(this.listButton);
            this._popup.setDefaultFocusComponent(jList);
            DefaultListModel<JideTabbedPane> defaultListModel = new DefaultListModel<JideTabbedPane>();
            int n4 = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            int n5 = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            for (int i = 0; i < n5; ++i) {
                defaultListModel.addElement(BasicJideTabbedPaneUI.this._tabPane);
            }
            jList.setCellRenderer(BasicJideTabbedPaneUI.this.getTabListCellRenderer());
            jList.setModel(defaultListModel);
            jList.setSelectedIndex(n4);
            jList.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    int n = jList.getSelectedIndex();
                    if (n != -1 && BasicJideTabbedPaneUI.this._tabPane.isEnabledAt(n)) {
                        if (n == BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex() && JideSwingUtilities.isAncestorOfFocusOwner(BasicJideTabbedPaneUI.this._tabPane)) {
                            if (BasicJideTabbedPaneUI.this._tabPane.isAutoFocusOnTabHideClose() && BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled()) {
                                Runnable runnable = new Runnable(){

                                    public void run() {
                                        BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                                    }
                                };
                                SwingUtilities.invokeLater(runnable);
                            }
                        } else {
                            BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(n);
                            final Component component = BasicJideTabbedPaneUI.this._tabPane.getComponentAt(n);
                            if (BasicJideTabbedPaneUI.this._tabPane.isAutoFocusOnTabHideClose() && !component.isVisible() && SystemInfo.isJdk15Above() && !SystemInfo.isJdk6Above()) {
                                component.addComponentListener(new ComponentAdapter(){

                                    public void componentShown(ComponentEvent componentEvent) {
                                        component.removeComponentListener(this);
                                        final Component component2 = BasicJideTabbedPaneUI.this._tabPane.getLastFocusedComponent(component);
                                        Runnable runnable = new Runnable(){

                                            public void run() {
                                                if (component2 != null) {
                                                    component2.requestFocus();
                                                } else if (BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled()) {
                                                    BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                                                }
                                            }
                                        };
                                        SwingUtilities.invokeLater(runnable);
                                    }
                                });
                            } else {
                                final Component component2 = BasicJideTabbedPaneUI.this._tabPane.getLastFocusedComponent(component);
                                if (component2 != null) {
                                    Runnable runnable = new Runnable(){

                                        public void run() {
                                            component2.requestFocus();
                                        }
                                    };
                                    SwingUtilities.invokeLater(runnable);
                                } else {
                                    Component component3;
                                    Container container = component instanceof Container ? (Container)component : component.getFocusCycleRootAncestor();
                                    FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
                                    if (focusTraversalPolicy != null) {
                                        component3 = focusTraversalPolicy.getDefaultComponent(container);
                                        if (component3 == null) {
                                            component3 = focusTraversalPolicy.getFirstComponent(container);
                                        }
                                    } else {
                                        component3 = component instanceof Container ? this.findFocusableComponent((Container)component) : component;
                                    }
                                    if (component3 != null) {
                                        final Component component4 = component3;
                                        Runnable runnable = new Runnable(){

                                            public void run() {
                                                component4.requestFocus();
                                            }
                                        };
                                        SwingUtilities.invokeLater(runnable);
                                    }
                                }
                            }
                        }
                        BasicJideTabbedPaneUI.this.ensureActiveTabIsVisible(false);
                        ScrollableTabSupport.this._popup.hidePopupImmediately();
                        ScrollableTabSupport.this._popup = null;
                    }
                }

                private Component findFocusableComponent(Container container) {
                    FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
                    Component component = null;
                    if (focusTraversalPolicy != null && (component = focusTraversalPolicy.getDefaultComponent(container)) == null) {
                        component = focusTraversalPolicy.getFirstComponent(container);
                    }
                    if (component != null) {
                        return component;
                    }
                    for (int i = 0; i < container.getComponentCount(); ++i) {
                        Component component2 = container.getComponent(i);
                        if (component2 instanceof Container) {
                            component = this.findFocusableComponent((Container)component2);
                            if (component == null) continue;
                            return component;
                        }
                        if (!component2.isFocusable()) continue;
                        return component2;
                    }
                    if (container.isFocusable()) {
                        return container;
                    }
                    return null;
                }
            });
            jList.setSelectionMode(0);
            Insets insets = jPanel.getInsets();
            int n6 = (PortingUtils.getLocalScreenSize((Component)BasicJideTabbedPaneUI.this._tabPane).height - insets.top - insets.bottom) / jList.getCellBounds((int)0, (int)0).height;
            if (defaultListModel.getSize() > n6) {
                jList.setVisibleRowCount(n6);
            } else {
                jList.setVisibleRowCount(defaultListModel.getSize());
            }
            this._popup.setOwner(BasicJideTabbedPaneUI.this._tabPane);
            this._popup.removeExcludedComponent(BasicJideTabbedPaneUI.this._tabPane);
            Dimension dimension = this._popup.getPreferredSize();
            Rectangle rectangle = this.listButton.getBounds();
            Point point = this.listButton.getLocationOnScreen();
            rectangle.x = point.x;
            rectangle.y = point.y;
            switch (n) {
                default: {
                    n3 = BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight() ? rectangle.x + rectangle.width - dimension.width : rectangle.x;
                    n2 = rectangle.y + rectangle.height + 2;
                    break;
                }
                case 3: {
                    n3 = BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight() ? rectangle.x + rectangle.width - dimension.width : rectangle.x;
                    n2 = rectangle.y - dimension.height - 2;
                    break;
                }
                case 2: {
                    n3 = rectangle.x + rectangle.width + 2;
                    n2 = rectangle.y + rectangle.height - dimension.height;
                    break;
                }
                case 4: {
                    n3 = rectangle.x - dimension.width - 2;
                    n2 = rectangle.y + rectangle.height - dimension.height;
                }
            }
            Rectangle rectangle2 = PortingUtils.getScreenBounds(BasicJideTabbedPaneUI.this._tabPane);
            int n7 = n3 + dimension.width + 3;
            int n8 = n2 + dimension.height + 3;
            if (n7 > rectangle2.x + rectangle2.width) {
                n3 -= n7 - rectangle2.x - rectangle2.width;
            }
            if (n3 < rectangle2.x) {
                n3 = rectangle2.x;
            }
            if (n8 > rectangle2.height) {
                n2 -= n8 - rectangle2.height;
            }
            if (n2 < rectangle2.y) {
                n2 = rectangle2.y;
            }
            this._popup.showPopup(n3, n2);
        }

        public void scrollForward(int n) {
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            if (n == 1 || n == 3 ? rectangle.width >= dimension.width - rectangle.x : rectangle.height >= dimension.height - rectangle.y) {
                return;
            }
            this.setLeadingTabIndex(n, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int n) {
            this.setLeadingTabIndex(n, this.leadingTabIndex > 0 ? this.leadingTabIndex - 1 : 0);
        }

        public void setLeadingTabIndex(int n, int n2) {
            if (n2 < 0 || n2 >= BasicJideTabbedPaneUI.this._tabPane.getTabCount()) {
                return;
            }
            this.leadingTabIndex = n2;
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            switch (n) {
                case 1: 
                case 3: {
                    this.tabViewPosition.y = 0;
                    if (BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight()) {
                        int n3 = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : BasicJideTabbedPaneUI.this._rects[this.leadingTabIndex].x;
                        if (dimension.width - this.tabViewPosition.x >= rectangle.width) break;
                        this.tabViewPosition.x = dimension.width - rectangle.width;
                        break;
                    }
                    this.tabViewPosition.x -= 10;
                    break;
                }
                case 2: 
                case 4: {
                    this.tabViewPosition.x = 0;
                    int n4 = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : BasicJideTabbedPaneUI.this._rects[this.leadingTabIndex].y;
                    if (dimension.height - this.tabViewPosition.y >= rectangle.height) break;
                    this.tabViewPosition.y = dimension.height - rectangle.height;
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (BasicJideTabbedPaneUI.this._tabPane == null) {
                return;
            }
            BasicJideTabbedPaneUI.this.ensureCurrentLayout();
            JViewport jViewport = (JViewport)changeEvent.getSource();
            int n = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
            int n2 = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            Rectangle rectangle = jViewport.getBounds();
            Dimension dimension = jViewport.getViewSize();
            Rectangle rectangle2 = jViewport.getViewRect();
            if (!(n != 1 && n != 3 || BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight())) {
                this.leadingTabIndex = BasicJideTabbedPaneUI.this.getClosestTab(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
                if (this.leadingTabIndex < 0) {
                    this.leadingTabIndex = 0;
                }
            } else {
                this.leadingTabIndex = BasicJideTabbedPaneUI.this.getClosestTab(rectangle2.x, rectangle2.y);
            }
            if (this.leadingTabIndex < BasicJideTabbedPaneUI.this._rects.length && this.leadingTabIndex >= BasicJideTabbedPaneUI.this._rects.length) {
                switch (n) {
                    case 1: 
                    case 3: {
                        if (BasicJideTabbedPaneUI.this._rects[this.leadingTabIndex].x >= rectangle2.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (BasicJideTabbedPaneUI.this._rects[this.leadingTabIndex].y >= rectangle2.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets insets = BasicJideTabbedPaneUI.this.getContentBorderInsets(n);
            switch (n) {
                case 2: {
                    BasicJideTabbedPaneUI.this._tabPane.repaint(rectangle.x + rectangle.width, rectangle.y, insets.left, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0 || this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 4: {
                    BasicJideTabbedPaneUI.this._tabPane.repaint(rectangle.x - insets.right, rectangle.y, insets.right, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0 || this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 3: {
                    BasicJideTabbedPaneUI.this._tabPane.repaint(rectangle.x, rectangle.y - insets.bottom, rectangle.width, insets.bottom);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0 || this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                    break;
                }
                default: {
                    BasicJideTabbedPaneUI.this._tabPane.repaint(rectangle.x, rectangle.y + rectangle.height, rectangle.width, insets.top);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0 || this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                }
            }
            if (SystemInfo.isJdk15Above()) {
                BasicJideTabbedPaneUI.this._tabPane.setComponentZOrder(BasicJideTabbedPaneUI.this._tabScroller.scrollForwardButton, 0);
                BasicJideTabbedPaneUI.this._tabPane.setComponentZOrder(BasicJideTabbedPaneUI.this._tabScroller.scrollBackwardButton, 0);
            }
            BasicJideTabbedPaneUI.this._tabScroller.scrollForwardButton.repaint();
            BasicJideTabbedPaneUI.this._tabScroller.scrollBackwardButton.repaint();
            int n3 = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            if (n3 >= 0 && n3 < BasicJideTabbedPaneUI.this._tabPane.getTabCount()) {
                this.closeButton.setEnabled(BasicJideTabbedPaneUI.this._tabPane.isTabClosableAt(n3));
            }
        }

        public String toString() {
            return "viewport.viewSize=" + this.viewport.getViewSize() + "\n" + "viewport.viewRectangle=" + this.viewport.getViewRect() + "\n" + "leadingTabIndex=" + this.leadingTabIndex + "\n" + "tabViewPosition=" + this.tabViewPosition;
        }
    }

    protected class ActivateTabAction
    extends AbstractAction {
        int _tabIndex;

        public ActivateTabAction(String string, Icon icon, int n) {
            super(string, icon);
            this._tabIndex = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(this._tabIndex);
        }
    }

    protected class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        protected TabbedPaneScrollLayout() {
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            return BasicJideTabbedPaneUI.this.calculateMaxTabHeight(n);
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            return BasicJideTabbedPaneUI.this.calculateMaxTabWidth(n);
        }

        public void layoutContainer(Container container) {
            int n = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
            int n2 = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            int n3 = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            Component component = BasicJideTabbedPaneUI.this.getVisibleComponent();
            boolean bl = BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight();
            JViewport jViewport = null;
            this.calculateLayoutInfo();
            if (n3 < 0) {
                if (component != null) {
                    BasicJideTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component component2 = n3 >= BasicJideTabbedPaneUI.this._tabPane.getTabCount() ? null : BasicJideTabbedPaneUI.this._tabPane.getComponentAt(n3);
                boolean bl2 = false;
                if (component2 != null) {
                    if (component2 != component && component != null && JideSwingUtilities.isAncestorOfFocusOwner(component) && BasicJideTabbedPaneUI.this._tabPane.isAutoRequestFocus()) {
                        bl2 = true;
                    }
                    BasicJideTabbedPaneUI.this.setVisibleComponent(component2);
                }
                Insets insets2 = BasicJideTabbedPaneUI.this.getContentBorderInsets(n);
                Rectangle rectangle = BasicJideTabbedPaneUI.this._tabPane.getBounds();
                int n4 = BasicJideTabbedPaneUI.this._tabPane.getComponentCount();
                Dimension dimension = new Dimension(0, 0);
                Dimension dimension2 = new Dimension(0, 0);
                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                    dimension = BasicJideTabbedPaneUI.this._tabLeadingComponent.getPreferredSize();
                }
                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                    dimension2 = BasicJideTabbedPaneUI.this._tabTrailingComponent.getPreferredSize();
                }
                if (n4 > 0) {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    switch (n) {
                        case 2: {
                            n13 = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(1, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                            n12 = rectangle.height - insets.top - insets.bottom;
                            n11 = insets.left;
                            n10 = insets.top;
                            if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                n10 += dimension.height;
                                n12 -= dimension.height;
                                if (dimension.width > n13) {
                                    n13 = dimension.width;
                                }
                            }
                            if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                n12 -= dimension2.height;
                                if (dimension2.width > n13) {
                                    n13 = dimension2.width;
                                }
                            }
                            n9 = n11 + n13 + insets2.left;
                            n8 = insets.top + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - n13 - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 4: {
                            n13 = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(1, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                            n12 = rectangle.height - insets.top - insets.bottom;
                            n11 = rectangle.width - insets.right - n13;
                            n10 = insets.top;
                            if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                n10 += dimension.height;
                                n12 -= dimension.height;
                                if (dimension.width > n13) {
                                    n13 = dimension.width;
                                    n11 = rectangle.width - insets.right - n13;
                                }
                            }
                            if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                n12 -= dimension2.height;
                                if (dimension2.width > n13) {
                                    n13 = dimension2.width;
                                    n11 = rectangle.width - insets.right - n13;
                                }
                            }
                            n9 = insets.left + insets2.left;
                            n8 = insets.top + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - n13 - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 3: {
                            n13 = rectangle.width - insets.left - insets.right;
                            n12 = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(n, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                            n11 = insets.left;
                            n10 = rectangle.height - insets.bottom - n12;
                            if (bl) {
                                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                    n11 += dimension.width;
                                    n13 -= dimension.width;
                                    if (dimension.height > n12) {
                                        n12 = dimension.height;
                                        n10 = rectangle.height - insets.bottom - n12;
                                    }
                                }
                                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                    n13 -= dimension2.width;
                                    if (dimension2.height > n12) {
                                        n12 = dimension2.height;
                                        n10 = rectangle.height - insets.bottom - n12;
                                    }
                                }
                            } else {
                                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                    n11 += dimension2.width;
                                    n13 -= dimension2.width;
                                    if (dimension2.height > n12) {
                                        n12 = dimension2.height;
                                        n10 = rectangle.height - insets.bottom - n12;
                                    }
                                }
                                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                    n13 -= dimension.width;
                                    if (dimension.height > n12) {
                                        n12 = dimension.height;
                                        n10 = rectangle.height - insets.bottom - n12;
                                    }
                                }
                            }
                            n9 = insets.left + insets2.left;
                            n8 = insets.top + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - n12 - insets2.top - insets2.bottom;
                            break;
                        }
                        default: {
                            n13 = rectangle.width - insets.left - insets.right;
                            n12 = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(n, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                            n11 = insets.left;
                            n10 = insets.top;
                            if (bl) {
                                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                    n11 += dimension.width;
                                    n13 -= dimension.width;
                                    if (dimension.height > n12) {
                                        n12 = dimension.height;
                                    }
                                }
                                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                    n13 -= dimension2.width;
                                    if (dimension2.height > n12) {
                                        n12 = dimension2.height;
                                    }
                                }
                            } else {
                                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                    n11 += dimension2.width;
                                    n13 -= dimension2.width;
                                    if (dimension2.height > n12) {
                                        n12 = dimension2.height;
                                    }
                                }
                                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                    n13 -= dimension.width;
                                    if (dimension.height > n12) {
                                        n12 = dimension.height;
                                    }
                                }
                            }
                            n9 = insets.left + insets2.left;
                            n8 = insets.top + n12 + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - n12 - insets2.top - insets2.bottom;
                        }
                    }
                    for (n5 = 0; n5 < n4; ++n5) {
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        Component component3 = BasicJideTabbedPaneUI.this._tabPane.getComponent(n5);
                        if (component3 instanceof ScrollableTabViewport) {
                            jViewport = (JViewport)component3;
                            int n18 = n13;
                            int n19 = n12;
                            n17 = BasicJideTabbedPaneUI.this.getNumberOfTabButtons();
                            switch (n) {
                                case 2: 
                                case 4: {
                                    n16 = BasicJideTabbedPaneUI.this._rects[n2 - 1].y + BasicJideTabbedPaneUI.this._rects[n2 - 1].height;
                                    if (n16 > n12 || BasicJideTabbedPaneUI.this.isShowTabButtons()) {
                                        if (!BasicJideTabbedPaneUI.this.isShowTabButtons()) {
                                            n17 += 3;
                                        }
                                        n19 = Math.max(n12 - BasicJideTabbedPaneUI.this._buttonSize * n17, 0);
                                    } else {
                                        n19 = Math.max(n12 - BasicJideTabbedPaneUI.this._buttonSize * n17, 0);
                                    }
                                    if (n19 + BasicJideTabbedPaneUI.this.getLayoutSize() >= n12 - BasicJideTabbedPaneUI.this._buttonSize * n17) break;
                                    n19 += BasicJideTabbedPaneUI.this.getLayoutSize();
                                    break;
                                }
                                default: {
                                    n15 = BasicJideTabbedPaneUI.this._rects[n2 - 1].x + BasicJideTabbedPaneUI.this._rects[n2 - 1].width;
                                    int n20 = bl ? (n15 <= n13 ? 1 : 0) : (n14 = BasicJideTabbedPaneUI.this._rects[n2 - 1].x >= 0 ? 1 : 0);
                                    if (BasicJideTabbedPaneUI.this.isShowTabButtons() || n14 == 0) {
                                        if (!BasicJideTabbedPaneUI.this.isShowTabButtons()) {
                                            n17 += 3;
                                        }
                                        n18 = Math.max(n13 - BasicJideTabbedPaneUI.this._buttonSize * n17, 0);
                                        if (!bl) {
                                            n11 = BasicJideTabbedPaneUI.this._buttonSize * n17;
                                        }
                                    } else {
                                        n18 = Math.max(n13 - BasicJideTabbedPaneUI.this._buttonSize * n17, 0);
                                        if (!bl) {
                                            n11 = BasicJideTabbedPaneUI.this._buttonSize * n17;
                                        }
                                    }
                                    if (n18 + BasicJideTabbedPaneUI.this.getLayoutSize() >= n13 - BasicJideTabbedPaneUI.this._buttonSize * n17) break;
                                    n18 += BasicJideTabbedPaneUI.this.getLayoutSize();
                                    if (bl) break;
                                    n11 -= BasicJideTabbedPaneUI.this.getLayoutSize();
                                }
                            }
                            component3.setBounds(n11, n10, n18, n19);
                            continue;
                        }
                        if (component3 instanceof TabCloseButton) {
                            TabCloseButton tabCloseButton = (TabCloseButton)component3;
                            if (BasicJideTabbedPaneUI.this._tabPane.isTabShown() && (tabCloseButton.getType() != 0 || !BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab())) {
                                Dimension dimension3 = tabCloseButton.getPreferredSize();
                                n17 = 0;
                                n16 = 0;
                                n15 = dimension3.width;
                                n14 = dimension3.height;
                                boolean bl3 = false;
                                switch (n) {
                                    case 2: 
                                    case 4: {
                                        int n21;
                                        int n22 = BasicJideTabbedPaneUI.this._rects[n2 - 1].y + BasicJideTabbedPaneUI.this._rects[n2 - 1].height;
                                        if (BasicJideTabbedPaneUI.this._tabPane.isTabShown() && (BasicJideTabbedPaneUI.this.isShowTabButtons() || n22 > n12)) {
                                            n21 = tabCloseButton.getType();
                                            tabCloseButton.setType(n21);
                                            switch (n21) {
                                                case 0: {
                                                    if (BasicJideTabbedPaneUI.this.isShowCloseButton()) {
                                                        bl3 = true;
                                                        n16 = rectangle.height - insets.top - dimension3.height - 5;
                                                        break;
                                                    }
                                                    bl3 = false;
                                                    n16 = 0;
                                                    break;
                                                }
                                                case 5: {
                                                    bl3 = true;
                                                    n16 = rectangle.height - insets.top - (2 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.height - 5;
                                                    break;
                                                }
                                                case 1: {
                                                    bl3 = !BasicJideTabbedPaneUI.this.isShrinkTabs();
                                                    n16 = rectangle.height - insets.top - (3 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.height - 5;
                                                    break;
                                                }
                                                case 2: {
                                                    bl3 = !BasicJideTabbedPaneUI.this.isShrinkTabs();
                                                    n16 = rectangle.height - insets.top - (4 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.height - 5;
                                                }
                                            }
                                            n17 = n11 + 2;
                                        } else {
                                            n21 = tabCloseButton.getType();
                                            tabCloseButton.setType(n21);
                                            if (n21 == 0) {
                                                if (BasicJideTabbedPaneUI.this.isShowCloseButton()) {
                                                    bl3 = true;
                                                    n16 = rectangle.height - insets.top - dimension3.height - 5;
                                                } else {
                                                    bl3 = false;
                                                    n16 = 0;
                                                }
                                                n17 = n11 + 2;
                                            }
                                        }
                                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                            n16 -= dimension2.height;
                                        }
                                        n21 = -1;
                                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && dimension.width >= BasicJideTabbedPaneUI.this._rects[0].width && n == 2) {
                                            n17 += dimension.width - BasicJideTabbedPaneUI.this._rects[0].width;
                                            n21 = dimension.width;
                                        }
                                        if (!BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() || dimension2.width < BasicJideTabbedPaneUI.this._rects[0].width || n21 >= dimension2.width || n != 2) break;
                                        n17 += dimension2.width - BasicJideTabbedPaneUI.this._rects[0].width;
                                        break;
                                    }
                                    default: {
                                        int n23;
                                        boolean bl4;
                                        int n24 = BasicJideTabbedPaneUI.this._rects[n2 - 1].x + BasicJideTabbedPaneUI.this._rects[n2 - 1].width;
                                        boolean bl5 = bl ? n24 <= n13 : (bl4 = BasicJideTabbedPaneUI.this._rects[n2 - 1].x >= 0);
                                        if (BasicJideTabbedPaneUI.this._tabPane.isTabShown() && (BasicJideTabbedPaneUI.this.isShowTabButtons() || !bl4)) {
                                            n23 = tabCloseButton.getType();
                                            tabCloseButton.setType(n23);
                                            switch (n23) {
                                                case 0: {
                                                    if (BasicJideTabbedPaneUI.this.isShowCloseButton()) {
                                                        bl3 = true;
                                                        if (bl) {
                                                            n17 = rectangle.width - insets.left - dimension3.width - 5;
                                                            break;
                                                        }
                                                        n17 = insets.left - 5;
                                                        break;
                                                    }
                                                    bl3 = false;
                                                    n17 = 0;
                                                    break;
                                                }
                                                case 5: {
                                                    bl3 = true;
                                                    if (bl) {
                                                        n17 = rectangle.width - insets.left - (2 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.width - 5;
                                                        break;
                                                    }
                                                    n17 = insets.left + (1 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.width + 5;
                                                    break;
                                                }
                                                case 1: {
                                                    boolean bl6 = bl3 = !BasicJideTabbedPaneUI.this.isShrinkTabs();
                                                    if (bl) {
                                                        n17 = rectangle.width - insets.left - (3 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.width - 5;
                                                        break;
                                                    }
                                                    n17 = insets.left + (2 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.width + 5;
                                                    break;
                                                }
                                                case 2: {
                                                    boolean bl7 = bl3 = !BasicJideTabbedPaneUI.this.isShrinkTabs();
                                                    n17 = bl ? rectangle.width - insets.left - (4 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.width - 5 : insets.left + (3 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.width + 5;
                                                }
                                            }
                                            n16 = (n12 - dimension3.height >> 1) + n10;
                                        } else {
                                            n23 = tabCloseButton.getType();
                                            tabCloseButton.setType(n23);
                                            if (n23 == 0) {
                                                if (BasicJideTabbedPaneUI.this.isShowCloseButton()) {
                                                    bl3 = true;
                                                    n17 = rectangle.width - insets.left - dimension3.width - 5;
                                                } else {
                                                    bl3 = false;
                                                    n17 = 0;
                                                }
                                                n16 = (n12 - dimension3.height >> 1) + n10;
                                            }
                                        }
                                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                            n17 -= dimension2.width;
                                        }
                                        int n21 = -1;
                                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && dimension.height >= BasicJideTabbedPaneUI.this._rects[0].height) {
                                            if (n == 1) {
                                                n16 = n10 + 2 + dimension.height - BasicJideTabbedPaneUI.this._rects[0].height;
                                                n21 = dimension.height;
                                            } else {
                                                n16 = n10 + 2;
                                            }
                                        }
                                        if (!BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() || dimension2.height < BasicJideTabbedPaneUI.this._rects[0].height || n21 >= dimension2.height) break;
                                        n16 = n == 1 ? n10 + 2 + dimension2.height - BasicJideTabbedPaneUI.this._rects[0].height : n10 + 2;
                                    }
                                }
                                component3.setVisible(bl3);
                                if (!bl3) continue;
                                component3.setBounds(n17, n16, n15, n14);
                                continue;
                            }
                            tabCloseButton.setBounds(0, 0, 0, 0);
                            continue;
                        }
                        if (component3 == BasicJideTabbedPaneUI.this._tabPane.getTabLeadingComponent() || component3 == BasicJideTabbedPaneUI.this._tabPane.getTabTrailingComponent()) continue;
                        if (BasicJideTabbedPaneUI.this._tabPane.isShowTabContent()) {
                            component3.setBounds(n9, n8, n7, n6);
                            continue;
                        }
                        component3.setBounds(0, 0, 0, 0);
                    }
                    if (bl) {
                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                            switch (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement()) {
                                case 2: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(n11 + n13 - dimension.width, n10 - dimension.height, dimension.width, dimension.height);
                                    break;
                                }
                                case 4: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(n11, n10 - dimension.height, dimension.width, dimension.height);
                                    break;
                                }
                                case 3: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(n11 - dimension.width, n10, dimension.width, dimension.height);
                                    break;
                                }
                                default: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(n11 - dimension.width, n10 + n12 - dimension.height, dimension.width, dimension.height);
                                }
                            }
                        }
                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                            switch (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement()) {
                                case 2: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(n11 + n13 - dimension2.width, n10 + n12, dimension2.width, dimension2.height);
                                    break;
                                }
                                case 4: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(n11, n10 + n12, dimension2.width, dimension2.height);
                                    break;
                                }
                                case 3: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(n11 + n13, n10, dimension2.width, dimension2.height);
                                    break;
                                }
                                default: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(n11 + n13, n10 + n12 - dimension2.height, dimension2.width, dimension2.height);
                                    break;
                                }
                            }
                        }
                    } else {
                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                            switch (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement()) {
                                case 2: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(n11 + n13 - dimension2.width, n10 - dimension2.height, dimension2.width, dimension2.height);
                                    break;
                                }
                                case 4: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(n11, n10 - dimension2.height, dimension2.width, dimension2.height);
                                    break;
                                }
                                case 3: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(n11 - dimension2.width, n10, dimension2.width, dimension2.height);
                                    break;
                                }
                                default: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(n11 - dimension2.width, n10 + n12 - dimension2.height, dimension2.width, dimension2.height);
                                }
                            }
                        }
                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                            switch (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement()) {
                                case 2: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(n11 + n13 - dimension.width, n10 + n12, dimension.width, dimension.height);
                                    break;
                                }
                                case 4: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(n11, n10 + n12, dimension.width, dimension.height);
                                    break;
                                }
                                case 3: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(n11 + n13, n10, dimension.width, dimension.height);
                                    break;
                                }
                                default: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(n11 + n13, n10 + n12 - dimension.height, dimension.width, dimension.height);
                                }
                            }
                        }
                    }
                    int n25 = n5 = n == 2 || n == 4 ? 1 : 0;
                    if (!bl && n5 == 0 && jViewport != null && !jViewport.getSize().equals(BasicJideTabbedPaneUI.this._tabPane.getSize())) {
                        int n26 = BasicJideTabbedPaneUI.this._tabPane.getWidth() - jViewport.getWidth();
                        for (Rectangle rectangle2 : BasicJideTabbedPaneUI.this._rects) {
                            rectangle2.x -= n26;
                        }
                    }
                    BasicJideTabbedPaneUI.this.updateCloseButtons();
                    if (bl2 && !BasicJideTabbedPaneUI.this.requestFocusForVisibleComponent() && !BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow()) {
                        BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                    }
                }
            }
        }

        protected void calculateTabRects(int n, int n2) {
            int n3;
            int n4;
            Dimension dimension = BasicJideTabbedPaneUI.this._tabPane.getSize();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            Insets insets2 = BasicJideTabbedPaneUI.this.getTabAreaInsets(n);
            boolean bl = n == 2 || n == 4;
            boolean bl2 = BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight();
            int n5 = insets2.left;
            int n6 = insets2.top;
            Dimension dimension2 = new Dimension(0, 0);
            Dimension dimension3 = new Dimension(0, 0);
            if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                dimension2 = BasicJideTabbedPaneUI.this._tabLeadingComponent.getPreferredSize();
            }
            if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                dimension3 = BasicJideTabbedPaneUI.this._tabTrailingComponent.getPreferredSize();
            }
            switch (n) {
                case 2: 
                case 4: {
                    BasicJideTabbedPaneUI.this._maxTabWidth = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(n);
                    if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && n == 4 && BasicJideTabbedPaneUI.this._maxTabWidth < dimension2.width) {
                        BasicJideTabbedPaneUI.this._maxTabWidth = dimension2.width;
                    }
                    if (!BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() || n != 4 || BasicJideTabbedPaneUI.this._maxTabWidth >= dimension3.width) break;
                    BasicJideTabbedPaneUI.this._maxTabWidth = dimension3.width;
                    break;
                }
                default: {
                    BasicJideTabbedPaneUI.this._maxTabHeight = BasicJideTabbedPaneUI.this.calculateMaxTabHeight(n);
                    if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && n == 3 && BasicJideTabbedPaneUI.this._maxTabHeight < dimension2.height) {
                        BasicJideTabbedPaneUI.this._maxTabHeight = dimension2.height;
                    }
                    if (!BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() || n != 3 || BasicJideTabbedPaneUI.this._maxTabHeight >= dimension3.height) break;
                    BasicJideTabbedPaneUI.this._maxTabHeight = dimension3.height;
                }
            }
            BasicJideTabbedPaneUI.this._runCount = 0;
            BasicJideTabbedPaneUI.this._selectedRun = -1;
            if (n2 == 0) {
                return;
            }
            BasicJideTabbedPaneUI.this._selectedRun = 0;
            BasicJideTabbedPaneUI.this._runCount = 1;
            for (n4 = 0; n4 < n2; ++n4) {
                FontMetrics fontMetrics = BasicJideTabbedPaneUI.this.getFontMetrics(n4);
                Rectangle rectangle = BasicJideTabbedPaneUI.this._rects[n4];
                if (!bl) {
                    if (n4 > 0) {
                        rectangle.x = BasicJideTabbedPaneUI.this._rects[n4 - 1].x + BasicJideTabbedPaneUI.this._rects[n4 - 1].width;
                    } else {
                        BasicJideTabbedPaneUI.this._tabRuns[0] = 0;
                        BasicJideTabbedPaneUI.this._maxTabWidth = 0;
                        rectangle.x = BasicJideTabbedPaneUI.this.getTabShape() != 3 ? n5 + BasicJideTabbedPaneUI.this.getLeftMargin() : n5;
                    }
                    rectangle.width = BasicJideTabbedPaneUI.this.calculateTabWidth(n, n4, fontMetrics) + BasicJideTabbedPaneUI.this._rectSizeExtend;
                    BasicJideTabbedPaneUI.this._maxTabWidth = Math.max(BasicJideTabbedPaneUI.this._maxTabWidth, rectangle.width);
                    rectangle.y = n6;
                    n3 = -1;
                    if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && n == 1 && BasicJideTabbedPaneUI.this._maxTabHeight < dimension2.height) {
                        rectangle.y = n6 + dimension2.height - BasicJideTabbedPaneUI.this._maxTabHeight - 2;
                        n3 = dimension2.height;
                        if (BasicJideTabbedPaneUI.this._rectSizeExtend > 0) {
                            rectangle.y += 2;
                        }
                    }
                    if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() && n == 1 && BasicJideTabbedPaneUI.this._maxTabHeight < dimension3.height && n3 < dimension3.height) {
                        rectangle.y = n6 + dimension3.height - BasicJideTabbedPaneUI.this._maxTabHeight - 2;
                        if (BasicJideTabbedPaneUI.this._rectSizeExtend > 0) {
                            rectangle.y += 2;
                        }
                    }
                    rectangle.height = BasicJideTabbedPaneUI.this.calculateMaxTabHeight(n);
                    continue;
                }
                if (n4 > 0) {
                    rectangle.y = BasicJideTabbedPaneUI.this._rects[n4 - 1].y + BasicJideTabbedPaneUI.this._rects[n4 - 1].height;
                } else {
                    BasicJideTabbedPaneUI.this._tabRuns[0] = 0;
                    BasicJideTabbedPaneUI.this._maxTabHeight = 0;
                    rectangle.y = BasicJideTabbedPaneUI.this.getTabShape() != 3 ? n6 + BasicJideTabbedPaneUI.this.getLeftMargin() : n6;
                }
                rectangle.height = BasicJideTabbedPaneUI.this.calculateTabHeight(n, n4, fontMetrics) + BasicJideTabbedPaneUI.this._rectSizeExtend;
                BasicJideTabbedPaneUI.this._maxTabHeight = Math.max(BasicJideTabbedPaneUI.this._maxTabHeight, rectangle.height);
                rectangle.x = n5;
                n3 = -1;
                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && n == 2 && BasicJideTabbedPaneUI.this._maxTabWidth < dimension2.width) {
                    rectangle.x = n5 + dimension2.width - BasicJideTabbedPaneUI.this._maxTabWidth - 2;
                    n3 = dimension2.width;
                    if (BasicJideTabbedPaneUI.this._rectSizeExtend > 0) {
                        rectangle.x += 2;
                    }
                }
                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() && n == 2 && BasicJideTabbedPaneUI.this._maxTabWidth < dimension3.width && n3 < dimension3.width) {
                    rectangle.x = n5 + dimension3.width - BasicJideTabbedPaneUI.this._maxTabWidth - 2;
                    if (BasicJideTabbedPaneUI.this._rectSizeExtend > 0) {
                        rectangle.x += 2;
                    }
                }
                rectangle.width = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(n);
            }
            if (!bl2 && !bl) {
                n4 = dimension.width - (insets.right + insets2.right);
                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                    n4 -= dimension2.width;
                }
                int n7 = 0;
                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                    n7 += dimension3.width;
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    BasicJideTabbedPaneUI.this._rects[n3].x = n4 - BasicJideTabbedPaneUI.this._rects[n3].x - BasicJideTabbedPaneUI.this._rects[n3].width - n7 + insets2.left;
                }
            }
            BasicJideTabbedPaneUI.this.ensureCurrentRects(BasicJideTabbedPaneUI.this.getLeftMargin(), n2);
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.calculateSize(false);
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.calculateSize(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Dimension calculateSize(boolean bl) {
            int n = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            Insets insets2 = BasicJideTabbedPaneUI.this.getContentBorderInsets(n);
            Insets insets3 = BasicJideTabbedPaneUI.this.getTabAreaInsets(n);
            Dimension dimension = new Dimension(0, 0);
            int n2 = insets2.top + insets2.bottom;
            int n3 = insets2.left + insets2.right;
            int n4 = 0;
            int n5 = 0;
            TabbedPaneLayout tabbedPaneLayout = this;
            synchronized (tabbedPaneLayout) {
                Dimension dimension2;
                Serializable serializable;
                int n6;
                BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
                this.calculateLayoutInfo();
                if (BasicJideTabbedPaneUI.this._tabPane.isShowTabContent()) {
                    for (n6 = 0; n6 < BasicJideTabbedPaneUI.this._tabPane.getTabCount(); ++n6) {
                        serializable = BasicJideTabbedPaneUI.this._tabPane.getComponentAt(n6);
                        if (serializable == null) continue;
                        dimension2 = dimension;
                        Dimension dimension3 = dimension2 = bl ? ((Component)serializable).getMinimumSize() : ((Component)serializable).getPreferredSize();
                        if (dimension2 == null) continue;
                        n5 = Math.max(dimension2.height, n5);
                        n4 = Math.max(dimension2.width, n4);
                    }
                    n3 += n4;
                    n2 += n5;
                }
                n6 = 0;
                serializable = new Dimension(0, 0);
                dimension2 = new Dimension(0, 0);
                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                    serializable = BasicJideTabbedPaneUI.this._tabLeadingComponent.getPreferredSize();
                }
                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                    dimension2 = BasicJideTabbedPaneUI.this._tabTrailingComponent.getPreferredSize();
                }
                switch (n) {
                    case 2: 
                    case 4: {
                        n2 = Math.max(n2, (bl ? 0 : BasicJideTabbedPaneUI.this.calculateMaxTabHeight(n)) + insets3.top + insets3.bottom);
                        n6 = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(n, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                            n6 = Math.max(((Dimension)serializable).width, n6);
                        }
                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                            n6 = Math.max(dimension2.width, n6);
                        }
                        n3 += n6;
                        break;
                    }
                    default: {
                        n3 = BasicJideTabbedPaneUI.this._tabPane.getTabResizeMode() == 2 ? Math.max(n3, (BasicJideTabbedPaneUI.this._tabPane.getTabCount() << 2) + insets3.left + insets3.right) : Math.max(n3, (bl ? 0 : BasicJideTabbedPaneUI.this.calculateMaxTabWidth(n)) + insets3.left + insets3.right);
                        if (!BasicJideTabbedPaneUI.this._tabPane.isTabShown()) break;
                        n6 = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(n, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                            n6 = Math.max(((Dimension)serializable).height, n6);
                        }
                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                            n6 = Math.max(dimension2.height, n6);
                        }
                        n2 += n6;
                    }
                }
            }
            return new Dimension(n3 + insets.left + insets.right, n2 + insets.bottom + insets.top);
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            int n3 = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            int n4 = 0;
            if (n3 > 0) {
                int n5 = 1;
                int n6 = 0;
                int n7 = BasicJideTabbedPaneUI.this.calculateMaxTabHeight(n);
                for (int i = 0; i < n3; ++i) {
                    FontMetrics fontMetrics = BasicJideTabbedPaneUI.this.getFontMetrics(i);
                    int n8 = BasicJideTabbedPaneUI.this.calculateTabWidth(n, i, fontMetrics);
                    if (n6 != 0 && n6 + n8 > n2) {
                        ++n5;
                        n6 = 0;
                    }
                    n6 += n8;
                }
                n4 = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(n, n5, n7);
            }
            return n4;
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            int n3 = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            int n4 = 0;
            if (n3 > 0) {
                int n5 = 1;
                int n6 = 0;
                BasicJideTabbedPaneUI.this._maxTabWidth = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(n);
                for (int i = 0; i < n3; ++i) {
                    FontMetrics fontMetrics = BasicJideTabbedPaneUI.this.getFontMetrics(i);
                    int n7 = BasicJideTabbedPaneUI.this.calculateTabHeight(n, i, fontMetrics);
                    if (n6 != 0 && n6 + n7 > n2) {
                        ++n5;
                        n6 = 0;
                    }
                    n6 += n7;
                }
                n4 = BasicJideTabbedPaneUI.this.calculateTabAreaWidth(n, n5, BasicJideTabbedPaneUI.this._maxTabWidth);
            }
            return n4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            int n = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            int n2 = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            Component component = BasicJideTabbedPaneUI.this.getVisibleComponent();
            TabbedPaneLayout tabbedPaneLayout = this;
            synchronized (tabbedPaneLayout) {
                BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
                this.calculateLayoutInfo();
                if (n2 < 0) {
                    if (component != null) {
                        BasicJideTabbedPaneUI.this.setVisibleComponent(null);
                    }
                } else {
                    int n3 = 0;
                    int n4 = 0;
                    Insets insets2 = BasicJideTabbedPaneUI.this.getContentBorderInsets(n);
                    Component component2 = BasicJideTabbedPaneUI.this._tabPane.getComponentAt(n2);
                    boolean bl = false;
                    if (component2 != null) {
                        if (component2 != component && component != null && JideSwingUtilities.isAncestorOfFocusOwner(component) && BasicJideTabbedPaneUI.this._tabPane.isAutoRequestFocus()) {
                            bl = true;
                        }
                        BasicJideTabbedPaneUI.this.setVisibleComponent(component2);
                    }
                    Rectangle rectangle = BasicJideTabbedPaneUI.this._tabPane.getBounds();
                    int n5 = BasicJideTabbedPaneUI.this._tabPane.getComponentCount();
                    if (n5 > 0) {
                        int n6;
                        int n7;
                        switch (n) {
                            case 2: {
                                n3 = BasicJideTabbedPaneUI.this.calculateTabAreaWidth(n, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                                n7 = insets.left + n3 + insets2.left;
                                n6 = insets.top + insets2.top;
                                break;
                            }
                            case 4: {
                                n3 = BasicJideTabbedPaneUI.this.calculateTabAreaWidth(n, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                                n7 = insets.left + insets2.left;
                                n6 = insets.top + insets2.top;
                                break;
                            }
                            case 3: {
                                n4 = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(n, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                                n7 = insets.left + insets2.left;
                                n6 = insets.top + insets2.top;
                                break;
                            }
                            default: {
                                n4 = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(n, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                                n7 = insets.left + insets2.left;
                                n6 = insets.top + n4 + insets2.top;
                            }
                        }
                        int n8 = rectangle.width - n3 - insets.left - insets.right - insets2.left - insets2.right;
                        int n9 = rectangle.height - n4 - insets.top - insets.bottom - insets2.top - insets2.bottom;
                        for (int i = 0; i < n5; ++i) {
                            Component component3 = BasicJideTabbedPaneUI.this._tabPane.getComponent(i);
                            component3.setBounds(n7, n6, n8, n9);
                        }
                    }
                    if (bl && !BasicJideTabbedPaneUI.this.requestFocusForVisibleComponent() && !BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow()) {
                        BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                    }
                }
            }
        }

        public void calculateLayoutInfo() {
            int n = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            BasicJideTabbedPaneUI.this.assureRectsCreated(n);
            this.calculateTabRects(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement(), n);
        }

        protected void calculateTabRects(int n, int n2) {
            Rectangle rectangle;
            int n3;
            int n4;
            int n5;
            int n6;
            Dimension dimension = BasicJideTabbedPaneUI.this._tabPane.getSize();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            Insets insets2 = BasicJideTabbedPaneUI.this.getTabAreaInsets(n);
            int n7 = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            boolean bl = n == 2 || n == 4;
            boolean bl2 = BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight();
            switch (n) {
                case 2: {
                    BasicJideTabbedPaneUI.this._maxTabWidth = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n6 = insets.left + insets2.left;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 4: {
                    BasicJideTabbedPaneUI.this._maxTabWidth = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n6 = dimension.width - insets.right - insets2.right - BasicJideTabbedPaneUI.this._maxTabWidth;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    BasicJideTabbedPaneUI.this._maxTabHeight = BasicJideTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = dimension.height - insets.bottom - insets2.bottom - BasicJideTabbedPaneUI.this._maxTabHeight;
                    n4 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    BasicJideTabbedPaneUI.this._maxTabHeight = BasicJideTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.width - (insets.right + insets2.right);
                }
            }
            int n8 = BasicJideTabbedPaneUI.this.getTabRunOverlay(n);
            BasicJideTabbedPaneUI.this._runCount = 0;
            BasicJideTabbedPaneUI.this._selectedRun = -1;
            if (n2 == 0) {
                return;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                FontMetrics fontMetrics = BasicJideTabbedPaneUI.this.getFontMetrics(n3);
                rectangle = BasicJideTabbedPaneUI.this._rects[n3];
                if (!bl) {
                    if (n3 > 0) {
                        rectangle.x = BasicJideTabbedPaneUI.this._rects[n3 - 1].x + BasicJideTabbedPaneUI.this._rects[n3 - 1].width;
                    } else {
                        BasicJideTabbedPaneUI.this._tabRuns[0] = 0;
                        BasicJideTabbedPaneUI.this._runCount = 1;
                        BasicJideTabbedPaneUI.this._maxTabWidth = 0;
                        rectangle.x = n6;
                    }
                    rectangle.width = BasicJideTabbedPaneUI.this.calculateTabWidth(n, n3, fontMetrics);
                    BasicJideTabbedPaneUI.this._maxTabWidth = Math.max(BasicJideTabbedPaneUI.this._maxTabWidth, rectangle.width);
                    if (rectangle.x != 2 + insets.left && rectangle.x + rectangle.width > n4) {
                        if (BasicJideTabbedPaneUI.this._runCount > BasicJideTabbedPaneUI.this._tabRuns.length - 1) {
                            BasicJideTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicJideTabbedPaneUI.this._tabRuns[BasicJideTabbedPaneUI.this._runCount] = n3;
                        ++BasicJideTabbedPaneUI.this._runCount;
                        rectangle.x = n6;
                    }
                    rectangle.y = n5;
                    rectangle.height = BasicJideTabbedPaneUI.this._maxTabHeight;
                } else {
                    if (n3 > 0) {
                        rectangle.y = BasicJideTabbedPaneUI.this._rects[n3 - 1].y + BasicJideTabbedPaneUI.this._rects[n3 - 1].height;
                    } else {
                        BasicJideTabbedPaneUI.this._tabRuns[0] = 0;
                        BasicJideTabbedPaneUI.this._runCount = 1;
                        BasicJideTabbedPaneUI.this._maxTabHeight = 0;
                        rectangle.y = n5;
                    }
                    rectangle.height = BasicJideTabbedPaneUI.this.calculateTabHeight(n, n3, fontMetrics);
                    BasicJideTabbedPaneUI.this._maxTabHeight = Math.max(BasicJideTabbedPaneUI.this._maxTabHeight, rectangle.height);
                    if (rectangle.y != 2 + insets.top && rectangle.y + rectangle.height > n4) {
                        if (BasicJideTabbedPaneUI.this._runCount > BasicJideTabbedPaneUI.this._tabRuns.length - 1) {
                            BasicJideTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicJideTabbedPaneUI.this._tabRuns[BasicJideTabbedPaneUI.this._runCount] = n3;
                        ++BasicJideTabbedPaneUI.this._runCount;
                        rectangle.y = n5;
                    }
                    rectangle.x = n6;
                    rectangle.width = BasicJideTabbedPaneUI.this._maxTabWidth;
                }
                if (n3 != n7) continue;
                BasicJideTabbedPaneUI.this._selectedRun = BasicJideTabbedPaneUI.this._runCount - 1;
            }
            if (BasicJideTabbedPaneUI.this._runCount > 1) {
                this.normalizeTabRuns(n, n2, bl ? n5 : n6, n4);
                BasicJideTabbedPaneUI.this._selectedRun = BasicJideTabbedPaneUI.this.getRunForTab(n2, n7);
                if (BasicJideTabbedPaneUI.this.shouldRotateTabRuns(n)) {
                    this.rotateTabRuns(n, BasicJideTabbedPaneUI.this._selectedRun);
                }
            }
            for (n3 = BasicJideTabbedPaneUI.this._runCount - 1; n3 >= 0; --n3) {
                int n9;
                int n10;
                int n11 = BasicJideTabbedPaneUI.this._tabRuns[n3];
                int n12 = BasicJideTabbedPaneUI.this._tabRuns[n3 == BasicJideTabbedPaneUI.this._runCount - 1 ? 0 : n3 + 1];
                int n13 = n10 = n12 != 0 ? n12 - 1 : n2 - 1;
                if (!bl) {
                    for (n9 = n11; n9 <= n10; ++n9) {
                        rectangle = BasicJideTabbedPaneUI.this._rects[n9];
                        rectangle.y = n5;
                        rectangle.x += BasicJideTabbedPaneUI.this.getTabRunIndent(n, n3);
                    }
                    if (BasicJideTabbedPaneUI.this.shouldPadTabRun(n, n3)) {
                        this.padTabRun(n, n11, n10, n4);
                    }
                    if (n == 3) {
                        n5 -= BasicJideTabbedPaneUI.this._maxTabHeight - n8;
                        continue;
                    }
                    n5 += BasicJideTabbedPaneUI.this._maxTabHeight - n8;
                    continue;
                }
                for (n9 = n11; n9 <= n10; ++n9) {
                    rectangle = BasicJideTabbedPaneUI.this._rects[n9];
                    rectangle.x = n6;
                    rectangle.y += BasicJideTabbedPaneUI.this.getTabRunIndent(n, n3);
                }
                if (BasicJideTabbedPaneUI.this.shouldPadTabRun(n, n3)) {
                    this.padTabRun(n, n11, n10, n4);
                }
                if (n == 4) {
                    n6 -= BasicJideTabbedPaneUI.this._maxTabWidth - n8;
                    continue;
                }
                n6 += BasicJideTabbedPaneUI.this._maxTabWidth - n8;
            }
            this.padSelectedTab(n, n7);
            if (!bl2 && !bl) {
                int n14 = dimension.width - (insets.right + insets2.right);
                for (n3 = 0; n3 < n2; ++n3) {
                    BasicJideTabbedPaneUI.this._rects[n3].x = n14 - BasicJideTabbedPaneUI.this._rects[n3].x - BasicJideTabbedPaneUI.this._rects[n3].width;
                }
            }
        }

        protected void rotateTabRuns(int n, int n2) {
            for (int i = 0; i < n2; ++i) {
                int n3 = BasicJideTabbedPaneUI.this._tabRuns[0];
                for (int j = 1; j < BasicJideTabbedPaneUI.this._runCount; ++j) {
                    BasicJideTabbedPaneUI.this._tabRuns[j - 1] = BasicJideTabbedPaneUI.this._tabRuns[j];
                }
                BasicJideTabbedPaneUI.this._tabRuns[BasicJideTabbedPaneUI.this._runCount - 1] = n3;
            }
        }

        protected void normalizeTabRuns(int n, int n2, int n3, int n4) {
            boolean bl = n == 2 || n == 4;
            int n5 = BasicJideTabbedPaneUI.this._runCount - 1;
            boolean bl2 = true;
            double d = 1.25;
            while (bl2) {
                int n6;
                int n7;
                int n8 = BasicJideTabbedPaneUI.this.lastTabInRun(n2, n5);
                int n9 = BasicJideTabbedPaneUI.this.lastTabInRun(n2, n5 - 1);
                if (!bl) {
                    n7 = BasicJideTabbedPaneUI.this._rects[n8].x + BasicJideTabbedPaneUI.this._rects[n8].width;
                    n6 = (int)((double)BasicJideTabbedPaneUI.this._maxTabWidth * d);
                } else {
                    n7 = BasicJideTabbedPaneUI.this._rects[n8].y + BasicJideTabbedPaneUI.this._rects[n8].height;
                    n6 = (int)((double)BasicJideTabbedPaneUI.this._maxTabHeight * d * 2.0);
                }
                if (n4 - n7 > n6) {
                    BasicJideTabbedPaneUI.this._tabRuns[n5] = n9;
                    if (!bl) {
                        BasicJideTabbedPaneUI.this._rects[n9].x = n3;
                    } else {
                        BasicJideTabbedPaneUI.this._rects[n9].y = n3;
                    }
                    for (int i = n9 + 1; i <= n8; ++i) {
                        if (!bl) {
                            BasicJideTabbedPaneUI.this._rects[i].x = BasicJideTabbedPaneUI.this._rects[i - 1].x + BasicJideTabbedPaneUI.this._rects[i - 1].width;
                            continue;
                        }
                        BasicJideTabbedPaneUI.this._rects[i].y = BasicJideTabbedPaneUI.this._rects[i - 1].y + BasicJideTabbedPaneUI.this._rects[i - 1].height;
                    }
                } else if (n5 == BasicJideTabbedPaneUI.this._runCount - 1) {
                    bl2 = false;
                }
                if (n5 - 1 > 0) {
                    --n5;
                    continue;
                }
                n5 = BasicJideTabbedPaneUI.this._runCount - 1;
                d += 0.25;
            }
        }

        protected void padTabRun(int n, int n2, int n3, int n4) {
            Rectangle rectangle = BasicJideTabbedPaneUI.this._rects[n3];
            if (n == 1 || n == 3) {
                int n5 = rectangle.x + rectangle.width - BasicJideTabbedPaneUI.this._rects[n2].x;
                int n6 = n4 - (rectangle.x + rectangle.width);
                float f = (float)n6 / (float)n5;
                for (int i = n2; i <= n3; ++i) {
                    Rectangle rectangle2 = BasicJideTabbedPaneUI.this._rects[i];
                    if (i > n2) {
                        rectangle2.x = BasicJideTabbedPaneUI.this._rects[i - 1].x + BasicJideTabbedPaneUI.this._rects[i - 1].width;
                    }
                    rectangle2.width += Math.round((float)rectangle2.width * f);
                }
                rectangle.width = n4 - rectangle.x;
            } else {
                int n7 = rectangle.y + rectangle.height - BasicJideTabbedPaneUI.this._rects[n2].y;
                int n8 = n4 - (rectangle.y + rectangle.height);
                float f = (float)n8 / (float)n7;
                for (int i = n2; i <= n3; ++i) {
                    Rectangle rectangle3 = BasicJideTabbedPaneUI.this._rects[i];
                    if (i > n2) {
                        rectangle3.y = BasicJideTabbedPaneUI.this._rects[i - 1].y + BasicJideTabbedPaneUI.this._rects[i - 1].height;
                    }
                    rectangle3.height += Math.round((float)rectangle3.height * f);
                }
                rectangle.height = n4 - rectangle.y;
            }
        }

        protected void padSelectedTab(int n, int n2) {
            if (n2 >= 0) {
                Rectangle rectangle = BasicJideTabbedPaneUI.this._rects[n2];
                Insets insets = BasicJideTabbedPaneUI.this.getSelectedTabPadInsets(n);
                rectangle.x -= insets.left;
                rectangle.width += insets.left + insets.right;
                rectangle.y -= insets.top;
                rectangle.height += insets.top + insets.bottom;
            }
        }
    }

    private static class CloseTabAction
    extends AbstractAction {
        public CloseTabAction() {
            this.putValue("ShortDescription", Resource.getResourceBundle(Locale.getDefault()).getString(BasicJideTabbedPaneUI.BUTTON_NAME_CLOSE));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            JideTabbedPane jideTabbedPane = null;
            Object object = actionEvent.getSource();
            int n = -1;
            boolean bl = false;
            if (object instanceof JideTabbedPane) {
                jideTabbedPane = (JideTabbedPane)object;
            } else if (object instanceof TabCloseButton && ((TabCloseButton)object).getParent() instanceof JideTabbedPane) {
                jideTabbedPane = (JideTabbedPane)((TabCloseButton)object).getParent();
                bl = true;
            } else if (object instanceof TabCloseButton && ((TabCloseButton)object).getParent() instanceof ScrollableTabPanel) {
                jideTabbedPane = (JideTabbedPane)SwingUtilities.getAncestorOfClass(JideTabbedPane.class, (TabCloseButton)object);
                bl = false;
            } else {
                return;
            }
            if (jideTabbedPane.isTabEditing()) {
                ((BasicJideTabbedPaneUI)jideTabbedPane.getUI()).stopOrCancelEditing();
            }
            ActionEvent actionEvent2 = actionEvent;
            if (object instanceof TabCloseButton) {
                n = ((TabCloseButton)object).getIndex();
                Component component2 = component = n != -1 ? jideTabbedPane.getComponentAt(n) : jideTabbedPane.getSelectedComponent();
                if (component != null) {
                    actionEvent2 = new ActionEvent(component, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers());
                }
            } else if ("middleMouseButtonClicked".equals(actionEvent.getActionCommand())) {
                n = actionEvent.getID();
                Component component3 = component = n != -1 ? jideTabbedPane.getComponentAt(n) : jideTabbedPane.getSelectedComponent();
                if (component != null) {
                    actionEvent2 = new ActionEvent(component, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers());
                }
            }
            if (jideTabbedPane.getCloseAction() != null) {
                jideTabbedPane.getCloseAction().actionPerformed(actionEvent2);
            } else if ("middleMouseButtonClicked".equals(actionEvent.getActionCommand())) {
                n = actionEvent.getID();
                if (n >= 0) {
                    jideTabbedPane.removeTabAt(n);
                }
                if (jideTabbedPane.getTabCount() == 0) {
                    jideTabbedPane.updateUI();
                }
            } else if (bl) {
                if (jideTabbedPane.getSelectedIndex() >= 0) {
                    jideTabbedPane.removeTabAt(jideTabbedPane.getSelectedIndex());
                }
                if (jideTabbedPane.getTabCount() == 0) {
                    jideTabbedPane.updateUI();
                }
            } else {
                int n2 = ((TabCloseButton)object).getIndex();
                if (n2 != -1) {
                    int n3 = jideTabbedPane.getSelectedIndex();
                    jideTabbedPane.removeTabAt(n2);
                    if (n2 < n3) {
                        jideTabbedPane.setSelectedIndex(n3 - 1);
                    }
                    if (jideTabbedPane.getTabCount() == 0) {
                        jideTabbedPane.updateUI();
                    }
                }
            }
        }
    }

    private static class ScrollTabsListAction
    extends AbstractAction {
        public ScrollTabsListAction() {
            this.putValue("ShortDescription", Resource.getResourceBundle(Locale.getDefault()).getString(BasicJideTabbedPaneUI.BUTTON_NAME_TAB_LIST));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicJideTabbedPaneUI basicJideTabbedPaneUI;
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof TabCloseButton) {
                jTabbedPane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, (TabCloseButton)object);
            }
            if (jTabbedPane != null && (basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI()).scrollableTabLayoutEnabled()) {
                if (basicJideTabbedPaneUI._tabScroller._popup != null && basicJideTabbedPaneUI._tabScroller._popup.isPopupVisible()) {
                    basicJideTabbedPaneUI._tabScroller._popup.hidePopupImmediately();
                    basicJideTabbedPaneUI._tabScroller._popup = null;
                } else {
                    basicJideTabbedPaneUI._tabScroller.createPopup(jTabbedPane.getTabPlacement());
                }
            }
        }
    }

    private static class ScrollTabsBackwardAction
    extends AbstractAction {
        public ScrollTabsBackwardAction() {
            this.putValue("ShortDescription", Resource.getResourceBundle(Locale.getDefault()).getString(BasicJideTabbedPaneUI.BUTTON_NAME_SCROLL_BACKWARD));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicJideTabbedPaneUI basicJideTabbedPaneUI;
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof TabCloseButton) {
                jTabbedPane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, (TabCloseButton)object);
            }
            if (jTabbedPane != null && (basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI()).scrollableTabLayoutEnabled()) {
                basicJideTabbedPaneUI._tabScroller.scrollBackward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private static class ScrollTabsForwardAction
    extends AbstractAction {
        public ScrollTabsForwardAction() {
            this.putValue("ShortDescription", Resource.getResourceBundle(Locale.getDefault()).getString(BasicJideTabbedPaneUI.BUTTON_NAME_SCROLL_FORWARD));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicJideTabbedPaneUI basicJideTabbedPaneUI;
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof TabCloseButton) {
                jTabbedPane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, (TabCloseButton)object);
            }
            if (jTabbedPane != null && (basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI()).scrollableTabLayoutEnabled()) {
                basicJideTabbedPaneUI._tabScroller.scrollForward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private static class SetSelectedIndexAction
    extends AbstractAction {
        private SetSelectedIndexAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            if (jTabbedPane != null && jTabbedPane.getUI() instanceof BasicJideTabbedPaneUI) {
                BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
                String string = actionEvent.getActionCommand();
                if (string != null && string.length() > 0) {
                    Integer n;
                    int n2 = actionEvent.getActionCommand().charAt(0);
                    if (n2 >= 97 && n2 <= 122) {
                        n2 -= 32;
                    }
                    if ((n = (Integer)basicJideTabbedPaneUI._mnemonicToIndexMap.get(new Integer(n2))) != null && jTabbedPane.isEnabledAt(n)) {
                        jTabbedPane.setSelectedIndex(n);
                    }
                }
            }
        }
    }

    private static class RequestFocusForVisibleAction
    extends AbstractAction {
        private RequestFocusForVisibleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            basicJideTabbedPaneUI.requestFocusForVisibleComponent();
        }
    }

    private static class RequestFocusAction
    extends AbstractAction {
        private RequestFocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            if (!jTabbedPane.requestFocusInWindow()) {
                jTabbedPane.requestFocus();
            }
        }
    }

    private static class PageDownAction
    extends AbstractAction {
        private PageDownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            int n = jTabbedPane.getTabPlacement();
            if (n == 1 || n == 3) {
                basicJideTabbedPaneUI.navigateSelectedTab(3);
            } else {
                basicJideTabbedPaneUI.navigateSelectedTab(5);
            }
        }
    }

    private static class PageUpAction
    extends AbstractAction {
        private PageUpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            int n = jTabbedPane.getTabPlacement();
            if (n == 1 || n == 3) {
                basicJideTabbedPaneUI.navigateSelectedTab(7);
            } else {
                basicJideTabbedPaneUI.navigateSelectedTab(1);
            }
        }
    }

    private static class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            basicJideTabbedPaneUI.navigateSelectedTab(13);
        }
    }

    private static class NextAction
    extends AbstractAction {
        private NextAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            basicJideTabbedPaneUI.navigateSelectedTab(12);
        }
    }

    private static class DownAction
    extends AbstractAction {
        private static final long serialVersionUID = -453174268282628886L;

        private DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            basicJideTabbedPaneUI.navigateSelectedTab(5);
        }
    }

    private static class UpAction
    extends AbstractAction {
        private static final long serialVersionUID = -6961702501242792445L;

        private UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            basicJideTabbedPaneUI.navigateSelectedTab(1);
        }
    }

    private static class LeftAction
    extends AbstractAction {
        private LeftAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            basicJideTabbedPaneUI.navigateSelectedTab(7);
        }
    }

    private static class RightAction
    extends AbstractAction {
        private static final long serialVersionUID = -1759791760116532857L;

        private RightAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            basicJideTabbedPaneUI.navigateSelectedTab(3);
        }
    }
}

