/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class ColumnFactory {
    private static ColumnFactory columnFactory;
    private int packMargin = 4;

    public static synchronized ColumnFactory getInstance() {
        if (columnFactory == null) {
            columnFactory = new ColumnFactory();
        }
        return columnFactory;
    }

    public static synchronized void setInstance(ColumnFactory factory) {
        columnFactory = factory;
    }

    public TableColumnExt createTableColumn(int modelIndex) {
        return new TableColumnExt(modelIndex);
    }

    public void configureTableColumn(TableModel model, TableColumnExt columnExt) {
        if (columnExt.getModelIndex() < 0 || columnExt.getModelIndex() >= model.getColumnCount()) {
            throw new IllegalStateException("column must have valid modelIndex");
        }
        columnExt.setHeaderValue(model.getColumnName(columnExt.getModelIndex()));
    }

    public TableColumnExt createAndConfigureTableColumn(TableModel model, int modelIndex) {
        TableColumnExt column = this.createTableColumn(modelIndex);
        this.configureTableColumn(model, column);
        return column;
    }

    public void configureColumnWidths(JXTable table, TableColumnExt columnExt) {
        Dimension cellSpacing = table.getIntercellSpacing();
        Object prototypeValue = columnExt.getPrototypeValue();
        if (prototypeValue != null) {
            JTableHeader header;
            TableCellRenderer renderer = table.getCellRenderer(0, table.convertColumnIndexToView(columnExt.getModelIndex()));
            Component comp = renderer.getTableCellRendererComponent(table, prototypeValue, false, false, 0, 0);
            int prefWidth = comp.getPreferredSize().width + cellSpacing.width;
            renderer = columnExt.getHeaderRenderer();
            if (renderer == null && (header = table.getTableHeader()) != null) {
                renderer = header.getDefaultRenderer();
            }
            if (renderer != null) {
                comp = renderer.getTableCellRendererComponent(table, columnExt.getHeaderValue(), false, false, 0, table.convertColumnIndexToView(columnExt.getModelIndex()));
                prefWidth = Math.max(comp.getPreferredSize().width, prefWidth);
            }
            columnExt.setPreferredWidth(prefWidth += table.getColumnModel().getColumnMargin());
        }
    }

    public void packColumn(JXTable table, TableColumnExt columnExt, int margin, int max) {
        TableCellRenderer renderer = columnExt.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        int column = table.convertColumnIndexToView(columnExt.getModelIndex());
        Component comp = renderer.getTableCellRendererComponent(table, columnExt.getHeaderValue(), false, false, 0, column);
        int width = comp.getPreferredSize().width;
        if (table.getRowCount() > 0) {
            renderer = table.getCellRenderer(0, column);
        }
        for (int r = 0; r < table.getRowCount(); ++r) {
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, column), false, false, r, column);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        if (margin < 0) {
            margin = this.getDefaultPackMargin();
        }
        if (max != -1 && (width += 2 * margin) > max) {
            width = max;
        }
        columnExt.setPreferredWidth(width);
    }

    public int getDefaultPackMargin() {
        return this.packMargin;
    }

    public void setDefaultPackMargin(int margin) {
        this.packMargin = margin;
    }
}

