/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Graphics2D;
import javax.swing.JComponent;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

public class CompoundPainter
extends AbstractPainter {
    private Painter[] painters = new Painter[0];

    public CompoundPainter() {
    }

    public CompoundPainter(Painter ... painters) {
        this.painters = new Painter[painters == null ? 0 : painters.length];
        if (painters != null) {
            System.arraycopy(painters, 0, this.painters, 0, painters.length);
        }
    }

    public void setPainters(Painter ... painters) {
        Painter[] old = this.getPainters();
        this.painters = new Painter[painters == null ? 0 : painters.length];
        if (painters != null) {
            System.arraycopy(painters, 0, this.painters, 0, painters.length);
        }
        this.firePropertyChange("painters", old, this.getPainters());
    }

    public Painter[] getPainters() {
        Painter[] results = new Painter[this.painters.length];
        System.arraycopy(this.painters, 0, results, 0, results.length);
        return results;
    }

    protected void paintBackground(Graphics2D g, JComponent component) {
        for (Painter p : this.getPainters()) {
            p.paint(g, component);
        }
    }
}

