/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jdesktop.swingx.painter.AbstractPainter;

public class CheckerboardPainter
extends AbstractPainter {
    private transient Paint checkerPaint;
    private Paint darkPaint = new Color(204, 204, 204);
    private Paint lightPaint = Color.WHITE;
    private int squareLength = 8;

    public CheckerboardPainter() {
    }

    public CheckerboardPainter(Paint darkPaint, Paint lightPaint) {
        this(darkPaint, lightPaint, 8);
    }

    public CheckerboardPainter(Paint darkPaint, Paint lightPaint, int length) {
        this.darkPaint = darkPaint;
        this.lightPaint = lightPaint;
        this.squareLength = length;
    }

    public void setSquareLength(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Length must be > 0");
        }
        int old = this.getSquareLength();
        this.squareLength = length;
        this.checkerPaint = null;
        this.firePropertyChange("squareLength", old, this.getSquareLength());
    }

    public int getSquareLength() {
        return this.squareLength;
    }

    public void setDarkPaint(Paint color) {
        Paint old = this.getDarkPaint();
        this.darkPaint = color;
        this.checkerPaint = null;
        this.firePropertyChange("darkPaint", old, this.getDarkPaint());
    }

    public Paint getDarkPaint() {
        return this.darkPaint;
    }

    public void setLightPaint(Paint color) {
        Paint old = this.getLightPaint();
        this.lightPaint = color;
        this.checkerPaint = null;
        this.firePropertyChange("lightPaint", old, this.getLightPaint());
    }

    public Paint getLightPaint() {
        return this.lightPaint;
    }

    private Paint getCheckerPaint(JComponent c) {
        if (this.checkerPaint == null) {
            int sqlength = this.getSquareLength();
            int length = sqlength * 2;
            BufferedImage image = new BufferedImage(length, length, 2);
            Graphics2D gfx = image.createGraphics();
            Paint p = this.getLightPaint();
            if (p == null) {
                p = c.getForeground();
            }
            gfx.setPaint(p);
            gfx.fillRect(0, 0, length, length);
            p = this.getDarkPaint();
            if (p == null) {
                p = c.getBackground();
            }
            gfx.setPaint(p);
            gfx.fillRect(0, 0, sqlength - 1, sqlength - 1);
            gfx.fillRect(sqlength, sqlength, sqlength - 1, sqlength - 1);
            gfx.dispose();
            this.checkerPaint = new TexturePaint(image, new Rectangle(0, 0, image.getWidth(), image.getHeight()));
        }
        return this.checkerPaint;
    }

    public void paintBackground(Graphics2D g, JComponent component) {
        g.setPaint(this.getCheckerPaint(component));
        g.fillRect(0, 0, component.getWidth(), component.getHeight());
    }
}

