/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXGradientChooser;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.multislider.ThumbRenderer;

public class GradientThumbRenderer
extends JComponent
implements ThumbRenderer {
    private final JXGradientChooser gradientPicker;
    private JXMultiThumbSlider slider;
    private Image thumb_black;
    private Image thumb_gray;
    private boolean selected;

    public GradientThumbRenderer(JXGradientChooser gradientPicker, JXMultiThumbSlider slider) {
        this.gradientPicker = gradientPicker;
        this.slider = slider;
        try {
            this.thumb_black = ImageIO.read(this.getClass().getResourceAsStream("/icons/thumb_black.png"));
            this.thumb_gray = ImageIO.read(this.getClass().getResourceAsStream("/icons/thumb_gray.png"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void paintComponent(Graphics g) {
        GradientThumbRenderer thumb = this;
        int w = thumb.getWidth();
        g.setColor(this.getForeground());
        g.fillRect(0, 0, w - 1, w - 1);
        if (this.selected) {
            g.drawImage(this.thumb_black, 0, 0, null);
        } else {
            g.drawImage(this.thumb_gray, 0, 0, null);
        }
    }

    public JComponent getThumbRendererComponent(JXMultiThumbSlider slider, int index, boolean selected) {
        Color c = this.gradientPicker.getSlider().getModel().getThumbAt(index).getObject();
        c = ColorUtil.removeAlpha(c);
        this.setForeground(c);
        this.selected = selected;
        return this;
    }
}

