/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.EventHandler;
import java.beans.Statement;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;
import org.jdesktop.swingx.action.AbstractActionExt;

public class BoundAction
extends AbstractActionExt {
    private static final Logger LOG = Logger.getLogger(BoundAction.class.getName());
    private EventListenerList listeners;

    public BoundAction() {
        this("BoundAction");
    }

    public BoundAction(String name) {
        super(name);
    }

    public BoundAction(String name, String command) {
        super(name, command);
    }

    public BoundAction(String name, Icon icon) {
        super(name, icon);
    }

    public BoundAction(String name, String command, Icon icon) {
        super(name, command, icon);
    }

    public void setCallback(String callback) {
        String[] elems = callback.split("#", 2);
        if (elems.length == 2) {
            try {
                Class<?> clz = Class.forName(elems[0]);
                Object obj = clz.newInstance();
                this.registerCallback(obj, elems[1]);
            }
            catch (Exception ex) {
                LOG.fine("ERROR: setCallback(" + callback + ") - " + ex.getMessage());
            }
        }
    }

    public void registerCallback(Object handler, String method) {
        if (this.isStateAction()) {
            this.addItemListener(new BooleanInvocationHandler(handler, method));
        } else {
            this.addActionListener(EventHandler.create(ActionListener.class, handler, method));
        }
    }

    private void addListener(Class clz, EventListener listener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(clz, listener);
    }

    private void removeListener(Class clz, EventListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(clz, listener);
        }
    }

    private EventListener[] getListeners(Class clz) {
        if (this.listeners == null) {
            return null;
        }
        return this.listeners.getListeners(clz);
    }

    public void addActionListener(ActionListener listener) {
        this.addListener(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.removeListener(ActionListener.class, listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    public void addItemListener(ItemListener listener) {
        this.addListener(ItemListener.class, listener);
    }

    public void removeItemListener(ItemListener listener) {
        this.removeListener(ItemListener.class, listener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(ItemListener.class);
    }

    public void actionPerformed(ActionEvent evt) {
        ActionListener[] alist = this.getActionListeners();
        if (alist != null) {
            for (int i = 0; i < alist.length; ++i) {
                alist[i].actionPerformed(evt);
            }
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        boolean newValue;
        boolean oldValue = this.isSelected();
        if (oldValue != (newValue = evt.getStateChange() == 1)) {
            this.setSelected(newValue);
            ItemListener[] ilist = this.getItemListeners();
            if (ilist != null) {
                for (int i = 0; i < ilist.length; ++i) {
                    ilist[i].itemStateChanged(evt);
                }
            }
        }
    }

    private class BooleanInvocationHandler
    implements ItemListener {
        private Statement falseStatement;
        private Statement trueStatement;

        public BooleanInvocationHandler(Object target, String methodName) {
            this.falseStatement = new Statement(target, methodName, new Object[]{Boolean.FALSE});
            this.trueStatement = new Statement(target, methodName, new Object[]{Boolean.TRUE});
        }

        public void itemStateChanged(ItemEvent evt) {
            Statement statement = evt.getStateChange() == 2 ? this.falseStatement : this.trueStatement;
            try {
                statement.execute();
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "Couldn't execute boolean method via Statement " + statement, ex);
            }
        }
    }
}

