/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.properties;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.exception.TablePropertiesLoadException;
import org.displaytag.export.MediaTypeEnum;

public class TableProperties {
    private static Log log = LogFactory.getLog((Class)(class$org$displaytag$properties$TableProperties == null ? (class$org$displaytag$properties$TableProperties = TableProperties.class$("org.displaytag.properties.TableProperties")) : class$org$displaytag$properties$TableProperties));
    private static final String DEFAULT_FILENAME = "TableTag.properties";
    private static String mPropertiesFilename = "TableTag.properties";
    public static final String LOCAL_PROPERTIES = "displaytag";
    private static Properties userProperties = new Properties();
    private Properties properties = null;
    private static final String PROPERTY_BOOLEAN_EXPORT_PREFIX = "export";
    private static final String PROPERTY_STRING_EXPORT_LABEL = "label";
    private static final String PROPERTY_BOOLEAN_EXPORT_HEADER = "include_header";
    private static final String PROPERTY_STRING_EXPORTBANNER = "export.banner";
    private static final String PROPERTY_STRING_EXPORTBANNER_SEPARATOR = "export.banner.sepchar";
    private static final String PROPERTY_BOOLEAN_EXPORTDECORATED = "export.decorated";
    private static final String PROPERTY_STRING_EXPORTAMOUNT = "export.amount";
    private static final String PROPERTY_STRING_EXPORT_FILENAME = "export.filename";
    private static final String PROPERTY_BOOLEAN_SHOWHEADER = "basic.show.header";
    private static final String PROPERTY_STRING_EMPTYLIST_MESSAGE = "basic.msg.empty_list";
    private static final String PROPERTY_STRING_BANNER_PLACEMENT = "paging.banner.placement";
    private static final String PROPERTY_STRING_PAGING_INVALIDPAGE = "error.msg.invalid_page";
    private static final String PROPERTY_STRING_PAGING_ITEM_NAME = "paging.banner.item_name";
    private static final String PROPERTY_STRING_PAGING_ITEMS_NAME = "paging.banner.items_name";
    private static final String PROPERTY_STRING_PAGING_NOITEMS = "paging.banner.no_items_found";
    private static final String PROPERTY_STRING_PAGING_FOUND_ONEITEM = "paging.banner.one_item_found";
    private static final String PROPERTY_STRING_PAGING_FOUND_ALLITEMS = "paging.banner.all_items_found";
    private static final String PROPERTY_STRING_PAGING_FOUND_SOMEITEMS = "paging.banner.some_items_found";
    private static final String PROPERTY_INT_PAGING_GROUPSIZE = "paging.banner.group_size";
    private static final String PROPERTY_STRING_PAGING_BANNER_ONEPAGE = "paging.banner.onepage";
    private static final String PROPERTY_STRING_PAGING_BANNER_FIRST = "paging.banner.first";
    private static final String PROPERTY_STRING_PAGING_BANNER_LAST = "paging.banner.last";
    private static final String PROPERTY_STRING_PAGING_BANNER_FULL = "paging.banner.full";
    private static final String PROPERTY_STRING_PAGING_PAGE_LINK = "paging.banner.page.link";
    private static final String PROPERTY_STRING_PAGING_PAGE_SELECTED = "paging.banner.page.selected";
    private static final String PROPERTY_STRING_PAGING_PAGE_SPARATOR = "paging.banner.page.separator";
    private static final String PROPERTY_STRING_SAVE_EXCEL_FILENAME = "save.excel.filename";
    private static final String PROPERTY_STRING_SAVE_EXCEL_BANNER = "save.excel.banner";
    static /* synthetic */ Class class$org$displaytag$properties$TableProperties;

    public static Properties getUserProperties() {
        return userProperties;
    }

    public static void setUserProperties(Properties overrideProperties) {
        Enumeration enumeration = ((Hashtable)overrideProperties).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (key == null || ((Hashtable)overrideProperties).get(key) == null) continue;
            userProperties.setProperty(key, (String)((Hashtable)overrideProperties).get(key));
        }
    }

    public String getPagingInvalidPage() {
        return this.getProperty(PROPERTY_STRING_PAGING_INVALIDPAGE);
    }

    public String getPagingItemName() {
        return this.getProperty(PROPERTY_STRING_PAGING_ITEM_NAME);
    }

    public String getPagingItemsName() {
        return this.getProperty(PROPERTY_STRING_PAGING_ITEMS_NAME);
    }

    public String getPagingFoundNoItems() {
        return this.getProperty(PROPERTY_STRING_PAGING_NOITEMS);
    }

    public String getPagingFoundOneItem() {
        return this.getProperty(PROPERTY_STRING_PAGING_FOUND_ONEITEM);
    }

    public String getPagingFoundAllItems() {
        return this.getProperty(PROPERTY_STRING_PAGING_FOUND_ALLITEMS);
    }

    public String getPagingFoundSomeItems() {
        return this.getProperty(PROPERTY_STRING_PAGING_FOUND_SOMEITEMS);
    }

    public int getPagingGroupSize(int defaultValue) {
        return this.getIntProperty(PROPERTY_INT_PAGING_GROUPSIZE, defaultValue);
    }

    public String getPagingBannerOnePage() {
        return this.getProperty(PROPERTY_STRING_PAGING_BANNER_ONEPAGE);
    }

    public String getPagingBannerFirst() {
        return this.getProperty(PROPERTY_STRING_PAGING_BANNER_FIRST);
    }

    public String getPagingBannerLast() {
        return this.getProperty(PROPERTY_STRING_PAGING_BANNER_LAST);
    }

    public String getPagingBannerFull() {
        return this.getProperty(PROPERTY_STRING_PAGING_BANNER_FULL);
    }

    public String getPagingPageLink() {
        return this.getProperty(PROPERTY_STRING_PAGING_PAGE_LINK);
    }

    public String getPagingPageSelected() {
        return this.getProperty(PROPERTY_STRING_PAGING_PAGE_SELECTED);
    }

    public String getPagingPageSeparator() {
        return this.getProperty(PROPERTY_STRING_PAGING_PAGE_SPARATOR);
    }

    public boolean getAddExport(MediaTypeEnum exportType) {
        return this.getBooleanProperty("export." + exportType.getName());
    }

    public boolean getExportHeader(MediaTypeEnum exportType) {
        return this.getBooleanProperty("export." + exportType + "." + PROPERTY_BOOLEAN_EXPORT_HEADER);
    }

    public String getExportLabel(MediaTypeEnum exportType) {
        return this.getProperty("export." + exportType + "." + PROPERTY_STRING_EXPORT_LABEL);
    }

    public boolean getExportDecorated() {
        return this.getBooleanProperty(PROPERTY_BOOLEAN_EXPORTDECORATED);
    }

    public String getExportFileName() {
        return this.getProperty(PROPERTY_STRING_EXPORT_FILENAME);
    }

    public String getExportBanner() {
        return this.getProperty(PROPERTY_STRING_EXPORTBANNER);
    }

    public String getExportBannerSeparator() {
        return this.getProperty(PROPERTY_STRING_EXPORTBANNER_SEPARATOR);
    }

    public boolean getShowHeader() {
        return this.getBooleanProperty(PROPERTY_BOOLEAN_SHOWHEADER);
    }

    public String getEmptyListMessage() {
        return this.getProperty(PROPERTY_STRING_EMPTYLIST_MESSAGE);
    }

    public boolean getExportFullList() {
        return "list".equals(this.getProperty(PROPERTY_STRING_EXPORTAMOUNT));
    }

    public boolean getAddPagingBannerTop() {
        String placement = this.getProperty(PROPERTY_STRING_BANNER_PLACEMENT);
        return "top".equals(placement) || "both".equals(placement);
    }

    public boolean getAddPagingBannerBottom() {
        String placement = this.getProperty(PROPERTY_STRING_BANNER_PLACEMENT);
        return "bottom".equals(placement) || "both".equals(placement);
    }

    public String getSaveExcelFilename() {
        return this.getProperty(PROPERTY_STRING_SAVE_EXCEL_FILENAME);
    }

    public String getSaveExcelBanner() {
        return this.getProperty(PROPERTY_STRING_SAVE_EXCEL_BANNER);
    }

    public String getNoColumnMessage() {
        return "Please provide column tags";
    }

    public TableProperties() throws TablePropertiesLoadException {
        Properties defaultProperties = new Properties();
        try {
            defaultProperties.load(this.getClass().getResourceAsStream(mPropertiesFilename));
            this.properties = new Properties(defaultProperties);
        }
        catch (Exception ex) {
            throw new TablePropertiesLoadException(this.getClass(), mPropertiesFilename, ex);
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(LOCAL_PROPERTIES);
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                this.properties.setProperty(key, bundle.getString(key));
            }
        }
        catch (MissingResourceException e) {
            log.info((Object)("Was not able to load a displaytag.properties; " + e.getMessage()));
        }
        Enumeration keys = ((Hashtable)userProperties).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key == null) continue;
            this.properties.setProperty(key, (String)((Hashtable)userProperties).get(key));
        }
    }

    private String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    private boolean getBooleanProperty(String key) {
        return Boolean.TRUE.toString().equals(this.getProperty(key));
    }

    private int getIntProperty(String key, int defaultValue) {
        int intValue = defaultValue;
        try {
            intValue = Integer.parseInt(this.getProperty(key));
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Invalid value for \"pPropertyName\" property: value=\"" + this.getProperty(key) + "\"; using default \"pDefault\""));
        }
        return intValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

