/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import java.util.Iterator;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class MediaTypeEnum {
    public static final MediaTypeEnum CSV = new MediaTypeEnum(1, "csv");
    public static final MediaTypeEnum EXCEL = new MediaTypeEnum(2, "excel");
    public static final MediaTypeEnum XML = new MediaTypeEnum(3, "xml");
    public static final MediaTypeEnum HTML = new MediaTypeEnum(4, "html");
    public static final MediaTypeEnum[] ALL = new MediaTypeEnum[]{EXCEL, XML, CSV, HTML};
    private final int enumCode;
    private final String enumName;

    private MediaTypeEnum(int code, String name) {
        this.enumCode = code;
        this.enumName = name;
    }

    public int getCode() {
        return this.enumCode;
    }

    public String getName() {
        return this.enumName;
    }

    public static MediaTypeEnum fromCode(int key) {
        int i = 0;
        while (i < ALL.length) {
            if (key == ALL[i].getCode()) {
                return ALL[i];
            }
            ++i;
        }
        return null;
    }

    public static MediaTypeEnum fromIntegerCode(Integer key) {
        if (key == null) {
            return null;
        }
        return MediaTypeEnum.fromCode(key);
    }

    public static MediaTypeEnum fromName(String code) {
        if (code == null) {
            return null;
        }
        int i = 0;
        while (i < ALL.length) {
            if (ALL[i].getName().equals(code)) {
                return ALL[i];
            }
            ++i;
        }
        return null;
    }

    public static Iterator iterator() {
        return IteratorUtils.arrayIterator((Object[])ALL);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return new HashCodeBuilder(1188997057, -1289297553).append(this.enumCode).toHashCode();
    }
}

