/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11.tests;

import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.test.validator.Assertion;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp11.ExtensibleSecurityTokenProfile;
import org.wsi.test.validator.bsp11.ProfileServiceBSP11;
import org.wsi.test.validator.bsp11.entrytypes.BinarySecurityTokenEntryType;
import org.wsi.test.validator.bsp11.entrytypes.SecurityTokenReferenceEntryType;
import org.wsi.test.validator.bsp11.entrytypes.StrEmbeddedEntryType;

public class BSP3060
extends Assertion {
    public BSP3060(Element el) {
        super(el);
    }

    public boolean isApplicable(Entry e) {
        return e instanceof StrEmbeddedEntryType;
    }

    private boolean isInternalSecurityToken(Element el) throws ValidatorException {
        if (BinarySecurityTokenEntryType.getFactory().isValidElement(el)) {
            return true;
        }
        if (SecurityTokenReferenceEntryType.getFactory().isValidElement(el)) {
            return true;
        }
        List<ExtensibleSecurityTokenProfile> profileExtensions = ProfileServiceBSP11.getSecurityTokenExtensions();
        for (ExtensibleSecurityTokenProfile profile : profileExtensions) {
            if (!profile.isValidElement(el)) continue;
            return true;
        }
        return false;
    }

    public boolean applyRule(Entry entry) throws ValidatorException {
        Element strEmbedded = entry.getElement();
        NodeList children = strEmbedded.getChildNodes();
        boolean childElementFound = false;
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                if (childElementFound) {
                    return false;
                }
                childElementFound = true;
                if (!this.isInternalSecurityToken((Element)child)) {
                    return false;
                }
            }
            ++i;
        }
        return childElementFound;
    }
}

