/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11.entrytypes;

import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.test.validator.bsp11.SecureConstants;
import org.wsi.test.validator.bsp11.entrytypes.SecureEntryType;

public abstract class ReferenceListEntryType
extends SecureEntryType {
    protected ReferenceListEntryType(Element e) {
        super(e);
    }

    public String[] getAllReferenceURIs() {
        String[] keyRefs = this.getKeyReferenceURIs();
        String[] dataRefs = this.getDataReferenceURIs();
        String[] allRefs = new String[keyRefs.length + dataRefs.length];
        int i = 0;
        while (i < keyRefs.length) {
            allRefs[i] = keyRefs[i];
            ++i;
        }
        i = 0;
        while (i < dataRefs.length) {
            allRefs[keyRefs.length + i] = dataRefs[i];
            ++i;
        }
        return allRefs;
    }

    public String[] getKeyReferenceURIs() {
        return this.getReferenceURIs("KeyReference");
    }

    public String[] getDataReferenceURIs() {
        return this.getReferenceURIs("DataReference");
    }

    public Element[] getDataReferenceElements() {
        return this.getReferenceElements("DataReference");
    }

    private Element[] getReferenceElements(String refType) {
        NodeList children = this.getElement().getChildNodes();
        ArrayList<Element> refs = new ArrayList<Element>();
        int i = 0;
        while (i < children.getLength()) {
            Element child;
            Node childNode = children.item(i);
            if (childNode.getNodeType() == 1 && (child = (Element)childNode).getNamespaceURI().equals(SecureConstants.XENC_NAMESPACE) && child.getLocalName().equals(refType)) {
                refs.add(child);
            }
            ++i;
        }
        return refs.toArray(new Element[0]);
    }

    private String[] getReferenceURIs(String refType) {
        NodeList children = this.getElement().getChildNodes();
        ArrayList<String> refs = new ArrayList<String>();
        int i = 0;
        while (i < children.getLength()) {
            Element child;
            Node childNode = children.item(i);
            if (childNode.getNodeType() == 1 && (child = (Element)childNode).getNamespaceURI().equals(SecureConstants.XENC_NAMESPACE) && child.getLocalName().equals(refType) && child.hasAttribute("URI")) {
                refs.add(child.getAttribute("URI"));
            }
            ++i;
        }
        return refs.toArray(new String[0]);
    }
}

