/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.ClobWithIO;
import java.io.IOException;
import java.io.Reader;

class ClobReader
extends Reader {
    private ClobWithIO clob;
    private int pointer;
    private int mark;

    ClobReader(ClobWithIO clobWithIO) {
        this.clob = clobWithIO;
        this.pointer = 0;
        this.mark = -1;
    }

    public int read() throws IOException {
        char[] cArray = new char[1];
        int n2 = this.read(cArray);
        if (n2 != 1) {
            return -1;
        }
        return cArray[0];
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n2, int n3) throws IOException {
        if (this.clob == null) {
            throw new IOException("Reader is closed");
        }
        if (n2 < 0 || n2 >= cArray.length || n3 <= 0 || n2 + n3 > cArray.length) {
            throw new IOException("invalid offset/length");
        }
        try {
            int n4 = (int)this.clob.size();
            if (n4 <= this.pointer) {
                return -1;
            }
            int n5 = Math.min(n3, n4 - this.pointer);
            int n6 = this.clob.substr(this.pointer, cArray, n2, n5);
            if (n6 < 0) {
                return -1;
            }
            this.pointer += n6;
            return n6;
        }
        catch (Exception exception) {
            throw new IOException("I/O error during Clob read(): " + exception);
        }
    }

    public long skip(long l2) throws IOException {
        if (this.clob == null) {
            throw new IOException("Reader is closed");
        }
        try {
            int n2 = (int)this.clob.size();
            int n3 = (long)this.pointer + l2 >= (long)n2 ? n2 : ((long)this.pointer + l2 <= 0L ? 0 : this.pointer + (int)l2);
            int n4 = n3 - this.pointer;
            this.pointer = n3;
            return n4;
        }
        catch (Exception exception) {
            throw new IOException("I/O error on Clob skip(): " + exception);
        }
    }

    public int available() throws IOException {
        if (this.clob == null) {
            throw new IOException("Reader is closed");
        }
        try {
            return (int)this.clob.size() - this.pointer;
        }
        catch (Exception exception) {
            throw new IOException("I/O error on Clob available(): " + exception);
        }
    }

    public synchronized void mark(int n2) throws IOException {
        if (this.clob == null) {
            throw new IOException("Reader is closed");
        }
        this.mark = this.pointer;
    }

    public synchronized void reset() throws IOException {
        if (this.clob == null) {
            throw new IOException("Reader is closed");
        }
        this.pointer = this.mark < 0 ? 0 : this.mark;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() {
        this.clob = null;
    }
}

