/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.message;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.demux.MessageDecoder;
import org.apache.mina.filter.codec.demux.MessageDecoderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.mina.CriticalProtocolCodecException;

public class FIXMessageDecoder
implements MessageDecoder {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final byte[] HEADER_PATTERN = "8=FIX.?.?\u00019=".getBytes();
    private static final byte[] CHECKSUM_PATTERN = "10=???\u0001".getBytes();
    private static final byte[] LOGON_PATTERN = "\u000135=A\u0001".getBytes();
    private static final int SEEKING_HEADER = 1;
    private static final int PARSING_LENGTH = 2;
    private static final int READING_BODY = 3;
    private static final int PARSING_CHECKSUM = 4;
    private int state;
    private int bodyLength;
    private int position;
    private int headerOffset;

    private void resetState() {
        this.state = 1;
        this.bodyLength = 0;
        this.position = 0;
    }

    public FIXMessageDecoder() {
        this.resetState();
    }

    public MessageDecoderResult decodable(IoSession session, ByteBuffer in) {
        this.headerOffset = FIXMessageDecoder.indexOf(in, in.position(), HEADER_PATTERN);
        return this.headerOffset != -1 ? MessageDecoderResult.OK : MessageDecoderResult.NEED_DATA;
    }

    public MessageDecoderResult decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws ProtocolCodecException {
        int messageCount = 0;
        while (this.parseMessage(in, out)) {
            ++messageCount;
        }
        if (messageCount > 0) {
            if (in.remaining() < HEADER_PATTERN.length) {
                this.position = 0;
            }
            return MessageDecoderResult.OK;
        }
        this.position -= in.position();
        return MessageDecoderResult.NEED_DATA;
    }

    private boolean parseMessage(ByteBuffer in, ProtocolDecoderOutput out) throws ProtocolCodecException {
        try {
            boolean messageFound = false;
            while (in.hasRemaining() && !messageFound) {
                if (this.state == 1) {
                    int headerOffset = FIXMessageDecoder.indexOf(in, this.position, HEADER_PATTERN);
                    if (headerOffset == -1) break;
                    in.position(headerOffset);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("detected header: " + this.getBufferDebugInfo(in));
                    }
                    this.position = headerOffset + HEADER_PATTERN.length;
                    this.state = 2;
                }
                if (this.state == 2) {
                    byte ch = 0;
                    while (this.hasRemaining(in) && Character.isDigit((char)(ch = this.get(in)))) {
                        this.bodyLength = this.bodyLength * 10 + (ch - 48);
                    }
                    if (ch == 1) {
                        this.state = 3;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("body length = " + this.bodyLength + ": " + this.getBufferDebugInfo(in));
                        }
                    } else {
                        if (!this.hasRemaining(in)) break;
                        this.handleError(in, in.position() + 1, "Error in message length format", false);
                        continue;
                    }
                }
                if (this.state == 3) {
                    if (this.remaining(in) < this.bodyLength) break;
                    this.position += this.bodyLength;
                    this.state = 4;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("message body found: " + this.getBufferDebugInfo(in));
                    }
                }
                if (this.state != 4) continue;
                if (FIXMessageDecoder.startsWith(in, this.position, CHECKSUM_PATTERN)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("found checksum: " + this.getBufferDebugInfo(in));
                    }
                    this.position += CHECKSUM_PATTERN.length;
                } else {
                    if (this.position + CHECKSUM_PATTERN.length >= in.limit()) break;
                    int recoveryPosition = this.position + 1;
                    this.handleError(in, recoveryPosition, "did not find checksum field, bad length?", this.isLogon(in));
                    continue;
                }
                String messageString = this.getMessageString(in);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("parsed message: " + this.getBufferDebugInfo(in) + " " + messageString);
                }
                out.write((Object)messageString);
                this.state = 1;
                this.bodyLength = 0;
                messageFound = true;
            }
            return messageFound;
        }
        catch (Throwable t) {
            this.state = 1;
            this.position = 0;
            this.bodyLength = 0;
            if (t instanceof ProtocolCodecException) {
                throw (ProtocolCodecException)t;
            }
            throw new ProtocolCodecException(t);
        }
    }

    private int remaining(ByteBuffer in) {
        return in.limit() - this.position;
    }

    private String getBufferDebugInfo(ByteBuffer in) {
        return "pos=" + in.position() + ",lim=" + in.limit() + ",rem=" + in.remaining() + ",offset=" + this.position + ",state=" + this.state;
    }

    private byte get(ByteBuffer in) {
        return in.get(this.position++);
    }

    private boolean hasRemaining(ByteBuffer in) {
        return this.position < in.limit();
    }

    private String getMessageString(ByteBuffer buffer) {
        byte[] data = new byte[this.position - buffer.position()];
        buffer.get(data);
        return new String(data);
    }

    private void handleError(ByteBuffer buffer, int recoveryPosition, String text, boolean disconnect) throws ProtocolCodecException {
        buffer.position(recoveryPosition);
        this.position = recoveryPosition;
        this.state = 1;
        this.bodyLength = 0;
        if (disconnect) {
            throw new CriticalProtocolCodecException(text);
        }
        this.log.error(text);
    }

    private boolean isLogon(ByteBuffer buffer) {
        return FIXMessageDecoder.indexOf(buffer, buffer.position(), LOGON_PATTERN) != -1;
    }

    private static int indexOf(ByteBuffer buffer, int position, byte[] data) {
        int limit = buffer.limit() - data.length + 1;
        for (int offset = position; offset < limit; ++offset) {
            if (buffer.get(offset) != data[0] || !FIXMessageDecoder.startsWith(buffer, offset, data)) continue;
            return offset;
        }
        return -1;
    }

    private static boolean startsWith(ByteBuffer buffer, int bufferOffset, byte[] data) {
        if (bufferOffset + data.length > buffer.limit()) {
            return false;
        }
        int bufferLimit = buffer.limit() - data.length + 1;
        for (int dataOffset = 0; dataOffset < data.length && bufferOffset < bufferLimit; ++dataOffset, ++bufferOffset) {
            if (buffer.get(bufferOffset) == data[dataOffset] || data[dataOffset] == 63) continue;
            return false;
        }
        return true;
    }
}

