/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.LogUtil;
import quickfix.Message;
import quickfix.Session;
import quickfix.SystemTime;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.SessionConnector;

public class SingleThreadedEventHandlingStrategy
implements EventHandlingStrategy {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private BlockingQueue eventQueue = new LinkedBlockingQueue();
    private volatile boolean isStopped;
    private long stopTime = 0L;
    private SessionConnector sessionConnector;

    public SingleThreadedEventHandlingStrategy(SessionConnector connector) {
        this.sessionConnector = connector;
    }

    public void onMessage(Session quickfixSession, Message message) {
        try {
            this.eventQueue.put((Object)new SessionMessageEvent(quickfixSession, message));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void block() {
        while (true) {
            if (this.isStopped) {
                if (this.stopTime == 0L) {
                    this.stopTime = SystemTime.currentTimeMillis();
                }
                if (!this.sessionConnector.isLoggedOn() || SystemTime.currentTimeMillis() - this.stopTime > 5000L) {
                    this.sessionConnector.stopSessionTimer();
                    return;
                }
            }
            try {
                SessionMessageEvent event = this.getMessage();
                if (event == null) continue;
                event.processMessage();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private SessionMessageEvent getMessage() throws InterruptedException {
        return (SessionMessageEvent)this.eventQueue.poll(1000L, TimeUnit.MILLISECONDS);
    }

    public void blockInThread() {
        Thread messageProcessingThread = new Thread(new Runnable(){

            public void run() {
                SingleThreadedEventHandlingStrategy.this.block();
            }
        }, "QFJ Socket Acceptor " + Integer.toHexString(System.identityHashCode(this)));
        messageProcessingThread.setDaemon(true);
        messageProcessingThread.start();
    }

    public boolean poll() {
        if (this.isStopped) {
            if (this.stopTime == 0L) {
                this.stopTime = SystemTime.currentTimeMillis();
            }
            if (!this.sessionConnector.isLoggedOn() || SystemTime.currentTimeMillis() - this.stopTime > 5000L) {
                this.sessionConnector.stopSessionTimer();
                return false;
            }
        }
        try {
            SessionMessageEvent event = this.getMessage();
            if (event != null) {
                event.processMessage();
            }
        }
        catch (InterruptedException e) {
            this.log.error("Unexpected exception: " + e);
        }
        return true;
    }

    public void stopHandlingMessages() {
        this.isStopped = true;
    }

    private static class SessionMessageEvent {
        private Session quickfixSession;
        private Message message;

        public SessionMessageEvent(Session session, Message message) {
            this.message = message;
            this.quickfixSession = session;
        }

        public void processMessage() {
            try {
                if (this.quickfixSession.getResponder() != null) {
                    this.quickfixSession.next(this.message);
                }
            }
            catch (Throwable e) {
                LogUtil.logThrowable(this.quickfixSession.getSessionID(), e.getMessage(), e);
            }
        }
    }
}

