/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.ConfigError;
import quickfix.FieldConvertError;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.field.converter.IntConverter;

public abstract class SessionConnector {
    public static final String QF_SESSION = "QF_SESSION";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map sessions;
    private final SessionSettings settings;
    private final SessionFactory sessionFactory;
    private static final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new QFTimerThreadFactory());
    private ScheduledFuture sessionTimerFuture;

    public SessionConnector(SessionSettings settings, SessionFactory sessionFactory) throws ConfigError {
        this.settings = settings;
        this.sessionFactory = sessionFactory;
        if (settings == null) {
            throw new ConfigError("no settings");
        }
    }

    protected void setSessions(Map sessions) {
        this.sessions = sessions;
    }

    public List getManagedSessions() {
        return new ArrayList(this.sessions.values());
    }

    protected Map getSessionMap() {
        return this.sessions;
    }

    public ArrayList getSessions() {
        return new ArrayList(this.sessions.keySet());
    }

    public SessionSettings getSettings() {
        return this.settings;
    }

    protected Session createSession(SessionID sessionID) throws ConfigError {
        return this.sessionFactory.create(sessionID, this.settings);
    }

    protected int getIntSetting(String key) throws ConfigError {
        try {
            return IntConverter.convert(this.settings.getString(key));
        }
        catch (FieldConvertError e) {
            throw (ConfigError)new ConfigError(e.getMessage()).fillInStackTrace();
        }
    }

    public boolean isLoggedOn() {
        Iterator sessionItr = this.sessions.values().iterator();
        while (sessionItr.hasNext()) {
            Session s = (Session)sessionItr.next();
            if (!s.isLoggedOn()) continue;
            return true;
        }
        return false;
    }

    protected void logoutAllSessions(boolean forceDisconnect) {
        Session session;
        this.log.info("Logging out all sessions");
        if (this.sessions == null) {
            this.log.error("Attempt to logout all sessions before intialization is complete.");
            return;
        }
        Iterator sessionItr = this.sessions.values().iterator();
        while (sessionItr.hasNext()) {
            session = (Session)sessionItr.next();
            try {
                session.logout();
            }
            catch (Throwable e) {
                this.logError(session.getSessionID(), null, "Error during logout", e);
            }
        }
        if (forceDisconnect && this.isLoggedOn()) {
            sessionItr = this.sessions.values().iterator();
            while (sessionItr.hasNext()) {
                session = (Session)sessionItr.next();
                try {
                    if (!session.isLoggedOn()) continue;
                    session.getLog().onEvent("Forcibly disconnecting session");
                    session.disconnect();
                }
                catch (Throwable e) {
                    this.logError(session.getSessionID(), null, "Error during disconnect", e);
                }
            }
        }
        if (!forceDisconnect) {
            this.waitForLogout();
        }
    }

    protected void waitForLogout() {
        if (this.isLoggedOn()) {
            this.log.info("Waiting for session logout");
            for (int second = 1; second <= 10 && this.isLoggedOn(); ++second) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void logError(SessionID sessionID, IoSession protocolSession, String message, Throwable t) {
        this.log.error(message + this.getLogSuffix(sessionID, protocolSession), t);
    }

    private String getLogSuffix(SessionID sessionID, IoSession protocolSession) {
        String suffix = ":";
        if (sessionID != null) {
            suffix = suffix + "sessionID=" + sessionID.toString() + ";";
        }
        if (protocolSession != null) {
            suffix = suffix + "address=" + protocolSession.getRemoteAddress();
        }
        return suffix;
    }

    protected void startSessionTimer() {
        this.sessionTimerFuture = scheduledExecutorService.scheduleAtFixedRate((Runnable)new SessionTimerTask(), 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    protected void stopSessionTimer() {
        if (this.sessionTimerFuture != null) {
            this.sessionTimerFuture.cancel(false);
        }
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        return scheduledExecutorService;
    }

    private static class QFTimerThreadFactory
    implements ThreadFactory {
        private QFTimerThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "QFJ Timer");
        }
    }

    private class SessionTimerTask
    implements Runnable {
        private SessionTimerTask() {
        }

        public void run() {
            try {
                Iterator sessionItr = SessionConnector.this.sessions.values().iterator();
                while (sessionItr.hasNext()) {
                    Session session = (Session)sessionItr.next();
                    try {
                        if (session.getResponder() == null) continue;
                        session.next();
                    }
                    catch (IOException e) {
                        SessionConnector.this.logError(session.getSessionID(), null, "Error in session timer processing", e);
                    }
                }
            }
            catch (Throwable e) {
                SessionConnector.this.log.error("Error during timer processing", e);
            }
        }
    }
}

