/*
 * Decompiled with CFR 0.152.
 */
package quickfix.field.converter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import quickfix.FieldConvertError;
import quickfix.RuntimeError;

public class DoubleConverter {
    private static final Pattern decimalPattern = Pattern.compile("-?\\d*(\\.\\d*)?");
    private static ThreadLocal threadDecimalFormats = new ThreadLocal();

    public static String convert(double d) {
        return DoubleConverter.convert(d, 0);
    }

    private static DecimalFormat getDecimalFormat(int padding) {
        DecimalFormat f;
        if (padding > 14) {
            throw new RuntimeError("maximum padding of 14 zeroes is supported: " + padding);
        }
        DecimalFormat[] decimalFormats = (DecimalFormat[])threadDecimalFormats.get();
        if (decimalFormats == null) {
            decimalFormats = new DecimalFormat[14];
            threadDecimalFormats.set(decimalFormats);
        }
        if ((f = decimalFormats[padding]) == null) {
            int i;
            StringBuffer buffer = new StringBuffer("0.");
            for (i = 0; i < padding; ++i) {
                buffer.append('0');
            }
            for (i = padding; i < 14; ++i) {
                buffer.append('#');
            }
            f = new DecimalFormat(buffer.toString());
            f.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
            decimalFormats[padding] = f;
        }
        return f;
    }

    public static String convert(double d, int padding) {
        return DoubleConverter.getDecimalFormat(padding).format(d);
    }

    public static double convert(String value) throws FieldConvertError {
        try {
            Matcher matcher = decimalPattern.matcher(value);
            if (!matcher.matches()) {
                throw new NumberFormatException();
            }
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new FieldConvertError("invalid double value: " + value);
        }
    }
}

