/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.ordermatch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import quickfix.examples.ordermatch.Market;
import quickfix.examples.ordermatch.Order;

public class OrderMatcher {
    private HashMap markets = new HashMap();

    private Market getMarket(String symbol) {
        Market m = (Market)this.markets.get(symbol);
        if (m == null) {
            m = new Market();
            this.markets.put(symbol, m);
        }
        return m;
    }

    public boolean insert(Order order) {
        return this.getMarket(order.getSymbol()).insert(order);
    }

    public void match(String symbol, ArrayList orders) {
        this.getMarket(symbol).match(symbol, orders);
    }

    public Order find(String symbol, char side, String id) {
        return this.getMarket(symbol).find(symbol, side, id);
    }

    public void erase(Order order) {
        this.getMarket(order.getSymbol()).erase(order);
    }

    public void display() {
        Iterator iter = this.markets.keySet().iterator();
        while (iter.hasNext()) {
            String symbol = (String)iter.next();
            System.out.println("MARKET: " + symbol);
            this.display(symbol);
        }
    }

    public void display(String symbol) {
        this.getMarket(symbol).display();
    }
}

