/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.ordermatch;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import quickfix.examples.ordermatch.Order;

public class Market {
    private List bidOrders = new ArrayList();
    private List askOrders = new ArrayList();

    public boolean match(String symbol, List orders) {
        while (true) {
            if (this.bidOrders.size() == 0 || this.askOrders.size() == 0) {
                return orders.size() != 0;
            }
            Order bidOrder = (Order)this.bidOrders.get(0);
            Order askOrder = (Order)this.askOrders.get(0);
            if (bidOrder.getType() != '1' && askOrder.getType() != '1' && !(bidOrder.getPrice() >= askOrder.getPrice())) break;
            this.match(bidOrder, askOrder);
            if (!orders.contains(bidOrder)) {
                orders.add(0, bidOrder);
            }
            if (!orders.contains(askOrder)) {
                orders.add(0, askOrder);
            }
            if (bidOrder.isClosed()) {
                this.bidOrders.remove(bidOrder);
            }
            if (!askOrder.isClosed()) continue;
            this.askOrders.remove(askOrder);
        }
        return orders.size() != 0;
    }

    private void match(Order bid, Order ask) {
        double price = ask.getType() == '2' ? ask.getPrice() : bid.getPrice();
        long quantity = 0L;
        quantity = bid.getOpenQuantity() >= ask.getOpenQuantity() ? ask.getOpenQuantity() : bid.getOpenQuantity();
        bid.execute(price, quantity);
        ask.execute(price, quantity);
    }

    public boolean insert(Order order) {
        boolean inserted = false;
        inserted = order.getSide() == '1' ? this.insert(order, true, this.bidOrders) : this.insert(order, false, this.askOrders);
        return inserted;
    }

    private boolean insert(Order order, boolean descending, List orders) {
        if (orders.size() == 0) {
            orders.add(order);
        } else if (order.getType() == '1') {
            orders.add(0, order);
        } else {
            for (int i = 0; i < orders.size(); ++i) {
                Order o = (Order)orders.get(i);
                if (!(descending ? order.getPrice() > o.getPrice() : order.getPrice() < o.getPrice()) || order.getEntryTime() >= o.getEntryTime()) continue;
                orders.add(i, order);
            }
            orders.add(order);
        }
        return true;
    }

    public void erase(Order order) {
        if (order.getSide() == '1') {
            this.bidOrders.remove(this.find(this.bidOrders, order.getClientOrderId()));
        } else {
            this.askOrders.remove(this.find(this.askOrders, order.getClientOrderId()));
        }
    }

    public Order find(String symbol, char side, String id) {
        Order order = null;
        order = side == '1' ? this.find(this.bidOrders, id) : this.find(this.askOrders, id);
        return order;
    }

    private Order find(List orders, String clientOrderId) {
        for (int i = 0; i < orders.size(); ++i) {
            Order o = (Order)orders.get(i);
            if (!o.getClientOrderId().equals(clientOrderId)) continue;
            return o;
        }
        return null;
    }

    public void display() {
        this.displaySide(this.bidOrders, "BIDS");
        this.displaySide(this.askOrders, "ASKS");
    }

    private void displaySide(List orders, String title) {
        DecimalFormat priceFormat = new DecimalFormat("#.00");
        DecimalFormat qtyFormat = new DecimalFormat("######");
        System.out.println(title + ":\n----");
        for (int i = 0; i < orders.size(); ++i) {
            Order order = (Order)orders.get(i);
            System.out.println("  $" + priceFormat.format(order.getPrice()) + " " + qtyFormat.format(order.getOpenQuantity()) + " " + order.getOwner() + " " + new Date(order.getEntryTime()));
        }
    }
}

